/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.ssas;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.aggdes.AggDesignerException;

public class ConversionUtil {
    private static final Log logger = LogFactory.getLog(ConversionUtil.class);

    private static Table findParentTable(Table table, List<String> tableNames) {
        ArrayList<String> tableNameList = new ArrayList<String>(tableNames);
        while (true) {
            if (tableNameList.contains(table.logicalName)) {
                tableNameList.remove(table.logicalName);
                if (tableNameList.size() == 0) {
                    return table;
                }
            }
            table = table.parentJoin.parentTable;
        }
    }

    private static boolean containsIgnoreCase(List<String> list, String val) {
        for (String str : list) {
            if (!str.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    private static Table findFragmentWithTables(List<String> tableNames, List<Table> allTables, String factForeignKey) {
        for (String name : tableNames) {
            List<Table> tables = ConversionUtil.findTables(allTables, name);
            if (tableNames.size() == 1 && ConversionUtil.containsIgnoreCase(tables.get((int)0).columns, factForeignKey)) {
                return tables.get(0).clone();
            }
            for (Table table : tables) {
                Table parent;
                boolean matchFound = true;
                for (String addlName : tableNames) {
                    Table start = table.parentJoin.parentTable;
                    if (addlName.equals(name)) continue;
                    boolean found = false;
                    while (start.parentJoin != null) {
                        if (start.logicalName.equals(addlName)) {
                            found = true;
                            break;
                        }
                        start = start.parentJoin.parentTable;
                    }
                    if (found) continue;
                    matchFound = false;
                    break;
                }
                if (!matchFound || !(parent = ConversionUtil.findParentTable(table, tableNames)).ancestorsHaveColumn(factForeignKey)) continue;
                Table toClone = table;
                Table toReturn = null;
                Join childJoin = null;
                Table childClone = null;
                boolean first = true;
                boolean reachedParent = false;
                do {
                    Table clone = toClone.clone();
                    if (first) {
                        toReturn = clone;
                        first = false;
                    }
                    if (toClone == parent) {
                        reachedParent = true;
                    }
                    if (childClone != null) {
                        Join clonedJoin;
                        childClone.parentJoin = clonedJoin = new Join(clone, childJoin.parentKeyObject, childClone, childJoin.childKeyObject);
                    }
                    childClone = clone;
                    childJoin = toClone.parentJoin;
                    toClone = toClone.parentJoin.parentTable;
                } while (!reachedParent || !ConversionUtil.containsIgnoreCase(childClone.columns, factForeignKey));
                return toReturn;
            }
        }
        return null;
    }

    private static List<Table> findTables(List<Table> allTables, String logicalTableName) {
        ArrayList<Table> list = new ArrayList<Table>();
        for (Table table : allTables) {
            if (!table.logicalName.equals(logicalTableName)) continue;
            list.add(table);
        }
        return list;
    }

    private static Table findTable(List<Table> allTables, String logicalTableName) {
        for (Table table : allTables) {
            if (!table.logicalName.equals(logicalTableName)) continue;
            return table;
        }
        return null;
    }

    private static List<Table> generateStarModels(Element ssasDataSourceView) {
        List tables = ssasDataSourceView.selectNodes("xs:complexType/xs:choice/xs:element");
        ArrayList<Table> starTables = new ArrayList<Table>();
        for (int i = 0; i < tables.size(); ++i) {
            Element table = (Element)tables.get(i);
            String name = table.attributeValue("name");
            String dbname = table.attributeValue("DbTableName");
            String dbSchemaName = table.attributeValue("DbSchemaName");
            String queryDefinition = table.attributeValue("QueryDefinition");
            List uniqueKeys = ssasDataSourceView.selectNodes("xs:unique[xs:selector/@xpath='.//" + name + "']");
            ArrayList<Key> uniqueKeyObjects = new ArrayList<Key>();
            for (Element uniqueKey : uniqueKeys) {
                List columns = uniqueKey.selectNodes("xs:field");
                Key key = new Key();
                for (Element column : columns) {
                    key.columns.add(column.attributeValue("xpath"));
                }
                if (key.columns.size() > 1) {
                    logger.debug((Object)("Compound Key for Table '" + name + "': " + key));
                }
                uniqueKeyObjects.add(key);
            }
            Table tableModel = new Table(name, dbname, dbSchemaName, uniqueKeyObjects, queryDefinition);
            List columns = table.selectNodes("xs:complexType/xs:sequence/xs:element");
            for (int j = 0; j < columns.size(); ++j) {
                Element column = (Element)columns.get(j);
                String colname = column.attributeValue("name");
                String dbColumnName = column.attributeValue("DbColumnName");
                if (dbColumnName == null) {
                    dbColumnName = colname;
                }
                String computedColumnExpression = column.attributeValue("ComputedColumnExpression");
                tableModel.columnObjs.add(new Column(colname, dbColumnName, computedColumnExpression));
                tableModel.columns.add(column.attributeValue("name"));
            }
            starTables.add(tableModel);
        }
        List keyrefs = ssasDataSourceView.selectNodes("xs:keyref");
        for (int i = 0; i < keyrefs.size(); ++i) {
            Element keyref = (Element)keyrefs.get(i);
            String refer = keyref.attributeValue("refer");
            String parentTable = ((Element)keyref.selectSingleNode("xs:selector")).attributeValue("xpath").substring(3);
            Key parentKeyObject = new Key();
            List parentKeys = keyref.selectNodes("xs:field");
            for (Element parentKey : parentKeys) {
                parentKeyObject.columns.add(parentKey.attributeValue("xpath"));
            }
            Element unique = (Element)ssasDataSourceView.selectSingleNode("xs:unique[@name='" + refer + "']");
            String childTable = ((Element)unique.selectSingleNode("xs:selector")).attributeValue("xpath").substring(3);
            Key childKeyObject = new Key();
            List childKeys = keyref.selectNodes("xs:field");
            for (Element childKey : childKeys) {
                childKeyObject.columns.add(childKey.attributeValue("xpath"));
            }
            ArrayList<Table> origTables = new ArrayList<Table>(starTables);
            boolean found = false;
            for (int j = 0; j < origTables.size() && !found; ++j) {
                Table childTableModel = (Table)origTables.get(j);
                if (!childTableModel.logicalName.equals(childTable)) continue;
                for (int k = 0; k < starTables.size() && !found; ++k) {
                    Join join;
                    Table parentTableModel = (Table)starTables.get(k);
                    if (!parentTableModel.logicalName.equals(parentTable) || parentTableModel.logicalName.equals(childTableModel.logicalName)) continue;
                    logger.debug((Object)("Adding Join: " + parentTable + "(" + parentKeyObject + ") to " + childTable + "(" + childKeyObject + ")"));
                    if (childTableModel.parentJoin != null) {
                        childTableModel = childTableModel.cloneTree();
                        starTables.add(childTableModel);
                    }
                    childTableModel.parentJoin = join = new Join(parentTableModel, parentKeyObject, childTableModel, childKeyObject);
                    parentTableModel.childJoins.add(join);
                    found = true;
                }
            }
        }
        List relationships = ssasDataSourceView.selectNodes("../xs:annotation/xs:appinfo/msdata:Relationship");
        for (int i = 0; i < relationships.size(); ++i) {
            String[] parentKeyStrs;
            String[] childKeyStrs;
            Element relationship = (Element)relationships.get(i);
            String childTable = relationship.attributeValue("parent");
            String childKey = relationship.attributeValue("parentkey");
            Key childKeyObject = new Key();
            for (String str : childKeyStrs = childKey.split(" ")) {
                childKeyObject.columns.add(str);
            }
            String parentTable = relationship.attributeValue("child");
            String parentKey = relationship.attributeValue("childkey");
            Key parentKeyObject = new Key();
            for (String str : parentKeyStrs = parentKey.split(" ")) {
                parentKeyObject.columns.add(str);
            }
            boolean found = false;
            ArrayList<Table> origTables = new ArrayList<Table>(starTables);
            for (int j = 0; j < origTables.size() && !found; ++j) {
                Table childTableModel = (Table)origTables.get(j);
                if (!childTableModel.logicalName.equals(childTable)) continue;
                for (int k = 0; k < starTables.size() && !found; ++k) {
                    Join join;
                    Table parentTableModel = (Table)starTables.get(k);
                    if (!parentTableModel.logicalName.equals(parentTable) || parentTableModel.logicalName.equals(childTableModel.logicalName)) continue;
                    logger.debug((Object)("Adding Join: " + parentTable + "(" + parentKey + ") to " + childTable + "(" + childKey + ")"));
                    if (childTableModel.parentJoin != null) {
                        childTableModel = childTableModel.cloneTree();
                        starTables.add(childTableModel);
                    }
                    childTableModel.parentJoin = join = new Join(parentTableModel, parentKeyObject, childTableModel, childKeyObject);
                    parentTableModel.childJoins.add(join);
                    found = true;
                }
            }
        }
        return starTables;
    }

    public static List<Document> generateMondrianDocsFromSSASSchema(InputStream input) throws DocumentException, IOException, AggDesignerException {
        Document ssasDocument = ConversionUtil.parseAssl(input);
        List allElements = ssasDocument.selectNodes("//*");
        for (int i = 0; i < allElements.size(); ++i) {
            Element element = (Element)allElements.get(i);
            element.setText(element.getText().replaceAll("[\\s]+", " ").trim());
        }
        List ssasDatabases = ssasDocument.selectNodes("//assl:Database");
        ArrayList<Document> mondrianDocs = new ArrayList<Document>(ssasDatabases.size());
        for (int i = 0; i < ssasDatabases.size(); ++i) {
            Document mondrianDoc = DocumentFactory.getInstance().createDocument();
            Element mondrianSchema = DocumentFactory.getInstance().createElement("Schema");
            mondrianDoc.add(mondrianSchema);
            Element ssasDatabase = (Element)ssasDatabases.get(i);
            mondrianSchema.add(DocumentFactory.getInstance().createAttribute(mondrianSchema, "name", ConversionUtil.getXPathNodeText((Node)ssasDatabase, "assl:Name")));
            ConversionUtil.populateCubes(mondrianSchema, ssasDatabase);
            mondrianDocs.add(mondrianDoc);
        }
        return mondrianDocs;
    }

    private static boolean isVirtualMeasureGroup(Element measureGroup) {
        return measureGroup.selectSingleNode("assl:Source[@xsi:type='MeasureGroupBinding']") != null;
    }

    private static void populateCubes(Element mondrianSchema, Element ssasDatabase) throws AggDesignerException {
        List allMeasureGroups = ssasDatabase.selectNodes("assl:Cubes/assl:Cube/assl:MeasureGroups/assl:MeasureGroup");
        HashMap<String, List<Table>> dataSourceViews = new HashMap<String, List<Table>>();
        for (int i = 0; i < allMeasureGroups.size(); ++i) {
            Element fact;
            String factTableName;
            Table factTable;
            Element ssasMeasureGroup = (Element)allMeasureGroups.get(i);
            String measureGroupName = ConversionUtil.getXPathNodeText((Node)ssasMeasureGroup, "assl:Name");
            if (ConversionUtil.isVirtualMeasureGroup(ssasMeasureGroup)) {
                String cubeName = ConversionUtil.getXPathNodeText((Node)ssasMeasureGroup, "../../assl:Name");
                logger.debug((Object)("Skipping SSAS Virtual Cube, Measure Group " + cubeName + ", " + measureGroupName));
                continue;
            }
            Element mondrianCube = DocumentFactory.getInstance().createElement("Cube");
            mondrianCube.addAttribute("name", measureGroupName);
            String dataSourceViewID = ConversionUtil.getXPathNodeText((Node)ssasMeasureGroup, "../../assl:Source/assl:DataSourceViewID").toLowerCase();
            List<Table> allTables = (List<Table>)dataSourceViews.get(dataSourceViewID);
            if (allTables == null) {
                Element ssasDataSourceView = (Element)ssasDatabase.selectSingleNode("assl:DataSourceViews/assl:DataSourceView[translate(assl:ID, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')='" + dataSourceViewID + "']/assl:Schema/xs:schema/xs:element");
                allTables = ConversionUtil.generateStarModels(ssasDataSourceView);
                dataSourceViews.put(dataSourceViewID, allTables);
            }
            if ((factTable = ConversionUtil.findTable(allTables, factTableName = ConversionUtil.getXPathNodeText((Node)ssasMeasureGroup, "assl:Measures/assl:Measure/assl:Source/assl:Source/assl:TableID"))) == null) {
                logger.error((Object)("Failed to locate fact table: " + factTableName));
            }
            if (factTable.queryDefinition != null) {
                fact = DocumentFactory.getInstance().createElement("View");
                fact.addAttribute("alias", factTable.dbName);
                Element sql = DocumentFactory.getInstance().createElement("SQL");
                sql.addAttribute("dialect", "generic");
                sql.add(DocumentFactory.getInstance().createCDATA(factTable.queryDefinition));
                fact.add(sql);
                mondrianCube.add(fact);
            } else {
                fact = DocumentFactory.getInstance().createElement("Table");
                if (factTable.dbSchemaName != null && factTable.dbSchemaName.trim().length() != 0) {
                    fact.addAttribute("schema", factTable.dbSchemaName);
                }
                fact.addAttribute("name", factTable.dbName);
                mondrianCube.add(fact);
            }
            ConversionUtil.populateDimensions(mondrianCube, ssasDatabase, ssasMeasureGroup, factTable, allTables);
            ConversionUtil.populateCubeMeasures(mondrianCube, ssasMeasureGroup, factTable, measureGroupName);
            mondrianSchema.add(mondrianCube);
        }
    }

    private static void populateDimensions(Element mondrianCube, Element ssasDatabase, Element ssasMeasureGroup, Table factTable, List<Table> allTables) throws AggDesignerException {
        List measureDimensions = ssasMeasureGroup.selectNodes("assl:Dimensions/assl:Dimension");
        for (int j = 0; j < measureDimensions.size(); ++j) {
            Element measureDimension = (Element)measureDimensions.get(j);
            String cubeDimensionId = ConversionUtil.getXPathNodeText((Node)measureDimension, "assl:CubeDimensionID");
            Element cubeDimension = (Element)ssasMeasureGroup.selectSingleNode("../../assl:Dimensions/assl:Dimension[assl:ID='" + cubeDimensionId + "']");
            String databaseDimensionId = ConversionUtil.getXPathNodeText((Node)cubeDimension, "assl:DimensionID");
            Element databaseDimension = (Element)ssasDatabase.selectSingleNode("assl:Dimensions/assl:Dimension[assl:ID='" + databaseDimensionId + "']");
            Element mondrianDimension = DocumentFactory.getInstance().createElement("Dimension");
            String dimensionName = ConversionUtil.getXPathNodeText((Node)cubeDimension, "assl:Name");
            mondrianDimension.addAttribute("name", dimensionName);
            Element keyAttribute = (Element)databaseDimension.selectSingleNode("assl:Attributes/assl:Attribute[assl:Usage='Key']");
            String keyAttributeID = ConversionUtil.getXPathNodeText((Node)keyAttribute, "assl:ID");
            String foreignKey = null;
            List nodes = measureDimension.selectNodes("assl:Attributes/assl:Attribute[assl:AttributeID='" + keyAttributeID + "']/assl:KeyColumns/assl:KeyColumn/assl:Source/assl:TableID");
            if (nodes.size() > 1) {
                logger.warn((Object)("(1) Key Column foreign key contains more than one column in dimension " + dimensionName + ", SKIPPING DIMENSION"));
                continue;
            }
            Element keyTableObject = (Element)measureDimension.selectSingleNode("assl:Attributes/assl:Attribute[assl:AttributeID='" + keyAttributeID + "']/assl:KeyColumns/assl:KeyColumn/assl:Source/assl:TableID");
            if (keyTableObject == null) {
                keyTableObject = (Element)keyAttribute.selectSingleNode("assl:KeyColumns/assl:KeyColumn/assl:Source/assl:TableID");
                nodes = keyAttribute.selectNodes("assl:KeyColumns/assl:KeyColumn/assl:Source/assl:TableID");
                if (nodes.size() > 1) {
                    logger.warn((Object)("(2) Key Column foreign key contains more than one column in dimension " + dimensionName + ", SKIPPING DIMENSION"));
                    continue;
                }
            }
            if (keyTableObject != null) {
                String tableID = keyTableObject.getTextTrim();
                List<Table> tables = ConversionUtil.findTables(allTables, tableID);
                for (Table table : tables) {
                    if (table == factTable) {
                        Element keyColumnObject = (Element)measureDimension.selectSingleNode("assl:Attributes/assl:Attribute[assl:AttributeID='" + keyAttributeID + "']/assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
                        if (keyColumnObject == null) {
                            keyColumnObject = (Element)keyAttribute.selectSingleNode("assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
                        }
                        foreignKey = keyColumnObject.getTextTrim();
                    } else {
                        Key foreignKeyObject = table.getFactForeignKey(factTable);
                        if (foreignKeyObject == null) continue;
                        if (foreignKeyObject.columns.size() > 1) {
                            logger.warn((Object)("FOREIGN KEY " + foreignKeyObject + " CONTAINS MORE THAN ONE COLUMN IN DIMENSION " + dimensionName));
                            continue;
                        }
                        foreignKey = foreignKeyObject.columns.get(0);
                        if (foreignKey == null) continue;
                    }
                    break;
                }
            } else {
                logger.warn((Object)"FAILED TO FIND FOREIGN KEY!");
            }
            if (foreignKey == null) {
                logger.warn((Object)("FAILED TO FIND FOREIGN KEY.  Excluding Dimension " + dimensionName));
                continue;
            }
            Column foreignKeyObject = factTable.findColumn(foreignKey);
            mondrianDimension.addAttribute("foreignKey", foreignKeyObject.dbName);
            ConversionUtil.populateHierarchies(mondrianDimension, cubeDimension, databaseDimension, keyAttribute, factTable, allTables, foreignKey);
            mondrianCube.add(mondrianDimension);
        }
    }

    private static void populateHierarchies(Element mondrianDimension, Element ssasCubeDimension, Element ssasDatabaseDimension, Element ssasDimensionKeyAttribute, Table factTable, List<Table> allTables, String factForeignKey) throws AggDesignerException {
        List cubeAttributes = ssasCubeDimension.selectNodes("assl:Attributes/assl:Attribute");
        for (int i = 0; i < cubeAttributes.size(); ++i) {
            Element cubeAttribute = (Element)cubeAttributes.get(i);
            String attribID = ConversionUtil.getXPathNodeText((Node)cubeAttribute, "assl:AttributeID");
            Element databaseAttribute = (Element)ssasDatabaseDimension.selectSingleNode("assl:Attributes/assl:Attribute[assl:ID='" + attribID + "']");
            Element usageElement = (Element)databaseAttribute.selectSingleNode("assl:Usage");
            if (usageElement == null || !"Parent".equals(usageElement.getTextTrim())) continue;
            ConversionUtil.populateParentChildHierarchy(mondrianDimension, databaseAttribute, ssasDimensionKeyAttribute, ssasDatabaseDimension, factTable, factForeignKey, allTables, attribID);
        }
        List hierarchies = ssasCubeDimension.selectNodes("assl:Hierarchies/assl:Hierarchy");
        for (int k = 0; k < hierarchies.size(); ++k) {
            Element hierarchy = (Element)hierarchies.get(k);
            String databaseHierarchyID = ConversionUtil.getXPathNodeText((Node)hierarchy, "assl:HierarchyID");
            Element databaseHierarchy = (Element)ssasDatabaseDimension.selectSingleNode("assl:Hierarchies/assl:Hierarchy[assl:ID='" + databaseHierarchyID + "']");
            if (databaseHierarchy == null) {
                throw new AggDesignerException("Failed to locate hierarchy " + databaseHierarchyID);
            }
            Element mondrianHierarchy = DocumentFactory.getInstance().createElement("Hierarchy");
            mondrianHierarchy.addAttribute("name", ConversionUtil.getXPathNodeText((Node)databaseHierarchy, "assl:Name"));
            String tableID = ConversionUtil.getXPathNodeText((Node)ssasDimensionKeyAttribute, "assl:KeyColumns/assl:KeyColumn/assl:Source/assl:TableID");
            Table primaryKeyTable = ConversionUtil.findTable(allTables, tableID);
            String primaryKey = ConversionUtil.getXPathNodeText((Node)ssasDimensionKeyAttribute, "assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
            Column primaryKeyColumn = primaryKeyTable.findColumn(primaryKey);
            mondrianHierarchy.addAttribute("primaryKey", primaryKeyColumn.dbName);
            Element allMemberName = (Element)databaseHierarchy.selectSingleNode("assl:AllMemberName");
            if (allMemberName != null && allMemberName.getTextTrim().length() != 0) {
                mondrianHierarchy.addAttribute("allMemberName", allMemberName.getTextTrim());
                mondrianHierarchy.addAttribute("hasAll", "true");
            } else {
                mondrianHierarchy.addAttribute("hasAll", "false");
            }
            List ssasLevels = databaseHierarchy.selectNodes("assl:Levels/assl:Level");
            ArrayList<String> tables = new ArrayList<String>();
            for (int l = 0; l < ssasLevels.size(); ++l) {
                Element level = (Element)ssasLevels.get(l);
                String sourceAttribID = ConversionUtil.getXPathNodeText((Node)level, "assl:SourceAttributeID");
                Element sourceAttribute = (Element)ssasDatabaseDimension.selectSingleNode("assl:Attributes/assl:Attribute[assl:ID='" + sourceAttribID + "']");
                String levelTableID = ConversionUtil.getXPathNodeText((Node)sourceAttribute, "assl:NameColumn/assl:Source/assl:TableID");
                if (tables.contains(levelTableID)) continue;
                tables.add(0, levelTableID);
            }
            if (tables.size() != 1 || !((String)tables.get(0)).equals(factTable.logicalName)) {
                ConversionUtil.populateHierarchyRelation(mondrianHierarchy, tables, ssasDatabaseDimension, factTable, allTables, databaseHierarchyID, factForeignKey);
            } else {
                mondrianHierarchy.add(DocumentFactory.getInstance().createComment("Degenerate Hierarchy"));
            }
            ConversionUtil.populateHierarchyLevels(mondrianHierarchy, ssasLevels, ssasDatabaseDimension, allTables, tables.size() > 1);
            mondrianDimension.add(mondrianHierarchy);
        }
        ConversionUtil.populateAttributeHierarchies(mondrianDimension, cubeAttributes, ssasDatabaseDimension, ssasDimensionKeyAttribute, factTable, factForeignKey, allTables);
    }

    private static void populateHierarchyRelation(Element mondrianHierarchy, List<String> tables, Element ssasDatabaseDimension, Table factTable, List<Table> allTables, String ssasHierarchyID, String factForeignKey) throws AggDesignerException {
        Table currentTable = factTable.findBranchWithTables(tables, factTable.logicalName, factForeignKey);
        if (currentTable == null) {
            currentTable = ConversionUtil.findFragmentWithTables(tables, allTables, factForeignKey);
            if (currentTable == null) {
                throw new AggDesignerException("Error: " + ssasHierarchyID + " star schema branch not found.  " + factTable.logicalName + "." + factForeignKey);
            }
            currentTable.getRoot().parentJoin = new Join(factTable, new Key(factForeignKey), currentTable, new Key(factForeignKey));
            logger.debug((Object)("IMPLICIT STAR JOIN FOR " + currentTable.logicalName + "." + factForeignKey + " to " + factTable.logicalName + "." + factForeignKey));
        }
        Element currentHierarchyRelation = null;
        if (currentTable.queryDefinition != null) {
            currentHierarchyRelation = DocumentFactory.getInstance().createElement("View");
            currentHierarchyRelation.addAttribute("alias", currentTable.dbName);
            Element sql = DocumentFactory.getInstance().createElement("SQL");
            sql.addAttribute("dialect", "generic");
            sql.add(DocumentFactory.getInstance().createCDATA(currentTable.queryDefinition));
            currentHierarchyRelation.add(sql);
        } else {
            currentHierarchyRelation = DocumentFactory.getInstance().createElement("Table");
            if (currentTable.dbSchemaName != null && currentTable.dbSchemaName.trim().length() != 0) {
                currentHierarchyRelation.addAttribute("schema", currentTable.dbSchemaName);
            }
            currentHierarchyRelation.addAttribute("name", currentTable.dbName);
        }
        if (!tables.contains(currentTable.logicalName)) {
            tables.add(currentTable.logicalName);
        }
        while (!currentTable.parentJoin.parentTable.logicalName.equals(factTable.logicalName)) {
            Element hierarchyRelation = DocumentFactory.getInstance().createElement("Join");
            Element tableRelation = null;
            if (currentTable.queryDefinition != null) {
                tableRelation = DocumentFactory.getInstance().createElement("View");
                tableRelation.addAttribute("alias", currentTable.dbName);
                Element sql = DocumentFactory.getInstance().createElement("SQL");
                sql.addAttribute("dialect", "generic");
                sql.add(DocumentFactory.getInstance().createCDATA(currentTable.queryDefinition));
                tableRelation.add(sql);
            } else {
                tableRelation = DocumentFactory.getInstance().createElement("Table");
                if (currentTable.parentJoin.parentTable.dbSchemaName != null && currentTable.parentJoin.parentTable.dbSchemaName.trim().length() != 0) {
                    tableRelation.addAttribute("schema", currentTable.parentJoin.parentTable.dbSchemaName);
                }
                tableRelation.addAttribute("name", currentTable.parentJoin.parentTable.dbName);
            }
            if (!tables.contains(currentTable.parentJoin.parentTable.logicalName)) {
                tables.add(currentTable.parentJoin.parentTable.logicalName);
            }
            hierarchyRelation.addAttribute("leftKey", currentTable.parentJoin.parentKeyObject.columns.get(0));
            hierarchyRelation.addAttribute("rightKey", currentTable.parentJoin.childKeyObject.columns.get(0));
            hierarchyRelation.add(tableRelation);
            hierarchyRelation.add(currentHierarchyRelation);
            currentHierarchyRelation = hierarchyRelation;
            currentTable = currentTable.parentJoin.parentTable;
        }
        if (currentHierarchyRelation.getName().equals("Join")) {
            mondrianHierarchy.addAttribute("primaryKeyTable", currentTable.dbName);
        }
        mondrianHierarchy.add(currentHierarchyRelation);
    }

    private static void populateHierarchyLevels(Element mondrianHierarchy, List ssasLevels, Element ssasDatabaseDimension, List<Table> allTables, boolean includeTableName) throws AggDesignerException {
        for (int l = 0; l < ssasLevels.size(); ++l) {
            Element level = (Element)ssasLevels.get(l);
            Element mondrianLevel = DocumentFactory.getInstance().createElement("Level");
            mondrianLevel.addAttribute("name", ConversionUtil.getXPathNodeText((Node)level, "assl:Name"));
            String sourceAttribID = ConversionUtil.getXPathNodeText((Node)level, "assl:SourceAttributeID");
            Element sourceAttribute = (Element)ssasDatabaseDimension.selectSingleNode("assl:Attributes/assl:Attribute[assl:ID='" + sourceAttribID + "']");
            Element keyUniquenessGuarantee = (Element)sourceAttribute.selectSingleNode("assl:KeyUniquenessGuarantee");
            boolean keyUniqueness = false;
            if (keyUniquenessGuarantee != null) {
                keyUniqueness = "true".equals(keyUniquenessGuarantee.getTextTrim());
            }
            mondrianLevel.addAttribute("uniqueMembers", "" + keyUniqueness);
            String levelTableID = ConversionUtil.getXPathNodeText((Node)sourceAttribute, "assl:NameColumn/assl:Source/assl:TableID");
            Table levelTable = ConversionUtil.findTable(allTables, levelTableID);
            if (includeTableName) {
                mondrianLevel.addAttribute("table", levelTable.dbName);
            }
            List nodes = sourceAttribute.selectNodes("assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
            String keyColumn = ((Element)nodes.get(nodes.size() - 1)).getTextTrim();
            String nameColumn = ConversionUtil.getXPathNodeText((Node)sourceAttribute, "assl:NameColumn/assl:Source/assl:ColumnID");
            if (keyColumn == null || keyColumn.equals(nameColumn)) {
                Column nameColumnObj = levelTable.findColumn(nameColumn);
                nameColumnObj.addToMondrian(mondrianLevel, "column", "KeyExpression");
            } else {
                Column keyColumnObj = levelTable.findColumn(keyColumn);
                keyColumnObj.addToMondrian(mondrianLevel, "column", "KeyExpression");
                Column nameColumnObj = levelTable.findColumn(nameColumn);
                nameColumnObj.addToMondrian(mondrianLevel, "nameColumn", "NameExpression");
            }
            String datatype = ConversionUtil.getXPathNodeText((Node)sourceAttribute, "assl:NameColumn/assl:DataType");
            if (datatype.equals("Numeric")) {
                mondrianLevel.addAttribute("type", "Numeric");
            }
            mondrianHierarchy.add(mondrianLevel);
        }
    }

    private static void populateParentChildHierarchy(Element mondrianDimension, Element databaseAttribute, Element ssasDimensionKeyAttribute, Element ssasDatabaseDimension, Table factTable, String factForeignKey, List<Table> allTables, String attributeID) throws AggDesignerException {
        mondrianDimension.add(DocumentFactory.getInstance().createComment("Parent Child Hierarchy"));
        Element mondrianHierarchy = DocumentFactory.getInstance().createElement("Hierarchy");
        mondrianHierarchy.addAttribute("name", ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:Name"));
        String tableID = ConversionUtil.getXPathNodeText((Node)ssasDimensionKeyAttribute, "assl:KeyColumns/assl:KeyColumn/assl:Source/assl:TableID");
        String keyColumnID = ConversionUtil.getXPathNodeText((Node)ssasDimensionKeyAttribute, "assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
        Table table = ConversionUtil.findTable(allTables, tableID);
        Column keyColumnObject = table.findColumn(keyColumnID);
        if (keyColumnObject.expression != null) {
            logger.warn((Object)"Mondrian does not support primary key expressions");
        }
        mondrianHierarchy.addAttribute("primaryKey", keyColumnObject.dbName);
        mondrianHierarchy.addAttribute("allMemberName", "All");
        mondrianHierarchy.addAttribute("hasAll", "true");
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(tableID);
        ConversionUtil.populateHierarchyRelation(mondrianHierarchy, tables, ssasDatabaseDimension, factTable, allTables, attributeID, factForeignKey);
        Element mondrianLevel = DocumentFactory.getInstance().createElement("Level");
        mondrianLevel.addAttribute("name", ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:Name"));
        mondrianLevel.addAttribute("uniqueMembers", "true");
        String parentID = ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
        String columnID = ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:NameColumn/assl:Source/assl:ColumnID");
        keyColumnObject.addToMondrian(mondrianLevel, "column", "KeyExpression");
        Column parentColumnObject = table.findColumn(parentID);
        parentColumnObject.addToMondrian(mondrianLevel, "parentColumn", "ParentExpression");
        Column nameColumnObject = table.findColumn(columnID);
        nameColumnObject.addToMondrian(mondrianLevel, "nameColumn", "NameExpression");
        mondrianLevel.addAttribute("nullParentValue", "0");
        mondrianHierarchy.add(mondrianLevel);
        mondrianDimension.add(mondrianHierarchy);
    }

    private static void populateAttributeHierarchies(Element mondrianDimension, List cubeAttributes, Element ssasDatabaseDimension, Element ssasDimensionKeyAttribute, Table factTable, String factForeignKey, List<Table> allTables) throws AggDesignerException {
        mondrianDimension.add(DocumentFactory.getInstance().createComment("Attribute Hierarchies"));
        for (int i = 0; i < cubeAttributes.size(); ++i) {
            Element usageElement;
            Element cubeAttribute = (Element)cubeAttributes.get(i);
            String attribID = ConversionUtil.getXPathNodeText((Node)cubeAttribute, "assl:AttributeID");
            Element databaseAttribute = (Element)ssasDatabaseDimension.selectSingleNode("assl:Attributes/assl:Attribute[assl:ID='" + attribID + "']");
            if (cubeAttribute.selectSingleNode("assl:AttributeHierarchyEnabled") == null || !"true".equals(ConversionUtil.getXPathNodeText((Node)cubeAttribute, "assl:AttributeHierarchyEnabled")) || (usageElement = (Element)databaseAttribute.selectSingleNode("assl:Usage")) != null && "Parent".equals(usageElement.getTextTrim())) continue;
            Element mondrianHierarchy = DocumentFactory.getInstance().createElement("Hierarchy");
            String attribName = ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:Name");
            mondrianHierarchy.addAttribute("name", attribName);
            String tableID = ConversionUtil.getXPathNodeText((Node)ssasDimensionKeyAttribute, "assl:KeyColumns/assl:KeyColumn/assl:Source/assl:TableID");
            Table table = ConversionUtil.findTable(allTables, tableID);
            String primaryKey = ConversionUtil.getXPathNodeText((Node)ssasDimensionKeyAttribute, "assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
            Column primaryKeyColumn = table.findColumn(primaryKey);
            List nodes = ssasDimensionKeyAttribute.selectNodes("assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
            if (nodes.size() > 1) {
                logger.warn((Object)("SKIPPING ATTRIBUTE HIERARCHY " + attribName + ", MORE THAN ONE FOREIGN KEY"));
                continue;
            }
            mondrianHierarchy.addAttribute("primaryKey", primaryKeyColumn.dbName);
            Element allMemberName = (Element)ssasDatabaseDimension.selectSingleNode("assl:AttributeAllMemberName");
            if (allMemberName != null && allMemberName.getTextTrim().length() != 0) {
                mondrianHierarchy.addAttribute("allMemberName", allMemberName.getTextTrim());
                mondrianHierarchy.addAttribute("hasAll", "true");
            } else {
                mondrianHierarchy.addAttribute("hasAll", "false");
            }
            String levelTableID = ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:NameColumn/assl:Source/assl:TableID");
            ArrayList<String> tables = new ArrayList<String>();
            tables.add(tableID);
            if (levelTableID != null && !levelTableID.equals(tableID)) {
                tables.add(levelTableID);
                table = ConversionUtil.findTable(allTables, levelTableID);
            }
            if (tables.size() != 1 || !((String)tables.get(0)).equals(factTable.logicalName)) {
                ConversionUtil.populateHierarchyRelation(mondrianHierarchy, tables, ssasDatabaseDimension, factTable, allTables, attribID, factForeignKey);
            }
            Element mondrianLevel = DocumentFactory.getInstance().createElement("Level");
            mondrianLevel.addAttribute("name", attribName);
            Element keyUniquenessGuarantee = (Element)databaseAttribute.selectSingleNode("assl:KeyUniquenessGuarantee");
            boolean keyUniqueness = false;
            if (keyUniquenessGuarantee != null) {
                keyUniqueness = "true".equals(keyUniquenessGuarantee.getTextTrim());
            }
            mondrianLevel.addAttribute("uniqueMembers", "" + keyUniqueness);
            if (tables.size() > 1) {
                mondrianLevel.addAttribute("table", table.dbName);
            }
            nodes = databaseAttribute.selectNodes("assl:KeyColumns/assl:KeyColumn/assl:Source/assl:ColumnID");
            String keyColumn = ((Element)nodes.get(nodes.size() - 1)).getTextTrim();
            String nameColumn = ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:NameColumn/assl:Source/assl:ColumnID");
            if (keyColumn == null || keyColumn.equals(nameColumn)) {
                Column nameColumnObject = table.findColumn(nameColumn);
                nameColumnObject.addToMondrian(mondrianLevel, "column", "KeyExpression");
            } else {
                Column keyColumnObject = table.findColumn(keyColumn);
                keyColumnObject.addToMondrian(mondrianLevel, "column", "KeyExpression");
                Column nameColumnObject = table.findColumn(nameColumn);
                nameColumnObject.addToMondrian(mondrianLevel, "nameColumn", "NameExpression");
            }
            String datatype = ConversionUtil.getXPathNodeText((Node)databaseAttribute, "assl:NameColumn/assl:DataType");
            if (datatype.equals("Numeric")) {
                mondrianLevel.addAttribute("type", "Numeric");
            }
            mondrianHierarchy.add(mondrianLevel);
            mondrianDimension.add(mondrianHierarchy);
        }
    }

    private static void populateCubeMeasures(Element mondrianCube, Element ssasMeasureGroup, Table factTable, String cubeName) throws AggDesignerException {
        List allMeasures = ssasMeasureGroup.selectNodes("assl:Measures/assl:Measure");
        for (int j = 0; j < allMeasures.size(); ++j) {
            Element measure = (Element)allMeasures.get(j);
            if (measure.selectSingleNode("assl:Source/assl:Source[@xsi:type='ColumnBinding']") == null && measure.selectSingleNode("assl:Source/assl:Source[@xsi:type='RowBinding']") == null) {
                logger.warn((Object)("SKIPPING MEASURE, INVALID MEASURE IN CUBE " + cubeName + " : " + measure.asXML()));
                continue;
            }
            Element mondrianMeasure = DocumentFactory.getInstance().createElement("Measure");
            String measureName = ConversionUtil.getXPathNodeText((Node)measure, "assl:Name");
            mondrianMeasure.addAttribute("name", measureName);
            logger.trace((Object)("MEASURE: " + measureName));
            String aggType = "sum";
            Element aggFunction = (Element)measure.selectSingleNode("assl:AggregateFunction");
            if (aggFunction != null) {
                aggType = aggFunction.getTextTrim().toLowerCase();
            }
            if (aggType.equals("distinctcount")) {
                aggType = "distinct-count";
            }
            mondrianMeasure.addAttribute("aggregator", aggType);
            if (measure.selectSingleNode("assl:Source/assl:Source[@xsi:type='ColumnBinding']") != null) {
                String column = ConversionUtil.getXPathNodeText((Node)measure, "assl:Source/assl:Source/assl:ColumnID");
                Column columnObj = factTable.findColumn(column);
                columnObj.addToMondrian(mondrianMeasure, "column", "MeasureExpression");
            } else {
                mondrianMeasure.addAttribute("column", factTable.columns.get(0));
            }
            mondrianCube.add(mondrianMeasure);
        }
    }

    public static Document parseAssl(URL url) throws DocumentException, IOException {
        return ConversionUtil.parseAssl(url.openStream());
    }

    public static Document parseAssl(InputStream input) throws DocumentException, IOException {
        HashMap<String, String> uris = new HashMap<String, String>();
        uris.put("assl", "http://schemas.microsoft.com/analysisservices/2003/engine");
        uris.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        uris.put("xs", "http://www.w3.org/2001/XMLSchema");
        uris.put("msprop", "urn:schemas-microsoft-com:xml-msprop");
        uris.put("msdata", "urn:schemas-microsoft-com:xml-msdata");
        DocumentFactory factory = new DocumentFactory();
        factory.setXPathNamespaceURIs(uris);
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory(factory);
        byte[] bytes = IOUtils.toByteArray((InputStream)input);
        ByteArrayInputStream byteInput = new ByteArrayInputStream(bytes);
        Document document = null;
        try {
            logger.debug((Object)"attempting to parse assuming utf-8 encoding");
            document = reader.read((InputStream)byteInput);
        }
        catch (DocumentException e) {
            reader.setEncoding("iso-8859-1");
            logger.debug((Object)"parse failed; attempting to parse assuming iso=8859-1 encoding");
            byteInput = new ByteArrayInputStream(bytes);
            document = reader.read((InputStream)byteInput);
        }
        return document;
    }

    public static String getXPathNodeText(Node parent, String xpath) throws AggDesignerException {
        Element element = (Element)parent.selectSingleNode(xpath);
        if (element == null) {
            throw new AggDesignerException("no element found for xpath '" + xpath + "'");
        }
        return ((Element)parent.selectSingleNode(xpath)).getTextTrim();
    }

    private static class Join {
        Key childKeyObject;
        Table childTable;
        Key parentKeyObject;
        Table parentTable;

        public Join(Table parentTable, Key parentKeyObject, Table childTable, Key childKeyObject) {
            this.parentTable = parentTable;
            this.parentKeyObject = parentKeyObject;
            this.childTable = childTable;
            this.childKeyObject = childKeyObject;
        }

        public String toString() {
            return "[Join: parent=" + this.parentTable.logicalName + ";pkey=" + this.parentKeyObject + "; child=" + this.childTable.logicalName + "; ckey=" + this.childKeyObject + "]";
        }
    }

    private static class Table {
        String logicalName;
        String dbName;
        String dbSchemaName;
        List<Key> uniqueKeys;
        String queryDefinition;
        boolean rootTable = false;
        List<Join> childJoins = new ArrayList<Join>();
        Join parentJoin;
        List<String> columns = new ArrayList<String>();
        List<Column> columnObjs = new ArrayList<Column>();

        public Table(String logicalName, String dbName, String dbSchemaName, List<Key> uniqueKeys, String queryDefinition) {
            this.logicalName = logicalName;
            this.dbName = dbName;
            this.dbSchemaName = dbSchemaName;
            this.uniqueKeys = uniqueKeys;
            this.queryDefinition = queryDefinition;
        }

        public Column findColumn(String colName) {
            for (Column col : this.columnObjs) {
                if (!col.logicalName.equals(colName)) continue;
                return col;
            }
            logger.error((Object)("COLUMN " + colName + " NOT FOUND IN TABLE " + this.logicalName));
            return null;
        }

        public String toString() {
            String str = "[Table: logical=" + this.logicalName + "; dbName=" + this.dbName + "; uniqueKeys=";
            for (int i = 0; i < this.uniqueKeys.size(); ++i) {
                if (i > 0) {
                    str = str + ", ";
                }
                str = str + this.uniqueKeys.get(i);
            }
            str = str + "; queryDefinition=" + this.queryDefinition + "]";
            return str;
        }

        public Table getJoinToFactTable(String factTable) {
            Table t = this;
            while (t.parentJoin != null) {
                if (t.parentJoin.parentTable.logicalName.equals(factTable)) {
                    return t;
                }
                t = t.parentJoin.parentTable;
            }
            return null;
        }

        public boolean ancestorsHaveColumn(String column) {
            if (this.columns.contains(column)) {
                return true;
            }
            if (this.parentJoin != null) {
                return this.parentJoin.parentTable.ancestorsHaveColumn(column);
            }
            return false;
        }

        public Key getFactForeignKey(Table factTable) {
            Table t = this;
            while (t.parentJoin != null) {
                if (t.parentJoin.parentTable == factTable) {
                    return t.parentJoin.parentKeyObject;
                }
                t = t.parentJoin.parentTable;
            }
            return null;
        }

        public Table getRoot() {
            Table t = this;
            while (t.parentJoin != null) {
                t = t.parentJoin.parentTable;
            }
            return t;
        }

        public Table clone() {
            ArrayList<Key> uniqueKeyClone = new ArrayList<Key>(this.uniqueKeys);
            Table table = new Table(this.logicalName, this.dbName, this.dbSchemaName, uniqueKeyClone, this.queryDefinition);
            table.columns.addAll(this.columns);
            return table;
        }

        public Table cloneTree() {
            Table clonetable = this.clone();
            for (Join join : this.childJoins) {
                Table childTable = join.childTable.cloneTree();
                Join clonejoin = new Join(join.parentTable, join.parentKeyObject, childTable, join.childKeyObject);
                clonetable.childJoins.add(clonejoin);
            }
            return clonetable;
        }

        public List<Table> findTable(String name) {
            ArrayList<Join> joins = new ArrayList<Join>(this.childJoins);
            ArrayList<Table> found = new ArrayList<Table>();
            while (joins.size() > 0) {
                Join join = (Join)joins.remove(0);
                if (join.childTable.logicalName.equals(name)) {
                    found.add(join.childTable);
                    continue;
                }
                joins.addAll(join.childTable.childJoins);
            }
            return found;
        }

        public Table findBranchWithTables(List<String> tableNames, String factTableName, String factForeignKey) {
            for (String name : tableNames) {
                List<Table> tables = this.findTable(name);
                for (Table table : tables) {
                    if (table.parentJoin == null) continue;
                    Table start = table.parentJoin.parentTable;
                    boolean matchFound = true;
                    for (String addlName : tableNames) {
                        if (addlName.equals(name)) continue;
                        boolean found = false;
                        while (start.parentJoin != null) {
                            if (start.logicalName.equals(addlName)) {
                                found = true;
                                break;
                            }
                            start = start.parentJoin.parentTable;
                        }
                        if (found) continue;
                        matchFound = false;
                        break;
                    }
                    if (!matchFound) continue;
                    Table joinTable = table.getJoinToFactTable(factTableName);
                    if (!joinTable.parentJoin.parentKeyObject.columns.get(0).equals(factForeignKey)) continue;
                    return table;
                }
            }
            return null;
        }
    }

    private static class Key {
        List<String> columns = new ArrayList<String>();

        public Key() {
        }

        public Key(String column) {
            this.columns.add(column);
        }

        public String toString() {
            String str = "[Key:";
            for (int i = 0; i < this.columns.size(); ++i) {
                if (i > 0) {
                    str = str + ",";
                }
                str = str + this.columns.get(i);
            }
            str = str + "]";
            return str;
        }
    }

    private static class Column {
        String logicalName;
        String dbName;
        String expression;

        public Column(String logicalName, String dbName, String expression) {
            this.logicalName = logicalName;
            this.dbName = dbName;
            this.expression = expression;
        }

        public String toString() {
            return "[Column: logical=" + this.logicalName + "; dbName=" + this.dbName + "; expression=" + this.expression + "]";
        }

        public void addToMondrian(Element parentElement, String attributeName, String expressionName) {
            if (this.expression == null) {
                parentElement.addAttribute(attributeName, this.dbName);
            } else {
                Element expressionElement = DocumentFactory.getInstance().createElement(expressionName);
                Element sql = DocumentFactory.getInstance().createElement("SQL");
                sql.addAttribute("dialect", "generic");
                sql.add(DocumentFactory.getInstance().createCDATA(this.expression));
                expressionElement.add(sql);
                parentElement.add(expressionElement);
            }
        }
    }
}

