/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.output.impl;

import org.pentaho.aggdes.model.Dialect;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.CreateScriptGenerator;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.impl.AbstractGenerator;
import org.pentaho.aggdes.output.impl.AggregateTableOutput;
import org.pentaho.aggdes.output.impl.ResultHandlerImpl;

public class CreateTableGenerator
extends AbstractGenerator
implements CreateScriptGenerator {
    @Override
    public Class[] getSupportedOutputClasses() {
        return new Class[]{AggregateTableOutput.class};
    }

    @Override
    public boolean canGenerate(Schema schema, Output output) {
        return output instanceof AggregateTableOutput;
    }

    @Override
    public String generate(Schema schema, Output output) {
        AggregateTableOutput tableOutput = (AggregateTableOutput)output;
        Dialect dialect = schema.getDialect();
        StringBuilder buf = new StringBuilder();
        dialect.comment(buf, "Aggregate table " + tableOutput.getTableName());
        dialect.comment(buf, "Estimated " + new Double(output.getAggregate().estimateRowCount()).intValue() + " rows, " + new Double(output.getAggregate().estimateSpace()).intValue() + " bytes");
        buf.append("CREATE TABLE ");
        dialect.quoteIdentifier(buf, new String[]{tableOutput.getCatalogName(), tableOutput.getSchemaName(), tableOutput.getTableName()});
        buf.append(" (").append(ResultHandlerImpl.NL);
        int i = -1;
        for (AggregateTableOutput.ColumnOutput columns : tableOutput.getColumnOutputs()) {
            if (++i > 0) {
                buf.append(",").append(ResultHandlerImpl.NL);
            }
            String columnName = columns.getName();
            buf.append("    ");
            dialect.quoteIdentifier(buf, new String[]{columnName});
            buf.append(" ");
            buf.append(columns.getAttribute().getDatatype(dialect));
        }
        buf.append(")");
        dialect.terminateCommand(buf);
        return buf.toString();
    }
}

