/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import mondrian.util.Base64;

public class XmlaUtil {
    public static String generateXmlaDiscoverRequest(String requestType) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<SOAP-ENV:Envelope\n").append(" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\n").append(" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n").append(" <SOAP-ENV:Body>\n").append("  <Discover xmlns=\"urn:schemas-microsoft-com:xml-analysis\"\n").append("   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n").append("   <RequestType>").append(requestType).append("</RequestType>\n").append("   <Restrictions>\n").append("    <RestrictionList/>\n").append("   </Restrictions>\n").append("   <Properties>\n").append("    <PropertyList/>\n").append("   </Properties>\n").append("  </Discover>\n").append(" </SOAP-ENV:Body>\n").append("</SOAP-ENV:Envelope>");
        return buf.toString();
    }

    public static byte[] executeXmlaRequest(URL url, String request) throws IOException {
        URLConnection urlConn = url.openConnection();
        urlConn.setDoOutput(true);
        String contentTypeKey = "content-type";
        String contentTypeValue = "text/xml";
        urlConn.setRequestProperty("content-type", "text/xml");
        if (url.getUserInfo() != null) {
            byte[] userInfoBytes = url.getUserInfo().getBytes();
            String basicAuthKey = "Authorization";
            String basicAuthVal = "Basic " + Base64.encodeBytes((byte[])userInfoBytes, (int)0);
            urlConn.setRequestProperty("Authorization", basicAuthVal);
        }
        byte[] requestBytes = request.getBytes("UTF-8");
        urlConn.getOutputStream().write(requestBytes);
        InputStream is = urlConn.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int count = is.read(buf);
        while (count > 0) {
            baos.write(buf, 0, count);
            count = is.read(buf);
        }
        return baos.toByteArray();
    }
}

