/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eigenbase.util.property.Property;

class PersistentPropertyStorage {
    private static final HashMap propertyFileMap = new HashMap();
    private File propertyFile;

    private PersistentPropertyStorage(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    static synchronized PersistentPropertyStorage newPersistentPropertyStorage(String propertyFile) throws IOException {
        File file = new File(propertyFile);
        String canonicalName = file.getCanonicalPath();
        if (propertyFileMap.containsKey(canonicalName)) {
            return (PersistentPropertyStorage)propertyFileMap.get(canonicalName);
        }
        PersistentPropertyStorage storage = new PersistentPropertyStorage(file);
        propertyFileMap.put(canonicalName, storage);
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storeProperty(Property property) throws IOException {
        boolean propertyFileExists = this.propertyFile.exists();
        boolean propertyStored = false;
        File tempFile = null;
        if (propertyFileExists) {
            tempFile = File.createTempFile("eigenbase", ".properties");
            try (FileReader fileReader = new FileReader(this.propertyFile);
                 FileWriter fileWriter = new FileWriter(tempFile);){
                int read;
                char[] buffer = new char[4096];
                while ((read = fileReader.read(buffer)) != -1) {
                    fileWriter.write(buffer, 0, read);
                }
                fileWriter.flush();
            }
            Pattern pattern = Pattern.compile("^#?\\Q" + property.getPath() + "\\E=.*");
            Matcher matcher = pattern.matcher("");
            BufferedReader reader = new BufferedReader(new FileReader(tempFile));
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.propertyFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    matcher.reset(line);
                    if (matcher.matches()) {
                        this.writePropertyValue(writer, property);
                        propertyStored = true;
                    } else {
                        writer.write(line);
                    }
                    writer.newLine();
                }
                writer.flush();
            }
            finally {
                reader.close();
                tempFile.delete();
            }
        }
        if (!propertyStored) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.propertyFile, true));){
                writer.newLine();
                this.writePropertyValue(writer, property);
                writer.newLine();
                writer.flush();
            }
        }
    }

    private void writePropertyValue(Writer writer, Property property) throws IOException {
        writer.write(property.getPath());
        writer.write(61);
        String value = property.getInternal(null, false);
        if (value != null) {
            writer.write(value);
        }
    }
}

