/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import java.util.Date;
import org.eigenbase.resgen.Generator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;

abstract class AbstractGenerator
implements Generator {
    private final File srcFile;
    private final File file;
    private Boolean scmSafeComments = null;

    public AbstractGenerator(File srcFile, File file) {
        this.srcFile = srcFile;
        this.file = file;
    }

    @Override
    public void setScmSafeComments(boolean enabled) {
        if (this.scmSafeComments != null) {
            throw new AssertionError((Object)"SCM safe comment style may only be configured once.");
        }
        this.scmSafeComments = enabled ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean useScmSafeComments() {
        return this.scmSafeComments != null && this.scmSafeComments != false;
    }

    protected abstract void generateResource(ResourceDef.Resource var1, PrintWriter var2);

    protected void generateDoNotModifyHeader(PrintWriter pw) {
        if (this.useScmSafeComments()) {
            pw.println("// This class is generated. Do NOT modify it manually.");
        } else {
            pw.println("// This class is generated. Do NOT modify it, or");
            pw.println("// add it to source control.");
        }
        pw.println();
    }

    protected void generateGeneratedByBlock(PrintWriter pw) {
        pw.println("/**");
        pw.println(" * This class was generated");
        pw.println(" * by " + ResourceGen.class);
        String file = this.getSrcFileForComment();
        pw.println(" * from " + file);
        if (!this.useScmSafeComments()) {
            pw.println(" * on " + new Date().toString() + ".");
        }
        pw.println(" * It contains a list of messages, and methods to");
        pw.println(" * retrieve and format those messages.");
        pw.println(" */");
        pw.println();
    }

    protected File getFile() {
        return this.file;
    }

    protected String getSrcFileForComment() {
        int slashPos;
        String filename = this.srcFile.toString().replace('\\', '/');
        if (this.useScmSafeComments() && (slashPos = filename.lastIndexOf(47)) > 0) {
            filename = "..." + filename.substring(slashPos);
        }
        return filename;
    }

    protected abstract String getClassName();

    protected abstract String getBaseClassName();

    protected String getParameterList(String message) {
        String[] types = this.getArgTypes(message);
        if (types.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(type);
            if (!type.endsWith("&") && !type.endsWith("*")) {
                sb.append(" ");
            }
            sb.append("p");
            sb.append(Integer.toString(i));
        }
        return sb.toString();
    }

    protected abstract String[] getArgTypes(String var1);

    protected String getArgumentList(String message) {
        String[] types = this.getArgTypes(message);
        if (types.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("p");
            sb.append(Integer.toString(i));
        }
        return sb.toString();
    }
}

