/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import org.eigenbase.resgen.CppGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.Util;

public class CppHeaderGenerator
extends CppGenerator {
    public CppHeaderGenerator(File srcFile, File file, String className, String baseClassName, String defaultExceptionClassName) {
        super(srcFile, file, className, baseClassName, defaultExceptionClassName, null);
    }

    @Override
    public void generateModule(ResourceGen generator, ResourceDef.ResourceBundle resourceList, PrintWriter pw) {
        ResourceDef.Resource resource;
        int i;
        this.generateDoNotModifyHeader(pw);
        this.generateGeneratedByBlock(pw);
        StringBuffer ifndef = new StringBuffer();
        String fileName = this.getFile().getName();
        ifndef.append(fileName.substring(0, fileName.length() - 2));
        ifndef.append("_Included");
        if (resourceList.cppNamespace != null) {
            ifndef.insert(0, '_');
            ifndef.insert(0, resourceList.cppNamespace.substring(1));
            ifndef.insert(0, Character.toUpperCase(resourceList.cppNamespace.charAt(0)));
        }
        pw.println("#ifndef " + ifndef.toString());
        pw.println("#define " + ifndef.toString());
        pw.println();
        pw.println("#include <ctime>");
        pw.println("#include <string>");
        pw.println();
        pw.println("#include \"Locale.h\"");
        pw.println("#include \"ResourceDefinition.h\"");
        pw.println("#include \"ResourceBundle.h\"");
        pw.println();
        pw.println("// begin includes specified by " + this.getSrcFileForComment());
        if (resourceList.cppExceptionClassLocation != null) {
            pw.println("#include \"" + resourceList.cppExceptionClassLocation + "\"");
        }
        for (int i2 = 0; i2 < resourceList.resources.length; ++i2) {
            ResourceDef.Resource resource2 = resourceList.resources[i2];
            if (!(resource2 instanceof ResourceDef.Exception)) continue;
            ResourceDef.Exception exception = (ResourceDef.Exception)resource2;
            if (exception.cppClassLocation == null) continue;
            pw.println("#include \"" + exception.cppClassLocation + "\"");
        }
        pw.println("// end includes specified by " + this.getSrcFileForComment());
        pw.println();
        if (resourceList.cppNamespace != null) {
            pw.println("namespace " + resourceList.cppNamespace + " {");
            pw.println();
        }
        pw.println();
        String baseClass = this.getBaseClassName();
        String className = this.getClassName();
        String bundleCacheClassName = className + "BundleCache";
        pw.println("class " + className + ";");
        pw.println("typedef map<Locale, " + className + "*> " + bundleCacheClassName + ";");
        pw.println();
        pw.println("class " + className + " : " + baseClass);
        pw.println("{");
        pw.println("    protected:");
        pw.println("    explicit " + className + "(Locale locale);");
        pw.println();
        pw.println("    public:");
        pw.println("    virtual ~" + className + "() { }");
        pw.println();
        pw.println("    static const " + className + " &instance();");
        pw.println("    static const " + className + " &instance(const Locale &locale);");
        pw.println();
        pw.println("    static void setResourceFileLocation(const std::string &location);");
        pw.println();
        for (i = 0; i < resourceList.resources.length; ++i) {
            resource = resourceList.resources[i];
            String text = resource.text.cdata;
            String comment = ResourceGen.getComment(resource);
            String parameterList = this.getParameterList(text);
            String resourceInitCap = ResourceGen.getResourceInitcap(resource);
            Util.generateCommentBlock(pw, resource.name, text, comment);
            pw.println("    std::string " + resource.name + "(" + parameterList + ") const;");
            if (resource instanceof ResourceDef.Exception) {
                boolean chainExceptions;
                ResourceDef.Exception exception = (ResourceDef.Exception)resource;
                String exceptionClass = exception.cppClassName;
                if (exceptionClass == null) {
                    exceptionClass = resourceList.cppExceptionClassName;
                }
                pw.println("    " + exceptionClass + "* new" + resourceInitCap + "(" + parameterList + ") const;");
                boolean bl = chainExceptions = exception.cppChainExceptions != null && exception.cppChainExceptions.equalsIgnoreCase("true");
                if (chainExceptions) {
                    if (parameterList.length() > 0) {
                        pw.println("    " + exceptionClass + "* new" + resourceInitCap + "(" + parameterList + ", const " + exceptionClass + " * const prev) const;");
                    } else {
                        pw.println("  " + exceptionClass + " new" + resourceInitCap + "(const " + exceptionClass + " * const prev) const;");
                    }
                }
            }
            pw.println();
        }
        pw.println("    private:");
        for (i = 0; i < resourceList.resources.length; ++i) {
            resource = resourceList.resources[i];
            pw.println("    ResourceDefinition _" + resource.name + ";");
        }
        pw.println();
        pw.println("    template<class _GRB, class _BC, class _BC_ITER>");
        pw.println("        friend _GRB *makeInstance(_BC &bundleCache, const Locale &locale);");
        pw.println("};");
        if (resourceList.cppNamespace != null) {
            pw.println();
            pw.println("} // end namespace " + resourceList.cppNamespace);
        }
        pw.println();
        pw.println("#endif // " + ifndef.toString());
    }
}

