/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import java.util.Locale;
import org.eigenbase.resgen.AbstractJavaGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.Util;

public class JavaLocaleGenerator
extends AbstractJavaGenerator {
    private final Locale locale;

    JavaLocaleGenerator(File srcFile, File file, String className, ResourceDef.ResourceBundle resourceBundle, Locale locale, String baseClassName) {
        super(srcFile, file, className, resourceBundle, baseClassName);
        this.locale = locale;
    }

    @Override
    public void generateModule(ResourceGen generator, ResourceDef.ResourceBundle resourceList, PrintWriter pw) {
        this.generateHeader(pw);
        String className = this.getClassName();
        String classNameSansPackage = Util.removePackage(className);
        String baseClass = this.getBaseClassName();
        String baseClassSansPackage = Util.removePackage(baseClass);
        pw.println("public class " + classNameSansPackage + " extends " + baseClassSansPackage + " {");
        pw.println("    public " + classNameSansPackage + "() throws IOException {");
        pw.println("    }");
        pw.println("}");
        pw.println("");
        this.generateFooter(pw, classNameSansPackage);
    }

    @Override
    public void generateResource(ResourceDef.Resource resource, PrintWriter pw) {
        throw new UnsupportedOperationException();
    }
}

