/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eigenbase.resgen.ResourceInstance;

public class ResourceDefinition {
    public final String key;
    public final String baseMessage;
    private final String[] props;
    private static final String[] EmptyStringArray = new String[0];
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_NUMBER = 1;
    public static final int TYPE_DATE = 2;
    public static final int TYPE_TIME = 3;
    private static final String[] TypeNames = new String[]{"string", "number", "date", "time"};

    public ResourceDefinition(String key, String baseMessage) {
        this(key, baseMessage, null);
    }

    public ResourceDefinition(String key, String baseMessage, String[] props) {
        this.key = key;
        this.baseMessage = baseMessage;
        if (props == null) {
            props = EmptyStringArray;
        }
        assert (props.length % 2 == 0) : "Must have even number of property names/values";
        this.props = props;
    }

    public String getKey() {
        return this.key;
    }

    public String getBaseMessage() {
        return this.baseMessage;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (int i = 0; i < this.props.length; ++i) {
            String prop = this.props[i];
            String value = this.props[++i];
            properties.setProperty(prop, value);
        }
        return properties;
    }

    public String[] getArgTypes() {
        return ResourceDefinition.getArgTypes(this.baseMessage, TypeNames);
    }

    public ResourceInstance instantiate(ResourceBundle bundle, Object[] args) {
        return new Instance(bundle, this, args);
    }

    protected static String[] getArgTypes(String message, String[] typeNames) {
        assert (typeNames.length == 4);
        try {
            Method method = MessageFormat.class.getMethod("getFormatsByArgumentIndex", null);
            try {
                MessageFormat format = new MessageFormat(message);
                Format[] argFormats = (Format[])method.invoke((Object)format, (Object[])null);
                String[] argTypes = new String[argFormats.length];
                for (int i = 0; i < argFormats.length; ++i) {
                    int x = ResourceDefinition.formatToType(argFormats[i]);
                    argTypes[i] = typeNames[x];
                }
                return argTypes;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.toString());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.toString());
            }
        }
        catch (NoSuchMethodException e) {
            return ResourceDefinition.getArgTypesByHand(message, typeNames);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected static String[] getArgTypesByHand(String message, String[] typeNames) {
        assert (typeNames.length == 4);
        String[] argTypes = new String[10];
        int length = 0;
        for (int i = 0; i < 10; ++i) {
            int type = ResourceDefinition.getArgType(i, message);
            if (type == -1) continue;
            length = i + 1;
            argTypes[i] = typeNames[type];
        }
        String[] argTypes2 = new String[length];
        System.arraycopy(argTypes, 0, argTypes2, 0, length);
        return argTypes2;
    }

    protected static int getArgType(int i, String message) {
        String arg = "{" + Integer.toString(i);
        int index = message.lastIndexOf(arg);
        if (index < 0) {
            return -1;
        }
        index += arg.length();
        int end = message.length();
        while (index < end && message.charAt(index) == ' ') {
            ++index;
        }
        if (index < end && message.charAt(index) == ',') {
            ++index;
            while (index < end && message.charAt(index) == ' ') {
                ++index;
            }
            if (index < end) {
                String sub = message.substring(index);
                if (sub.startsWith("number")) {
                    return 1;
                }
                if (sub.startsWith("date")) {
                    return 2;
                }
                if (sub.startsWith("time")) {
                    return 3;
                }
                if (sub.startsWith("choice")) {
                    return -1;
                }
            }
        }
        return 0;
    }

    private static int formatToType(Format format) {
        if (format == null) {
            return 0;
        }
        if (format instanceof NumberFormat) {
            return 1;
        }
        if (format instanceof DateFormat) {
            return 2;
        }
        return 0;
    }

    private static class Instance
    implements ResourceInstance {
        ResourceDefinition definition;
        ResourceBundle bundle;
        Object[] args;

        public Instance(ResourceBundle bundle, ResourceDefinition definition, Object[] args) {
            this.definition = definition;
            this.bundle = bundle;
            this.args = args;
        }

        @Override
        public String toString() {
            String message = this.bundle.getString(this.definition.key);
            MessageFormat format = new MessageFormat(message);
            format.setLocale(this.bundle.getLocale());
            String formattedMessage = format.format(this.args);
            return formattedMessage;
        }
    }
}

