/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eigenbase.resgen.FileTask;
import org.eigenbase.resgen.ResourceGen;

public class ResourceGenTask
extends Task {
    private ArrayList resources = new ArrayList();
    int mode = 1;
    File src;
    File dest;
    File res;
    int style = 1;
    String locales;
    boolean force;
    int commentStyle = 1;
    private static final int MODE_UNKNOWN = -1;
    private static final int MODE_JAVA = 1;
    private static final int MODE_CPP = 2;
    private static final int MODE_ALL = 3;
    public static final int STYLE_DYNAMIC = 1;
    public static final int STYLE_FUNCTOR = 2;
    public static final int COMMENT_STYLE_NORMAL = 1;
    public static final int COMMENT_STYLE_SCM_SAFE = 2;

    public void execute() throws BuildException {
        this.validate();
        try {
            new ResourceGen().run(this);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void addInclude(Include resourceArgs) {
        this.resources.add(resourceArgs);
        resourceArgs.root = this;
    }

    void validate() {
        if (this.mode != 1 && this.mode != 2 && this.mode != 3) {
            throw new BuildException("You must specify a value mode: java, c++, or all");
        }
        if (this.src == null) {
            throw new BuildException("You must specify 'srcdir'");
        }
        if (this.dest == null) {
            this.dest = this.src;
        }
        if (this.res == null) {
            this.res = this.dest;
        }
        Include[] args = this.getIncludes();
        for (int i = 0; i < args.length; ++i) {
            args[i].validate();
        }
    }

    Include[] getIncludes() {
        return this.resources.toArray(new Include[0]);
    }

    public void setMode(String mode) throws BuildException {
        this.mode = "java".equals(mode) ? 1 : ("c++".equals(mode) ? 2 : ("all".equals(mode) ? 3 : -1));
    }

    public void setSrcdir(File srcDir) {
        this.src = srcDir;
    }

    public File getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.dest = destDir;
    }

    public File getDestdir() {
        return this.dest;
    }

    public void setResdir(File resDir) {
        this.res = resDir;
    }

    public void setStyle(String style) throws BuildException {
        if (style.equals("dynamic")) {
            this.style = 1;
        } else if (style.equals("functor")) {
            this.style = 2;
        } else {
            throw new BuildException("Invalid style '" + style + "'");
        }
    }

    public void setLocales(String locales) throws BuildException {
        this.locales = locales;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setCommentStyle(String commentStyle) throws BuildException {
        if (commentStyle.equals("normal")) {
            this.commentStyle = 1;
        } else if (commentStyle.equals("scm-safe")) {
            this.commentStyle = 2;
        } else {
            throw new BuildException("Invalid commentstyle '" + commentStyle + "'");
        }
    }

    public static class Include {
        ResourceGenTask root;
        String fileName;
        String className;
        String baseClassName;
        String cppClassName;
        String cppBaseClassName;

        void validate() throws BuildException {
            if (this.fileName == null) {
                throw new BuildException("You must specify attribute 'name'");
            }
        }

        void process(ResourceGen generator) throws BuildException {
            FileTask task;
            boolean outputCpp;
            boolean outputJava = this.root.mode != 2;
            boolean bl = outputCpp = this.root.mode != 1;
            if (this.fileName.endsWith(".xml")) {
                task = generator.createXmlTask(this, this.fileName, this.className, this.baseClassName, outputJava, this.cppClassName, this.cppBaseClassName, outputCpp);
            } else if (this.fileName.endsWith(".properties")) {
                task = generator.createPropertiesTask(this, this.fileName);
            } else {
                throw new BuildException("File '" + this.fileName + "' is not of a supported type (.java or .properties)");
            }
            try {
                task.process(generator);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BuildException("Failed while processing '" + this.fileName + "'", (Throwable)e);
            }
        }

        public void setName(String name) {
            this.fileName = name;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setBaseClassName(String baseClassName) {
            this.baseClassName = baseClassName;
        }

        String getBaseClassName() {
            return this.baseClassName;
        }

        public void setCppClassName(String className) {
            this.cppClassName = className;
        }

        public void setCppBaseClassName(String baseClassName) {
            this.cppBaseClassName = baseClassName;
        }

        String getCppBaseClassName() {
            return this.cppBaseClassName;
        }
    }
}

