/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.eigenbase.xom.StringEscaper;

public class XMLUtil {
    public static boolean stringHasXMLSpecials(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    return true;
                }
            }
        }
        return false;
    }

    public static void stringEncodeXML(String input, PrintWriter out) {
        block3: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    out.print("&#" + c + ";");
                    continue block3;
                }
                default: {
                    out.print(c);
                }
            }
        }
    }

    public static void printPCDATA(PrintWriter pw, String data) {
        if (data.indexOf("]]>") > -1) {
            String s = StringEscaper.xmlEscaper.escapeString(data);
            pw.print(s);
        } else {
            pw.print("<![CDATA[");
            pw.print(data);
            pw.print("]]>");
        }
    }

    public static String quotePCDATA(String data) {
        if (data.indexOf("]]>") > -1) {
            return StringEscaper.xmlEscaper.escapeString(data);
        }
        return "<![CDATA[" + data + "]]>";
    }

    public static void printPCDATA(PrintWriter pw, String tag, String data, boolean newline) {
        if (data == null || data.length() == 0) {
            return;
        }
        pw.print("<");
        pw.print(tag);
        pw.print(">");
        XMLUtil.printPCDATA(pw, data);
        pw.print("</");
        pw.print(tag);
        pw.print(">");
        if (newline) {
            pw.println();
        }
    }

    public static void printPCDATA(PrintWriter pw, String tag, String data) {
        boolean newline = false;
        XMLUtil.printPCDATA(pw, tag, data, newline);
    }

    private static String escapeForQuoting(String val) {
        return StringEscaper.xmlNumericEscaper.escapeString(val);
    }

    public static String quoteAtt(String val) {
        return "\"" + XMLUtil.escapeForQuoting(val) + "\"";
    }

    public static String quoteAtt(String name, String val) {
        if (val == null || val.equals("")) {
            return "";
        }
        return " " + name + "=" + XMLUtil.quoteAtt(val);
    }

    public static String quoteAtt(String name, int val) {
        return " " + name + "=\"" + val + "\"";
    }

    public static String quoteAtt(String name, boolean val) {
        return " " + name + "=\"" + (val ? "TRUE" : "FALSE") + "\"";
    }

    public static void printAtt(PrintWriter pw, String val) {
        pw.print("\"");
        pw.print(XMLUtil.escapeForQuoting(val));
        pw.print("\"");
    }

    public static void printAtt(PrintWriter pw, String name, String val) {
        if (val != null) {
            pw.print(" ");
            pw.print(name);
            pw.print("=\"");
            pw.print(XMLUtil.escapeForQuoting(val));
            pw.print("\"");
        }
    }

    public static void printAtt(PrintWriter pw, String name, int val) {
        pw.print(" ");
        pw.print(name);
        pw.print("=\"");
        pw.print(val);
        pw.print("\"");
    }

    public static void printAtt(PrintWriter pw, String name, boolean val) {
        pw.print(" ");
        pw.print(name);
        pw.print(val ? "=\"true\"" : "=\"false\"");
    }

    public static String getFirstTagName(Reader xml) {
        boolean OUTSIDE = false;
        boolean BRACKET = true;
        int COMMENT = 2;
        int IGNORE = 3;
        int TAG = 4;
        int state = 0;
        String commentMatch = null;
        StringBuffer tagBuffer = null;
        boolean sawBang = false;
        try {
            int c = xml.read();
            while (true) {
                if (c == -1) {
                    return null;
                }
                block1 : switch (state) {
                    case 0: {
                        if (c == 60) {
                            state = 1;
                            commentMatch = "!--";
                            sawBang = false;
                            c = xml.read();
                            break;
                        }
                        if (!Character.isWhitespace((char)c)) {
                            return null;
                        }
                        c = xml.read();
                        break;
                    }
                    case 1: {
                        if (commentMatch != null) {
                            if (c == commentMatch.charAt(0)) {
                                if (commentMatch.length() == 1) {
                                    c = xml.read();
                                    commentMatch = "-->";
                                    state = 2;
                                } else {
                                    commentMatch = commentMatch.substring(1, commentMatch.length());
                                }
                            } else {
                                commentMatch = null;
                            }
                        }
                        if (Character.isWhitespace((char)c)) {
                            c = xml.read();
                            break;
                        }
                        switch (c) {
                            case 63: {
                                c = xml.read();
                                state = 3;
                                break block1;
                            }
                            case 33: {
                                c = xml.read();
                                sawBang = true;
                                if (commentMatch != null) break block1;
                                state = 3;
                                break block1;
                            }
                            case 45: {
                                c = xml.read();
                                if (commentMatch != null) break block1;
                                state = 3;
                                break block1;
                            }
                            case 62: {
                                c = xml.read();
                                state = 0;
                                break block1;
                            }
                        }
                        state = sawBang ? 3 : 4;
                        tagBuffer = new StringBuffer();
                        break;
                    }
                    case 2: {
                        if (c == commentMatch.charAt(0)) {
                            c = xml.read();
                            if (commentMatch.length() == 1) {
                                state = 0;
                                break;
                            }
                            commentMatch = commentMatch.substring(1, commentMatch.length());
                            break;
                        }
                        c = xml.read();
                        commentMatch = "-->";
                        break;
                    }
                    case 3: {
                        if (c == 62) {
                            c = xml.read();
                            state = 0;
                            break;
                        }
                        c = xml.read();
                        break;
                    }
                    case 4: {
                        if (Character.isWhitespace((char)c) || c == 62 || c == 47) {
                            return tagBuffer.toString();
                        }
                        tagBuffer.append((char)c);
                        c = xml.read();
                    }
                }
            }
        }
        catch (IOException ex) {
            return null;
        }
    }
}

