/* FiltexParserImpl.java */
/* Generated By:JavaCC: Do not edit this line. FiltexParserImpl.java */
package net.hydromatic.filtex.parse;

import net.hydromatic.filtex.ast.Ast;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.Bound;
import net.hydromatic.filtex.ast.Date;
import net.hydromatic.filtex.ast.DatetimeUnit;
import net.hydromatic.filtex.ast.Location;
import net.hydromatic.filtex.ast.Op;
import net.hydromatic.filtex.ast.Pos;
import net.hydromatic.filtex.ast.Time;
import net.hydromatic.filtex.ast.Unit;

import org.checkerframework.checker.nullness.qual.Nullable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

import static net.hydromatic.filtex.ast.AstBuilder.ast;

/**
 * Parser for filter expressions, generated from FiltexParser.jj by JavaCC.
 */
public class FiltexParserImpl implements FiltexParser, FiltexParserImplConstants {
  private static final Logger LOGGER =
      LoggerFactory.getLogger("net.hydromatic.filtex.parse");

  private static final Pattern YEAR_PATTERN =
     Pattern.compile("[0-9][0-9][0-9][0-9]");

  private static final Pattern POSITIVE_INTEGER_PATTERN =
     Pattern.compile("[1-9][0-9]*");

  private int lineOffset;
  private String file = "";

  public void setTabSize(int tabSize) {
    jj_input_stream.setTabSize(tabSize);
  }

  public Pos pos() {
    return new Pos(file,
        token.beginLine - lineOffset, token.beginColumn,
        token.endLine - lineOffset, token.endColumn + 1);
  }

  public void zero(String file) {
    this.file = file;
    if (jj_input_stream.bufpos >= 0) {
      this.lineOffset = jj_input_stream.bufline[jj_input_stream.bufpos];
    }
  }

  void debug_message1() throws ParseException {LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

/** Parses a date filter expression followed by end-of-file. */
  final public AstNode dateExpressionEof() throws ParseException {final AstNode node;
    node = dateExpression();
    jj_consume_token(0);
{if ("" != null) return node;}
    throw new Error("Missing return statement in function");
}

/** Parses a location filter expression followed by end-of-file. */
  final public AstNode locationExpressionEof() throws ParseException {final AstNode node;
    node = locationExpression();
    jj_consume_token(0);
{if ("" != null) return node;}
    throw new Error("Missing return statement in function");
}

/** Parses a numeric filter expression followed by end-of-file. */
  final public AstNode numericExpressionEof() throws ParseException {final AstNode node;
    node = numericExpression();
    jj_consume_token(0);
{if ("" != null) return node;}
    throw new Error("Missing return statement in function");
}

// == Date ===================================================================

/** Parses a date expression.
 *
 * <p>Accepts expressions like: TODO
 */
  final public AstNode dateExpression() throws ParseException {final List<AstNode> list = new ArrayList<>();
    addDateTerm(list);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
      addTerm(list);
    }
{if ("" != null) return ast.logicalExpression(list);}
    throw new Error("Missing return statement in function");
}

/** Adds a date term to a list. */
  final public void addDateTerm(List<AstNode> list) throws ParseException {final AstNode node;
    node = dateTerm();
list.add(node);
}

/** Parses a date term. */
  final public AstNode dateTerm() throws ParseException {final boolean is;
  final AstNode node;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOUBLE_LBRACE:{
      node = userAttribute();
{if ("" != null) return node;}
      break;
      }
    case YYYY_MM_DD:{
      node = onDatetime();
{if ("" != null) return node;}
      break;
      }
    case YEAR_QUARTER:{
      node = yearQuarter();
{if ("" != null) return node;}
      break;
      }
    case YEAR_MONTH:{
      node = yearMonth();
{if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      if (jj_2_1(1)) {
        node = year();
{if ("" != null) return node;}
      } else if (jj_2_2(1)) {
        node = relativeRange();
{if ("" != null) return node;}
      } else if (jj_2_3(3)) {
        node = thisRange();
{if ("" != null) return node;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NEXT:
        case THIS:{
          node = thisNext();
{if ("" != null) return node;}
          break;
          }
        case LAST:{
          node = last();
{if ("" != null) return node;}
          break;
          }
        case MONDAY:
        case TUESDAY:
        case WEDNESDAY:
        case THURSDAY:
        case FRIDAY:
        case SATURDAY:
        case SUNDAY:
        case TODAY:
        case YESTERDAY:
        case TOMORROW:{
          node = dayExpression();
{if ("" != null) return node;}
          break;
          }
        case AFTER:
        case BEFORE:{
          node = absoluteBeforeAfter();
{if ("" != null) return node;}
          break;
          }
        case FY_YEAR_QUARTER:{
          node = fiscalQuarter();
{if ("" != null) return node;}
          break;
          }
        case FY_YEAR:{
          node = fiscalYear();
{if ("" != null) return node;}
          break;
          }
        case 21:
        case NOT:
        case NULL:{
          node = nulls();
{if ("" != null) return node;}
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
}

// E.g. "3 days"
  final public Ast.Interval nInterval() throws ParseException {final BigDecimal value;
  final DatetimeUnit unit;
    value = positiveInteger();
    unit = intervalUnit();
{if ("" != null) return ast.interval(unit, value);}
    throw new Error("Missing return statement in function");
}

  final public BigDecimal positiveInteger() throws ParseException {
    if (getToken(1).kind == NUMBER_LITERAL
        && POSITIVE_INTEGER_PATTERN.matcher(getToken(1).image).matches()) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(NUMBER_LITERAL);
{if ("" != null) return new BigDecimal(token.image);}
    throw new Error("Missing return statement in function");
}

// "today", "friday"
  final public AstNode dayExpression() throws ParseException {final String day;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MONDAY:
    case TUESDAY:
    case WEDNESDAY:
    case THURSDAY:
    case FRIDAY:
    case SATURDAY:
    case SUNDAY:{
      day = dayOfWeekKeyword();
      break;
      }
    case TODAY:
    case YESTERDAY:
    case TOMORROW:{
      day = dayKeyword();
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ast.day(day);}
    throw new Error("Missing return statement in function");
}

  final public String dayKeyword() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TODAY:{
      jj_consume_token(TODAY);
      break;
      }
    case YESTERDAY:{
      jj_consume_token(YESTERDAY);
      break;
      }
    case TOMORROW:{
      jj_consume_token(TOMORROW);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image.toLowerCase(Locale.ROOT);}
    throw new Error("Missing return statement in function");
}

  final public String dayOfWeekKeyword() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MONDAY:{
      jj_consume_token(MONDAY);
      break;
      }
    case TUESDAY:{
      jj_consume_token(TUESDAY);
      break;
      }
    case WEDNESDAY:{
      jj_consume_token(WEDNESDAY);
      break;
      }
    case THURSDAY:{
      jj_consume_token(THURSDAY);
      break;
      }
    case FRIDAY:{
      jj_consume_token(FRIDAY);
      break;
      }
    case SATURDAY:{
      jj_consume_token(SATURDAY);
      break;
      }
    case SUNDAY:{
      jj_consume_token(SUNDAY);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image.toLowerCase(Locale.ROOT);}
    throw new Error("Missing return statement in function");
}

  final public AstNode year() throws ParseException {
    if (getToken(1).kind == NUMBER_LITERAL
        && YEAR_PATTERN.matcher(getToken(1).image).matches()) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(NUMBER_LITERAL);
{if ("" != null) return ast.year(Integer.parseInt(token.image));}
    throw new Error("Missing return statement in function");
}

  final public AstNode fiscalYear() throws ParseException {
    jj_consume_token(FY_YEAR);
{if ("" != null) return ast.fiscalYear(Integer.parseInt(token.image.substring(2)));}
    throw new Error("Missing return statement in function");
}

  final public AstNode fiscalQuarter() throws ParseException {
    jj_consume_token(FY_YEAR_QUARTER);
{if ("" != null) return ast.fiscalQuarter(Integer.parseInt(token.image.substring(2, 6)),
        Integer.parseInt(token.image.substring(8, 9)));}
    throw new Error("Missing return statement in function");
}

// "2018/05", "2018/05 for 2 months"
  final public AstNode yearMonth() throws ParseException {final int year;
  final int month;
  final Ast.Interval end;
    jj_consume_token(YEAR_MONTH);
year = Integer.parseInt(token.image.substring(0, 4));
    month = Integer.parseInt(token.image.substring(5, 7));
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FOR:{
      jj_consume_token(FOR);
      end = nInterval();
{if ("" != null) return ast.monthInterval(year, month, end);}
      break;
      }
    default:
      jj_la1[6] = jj_gen;
{if ("" != null) return ast.month(year, month);}
    }
    throw new Error("Missing return statement in function");
}

// "2018-Q4"
  final public AstNode yearQuarter() throws ParseException {
    jj_consume_token(YEAR_QUARTER);
{if ("" != null) return ast.quarter(Integer.parseInt(token.image.substring(0, 4)),
        Integer.parseInt(token.image.substring(6, 7)));}
    throw new Error("Missing return statement in function");
}

// break units as used by the this/next/last expressions
  final public DatetimeUnit intervalUnit() throws ParseException {DatetimeUnit unit;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:{
      unit = timeUnit();
{if ("" != null) return unit;}
      break;
      }
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:{
      unit = dateUnit();
{if ("" != null) return unit;}
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// break units as used by the this/next/last expressions
  final public DatetimeUnit timeUnit() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 1:{
      jj_consume_token(1);
      break;
      }
    case 2:{
      jj_consume_token(2);
      break;
      }
    case 3:{
      jj_consume_token(3);
      break;
      }
    case 4:{
      jj_consume_token(4);
      break;
      }
    case 5:{
      jj_consume_token(5);
      break;
      }
    case 6:{
      jj_consume_token(6);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return DatetimeUnit.of(token.image);}
    throw new Error("Missing return statement in function");
}

  final public DatetimeUnit dateUnit() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 7:{
      jj_consume_token(7);
      break;
      }
    case 8:{
      jj_consume_token(8);
      break;
      }
    case 9:{
      jj_consume_token(9);
      break;
      }
    case 10:{
      jj_consume_token(10);
      break;
      }
    case 11:{
      jj_consume_token(11);
      break;
      }
    case 12:{
      jj_consume_token(12);
      break;
      }
    case 13:{
      jj_consume_token(13);
      break;
      }
    case 14:{
      jj_consume_token(14);
      break;
      }
    case 15:{
      jj_consume_token(15);
      break;
      }
    case 16:{
      jj_consume_token(16);
      break;
      }
    case 17:{
      jj_consume_token(17);
      break;
      }
    case 18:{
      jj_consume_token(18);
      break;
      }
    case 19:{
      jj_consume_token(19);
      break;
      }
    case 20:{
      jj_consume_token(20);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return DatetimeUnit.of(token.image);}
    throw new Error("Missing return statement in function");
}

// "this day", "next week"
  final public AstNode thisNext() throws ParseException {final Op op;
  final DatetimeUnit unit;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case THIS:{
      jj_consume_token(THIS);
op = Op.THIS;
      break;
      }
    case NEXT:{
      jj_consume_token(NEXT);
op = Op.NEXT;
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    unit = dateUnit();
{if ("" != null) return ast.thisUnit(op, unit);}
    throw new Error("Missing return statement in function");
}

// "last year",
// "last 3 days"
  final public AstNode last() throws ParseException {final Ast.Interval interval;
  final DatetimeUnit unit;
    jj_consume_token(LAST);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:{
      unit = intervalUnit();
{if ("" != null) return ast.thisUnit(Op.LAST, unit);}
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      if (jj_2_4(1)) {
        interval = nInterval();
{if ("" != null) return ast.lastInterval(interval.value, interval.unit);}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

// "this day to second"
  final public AstNode thisRange() throws ParseException {final DatetimeUnit startInterval;
 final DatetimeUnit endInterval;
    jj_consume_token(THIS);
    startInterval = intervalUnit();
    jj_consume_token(TO);
    endInterval = intervalUnit();
{if ("" != null) return ast.thisRange(startInterval, endInterval);}
    throw new Error("Missing return statement in function");
}

// True for "from now", false for "ago"
  final public boolean intervalType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AGO:{
      jj_consume_token(AGO);
{if ("" != null) return false;}
      break;
      }
    case FROM:{
      jj_consume_token(FROM);
      jj_consume_token(NOW);
{if ("" != null) return true;}
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// "3 days from now for 2 weeks"
// "3 months ago for 2 days"
// "3 days ago for 3 days" (complete)
// "3 days"
// "3 days ago"
  final public AstNode relativeRange() throws ParseException {final Ast.Interval startInterval;
  final boolean fromNow;
  final Ast.Interval endInterval;
    startInterval = nInterval();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AGO:
    case FROM:{
      fromNow = intervalType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FOR:{
        jj_consume_token(FOR);
        endInterval = nInterval();
if (startInterval.equals(endInterval)) {
          {if ("" != null) return ast.past(startInterval.value, startInterval.unit, true);}
        }
        {if ("" != null) return ast.relativeRange(fromNow, startInterval, endInterval);}
        break;
        }
      default:
        jj_la1[13] = jj_gen;
{if ("" != null) return ast.relative(fromNow, startInterval);}
      }
      break;
      }
    default:
      jj_la1[14] = jj_gen;
{if ("" != null) return ast.past(startInterval.value, startInterval.unit);}
    }
    throw new Error("Missing return statement in function");
}

// Returns true for "before", false for "after"
  final public boolean beforeAfter() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BEFORE:{
      jj_consume_token(BEFORE);
{if ("" != null) return true;}
      break;
      }
    case AFTER:{
      jj_consume_token(AFTER);
{if ("" != null) return false;}
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// "after 2018/05/10",
// "before 2018/05/10"
// "before 3 days"
// "before 3 days ago"
// "before 3 days from now"
  final public AstNode absoluteBeforeAfter() throws ParseException {final boolean before;
  final Ast.Interval interval;
  final boolean fromNow;
  final Op op;
  final DatetimeUnit unit;
  final Date date;
    before = beforeAfter();
    if (jj_2_5(1)) {
      interval = nInterval();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AGO:
      case FROM:{
        fromNow = intervalType();
        break;
        }
      default:
        jj_la1[16] = jj_gen;
fromNow = false;
      }
{if ("" != null) return ast.relativeUnit(before, fromNow, interval.value, interval.unit);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LAST:
      case NEXT:
      case THIS:{
        op = thisNextLast();
        unit = dateUnit();
{if ("" != null) return ast.relative1(before, op, unit);}
        break;
        }
      case YYYY_MM_DD:{
        date = datetime();
{if ("" != null) return ast.absolute(date, before);}
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

  final public Op thisNextLast() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case THIS:{
      jj_consume_token(THIS);
{if ("" != null) return Op.THIS;}
      break;
      }
    case LAST:{
      jj_consume_token(LAST);
{if ("" != null) return Op.LAST;}
      break;
      }
    case NEXT:{
      jj_consume_token(NEXT);
{if ("" != null) return Op.NEXT;}
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// "2019/01/01 08:45:00" (on)
// or "2018/05/10 for 5 months" (rangeInterval)
// or "2018-05-18 12:00:00 to 2018-05-18 14:00:00" (range)
  final public AstNode onDatetime() throws ParseException {final Date start;
  final Ast.Interval endInterval;
  final Date end;
    start = datetime();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FOR:{
      jj_consume_token(FOR);
      endInterval = nInterval();
{if ("" != null) return ast.rangeInterval(start, endInterval);}
      break;
      }
    case TO:{
      jj_consume_token(TO);
      end = datetime();
{if ("" != null) return ast.range(start, end);}
      break;
      }
    default:
      jj_la1[19] = jj_gen;
{if ("" != null) return ast.on(start);}
    }
    throw new Error("Missing return statement in function");
}

// Date or Datetime
  final public Date datetime() throws ParseException {final Date date;
  final Time time;
    date = date();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HH_MM_SS:{
      time = time();
{if ("" != null) return date.plus(time);}
      break;
      }
    default:
      jj_la1[20] = jj_gen;
{if ("" != null) return date;}
    }
    throw new Error("Missing return statement in function");
}

  final public Date date() throws ParseException {
    jj_consume_token(YYYY_MM_DD);
{if ("" != null) return new Date(Integer.parseInt(token.image.substring(0, 4)),
      Integer.parseInt(token.image.substring(5, 7)),
      Integer.parseInt(token.image.substring(8, 10)));}
    throw new Error("Missing return statement in function");
}

  final public Time time() throws ParseException {
    jj_consume_token(HH_MM_SS);
{if ("" != null) return new Time(Integer.parseInt(token.image.substring(0, 2)),
      Integer.parseInt(token.image.substring(3, 5)),
      token.image.length() == 8
        ? Integer.parseInt(token.image.substring(6, 8))
        : null);}
    throw new Error("Missing return statement in function");
}

// == Location ===============================================================

/** Parses a location expression.
 *
 * <p>Accepts expressions like:
 * "{@code 36.97, -122.03}",
 * "{@code 40 miles from 36.97, -122.03}",
 * "{@code inside box from 72.33, -173.14 to 14.39, -61.70}"
 */
  final public AstNode locationExpression() throws ParseException {final AstNode node;
  final Location location;
    if (jj_2_6(2)) {
      // distinguish location (number comma) from circle (number unit)
        node = circle();
{if ("" != null) return node;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER_LITERAL:
      case NUMBER_LITERAL0:{
        location = location();
{if ("" != null) return ast.point(location);}
        break;
        }
      case INSIDE:{
        node = box();
{if ("" != null) return node;}
        break;
        }
      case DOUBLE_LBRACE:{
        node = userAttribute();
{if ("" != null) return node;}
        break;
        }
      case 21:
      case NOT:
      case NULL:{
        node = nulls();
{if ("" != null) return node;}
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        node = anywhere();
{if ("" != null) return node;}
      }
    }
    throw new Error("Missing return statement in function");
}

  final public AstNode anywhere() throws ParseException {
{if ("" != null) return ast.anywhere();}
    throw new Error("Missing return statement in function");
}

  final public AstNode nulls() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:{
      jj_consume_token(NULL);
{if ("" != null) return ast.isNull(true);}
      break;
      }
    case NOT:{
      jj_consume_token(NOT);
      jj_consume_token(NULL);
{if ("" != null) return ast.isNotNull();}
      break;
      }
    case 21:{
      jj_consume_token(21);
      jj_consume_token(NULL);
{if ("" != null) return ast.isNotNull();}
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public AstNode box() throws ParseException {final Location from;
  final Location to;
    jj_consume_token(INSIDE);
    jj_consume_token(BOX);
    jj_consume_token(FROM);
    from = location();
    jj_consume_token(TO);
    to = location();
{if ("" != null) return ast.box(from, to);}
    throw new Error("Missing return statement in function");
}

  final public AstNode circle() throws ParseException {final BigDecimal distance;
  final Unit unit;
  final Location location;
    distance = number();
    unit = unit();
    jj_consume_token(FROM);
    location = location();
if (distance.signum() < 0) {
      {if (true) throw new ParseException("expected a positive value");}
    }
    {if ("" != null) return ast.circle(distance, unit, location);}
    throw new Error("Missing return statement in function");
}

  final public Location location() throws ParseException {final BigDecimal latitude;
  final BigDecimal longitude;
    latitude = number();
    jj_consume_token(COMMA);
    longitude = number();
if (latitude.compareTo(BigDecimal.valueOf(-90)) < 0
        || latitude.compareTo(BigDecimal.valueOf(90)) > 0) {
      {if (true) throw new ParseException("expected a number between -90 and 90");}
    }
    if (longitude.compareTo(BigDecimal.valueOf(-180)) < 0
        || longitude.compareTo(BigDecimal.valueOf(180)) > 0) {
      {if (true) throw new ParseException("expected a number between -180 and 180");}
    }
    {if ("" != null) return new Location(latitude, longitude);}
    throw new Error("Missing return statement in function");
}

  final public Unit unit() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case METERS:{
      jj_consume_token(METERS);
{if ("" != null) return Unit.METER;}
      break;
      }
    case FEET:{
      jj_consume_token(FEET);
{if ("" != null) return Unit.FOOT;}
      break;
      }
    case KILOMETERS:{
      jj_consume_token(KILOMETERS);
{if ("" != null) return Unit.KILOMETER;}
      break;
      }
    case MILES:{
      jj_consume_token(MILES);
{if ("" != null) return Unit.MILE;}
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// == Number =================================================================

/** Parses a numeric expression.
 *
 * <p>Accepts expressions like "not 66, 99, 4", "1 to 100"
 * and returns an AST.
 * See https://docs.looker.com/reference/filter-expressions#number
 *
 * <p>A top-level numeric expression is a comma-separated list of terms.
 */
  final public AstNode numericExpression() throws ParseException {final List<AstNode> list = new ArrayList<>();
    addTerm(list);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      case OR:{
        jj_consume_token(OR);
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      addTerm(list);
    }
{if ("" != null) return ast.logicalExpression(list);}
    throw new Error("Missing return statement in function");
}

/** Adds a term to a list. */
  final public void addTerm(List<AstNode> list) throws ParseException {final AstNode node;
    node = term();
list.add(node);
}

/** Parses a numeric term. */
  final public AstNode term() throws ParseException {final boolean is;
  final AstNode node;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOUBLE_LBRACE:{
      node = userAttribute();
{if ("" != null) return node;}
      break;
      }
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case NUMBER_LITERAL:
    case NUMBER_LITERAL0:
    case NOT:
    case TO:
    case BANG_EQ:
    case LT_GT:
    case NULL:{
      is = is();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NULL:{
        jj_consume_token(NULL);
node = ast.isNull(is);
        break;
        }
      case 22:
      case 23:{
        node = intervalComp1(is);
        break;
        }
      case 24:
      case 25:{
        node = intervalComp2(is);
        break;
        }
      case NUMBER_LITERAL:
      case NUMBER_LITERAL0:
      case TO:{
        node = to(is);
        break;
        }
      case 26:
      case 27:{
        node = interval(is);
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

/** Reads an optional prefix ("not", "&lt;&gt;", "!=") and returns whether the
 * following term should be negated. */
  final public boolean is() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
{if ("" != null) return false;}
      break;
      }
    case BANG_EQ:{
      jj_consume_token(BANG_EQ);
{if ("" != null) return false;}
      break;
      }
    case LT_GT:{
      jj_consume_token(LT_GT);
{if ("" != null) return false;}
      break;
      }
    default:
      jj_la1[28] = jj_gen;
{if ("" != null) return true;}
    }
    throw new Error("Missing return statement in function");
}

/* Special rules for defining BETWEEN ranges using comparison operators with AND/OR */

/** Special interval,
 * "{@code >= 7 AND <80.44}" becomes "(7, 80.44)", and
 * "{@code >=80.44 OR <.1}" becomes "(0.01, 80.44]".
 * Also parses comparison, "{@code > 10}". */
  final public AstNode intervalComp1(boolean is) throws ParseException {final Bound leftBound;
 final BigDecimal left;
 final BigDecimal right;
 final Bound rightBound;
 final boolean reverse;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 22:{
      jj_consume_token(22);
leftBound = Bound.OPEN;
      break;
      }
    case 23:{
      jj_consume_token(23);
leftBound = Bound.CLOSED;
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    left = number();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        jj_consume_token(AND);
reverse = false;
        break;
        }
      case OR:{
        jj_consume_token(OR);
reverse = true;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 24:{
        jj_consume_token(24);
rightBound = Bound.OPEN;
        break;
        }
      case 25:{
        jj_consume_token(25);
rightBound = Bound.CLOSED;
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = number();
if (reverse) {
        // FIXME number_grammar.ts passes false, should pass !is
        {if ("" != null) return ast.between(!is, leftBound.flip(), rightBound.flip(), right,
            left);}
      } else {
        {if ("" != null) return ast.between(is, leftBound, rightBound, left, right);}
      }
      break;
      }
    default:
      jj_la1[32] = jj_gen;
{if ("" != null) return ast.between(is, leftBound, Bound.ABSENT, left, null);}
    }
    throw new Error("Missing return statement in function");
}

/** Special interval, second kind;
 * "{@code <=80.44  AND    >.1}"  becomes "(0.01, 80.44]", and
 * "{@code <= 7 OR >80.44}" becomes "[7, 80.44)".
 * Also parses comparison, "{@code < 10}". */
  final public AstNode intervalComp2(boolean is) throws ParseException {final Bound leftBound;
 final BigDecimal left;
 final BigDecimal right;
 final Bound rightBound;
 final boolean reverse;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 24:{
      jj_consume_token(24);
leftBound = Bound.OPEN;
      break;
      }
    case 25:{
      jj_consume_token(25);
leftBound = Bound.CLOSED;
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    left = number();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AND:
    case OR:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        jj_consume_token(AND);
reverse = false;
        break;
        }
      case OR:{
        jj_consume_token(OR);
reverse = true;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 22:{
        jj_consume_token(22);
rightBound = Bound.OPEN;
        break;
        }
      case 23:{
        jj_consume_token(23);
rightBound = Bound.CLOSED;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = number();
if (reverse) {
        // FIXME number_grammar.ts passes false, should pass !is
        {if ("" != null) return ast.between(!is, rightBound.flip(), leftBound.flip(), left, right);}
      } else {
        {if ("" != null) return ast.between(is, rightBound, leftBound, right, left);}
      }
      break;
      }
    default:
      jj_la1[36] = jj_gen;
{if ("" != null) return ast.between(is, Bound.ABSENT, leftBound, null, left);}
    }
    throw new Error("Missing return statement in function");
}

/** Parses a range (such as "5 to 10", "to 10", "5 to"), and also a numeric
 * literal (such as "5"). */
  final public AstNode to(boolean is) throws ParseException {final BigDecimal begin;
  final BigDecimal end;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NUMBER_LITERAL:
    case NUMBER_LITERAL0:{
      begin = number();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TO:{
        jj_consume_token(TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NUMBER_LITERAL:
        case NUMBER_LITERAL0:{
          end = number();
{if ("" != null) return ast.between(is, Bound.CLOSED, Bound.CLOSED, begin, end);}
          break;
          }
        default:
          jj_la1[37] = jj_gen;
{if ("" != null) return ast.between(Op.CLOSED_ABSENT, is, begin);}
        }
        break;
        }
      default:
        jj_la1[38] = jj_gen;
{if ("" != null) return ast.numberLiteral(is, begin);}
      }
      break;
      }
    case TO:{
      jj_consume_token(TO);
      end = number();
{if ("" != null) return ast.between(Op.ABSENT_CLOSED, is, end);}
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public AstNode interval(boolean is) throws ParseException {Bound leftBound;
 final @Nullable BigDecimal left;
 final @Nullable BigDecimal right;
 Bound rightBound;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 26:{
      jj_consume_token(26);
leftBound = Bound.OPEN;
      break;
      }
    case 27:{
      jj_consume_token(27);
leftBound = Bound.CLOSED;
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NUMBER_LITERAL:
    case NUMBER_LITERAL0:{
      left = number();
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 28:{
        jj_consume_token(28);
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        ;
      }
left = null;
    }
    jj_consume_token(COMMA);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NUMBER_LITERAL:
    case NUMBER_LITERAL0:{
      right = number();
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 29:{
        jj_consume_token(29);
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        ;
      }
right = null;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 30:{
      jj_consume_token(30);
rightBound = Bound.OPEN;
      break;
      }
    case 31:{
      jj_consume_token(31);
rightBound = Bound.CLOSED;
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
// FIXME: Grammar allows both bounds absent, e.g. '[,]' and '(-inf,inf)'
    //   but should not
    if (left == null) {
      leftBound = Bound.ABSENT;
    }
    if (right == null) {
      rightBound = Bound.ABSENT;
    }
    if (left == null && right == null) {
      {if (true) throw new ParseException("unbounded interval");}
    }
    {if ("" != null) return ast.between(is, leftBound, rightBound, left, right);}
    throw new Error("Missing return statement in function");
}

  final public AstNode userAttribute() throws ParseException {
    jj_consume_token(DOUBLE_LBRACE);
    jj_consume_token(32);
    jj_consume_token(31);
    jj_consume_token(DOUBLE_RBRACE);
{if (true) throw new UnsupportedOperationException("userAttribute");}
    throw new Error("Missing return statement in function");
}

  final public BigDecimal number() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NUMBER_LITERAL:{
      jj_consume_token(NUMBER_LITERAL);
      break;
      }
    case NUMBER_LITERAL0:{
      jj_consume_token(NUMBER_LITERAL0);
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new BigDecimal(token.image);}
    throw new Error("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_3R_year_219_14_8()
 {
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_nInterval_178_3_6()) return true;
    return false;
  }

  private boolean jj_3R_intervalUnit_272_3_14()
 {
    if (jj_3R_dateUnit_286_3_21()) return true;
    return false;
  }

  private boolean jj_3R_nInterval_178_3_6()
 {
    if (jj_3R_positiveInteger_186_3_10()) return true;
    return false;
  }

  private boolean jj_3R_intervalUnit_271_3_9()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_intervalUnit_271_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_intervalUnit_272_3_14()) return true;
    }
    return false;
  }

  private boolean jj_3R_intervalUnit_271_3_13()
 {
    if (jj_3R_timeUnit_279_3_20()) return true;
    return false;
  }

  private boolean jj_3R_unit_552_3_19()
 {
    if (jj_scan_token(MILES)) return true;
    return false;
  }

  private boolean jj_3R_unit_551_3_18()
 {
    if (jj_scan_token(KILOMETERS)) return true;
    return false;
  }

  private boolean jj_3R_unit_550_3_17()
 {
    if (jj_scan_token(FEET)) return true;
    return false;
  }

  private boolean jj_3R_unit_549_3_16()
 {
    if (jj_scan_token(METERS)) return true;
    return false;
  }

  private boolean jj_3R_unit_549_3_12()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_unit_549_3_16()) {
    jj_scanpos = xsp;
    if (jj_3R_unit_550_3_17()) {
    jj_scanpos = xsp;
    if (jj_3R_unit_551_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_unit_552_3_19()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_year_219_3_3()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER_LITERAL
    && YEAR_PATTERN.matcher(getToken(1).image).matches();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_year_219_14_8()) return true;
    if (jj_scan_token(NUMBER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_relativeRange_357_3_4()
 {
    if (jj_3R_nInterval_178_3_6()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_nInterval_178_3_6()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_thisRange_334_3_5()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_relativeRange_357_3_4()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_year_219_3_3()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_circle_520_3_7()) return true;
    return false;
  }

  private boolean jj_3R_positiveInteger_186_14_15()
 {
    return false;
  }

  private boolean jj_3R_thisRange_334_3_5()
 {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_intervalUnit_271_3_9()) return true;
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3R_dateUnit_286_3_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_circle_520_3_7()
 {
    if (jj_3R_number_752_3_11()) return true;
    if (jj_3R_unit_549_3_12()) return true;
    return false;
  }

  private boolean jj_3R_number_752_3_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  private boolean jj_3R_positiveInteger_186_3_10()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == NUMBER_LITERAL
    && POSITIVE_INTEGER_PATTERN.matcher(getToken(1).image).matches();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_positiveInteger_186_14_15()) return true;
    if (jj_scan_token(NUMBER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_timeUnit_279_3_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  /** Generated Token Manager. */
  public FiltexParserImplTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[47];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x1ffffe,0x7e,0x1fff80,0x0,0x1ffffe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0xfc00000,0xfc00000,0x0,0xc00000,0x0,0x3000000,0x0,0x3000000,0x0,0xc00000,0x0,0x0,0x0,0x0,0xc000000,0x10000000,0x0,0x20000000,0x0,0xc0000000,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x2c00,0x4800c000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x10000000,0x48000000,0x10000000,0x800,0x0,0x0,0x1000,0x30000,0x0,0x0,0x0,0x0,0x30000,0x30000,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x20000000,0x0,0x20000000,0x30000,0x0,0x30000,0x0,0x0,0x30000,0x0,0x30000,0x0,0x30000,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x4000000,0x8000000,0x20ffd038,0xffc000,0xe00000,0x1fc000,0x1,0x0,0x0,0x0,0x1010,0x0,0x2,0x1,0x2,0x0,0x2,0x1018,0x1018,0x2001,0x0,0x28000024,0x20000020,0x780,0x4000800,0x4000800,0x20002000,0x2b002020,0x3000020,0x0,0x800,0x0,0x800,0x0,0x800,0x0,0x800,0x0,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[6];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public FiltexParserImpl(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public FiltexParserImpl(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new FiltexParserImplTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 47; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 47; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public FiltexParserImpl(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new FiltexParserImplTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 47; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new FiltexParserImplTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 47; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public FiltexParserImpl(FiltexParserImplTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 47; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(FiltexParserImplTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 47; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[95];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 47; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 95; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 6; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
