/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex;

import com.google.common.collect.ImmutableList;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import net.hydromatic.filtex.Transforms;
import net.hydromatic.filtex.TypeFamily;
import net.hydromatic.filtex.ast.Ast;
import net.hydromatic.filtex.ast.AstBuilder;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.Summary;
import net.hydromatic.filtex.parse.FiltexParserImpl;
import net.hydromatic.filtex.parse.ParseException;
import net.hydromatic.filtex.parse.TokenMgrError;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Filtex {
    private Filtex() {
    }

    public static TypeFamily getExpressionType(boolean numeric, String type) {
        if (numeric && type.equals("field_filter")) {
            return TypeFamily.NUMBER;
        }
        throw new UnsupportedOperationException();
    }

    public static AstNode parseFilterExpression(TypeFamily typeFamily, String expression) {
        FiltexParserImpl parser = new FiltexParserImpl(new StringReader(expression));
        try {
            switch (typeFamily) {
                case DATE: {
                    AstNode node = parser.dateExpressionEof();
                    return Transforms.locationTransform(node);
                }
                case LOCATION: {
                    AstNode node = parser.locationExpressionEof();
                    return Transforms.locationTransform(node);
                }
                case NUMBER: {
                    AstNode node = parser.numericExpressionEof();
                    return Transforms.numberTransform(node);
                }
            }
            throw new IllegalArgumentException("unknown type family " + (Object)((Object)typeFamily));
        }
        catch (ParseException | TokenMgrError e) {
            return Filtex.getMatchesAdvancedNode(expression, null);
        }
    }

    private static AstNode getMatchesAdvancedNode(String expression, @Nullable AstNode node) {
        Integer id;
        if (node != null) {
            if (node.expression() != null) {
                expression = node.expression();
            }
            id = node.id;
        } else {
            id = 1;
        }
        Ast.MatchesAdvanced matchesAdvanced = AstBuilder.ast.matchesAdvanced(expression);
        matchesAdvanced.id = id;
        return matchesAdvanced;
    }

    public static String summary(TypeFamily typeFamily, String s, Locale locale) {
        return Summary.summary(typeFamily, s, (List<Object>)ImmutableList.of(), null, true);
    }

    public static void typeToGrammar() {
        throw new UnsupportedOperationException();
    }

    public static void getFilterTokenItem() {
        throw new UnsupportedOperationException();
    }
}

