/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.hydromatic.filtex.ast.Ast;
import net.hydromatic.filtex.ast.AstBuilder;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.Asts;
import net.hydromatic.filtex.ast.Op;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Transforms {
    private Transforms() {
    }

    static int countNots(AstNode root) {
        class CountingConsumer
        implements Consumer<AstNode> {
            private int count = 0;

            CountingConsumer() {
            }

            @Override
            public void accept(AstNode node) {
                if (!node.is()) {
                    ++this.count;
                }
            }
        }
        CountingConsumer consumer = new CountingConsumer();
        Asts.traverse(root, consumer);
        return consumer.count;
    }

    static AstNode removeDuplicateNotNodes(AstNode root) {
        AstNode workingRoot = Asts.applyId(root);
        List andClauses = Asts.treeToList(workingRoot).stream().filter(model -> !model.is()).collect(Collectors.toList());
        return andClauses.size() == 2 && ((AstNode)andClauses.get(0)).equals(andClauses.get(1)) ? Asts.removeNode(workingRoot, ((AstNode)andClauses.get((int)1)).id) : workingRoot;
    }

    static AstNode mergeNodes(AstNode left, AstNode right) {
        assert (left.op == right.op);
        switch (left.op) {
            case EQ: {
                Ast.Comparison left2 = (Ast.Comparison)left;
                Ast.Comparison right2 = (Ast.Comparison)right;
                return AstBuilder.ast.comparison(left2.is & right2.is, left.op, Iterables.concat(left2.value, right2.value));
            }
        }
        throw new AssertionError((Object)left.op);
    }

    static boolean canMergeLeftNodes(@Nullable Ast.Comparison left, @Nullable Ast.Call2 right, Op compareType, boolean allowDifferentIsValue) {
        return left != null && right != null && right.left != null && left.op == right.left.op && left.op == compareType && (left.is() == right.left.is() || allowDifferentIsValue);
    }

    static boolean canMergeEndNodes(@Nullable Ast.Comparison left, @Nullable Ast.Comparison right, Op compareType, boolean allowDifferentIsValue) {
        return left != null && right != null && left.op == right.op && left.op == compareType && (left.is() == right.is() || allowDifferentIsValue);
    }

    static AstNode mergeNodesWithSameType(AstNode root, Op compareType, boolean allowDifferentIsValue) {
        Ast.Call2 node2;
        AstNode node = root;
        while (node instanceof Ast.Call2 && ((Ast.Call2)node).left instanceof Ast.Comparison && ((Ast.Call2)node).right instanceof Ast.Call2 && Transforms.canMergeLeftNodes((Ast.Comparison)((Ast.Call2)node).left, (Ast.Call2)((Ast.Call2)node).right, compareType, allowDifferentIsValue)) {
            node2 = (Ast.Call2)node;
            Ast.Comparison left = (Ast.Comparison)node2.left;
            Ast.Call2 right = (Ast.Call2)node2.right;
            AstNode newLeft = Transforms.mergeNodes(left, right.left);
            AstNode newRight = right.right;
            node = new Ast.Call2(node2.op, newLeft, newRight);
        }
        if (node instanceof Ast.Call2 && ((Ast.Call2)node).left instanceof Ast.Comparison && ((Ast.Call2)node).right instanceof Ast.Comparison && Transforms.canMergeEndNodes((Ast.Comparison)((Ast.Call2)node).left, (Ast.Comparison)((Ast.Call2)node).right, compareType, allowDifferentIsValue)) {
            node2 = (Ast.Call2)node;
            node = Transforms.mergeNodes(node2.left, node2.right);
        }
        return node;
    }

    public static AstNode mergeMultiValueNodes(AstNode root, Op type, boolean mergeDifferentIsValue) {
        AstNode workingRoot;
        AstNode pointer = workingRoot = Transforms.mergeNodesWithSameType(root, type, mergeDifferentIsValue);
        while (pointer instanceof Ast.Call2 && ((Ast.Call2)pointer).right != null) {
            pointer = ((Ast.Call2)pointer).right = Transforms.mergeNodesWithSameType(((Ast.Call2)pointer).right, type, mergeDifferentIsValue);
        }
        return workingRoot;
    }

    public static AstNode dateTransform(AstNode root) {
        return root;
    }

    public static AstNode locationTransform(AstNode root) {
        return root;
    }

    public static AstNode numberTransform(AstNode root) {
        int countOfNotNodes = Transforms.countNots(root);
        boolean mergeNodesWithDifferentIsValue = countOfNotNodes == 1;
        AstNode mergedRoot = Transforms.mergeMultiValueNodes(root, Op.EQ, mergeNodesWithDifferentIsValue);
        boolean checkForDuplicates = countOfNotNodes == 2;
        return checkForDuplicates ? Transforms.removeDuplicateNotNodes(mergedRoot) : mergedRoot;
    }
}

