/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.AstVisitor;
import net.hydromatic.filtex.ast.AstWriter;
import net.hydromatic.filtex.ast.Date;
import net.hydromatic.filtex.ast.DatetimeUnit;
import net.hydromatic.filtex.ast.Digester;
import net.hydromatic.filtex.ast.Location;
import net.hydromatic.filtex.ast.Op;
import net.hydromatic.filtex.ast.Pos;
import net.hydromatic.filtex.ast.Unit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Ast {
    private Ast() {
    }

    public static class LastInterval
    extends AstNode {
        public final BigDecimal value;
        public final DatetimeUnit unit;

        LastInterval(BigDecimal value, DatetimeUnit unit) {
            super(Pos.ZERO, Op.LAST_INTERVAL);
            this.value = value;
            this.unit = unit;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("unit", this.unit.singular).put("value", this.value);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class ThisRange
    extends AstNode {
        public final DatetimeUnit startInterval;
        public final DatetimeUnit endInterval;

        ThisRange(DatetimeUnit startInterval, DatetimeUnit endInterval) {
            super(Pos.ZERO, Op.THIS_RANGE);
            this.startInterval = startInterval;
            this.endInterval = endInterval;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("startInterval", this.startInterval.singular).put("endInterval", this.endInterval.singular);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class ThisUnit
    extends AstNode {
        public final DatetimeUnit unit;

        ThisUnit(Op op, DatetimeUnit unit) {
            super(Pos.ZERO, op);
            Preconditions.checkArgument((op == Op.THIS || op == Op.BEFORE_THIS || op == Op.AFTER_THIS || op == Op.NEXT || op == Op.BEFORE_NEXT || op == Op.AFTER_NEXT || op == Op.LAST || op == Op.BEFORE_LAST || op == Op.AFTER_LAST ? 1 : 0) != 0);
            this.unit = unit;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("unit", this.unit.singular);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class Relative
    extends AstNode {
        public final BigDecimal value;
        public final DatetimeUnit unit;

        Relative(Op op, BigDecimal value, DatetimeUnit unit) {
            super(Pos.ZERO, op);
            Preconditions.checkArgument((op == Op.FROM_NOW || op == Op.PAST_AGO ? 1 : 0) != 0);
            this.value = value;
            this.unit = unit;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("unit", this.unit.singular).put("value", this.value);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class Past
    extends AstNode {
        public final BigDecimal value;
        public final DatetimeUnit unit;
        public final boolean complete;

        Past(BigDecimal value, DatetimeUnit unit, boolean complete) {
            super(Pos.ZERO, Op.PAST);
            this.value = value;
            this.unit = unit;
            this.complete = complete;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("unit", this.unit.singular).put("value", this.value).putIf("complete", this.complete ? Boolean.valueOf(true) : null);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class RelativeUnit
    extends AstNode {
        public final boolean fromNow;
        public final BigDecimal value;
        public final DatetimeUnit unit;

        RelativeUnit(boolean before, boolean fromNow, BigDecimal value, DatetimeUnit unit) {
            super(Pos.ZERO, before ? Op.BEFORE : Op.AFTER);
            this.fromNow = fromNow;
            this.value = value;
            this.unit = unit;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("range", "relative").put("fromnow", this.fromNow).put("unit", this.unit.singular).put("value", this.value);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class RelativeRange
    extends AstNode {
        public final boolean fromNow;
        public final Interval startInterval;
        public final Interval endInterval;

        RelativeRange(boolean fromNow, Interval startInterval, Interval endInterval) {
            super(Pos.ZERO, Op.RELATIVE);
            this.fromNow = fromNow;
            this.startInterval = startInterval;
            this.endInterval = endInterval;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("intervalType", this.intervalType()).sub("endInterval", this.endInterval).sub("startInterval", this.startInterval);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }

        public String intervalType() {
            return this.fromNow ? "from now" : "ago";
        }
    }

    public static class Absolute
    extends AstNode {
        public final Date date;

        Absolute(Date date, boolean before) {
            super(Pos.ZERO, before ? Op.BEFORE : Op.AFTER);
            this.date = date;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).sub("date", this.date).put("range", "absolute");
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class MatchesAdvanced
    extends AstNode {
        public final String expression;

        MatchesAdvanced(String expression) {
            super(Pos.ZERO, Op.MATCHES_ADVANCED);
            this.expression = expression;
        }

        @Override
        public String expression() {
            return this.expression;
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            visitor.visit(this, parent);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            return writer.append(this.expression);
        }
    }

    public static class NumericRange
    extends AstNode {
        public final boolean is;
        public final BigDecimal left;
        public final BigDecimal right;

        NumericRange(Op op, String id, boolean is, BigDecimal left, BigDecimal right) {
            super(Pos.ZERO, op);
            this.is = is;
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            writer.append(this.op.left);
            if (this.left != null) {
                writer.appendLiteral(this.left);
            }
            writer.append(",");
            if (this.right != null) {
                writer.appendLiteral(this.right);
            }
            writer.append(this.op.right);
            return writer;
        }

        @Override
        public void accept(AstVisitor visitor, AstNode parent) {
            visitor.visit(this, parent);
        }

        @Override
        public String type() {
            switch (this.op) {
                case ABSENT_CLOSED: 
                case ABSENT_OPEN: 
                case CLOSED_ABSENT: 
                case OPEN_ABSENT: {
                    return this.op.s;
                }
            }
            return "between";
        }

        @Override
        public boolean is() {
            return this.is;
        }

        @Override
        public Iterable<Comparable> value() {
            return this.left != null && this.right != null ? ImmutableList.of((Object)this.left, (Object)this.right) : (this.left != null ? ImmutableList.of((Object)this.left) : ImmutableList.of((Object)this.right));
        }

        @Override
        public String low() {
            return this.left == null ? "" : this.left.toString();
        }

        @Override
        public String high() {
            return this.right == null ? "" : this.right.toString();
        }

        @Override
        public String bounds() {
            return this.op.s;
        }
    }

    public static class Call2
    extends AstNode {
        public final AstNode left;
        public AstNode right;

        public Call2(Op op, AstNode left, AstNode right) {
            super(Pos.ZERO, op);
            this.left = left;
            this.right = right;
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            return writer.infix(this.left, this.op, this.right);
        }

        @Override
        public void accept(AstVisitor visitor, AstNode parent) {
            visitor.visit(this, parent);
        }
    }

    public static class Call1
    extends AstNode {
        public final boolean is;
        public final AstNode node;

        Call1(Op op, boolean is, AstNode node) {
            super(Pos.ZERO, op);
            this.is = is;
            this.node = node;
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            visitor.visit(this, parent);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            writer.append("(");
            if (!this.is) {
                writer.append("not ");
            }
            writer.append(this.op.s);
            return writer.append(")");
        }
    }

    public static class Call0
    extends AstNode {
        final boolean is;

        Call0(Op op, boolean is) {
            super(Pos.ZERO, op);
            this.is = is;
        }

        @Override
        public boolean is() {
            return this.is;
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            switch (this.op) {
                case NULL: {
                    return writer.append(this.is ? "is null" : "is not null");
                }
                case NOTNULL: {
                    return writer.append("is not null");
                }
            }
            if (!this.is) {
                writer.append("not ");
            }
            return writer.append(this.op.s);
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            visitor.visit(this, parent);
        }
    }

    public static class Comparison
    extends AstNode {
        public final boolean is;
        public final List<Comparable> value;

        Comparison(boolean is, Op op, List<Comparable> value) {
            super(Pos.ZERO, op);
            this.is = is;
            this.value = value;
        }

        @Override
        public boolean is() {
            return this.is;
        }

        @Override
        public Iterable<Comparable> value() {
            return this.value;
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            visitor.visit(this, parent);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            return writer.append(this.valueString());
        }
    }

    public static class Circle
    extends AstNode {
        public final BigDecimal distance;
        public final Unit unit;
        public final Location location;

        Circle(BigDecimal distance, Unit unit, Location location) {
            super(Pos.ZERO, Op.CIRCLE);
            this.distance = distance;
            this.unit = unit;
            this.location = location;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("distance", this.distance).put("unit", this.unit.plural).put("lat", this.location.latitude).put("lon", this.location.longitude);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            return writer.appendLiteral(this.distance).append(" ").append(this.unit.plural).append(" from ").appendLiteral(this.location.latitude).append(", ").appendLiteral(this.location.longitude);
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
        }
    }

    public static class Box
    extends AstNode {
        public final Location from;
        public final Location to;

        protected Box(Location from, Location to) {
            super(Pos.ZERO, Op.BOX);
            this.from = from;
            this.to = to;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("lat", this.from.latitude).put("lon", this.from.longitude).put("lat1", this.to.latitude).put("lon1", this.to.longitude);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            this.appendDegrees(writer, this.from.latitude, "\u00b0S", "\u00b0N");
            writer.append(", ");
            this.appendDegrees(writer, this.from.longitude, "\u00b0W", "\u00b0E");
            writer.append(" to ");
            this.appendDegrees(writer, this.to.latitude, "\u00b0S", "\u00b0N");
            writer.append(", ");
            this.appendDegrees(writer, this.to.longitude, "\u00b0W", "\u00b0E");
            return writer;
        }

        private void appendDegrees(AstWriter w, BigDecimal v, String neg, String pos) {
            if ((v = v.setScale(1, RoundingMode.HALF_EVEN)).signum() < 0) {
                w.appendLiteral(v.negate()).append(neg);
            } else {
                w.appendLiteral(v).append(pos);
            }
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
        }
    }

    public static class Point
    extends AstNode {
        public final Location location;

        protected Point(Location location) {
            super(Pos.ZERO, Op.POINT);
            this.location = location;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("lat", this.location.latitude).put("long", this.location.longitude);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            return writer.append(this.location.latitude.toString()).append(", ").append(this.location.longitude.toString());
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
        }
    }

    public static class MonthInterval
    extends AstNode {
        public final int year;
        public final int month;
        public final Interval end;

        MonthInterval(int year, int month, Interval end) {
            super(Pos.ZERO, Op.MONTH_INTERVAL);
            this.year = year;
            this.month = month;
            this.end = end;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).sub("end", this.end).put("year", this.year).put("month", this.month);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class RangeInterval
    extends AstNode {
        public final Date start;
        public final Interval end;

        RangeInterval(Date start, Interval end) {
            super(Pos.ZERO, Op.RANGE_INTERVAL);
            this.start = start;
            this.end = end;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).sub("end", this.end).sub("start", this.start);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class Range
    extends AstNode {
        public final Date start;
        public final Date end;

        Range(Date start, Date end) {
            super(Pos.ZERO, Op.RANGE);
            this.start = start;
            this.end = end;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).sub("end", this.end).sub("start", this.start);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class Interval
    extends AstNode {
        public final BigDecimal value;
        public final DatetimeUnit unit;

        Interval(DatetimeUnit unit, BigDecimal value) {
            super(Pos.ZERO, Op.INTERVAL);
            this.unit = unit;
            this.value = value;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Interval && this.value.equals(((Interval)o).value) && this.unit == ((Interval)o).unit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value, this.unit});
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("unit", this.unit.singular).put("value", this.value);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class DayLiteral
    extends AstNode {
        public final String day;

        public DayLiteral(String day) {
            super(Pos.ZERO, Op.DAY);
            this.day = day;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put("day", this.day);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }

    public static class DateLiteral
    extends AstNode {
        public final int year;
        public final @Nullable Integer quarter;
        public final @Nullable Integer month;
        public final @Nullable Integer day;
        private final @Nullable Integer hour;
        private final @Nullable Integer minute;
        private final @Nullable Integer second;

        public DateLiteral(Op op, int year, @Nullable Integer quarter, @Nullable Integer month, @Nullable Integer day, @Nullable Integer hour, @Nullable Integer minute, @Nullable Integer second) {
            super(Pos.ZERO, op);
            this.year = year;
            this.quarter = quarter;
            this.month = month;
            this.day = day;
            this.hour = hour;
            this.minute = minute;
            this.second = second;
        }

        @Override
        public Digester digest(Digester digester) {
            return super.digest(digester).put(this.op == Op.ON ? "date.year" : "year", this.year).putIf(this.op == Op.ON ? "date.month" : "month", this.month).putIf(this.op == Op.ON ? "date.day" : "day", this.day).putIf("quarter.quarter", this.quarter);
        }

        @Override
        public AstWriter unparse(AstWriter writer) {
            throw new AssertionError();
        }

        @Override
        public void accept(AstVisitor visitor, @Nullable AstNode parent) {
            throw new AssertionError();
        }
    }
}

