/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.BinaryOperator;
import net.hydromatic.filtex.ast.Ast;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.Bound;
import net.hydromatic.filtex.ast.Date;
import net.hydromatic.filtex.ast.Datetime;
import net.hydromatic.filtex.ast.DatetimeUnit;
import net.hydromatic.filtex.ast.Location;
import net.hydromatic.filtex.ast.Op;
import net.hydromatic.filtex.ast.Unit;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum AstBuilder {
    ast;


    public AstNode anywhere() {
        return new Ast.Call0(Op.ANYWHERE, true);
    }

    public AstNode point(Location location) {
        return new Ast.Point(location);
    }

    public AstNode box(Location from, Location to) {
        return new Ast.Box(from, to);
    }

    public AstNode circle(BigDecimal distance, Unit unit, Location location) {
        return new Ast.Circle(distance, unit, location);
    }

    public Ast.Comparison comparison(boolean is, Op op, Comparable value) {
        return this.comparison(is, op, (Iterable<Comparable>)ImmutableList.of((Object)value));
    }

    public Ast.Comparison comparison(boolean is, Op op, Iterable<Comparable> value) {
        return new Ast.Comparison(is, op, (List<Comparable>)ImmutableList.copyOf(value));
    }

    public AstNode day(String day) {
        return new Ast.DayLiteral(day);
    }

    public AstNode year(int year) {
        return new Ast.DateLiteral(Op.YEAR, year, null, null, null, null, null, null);
    }

    public AstNode fiscalYear(int year) {
        return new Ast.DateLiteral(Op.FISCAL_YEAR, year, null, null, null, null, null, null);
    }

    public AstNode quarter(int year, int quarter) {
        return new Ast.DateLiteral(Op.QUARTER, year, quarter, null, null, null, null, null);
    }

    public AstNode fiscalQuarter(int year, int quarter) {
        return new Ast.DateLiteral(Op.FISCAL_QUARTER, year, quarter, null, null, null, null, null);
    }

    public AstNode month(int year, int month) {
        return new Ast.DateLiteral(Op.MONTH, year, null, month, null, null, null, null);
    }

    public AstNode on(Date date) {
        if (date instanceof Datetime) {
            Datetime datetime = (Datetime)date;
            return new Ast.DateLiteral(Op.ON, datetime.year, null, datetime.month, datetime.day, datetime.hour, datetime.minute, datetime.second);
        }
        return new Ast.DateLiteral(Op.ON, date.year, null, date.month, date.day, null, null, null);
    }

    public Ast.Comparison numberLiteral(boolean is, BigDecimal value) {
        return this.comparison(is, Op.EQ, (Iterable<Comparable>)ImmutableList.of((Object)value));
    }

    public Ast.Comparison stringLiteral(boolean is, String value) {
        return this.comparison(is, Op.EQ, (Iterable<Comparable>)ImmutableList.of((Object)value));
    }

    public AstNode logicalExpression(AstNode left, AstNode right) {
        return new Ast.Call2(Op.COMMA, left, right);
    }

    public AstNode logicalExpression(List<AstNode> terms) {
        return AstBuilder.foldRight(terms, this::logicalExpression);
    }

    public AstNode isNull(boolean is) {
        return new Ast.Call0(Op.NULL, is);
    }

    public AstNode isNotNull() {
        return new Ast.Call0(Op.NOTNULL, true);
    }

    public AstNode between(boolean is, Bound leftBound, Bound rightBound, @Nullable BigDecimal left, @Nullable BigDecimal right) {
        if (left != null && right != null) {
            return this.range(this.getOp(leftBound, rightBound), is, left, right);
        }
        if (left != null) {
            return this.comparison(is, leftBound == Bound.CLOSED ? Op.GE : Op.GT, left);
        }
        if (right != null) {
            return this.comparison(is, rightBound == Bound.CLOSED ? Op.LE : Op.LT, right);
        }
        throw new IllegalArgumentException();
    }

    private Ast.NumericRange range(Op op, boolean is, BigDecimal left, BigDecimal right) {
        return new Ast.NumericRange(op, null, is, left, right);
    }

    public AstNode between(Op op, boolean is, BigDecimal number) {
        switch (op) {
            case ABSENT_OPEN: 
            case ABSENT_CLOSED: {
                return this.comparison(is, op == Op.ABSENT_OPEN ? Op.LT : Op.LE, number);
            }
            case OPEN_ABSENT: 
            case CLOSED_ABSENT: {
                return this.comparison(is, op == Op.OPEN_ABSENT ? Op.GT : Op.GE, number);
            }
        }
        throw new AssertionError((Object)("unknown " + (Object)((Object)op)));
    }

    public Ast.MatchesAdvanced matchesAdvanced(String expression) {
        return new Ast.MatchesAdvanced(expression);
    }

    private Op getOp(Bound left, Bound right) {
        return Op.valueOf((Object)((Object)left) + "_" + (Object)((Object)right));
    }

    private static <E> E foldLeft(Iterable<? extends E> iterable, BinaryOperator<E> combiner) {
        Object previous = null;
        for (E e : iterable) {
            if (previous == null) {
                previous = e;
                continue;
            }
            previous = combiner.apply(previous, e);
        }
        if (previous == null) {
            throw new IllegalArgumentException("empty list");
        }
        return (E)previous;
    }

    private static <E> E foldRight(Iterable<? extends E> iterable, BinaryOperator<E> combiner) {
        return AstBuilder.foldLeft(ImmutableList.copyOf(iterable).reverse(), (x, y) -> combiner.apply(y, x));
    }

    public Ast.Interval interval(DatetimeUnit unit, BigDecimal value) {
        return new Ast.Interval(unit, value);
    }

    public AstNode rangeInterval(Date start, Ast.Interval end) {
        return new Ast.RangeInterval(start, end);
    }

    public AstNode range(Date start, Date end) {
        return new Ast.Range(start, end);
    }

    public AstNode monthInterval(int year, int month, Ast.Interval end) {
        return new Ast.MonthInterval(year, month, end);
    }

    public AstNode absolute(Date date, boolean before) {
        return new Ast.Absolute(date, before);
    }

    public AstNode relativeRange(boolean fromNow, Ast.Interval startInterval, Ast.Interval endInterval) {
        return new Ast.RelativeRange(fromNow, startInterval, endInterval);
    }

    public AstNode relative(boolean fromNow, Ast.Interval startInterval) {
        return new Ast.Relative(fromNow ? Op.FROM_NOW : Op.PAST_AGO, startInterval.value, startInterval.unit);
    }

    public AstNode relative1(boolean before, Op op, DatetimeUnit unit) {
        return new Ast.ThisUnit(op.beforeAfter(before), unit);
    }

    public AstNode relativeUnit(boolean before, boolean fromNow, BigDecimal value, DatetimeUnit unit) {
        return new Ast.RelativeUnit(before, fromNow, value, unit);
    }

    public AstNode past(BigDecimal value, DatetimeUnit unit, boolean complete) {
        return new Ast.Past(value, unit, complete);
    }

    public AstNode past(BigDecimal value, DatetimeUnit unit) {
        return this.past(value, unit, false);
    }

    public AstNode thisUnit(Op op, DatetimeUnit unit) {
        return new Ast.ThisUnit(op, unit);
    }

    public AstNode thisRange(DatetimeUnit startInterval, DatetimeUnit endInterval) {
        return new Ast.ThisRange(startInterval, endInterval);
    }

    public AstNode lastInterval(BigDecimal value, DatetimeUnit interval) {
        return new Ast.LastInterval(value, interval);
    }
}

