/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import net.hydromatic.filtex.ast.AstVisitor;
import net.hydromatic.filtex.ast.AstWriter;
import net.hydromatic.filtex.ast.Digester;
import net.hydromatic.filtex.ast.Op;
import net.hydromatic.filtex.ast.Pos;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AstNode {
    public final Pos pos;
    public final Op op;
    public @Nullable Integer id;

    protected AstNode(Pos pos, Op op) {
        this.pos = pos;
        this.op = op;
    }

    public String toString() {
        return this.unparse(new AstWriter()).toString();
    }

    public abstract AstWriter unparse(AstWriter var1);

    public abstract void accept(AstVisitor var1, @Nullable AstNode var2);

    public boolean is() {
        return true;
    }

    public @Nullable String expression() {
        return null;
    }

    public @Nullable String summary() {
        return null;
    }

    public String type() {
        return this.op.s;
    }

    public Iterable<Comparable> value() {
        return null;
    }

    public String low() {
        return null;
    }

    public String high() {
        return null;
    }

    public String bounds() {
        return null;
    }

    public @Nullable String valueString() {
        @Nullable Iterable<Comparable> value = this.value();
        if (value == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (Comparable comparable : value) {
            b.append(sep).append(comparable);
            sep = ",";
        }
        return b.toString();
    }

    public String dateString(boolean showTime) {
        throw new UnsupportedOperationException("not a date: " + this.getClass());
    }

    public Digester digest(Digester digester) {
        return digester.put("type", this.type());
    }
}

