/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.Op;

public class AstWriter {
    private final StringBuilder b = new StringBuilder();

    private AstWriter(StringBuilder b) {
    }

    public AstWriter() {
        this(new StringBuilder());
    }

    public String toString() {
        return this.b.toString();
    }

    public AstWriter append(String s) {
        this.b.append(s);
        return this;
    }

    public AstWriter id(String s) {
        this.b.append(s);
        return this;
    }

    public AstWriter prefix(boolean is, Op op, AstNode a) {
        this.b.append('{');
        if (!is) {
            this.append("not ");
        }
        this.append(op.s);
        a.unparse(this);
        this.b.append('}');
        return this;
    }

    public AstWriter infix(AstNode left, Op op, AstNode right) {
        this.append("{");
        left.unparse(this);
        this.append(op.s);
        right.unparse(this);
        this.append("}");
        return this;
    }

    public AstWriter appendLiteral(Comparable value) {
        if (value instanceof String) {
            this.append("\"").append(((String)((Object)value)).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
        } else if (value instanceof Character) {
            char c = ((Character)value).charValue();
            this.append("#\"").append(c == '\"' ? "\\\"" : (c == '\\' ? "\\\\" : Character.toString(c))).append("\"");
        } else {
            this.append(value.toString());
        }
        return this;
    }
}

