/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.hydromatic.filtex.TypeFamily;
import net.hydromatic.filtex.ast.Ast;
import net.hydromatic.filtex.ast.AstBuilder;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.AstVisitorImpl;
import net.hydromatic.filtex.ast.Op;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Asts {
    private Asts() {
    }

    public static List<AstNode> treeToList(AstNode root) {
        final ArrayList orItems = new ArrayList();
        final ArrayList andItems = new ArrayList();
        AstVisitorImpl visitor = new AstVisitorImpl(){

            @Override
            public void infix(Ast.Call2 call2, @Nullable AstNode parent) {
                if (call2.op != Op.COMMA) {
                    (call2.is() ? orItems : andItems).add(call2);
                }
            }

            @Override
            public void visit(Ast.Call0 call0, @Nullable AstNode parent) {
                (call0.is() ? orItems : andItems).add(call0);
            }

            @Override
            public void visit(Ast.MatchesAdvanced matchesAdvanced, @Nullable AstNode parent) {
                (matchesAdvanced.is() ? orItems : andItems).add(matchesAdvanced);
            }

            @Override
            public void visit(Ast.Comparison literal, @Nullable AstNode parent) {
                (literal.is() ? orItems : andItems).add(literal);
            }

            @Override
            public void visit(Ast.NumericRange range, @Nullable AstNode parent) {
                List list;
                List list2 = list = range.is ? orItems : andItems;
                if (range.left != null && range.right != null) {
                    list.add(range);
                } else if (range.left != null) {
                    Op op = range.op.containsLowerBound() ? Op.GE : Op.GT;
                    Ast.Comparison comparison = AstBuilder.ast.comparison(true, op, range.left);
                    list.add(comparison);
                } else if (range.right != null) {
                    Op op = range.op.containsUpperBound() ? Op.LE : Op.LT;
                    Ast.Comparison comparison = AstBuilder.ast.comparison(true, op, range.right);
                    list.add(comparison);
                }
            }
        };
        root.accept(visitor, null);
        return ImmutableList.builder().addAll(orItems).addAll(andItems).build();
    }

    public static String treeToString(AstNode root, Function<AstNode, String> f, Predicate<AstNode> predicate) {
        return Asts.treeToList(root).stream().filter(predicate).map(f).collect(Collectors.joining(","));
    }

    static void inorderTraversal(AstNode root, NodeHandler<Void> nodeHandler) {
        Asts.inorder(root, null, nodeHandler);
    }

    private static void inorder(AstNode node, AstNode parent, NodeHandler<Void> nodeHandler) {
        if (node instanceof Ast.Call2) {
            Ast.Call2 call2 = (Ast.Call2)node;
            if (call2.left != null) {
                Asts.inorder(call2.left, node, nodeHandler);
            }
            nodeHandler.apply(node, parent);
            if (call2.right != null) {
                Asts.inorder(call2.right, node, nodeHandler);
            }
        } else if (node instanceof Ast.NumericRange) {
            Ast.NumericRange call2 = (Ast.NumericRange)node;
            if (call2.left != null) {
                Asts.inorder(AstBuilder.ast.numberLiteral(true, call2.left), node, nodeHandler);
            }
            nodeHandler.apply(node, parent);
            if (call2.right != null) {
                Asts.inorder(AstBuilder.ast.numberLiteral(true, call2.right), node, nodeHandler);
            }
        } else if (node instanceof Ast.Comparison) {
            nodeHandler.apply(node, parent);
        }
    }

    public static void traverse(AstNode root, final Consumer<AstNode> consumer) {
        AstVisitorImpl visitor = new AstVisitorImpl(){

            @Override
            public void visit(Ast.Call2 call2, @Nullable AstNode parent) {
                consumer.accept(call2);
                super.visit(call2, parent);
            }

            @Override
            public void visit(Ast.MatchesAdvanced matchesAdvanced, @Nullable AstNode parent) {
                consumer.accept(matchesAdvanced);
                super.visit(matchesAdvanced, parent);
            }

            @Override
            public void visit(Ast.Call1 call1, @Nullable AstNode parent) {
                consumer.accept(call1);
                super.visit(call1, parent);
            }

            @Override
            public void visit(Ast.Call0 call0, @Nullable AstNode parent) {
                consumer.accept(call0);
                super.visit(call0, parent);
            }

            @Override
            public void visit(Ast.Comparison literal, @Nullable AstNode parent) {
                consumer.accept(literal);
                super.visit(literal, parent);
            }

            @Override
            public void visit(Ast.NumericRange range, @Nullable AstNode parent) {
                consumer.accept(range);
                super.visit(range, parent);
            }
        };
        root.accept(visitor, null);
    }

    public static AstNode applyId(AstNode root) {
        root.accept(new NumberingVisitor(), null);
        return root;
    }

    public static @Nullable AstNode removeNode(AstNode root, Integer nodeId) {
        if (nodeId.equals(root.id)) {
            return null;
        }
        if (root.op == Op.COMMA) {
            Ast.Call2 call2 = (Ast.Call2)root;
            @Nullable AstNode left2 = Asts.removeNode(call2.left, nodeId);
            @Nullable AstNode right2 = Asts.removeNode(call2.right, nodeId);
            if (left2 == null) {
                return right2;
            }
            if (right2 == null) {
                return left2;
            }
            return AstBuilder.ast.logicalExpression(left2, right2);
        }
        return root;
    }

    public static String convertTypeToOption(boolean is, String type) {
        return is ? type : "!" + type;
    }

    public static String convertTypeToMatchesAdvancedOption(String type) {
        return type.equals("day") || type.equals("thisRange") || type.equals("pastAgo") || type.startsWith("before_") || type.startsWith("after_") ? "matchesAdvanced" : type;
    }

    public static String dateFilterToString(AstNode root, TypeFamily typeFamily) {
        return Asts.treeToString(root, node -> node.dateString(typeFamily.isDateTime()), node -> true);
    }

    @FunctionalInterface
    static interface NodeHandler<R> {
        public R apply(AstNode var1, @Nullable AstNode var2);
    }

    private static class NumberingVisitor
    extends AstVisitorImpl {
        final Set<Integer> set = new HashSet<Integer>();

        private NumberingVisitor() {
        }

        void handle(AstNode node) {
            if (node.id == null || !this.set.add(node.id)) {
                int i = this.set.size();
                while (true) {
                    Integer id;
                    if (this.set.add(id = Integer.valueOf(i))) {
                        node.id = id;
                        break;
                    }
                    ++i;
                }
            }
        }

        @Override
        public void visit(Ast.Call2 call2, @Nullable AstNode parent) {
            this.handle(call2);
            super.visit(call2, parent);
        }

        @Override
        public void visit(Ast.Call1 call1, @Nullable AstNode parent) {
            this.handle(call1);
            super.visit(call1, parent);
        }

        @Override
        public void visit(Ast.Call0 call0, @Nullable AstNode parent) {
            this.handle(call0);
            super.visit(call0, parent);
        }

        @Override
        public void visit(Ast.Comparison literal, @Nullable AstNode parent) {
            this.handle(literal);
            super.visit(literal, parent);
        }

        @Override
        public void visit(Ast.NumericRange range, @Nullable AstNode parent) {
            this.handle(range);
            super.visit(range, parent);
        }
    }
}

