/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import com.google.common.base.CaseFormat;
import java.math.BigDecimal;
import java.util.Locale;
import net.hydromatic.filtex.util.Pair;

public enum DatetimeUnit {
    YEAR,
    FISCAL_YEAR,
    MONTH,
    WEEK,
    QUARTER,
    FISCAL_QUARTER,
    DAY,
    HOUR,
    MINUTE,
    SECOND;

    public final String singular = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
    public final String plural = this.singular + "s";

    public static DatetimeUnit of(String name) {
        if ((name = name.toUpperCase(Locale.ROOT)).endsWith("S")) {
            name = name.substring(0, name.length() - 1);
        }
        return DatetimeUnit.valueOf(name);
    }

    public Pair<BigDecimal, DatetimeUnit> times(BigDecimal multiplier) {
        return Pair.of(multiplier, this);
    }
}

