/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.Date;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Digester {
    static final Pattern ALPHANUMERIC = Pattern.compile("[a-zA-Z0-9_]*");
    final SortedMap<String, Object> map;
    final String prefix;

    public Digester() {
        this(new TreeMap<String, Object>(), "");
    }

    private Digester(SortedMap<String, Object> map, String prefix) {
        this.map = map;
        this.prefix = prefix;
    }

    private Digester plus(String prefix) {
        return new Digester(this.map, this.prefix + prefix + ".");
    }

    public Digester put(String key, Object value) {
        this.map.put(this.prefix + key, value);
        return this;
    }

    public Digester putIf(String key, @Nullable Object value) {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public Digester sub(String key, AstNode node) {
        node.digest(this.plus(key));
        return this;
    }

    public Digester sub(String key, Date date) {
        date.digest(this.plus(key));
        return this;
    }

    public String toString() {
        TreeMap map2 = new TreeMap();
        this.map.forEach((key, value) -> {
            if (value instanceof String && !ALPHANUMERIC.matcher((String)value).matches()) {
                value = "'" + value + "'";
            }
            if (key.contains(".")) {
                int i = key.indexOf(46);
                Map subMap = (Map)map2.computeIfAbsent(key.substring(0, i), k -> new TreeMap());
                subMap.put(key.substring(i + 1), value);
            } else {
                map2.put(key, value);
            }
        });
        return ((Object)map2).toString();
    }
}

