/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.ast;

import com.google.common.base.CaseFormat;

public enum Op {
    EQ("="),
    GE(">="),
    GT(">"),
    LE("<="),
    LT("<"),
    COMMA(","),
    LITERAL(""),
    NULL,
    NOTNULL,
    OPEN_OPEN("()", "(", ")"),
    OPEN_CLOSED("(]", "(", "]"),
    OPEN_ABSENT(">", "(", "inf)"),
    CLOSED_OPEN("[)", "[", ")"),
    CLOSED_CLOSED("[]", "[", "]"),
    CLOSED_ABSENT(">=", "[", "inf)"),
    ABSENT_OPEN("<", "(-inf", ")"),
    ABSENT_CLOSED("<=", "(-inf", "]"),
    MATCHES_ADVANCED,
    ANYWHERE("is anywhere"),
    BOX,
    CIRCLE,
    POINT("location"),
    YEAR,
    FISCAL_YEAR,
    QUARTER,
    FISCAL_QUARTER,
    MONTH,
    ON,
    RANGE_INTERVAL,
    RANGE,
    MONTH_INTERVAL,
    INTERVAL,
    BEFORE,
    AFTER,
    AFTER_THIS("after_this"),
    BEFORE_THIS("before_this"),
    AFTER_NEXT("after_next"),
    BEFORE_NEXT("before_next"),
    AFTER_LAST("after_last"),
    BEFORE_LAST("before_last"),
    RELATIVE,
    THIS,
    NEXT,
    LAST,
    THIS_RANGE,
    PAST,
    PAST_AGO,
    FROM_NOW("from now"),
    DAY,
    LAST_INTERVAL;

    public final String s;
    public final String left;
    public final String right;

    private Op(String s, String left, String right) {
        this.s = s;
        this.left = left;
        this.right = right;
    }

    private Op(String s) {
        this.s = s != null ? s : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
        this.left = null;
        this.right = null;
    }

    private Op() {
        this(null);
    }

    public boolean containsLowerBound() {
        return this.s.startsWith("[");
    }

    public boolean containsUpperBound() {
        return this.s.endsWith("]");
    }

    public Op beforeAfter(boolean before) {
        switch (this) {
            case THIS: {
                return before ? BEFORE_THIS : AFTER_THIS;
            }
            case NEXT: {
                return before ? BEFORE_NEXT : AFTER_NEXT;
            }
            case LAST: {
                return before ? BEFORE_LAST : AFTER_LAST;
            }
        }
        throw new IllegalArgumentException((before ? "before" : "after") + "-" + (Object)((Object)this));
    }
}

