/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.filtex.parse;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.hydromatic.filtex.ast.Ast;
import net.hydromatic.filtex.ast.AstBuilder;
import net.hydromatic.filtex.ast.AstNode;
import net.hydromatic.filtex.ast.Bound;
import net.hydromatic.filtex.ast.Date;
import net.hydromatic.filtex.ast.DatetimeUnit;
import net.hydromatic.filtex.ast.Location;
import net.hydromatic.filtex.ast.Op;
import net.hydromatic.filtex.ast.Pos;
import net.hydromatic.filtex.ast.Time;
import net.hydromatic.filtex.ast.Unit;
import net.hydromatic.filtex.parse.FiltexParser;
import net.hydromatic.filtex.parse.FiltexParserImplConstants;
import net.hydromatic.filtex.parse.FiltexParserImplTokenManager;
import net.hydromatic.filtex.parse.ParseException;
import net.hydromatic.filtex.parse.SimpleCharStream;
import net.hydromatic.filtex.parse.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltexParserImpl
implements FiltexParser,
FiltexParserImplConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"net.hydromatic.filtex.parse");
    private static final Pattern YEAR_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]");
    private static final Pattern POSITIVE_INTEGER_PATTERN = Pattern.compile("[1-9][0-9]*");
    private int lineOffset;
    private String file = "";
    public FiltexParserImplTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[47];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public void setTabSize(int tabSize) {
        this.jj_input_stream.setTabSize(tabSize);
    }

    @Override
    public Pos pos() {
        return new Pos(this.file, this.token.beginLine - this.lineOffset, this.token.beginColumn, this.token.endLine - this.lineOffset, this.token.endColumn + 1);
    }

    @Override
    public void zero(String file) {
        this.file = file;
        if (this.jj_input_stream.bufpos >= 0) {
            this.lineOffset = this.jj_input_stream.bufline[this.jj_input_stream.bufpos];
        }
    }

    void debug_message1() throws ParseException {
        LOGGER.info("{} , {}", (Object)this.getToken((int)0).image, (Object)this.getToken((int)1).image);
    }

    public final AstNode dateExpressionEof() throws ParseException {
        AstNode node = this.dateExpression();
        this.jj_consume_token(0);
        return node;
    }

    public final AstNode locationExpressionEof() throws ParseException {
        AstNode node = this.locationExpression();
        this.jj_consume_token(0);
        return node;
    }

    public final AstNode numericExpressionEof() throws ParseException {
        AstNode node = this.numericExpression();
        this.jj_consume_token(0);
        return node;
    }

    public final AstNode dateExpression() throws ParseException {
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        this.addDateTerm(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(90);
            this.addTerm(list);
        }
        return AstBuilder.ast.logicalExpression(list);
    }

    public final void addDateTerm(List<AstNode> list) throws ParseException {
        AstNode node = this.dateTerm();
        list.add(node);
    }

    public final AstNode dateTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 91: {
                AstNode node = this.userAttribute();
                return node;
            }
            case 43: {
                AstNode node = this.onDatetime();
                return node;
            }
            case 45: {
                AstNode node = this.yearQuarter();
                return node;
            }
            case 42: {
                AstNode node = this.yearMonth();
                return node;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        if (this.jj_2_1(1)) {
            AstNode node = this.year();
            return node;
        }
        if (this.jj_2_2(1)) {
            AstNode node = this.relativeRange();
            return node;
        }
        if (this.jj_2_3(3)) {
            AstNode node = this.thisRange();
            return node;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 68: 
            case 76: {
                AstNode node = this.thisNext();
                return node;
            }
            case 67: {
                AstNode node = this.last();
                return node;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                AstNode node = this.dayExpression();
                return node;
            }
            case 59: 
            case 62: {
                AstNode node = this.absoluteBeforeAfter();
                return node;
            }
            case 47: {
                AstNode node = this.fiscalQuarter();
                return node;
            }
            case 46: {
                AstNode node = this.fiscalYear();
                return node;
            }
            case 21: 
            case 69: 
            case 93: {
                AstNode node = this.nulls();
                return node;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Interval nInterval() throws ParseException {
        BigDecimal value = this.positiveInteger();
        DatetimeUnit unit = this.intervalUnit();
        return AstBuilder.ast.interval(unit, value);
    }

    public final BigDecimal positiveInteger() throws ParseException {
        if (this.getToken((int)1).kind != 48 || !POSITIVE_INTEGER_PATTERN.matcher(this.getToken((int)1).image).matches()) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(48);
        return new BigDecimal(this.token.image);
    }

    public final AstNode dayExpression() throws ParseException {
        String day;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                day = this.dayOfWeekKeyword();
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                day = this.dayKeyword();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return AstBuilder.ast.day(day);
    }

    public final String dayKeyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toLowerCase(Locale.ROOT);
    }

    public final String dayOfWeekKeyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toLowerCase(Locale.ROOT);
    }

    public final AstNode year() throws ParseException {
        if (this.getToken((int)1).kind != 48 || !YEAR_PATTERN.matcher(this.getToken((int)1).image).matches()) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(48);
        return AstBuilder.ast.year(Integer.parseInt(this.token.image));
    }

    public final AstNode fiscalYear() throws ParseException {
        this.jj_consume_token(46);
        return AstBuilder.ast.fiscalYear(Integer.parseInt(this.token.image.substring(2)));
    }

    public final AstNode fiscalQuarter() throws ParseException {
        this.jj_consume_token(47);
        return AstBuilder.ast.fiscalQuarter(Integer.parseInt(this.token.image.substring(2, 6)), Integer.parseInt(this.token.image.substring(8, 9)));
    }

    public final AstNode yearMonth() throws ParseException {
        this.jj_consume_token(42);
        int year = Integer.parseInt(this.token.image.substring(0, 4));
        int month = Integer.parseInt(this.token.image.substring(5, 7));
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                Ast.Interval end = this.nInterval();
                return AstBuilder.ast.monthInterval(year, month, end);
            }
        }
        this.jj_la1[6] = this.jj_gen;
        return AstBuilder.ast.month(year, month);
    }

    public final AstNode yearQuarter() throws ParseException {
        this.jj_consume_token(45);
        return AstBuilder.ast.quarter(Integer.parseInt(this.token.image.substring(0, 4)), Integer.parseInt(this.token.image.substring(6, 7)));
    }

    public final DatetimeUnit intervalUnit() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                DatetimeUnit unit = this.timeUnit();
                return unit;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                DatetimeUnit unit = this.dateUnit();
                return unit;
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DatetimeUnit timeUnit() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 4: {
                this.jj_consume_token(4);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return DatetimeUnit.of(this.token.image);
    }

    public final DatetimeUnit dateUnit() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return DatetimeUnit.of(this.token.image);
    }

    public final AstNode thisNext() throws ParseException {
        Op op;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                op = Op.THIS;
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                op = Op.NEXT;
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DatetimeUnit unit = this.dateUnit();
        return AstBuilder.ast.thisUnit(op, unit);
    }

    public final AstNode last() throws ParseException {
        this.jj_consume_token(67);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                DatetimeUnit unit = this.intervalUnit();
                return AstBuilder.ast.thisUnit(Op.LAST, unit);
            }
        }
        this.jj_la1[11] = this.jj_gen;
        if (this.jj_2_4(1)) {
            Ast.Interval interval = this.nInterval();
            return AstBuilder.ast.lastInterval(interval.value, interval.unit);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode thisRange() throws ParseException {
        this.jj_consume_token(76);
        DatetimeUnit startInterval = this.intervalUnit();
        this.jj_consume_token(77);
        DatetimeUnit endInterval = this.intervalUnit();
        return AstBuilder.ast.thisRange(startInterval, endInterval);
    }

    public final boolean intervalType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                return false;
            }
            case 65: {
                this.jj_consume_token(65);
                this.jj_consume_token(70);
                return true;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode relativeRange() throws ParseException {
        Ast.Interval startInterval = this.nInterval();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 60: 
            case 65: {
                boolean fromNow = this.intervalType();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 64: {
                        this.jj_consume_token(64);
                        Ast.Interval endInterval = this.nInterval();
                        if (startInterval.equals(endInterval)) {
                            return AstBuilder.ast.past(startInterval.value, startInterval.unit, true);
                        }
                        return AstBuilder.ast.relativeRange(fromNow, startInterval, endInterval);
                    }
                }
                this.jj_la1[13] = this.jj_gen;
                return AstBuilder.ast.relative(fromNow, startInterval);
            }
        }
        this.jj_la1[14] = this.jj_gen;
        return AstBuilder.ast.past(startInterval.value, startInterval.unit);
    }

    public final boolean beforeAfter() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 62: {
                this.jj_consume_token(62);
                return true;
            }
            case 59: {
                this.jj_consume_token(59);
                return false;
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode absoluteBeforeAfter() throws ParseException {
        boolean before = this.beforeAfter();
        if (this.jj_2_5(1)) {
            boolean fromNow;
            Ast.Interval interval = this.nInterval();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 60: 
                case 65: {
                    fromNow = this.intervalType();
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    fromNow = false;
                }
            }
            return AstBuilder.ast.relativeUnit(before, fromNow, interval.value, interval.unit);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: 
            case 68: 
            case 76: {
                Op op = this.thisNextLast();
                DatetimeUnit unit = this.dateUnit();
                return AstBuilder.ast.relative1(before, op, unit);
            }
            case 43: {
                Date date = this.datetime();
                return AstBuilder.ast.absolute(date, before);
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Op thisNextLast() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                return Op.THIS;
            }
            case 67: {
                this.jj_consume_token(67);
                return Op.LAST;
            }
            case 68: {
                this.jj_consume_token(68);
                return Op.NEXT;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode onDatetime() throws ParseException {
        Date start = this.datetime();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                Ast.Interval endInterval = this.nInterval();
                return AstBuilder.ast.rangeInterval(start, endInterval);
            }
            case 77: {
                this.jj_consume_token(77);
                Date end = this.datetime();
                return AstBuilder.ast.range(start, end);
            }
        }
        this.jj_la1[19] = this.jj_gen;
        return AstBuilder.ast.on(start);
    }

    public final Date datetime() throws ParseException {
        Date date = this.date();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: {
                Time time = this.time();
                return date.plus(time);
            }
        }
        this.jj_la1[20] = this.jj_gen;
        return date;
    }

    public final Date date() throws ParseException {
        this.jj_consume_token(43);
        return new Date(Integer.parseInt(this.token.image.substring(0, 4)), Integer.parseInt(this.token.image.substring(5, 7)), Integer.parseInt(this.token.image.substring(8, 10)));
    }

    public final Time time() throws ParseException {
        this.jj_consume_token(44);
        return new Time(Integer.parseInt(this.token.image.substring(0, 2)), Integer.parseInt(this.token.image.substring(3, 5)), this.token.image.length() == 8 ? Integer.valueOf(Integer.parseInt(this.token.image.substring(6, 8))) : null);
    }

    public final AstNode locationExpression() throws ParseException {
        if (this.jj_2_6(2)) {
            AstNode node = this.circle();
            return node;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: 
            case 49: {
                Location location = this.location();
                return AstBuilder.ast.point(location);
            }
            case 66: {
                AstNode node = this.box();
                return node;
            }
            case 91: {
                AstNode node = this.userAttribute();
                return node;
            }
            case 21: 
            case 69: 
            case 93: {
                AstNode node = this.nulls();
                return node;
            }
        }
        this.jj_la1[21] = this.jj_gen;
        AstNode node = this.anywhere();
        return node;
    }

    public final AstNode anywhere() throws ParseException {
        return AstBuilder.ast.anywhere();
    }

    public final AstNode nulls() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 93: {
                this.jj_consume_token(93);
                return AstBuilder.ast.isNull(true);
            }
            case 69: {
                this.jj_consume_token(69);
                this.jj_consume_token(93);
                return AstBuilder.ast.isNotNull();
            }
            case 21: {
                this.jj_consume_token(21);
                this.jj_consume_token(93);
                return AstBuilder.ast.isNotNull();
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode box() throws ParseException {
        this.jj_consume_token(66);
        this.jj_consume_token(63);
        this.jj_consume_token(65);
        Location from = this.location();
        this.jj_consume_token(77);
        Location to = this.location();
        return AstBuilder.ast.box(from, to);
    }

    public final AstNode circle() throws ParseException {
        BigDecimal distance = this.number();
        Unit unit = this.unit();
        this.jj_consume_token(65);
        Location location = this.location();
        if (distance.signum() < 0) {
            throw new ParseException("expected a positive value");
        }
        return AstBuilder.ast.circle(distance, unit, location);
    }

    public final Location location() throws ParseException {
        BigDecimal latitude = this.number();
        this.jj_consume_token(90);
        BigDecimal longitude = this.number();
        if (latitude.compareTo(BigDecimal.valueOf(-90L)) < 0 || latitude.compareTo(BigDecimal.valueOf(90L)) > 0) {
            throw new ParseException("expected a number between -90 and 90");
        }
        if (longitude.compareTo(BigDecimal.valueOf(-180L)) < 0 || longitude.compareTo(BigDecimal.valueOf(180L)) > 0) {
            throw new ParseException("expected a number between -180 and 180");
        }
        return new Location(latitude, longitude);
    }

    public final Unit unit() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                return Unit.METER;
            }
            case 71: {
                this.jj_consume_token(71);
                return Unit.FOOT;
            }
            case 72: {
                this.jj_consume_token(72);
                return Unit.KILOMETER;
            }
            case 74: {
                this.jj_consume_token(74);
                return Unit.MILE;
            }
        }
        this.jj_la1[23] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode numericExpression() throws ParseException {
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        this.addTerm(list);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 75: 
                case 90: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    this.jj_consume_token(90);
                    break;
                }
                case 75: {
                    this.jj_consume_token(75);
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.addTerm(list);
        }
        return AstBuilder.ast.logicalExpression(list);
    }

    public final void addTerm(List<AstNode> list) throws ParseException {
        AstNode node = this.term();
        list.add(node);
    }

    public final AstNode term() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 91: {
                AstNode node = this.userAttribute();
                return node;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 48: 
            case 49: 
            case 69: 
            case 77: 
            case 88: 
            case 89: 
            case 93: {
                AstNode node;
                boolean is = this.is();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 93: {
                        this.jj_consume_token(93);
                        node = AstBuilder.ast.isNull(is);
                        break;
                    }
                    case 22: 
                    case 23: {
                        node = this.intervalComp1(is);
                        break;
                    }
                    case 24: 
                    case 25: {
                        node = this.intervalComp2(is);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 77: {
                        node = this.to(is);
                        break;
                    }
                    case 26: 
                    case 27: {
                        node = this.interval(is);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return node;
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean is() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                return false;
            }
            case 88: {
                this.jj_consume_token(88);
                return false;
            }
            case 89: {
                this.jj_consume_token(89);
                return false;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        return true;
    }

    public final AstNode intervalComp1(boolean is) throws ParseException {
        Bound leftBound;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                leftBound = Bound.OPEN;
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                leftBound = Bound.CLOSED;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        BigDecimal left = this.number();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 61: 
            case 75: {
                Bound rightBound;
                boolean reverse;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        reverse = false;
                        break;
                    }
                    case 75: {
                        this.jj_consume_token(75);
                        reverse = true;
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        rightBound = Bound.OPEN;
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        rightBound = Bound.CLOSED;
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                BigDecimal right = this.number();
                if (reverse) {
                    return AstBuilder.ast.between(!is, leftBound.flip(), rightBound.flip(), right, left);
                }
                return AstBuilder.ast.between(is, leftBound, rightBound, left, right);
            }
        }
        this.jj_la1[32] = this.jj_gen;
        return AstBuilder.ast.between(is, leftBound, Bound.ABSENT, left, null);
    }

    public final AstNode intervalComp2(boolean is) throws ParseException {
        Bound leftBound;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                leftBound = Bound.OPEN;
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                leftBound = Bound.CLOSED;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        BigDecimal left = this.number();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 61: 
            case 75: {
                Bound rightBound;
                boolean reverse;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        reverse = false;
                        break;
                    }
                    case 75: {
                        this.jj_consume_token(75);
                        reverse = true;
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        rightBound = Bound.OPEN;
                        break;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        rightBound = Bound.CLOSED;
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                BigDecimal right = this.number();
                if (reverse) {
                    return AstBuilder.ast.between(!is, rightBound.flip(), leftBound.flip(), left, right);
                }
                return AstBuilder.ast.between(is, rightBound, leftBound, right, left);
            }
        }
        this.jj_la1[36] = this.jj_gen;
        return AstBuilder.ast.between(is, Bound.ABSENT, leftBound, null, left);
    }

    public final AstNode to(boolean is) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: 
            case 49: {
                BigDecimal begin = this.number();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 77: {
                        this.jj_consume_token(77);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 48: 
                            case 49: {
                                BigDecimal end = this.number();
                                return AstBuilder.ast.between(is, Bound.CLOSED, Bound.CLOSED, begin, end);
                            }
                        }
                        this.jj_la1[37] = this.jj_gen;
                        return AstBuilder.ast.between(Op.CLOSED_ABSENT, is, begin);
                    }
                }
                this.jj_la1[38] = this.jj_gen;
                return AstBuilder.ast.numberLiteral(is, begin);
            }
            case 77: {
                this.jj_consume_token(77);
                BigDecimal end = this.number();
                return AstBuilder.ast.between(Op.ABSENT_CLOSED, is, end);
            }
        }
        this.jj_la1[39] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AstNode interval(boolean is) throws ParseException {
        Bound rightBound;
        BigDecimal right;
        BigDecimal left;
        Bound leftBound;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                leftBound = Bound.OPEN;
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                leftBound = Bound.CLOSED;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: 
            case 49: {
                left = this.number();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                    }
                }
                left = null;
            }
        }
        this.jj_consume_token(90);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: 
            case 49: {
                right = this.number();
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                    }
                }
                right = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                rightBound = Bound.OPEN;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                rightBound = Bound.CLOSED;
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (left == null) {
            leftBound = Bound.ABSENT;
        }
        if (right == null) {
            rightBound = Bound.ABSENT;
        }
        if (left == null && right == null) {
            throw new ParseException("unbounded interval");
        }
        return AstBuilder.ast.between(is, leftBound, rightBound, left, right);
    }

    public final AstNode userAttribute() throws ParseException {
        this.jj_consume_token(91);
        this.jj_consume_token(32);
        this.jj_consume_token(31);
        this.jj_consume_token(92);
        throw new UnsupportedOperationException("userAttribute");
    }

    public final BigDecimal number() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new BigDecimal(this.token.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    private boolean jj_3R_year_219_14_8() {
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_3R_nInterval_178_3_6();
    }

    private boolean jj_3R_intervalUnit_272_3_14() {
        return this.jj_3R_dateUnit_286_3_21();
    }

    private boolean jj_3R_nInterval_178_3_6() {
        return this.jj_3R_positiveInteger_186_3_10();
    }

    private boolean jj_3R_intervalUnit_271_3_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_intervalUnit_271_3_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_intervalUnit_272_3_14()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_intervalUnit_271_3_13() {
        return this.jj_3R_timeUnit_279_3_20();
    }

    private boolean jj_3R_unit_552_3_19() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3R_unit_551_3_18() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_unit_550_3_17() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_unit_549_3_16() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_unit_549_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_unit_549_3_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_unit_550_3_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_unit_551_3_18()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_unit_552_3_19()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_year_219_3_3() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 48 && YEAR_PATTERN.matcher(this.getToken((int)1).image).matches();
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_year_219_14_8()) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_relativeRange_357_3_4() {
        return this.jj_3R_nInterval_178_3_6();
    }

    private boolean jj_3_5() {
        return this.jj_3R_nInterval_178_3_6();
    }

    private boolean jj_3_3() {
        return this.jj_3R_thisRange_334_3_5();
    }

    private boolean jj_3_2() {
        return this.jj_3R_relativeRange_357_3_4();
    }

    private boolean jj_3_1() {
        return this.jj_3R_year_219_3_3();
    }

    private boolean jj_3_6() {
        return this.jj_3R_circle_520_3_7();
    }

    private boolean jj_3R_positiveInteger_186_14_15() {
        return false;
    }

    private boolean jj_3R_thisRange_334_3_5() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_3R_intervalUnit_271_3_9()) {
            return true;
        }
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_dateUnit_286_3_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(7)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(8)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(9)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(10)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(11)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(12)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(13)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(14)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(15)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(16)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(17)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(18)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(19)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(20)) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_circle_520_3_7() {
        if (this.jj_3R_number_752_3_11()) {
            return true;
        }
        return this.jj_3R_unit_549_3_12();
    }

    private boolean jj_3R_number_752_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(48)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(49)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_positiveInteger_186_3_10() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 48 && POSITIVE_INTEGER_PATTERN.matcher(this.getToken((int)1).image).matches();
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_positiveInteger_186_14_15()) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_timeUnit_279_3_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(2)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(3)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(4)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(5)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(6)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 0x200000, 0, 0, 0, 0, 0x1FFFFE, 126, 2097024, 0, 0x1FFFFE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0x200000, 0, 0, 0, 0xFC00000, 0xFC00000, 0, 0xC00000, 0, 0x3000000, 0, 0x3000000, 0, 0xC00000, 0, 0, 0, 0, 0xC000000, 0x10000000, 0, 0x20000000, 0, -1073741824, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 11264, 1208008704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0x10000000, 0x48000000, 0x10000000, 2048, 0, 0, 4096, 196608, 0, 0, 0, 0, 196608, 196608, 0, 0, 0x20000000, 0, 0x20000000, 0, 0x20000000, 0, 0x20000000, 196608, 0, 196608, 0, 0, 196608, 0, 196608, 0, 196608};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0x4000000, 0x8000000, 553635896, 0xFFC000, 0xE00000, 2080768, 1, 0, 0, 0, 4112, 0, 2, 1, 2, 0, 2, 4120, 4120, 8193, 0, 671088676, 0x20000020, 1920, 0x4000800, 0x4000800, 0x20002000, 0x2B002020, 0x3000020, 0, 2048, 0, 2048, 0, 2048, 0, 2048, 0, 8192, 8192, 0, 0, 0, 0, 0, 0, 0};
    }

    public FiltexParserImpl(InputStream stream) {
        this(stream, null);
    }

    public FiltexParserImpl(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new FiltexParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 47; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 47; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FiltexParserImpl(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FiltexParserImplTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 47; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new FiltexParserImplTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 47; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FiltexParserImpl(FiltexParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 47; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(FiltexParserImplTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 47; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[95];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 47; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 95; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        FiltexParserImpl.jj_la1_init_0();
        FiltexParserImpl.jj_la1_init_1();
        FiltexParserImpl.jj_la1_init_2();
        jj_ls = new LookaheadSuccess();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

