/* Generated By:JavaCC: Do not edit this line. MorelParserImpl.java */
package net.hydromatic.morel.parse;

import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.Ast.*;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.util.Pair;

import com.google.common.collect.ImmutableList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import static net.hydromatic.morel.ast.AstBuilder.ast;

/**
 * Parser for Standard ML, generated from MorelParser.jj by JavaCC.
 */
public class MorelParserImpl implements MorelParser, MorelParserImplConstants {
  private static final Logger LOGGER =
      LoggerFactory.getLogger("net.hydromatic.morel.parse");

  public void setTabSize(int tabSize) {
    jj_input_stream.setTabSize(tabSize);
  }

  public Pos getPos() {
    return new Pos(token.beginLine, token.beginColumn,
        token.endLine, token.endColumn);
  }

  void debug_message1() throws ParseException {
  LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

  Pos pos() throws ParseException {
  return new Pos(token.beginLine, token.beginColumn,
    token.endLine, token.endColumn);
  }

/** Parses a literal expression. */
  final public Literal literal() throws ParseException {
  final Ast.Literal e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NATURAL_LITERAL:
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
      e = numericLiteral();
                         {if (true) return e;}
      break;
    case QUOTED_STRING:
      e = stringLiteral();
                        {if (true) return e;}
      break;
    case CHAR_LITERAL:
      e = charLiteral();
                      {if (true) return e;}
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a numeric literal */
  final public Literal numericLiteral() throws ParseException {
  final BigDecimal d;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NATURAL_LITERAL:
    case INTEGER_LITERAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NATURAL_LITERAL:
        jj_consume_token(NATURAL_LITERAL);
        break;
      case INTEGER_LITERAL:
        jj_consume_token(INTEGER_LITERAL);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    if (token.image.startsWith("~")) {
      d = new BigDecimal(token.image.substring(1)).negate();
    } else {
      d = new BigDecimal(token.image);
    }
    {if (true) return ast.intLiteral(d, pos());}
      break;
    case REAL_LITERAL:
      jj_consume_token(REAL_LITERAL);
    if (token.image.startsWith("~")) {
      d = new BigDecimal(token.image.substring(1)).negate();
    } else {
      d = new BigDecimal(token.image);
    }
    {if (true) return ast.realLiteral(d, pos());}
      break;
    case SCIENTIFIC_LITERAL:
      jj_consume_token(SCIENTIFIC_LITERAL);
    final int e = Math.max(token.image.indexOf("e"),
      token.image.indexOf("E"));
    if (token.image.startsWith("~")) {
      d = new BigDecimal(token.image.substring(1, e)).negate();
    } else {
      d = new BigDecimal(token.image.substring(0, e));
    }
    final int exponent;
    if (token.image.startsWith("~", e + 1)) {
      exponent = -Integer.valueOf(token.image.substring(e + 2));
    } else {
      exponent = Integer.valueOf(token.image.substring(e + 1));
    }
    {if (true) return ast.realLiteral(d.scaleByPowerOfTen(exponent), pos());}
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a string literal. */
  final public Literal stringLiteral() throws ParseException {
    jj_consume_token(QUOTED_STRING);
    assert token.image.charAt(0) == '"';
    assert token.image.charAt(token.image.length() - 1) == '"';
    String image = token.image.substring(1, token.image.length() - 1);
    {if (true) return ast.stringLiteral(pos(), image.replace("''", "'"));}
    throw new Error("Missing return statement in function");
  }

/** Parses a char literal. */
  final public Literal charLiteral() throws ParseException {
    jj_consume_token(CHAR_LITERAL);
    assert token.image.charAt(0) == '#';
    assert token.image.charAt(1) == '"';
    assert token.image.charAt(token.image.length() - 1) == '"';
    final String image0 = token.image.substring(2, token.image.length() - 1);
    final String image = image0.replace("''", "'");
    if (image.length() != 1) {
      {if (true) throw new RuntimeException("Error: character constant not length 1");}
    }
    {if (true) return ast.charLiteral(pos(), image.charAt(0));}
    throw new Error("Missing return statement in function");
  }

/** Parses an identifier. */
  final public Id identifier() throws ParseException {
    jj_consume_token(IDENTIFIER);
    {if (true) return ast.id(pos(), token.image);}
    throw new Error("Missing return statement in function");
  }

/** Parses a record selector, e.g. "{@code #empno}".
 *
 * <p>You use it as a function to extract a field of a record;
 * for example <code>#empno {empno=10, name="Fred"}</code>
 * yields {@code 10}. */
  final public RecordSelector recordSelector() throws ParseException {
    jj_consume_token(LABEL);
    assert token.image.startsWith("#");
    {if (true) return ast.recordSelector(pos(), token.image.substring(1));}
    throw new Error("Missing return statement in function");
  }

/** Parses a type variable, e.g. "{@code 'a}". */
  final public TyVar tyVar() throws ParseException {
    jj_consume_token(TY_VAR);
    assert token.image.startsWith("'");
    {if (true) return ast.tyVar(pos(), token.image);}
    throw new Error("Missing return statement in function");
  }

/** Parses a type variable, or a list of 1 or more type variables in
 *  parentheses, or empty. Valid examples: "", "'a", "('a)", "('a, 'b)". */
  final public List tyVarOptionalList() throws ParseException {
  TyVar tyVar;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TY_VAR:
      tyVar = tyVar();
                    {if (true) return ImmutableList.of(tyVar);}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
             List<TyVar> tyVars = new ArrayList<TyVar>();
      tyVar = tyVar();
                    tyVars.add(tyVar);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_1;
        }
        jj_consume_token(COMMA);
        tyVar = tyVar();
                              tyVars.add(tyVar);
      }
    {if (true) return tyVars;}
      break;
    default:
      jj_la1[4] = jj_gen;
    {if (true) return ImmutableList.of();}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a record type, e.g. "{@code {a:int,b:string} }". */
  final public RecordType recordType() throws ParseException {
  final Span span;
    jj_consume_token(LBRACE);
    span = Span.of(getPos());
    final Map<String, Type> map = new LinkedHashMap<String, Type>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      fieldType(map);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[5] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        fieldType(map);
      }
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    {if (true) return ast.recordType(span.end(this), map);}
    throw new Error("Missing return statement in function");
  }

  final public void fieldType(Map/*<String, Type>*/ map) throws ParseException {
  final Id id;
  final Type type;
    id = identifier();
    jj_consume_token(COLON);
    type = type();
    map.put(id.name, type);
  }

/** Parses a "if ... then ... else ..." expression. */
  final public Exp ifThenElse() throws ParseException {
  final Span span;
  final Exp condition;
  final Exp ifTrue;
  final Exp ifFalse;
    jj_consume_token(IF);
         span = Span.of(getPos());
    condition = expression();
    jj_consume_token(THEN);
    ifTrue = expression();
    jj_consume_token(ELSE);
    ifFalse = expression();
    {if (true) return ast.ifThenElse(span.end(this), condition, ifTrue, ifFalse);}
    throw new Error("Missing return statement in function");
  }

/** Parses a "let ... in expression end" expression. */
  final public Exp let() throws ParseException {
  final Span span;
  final Exp e;
  Decl decl;
  final List<Decl> declList = new ArrayList<Decl>();
    jj_consume_token(LET);
          span = Span.of(getPos());
    label_3:
    while (true) {
      decl = decl();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[7] = jj_gen;
        ;
      }
                                    declList.add(decl);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATATYPE:
      case FUN:
      case VAL:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
    }
    jj_consume_token(IN);
    e = expression();
    jj_consume_token(END);
    {if (true) return ast.let(span.end(this), declList, e);}
    throw new Error("Missing return statement in function");
  }

/** Parses a "{@code case exp of pat => exp | pat => exp}" expression. */
  final public Exp caseOf() throws ParseException {
  final Span span;
  final Exp exp;
  final List<Match> matchList;
    jj_consume_token(CASE);
           span = Span.of(getPos());
    exp = expression();
    jj_consume_token(OF);
    matchList = matchList();
    {if (true) return ast.caseOf(span.end(this), exp, matchList);}
    throw new Error("Missing return statement in function");
  }

/** Parses a "{@code from exp as id yield exp}" expression. */
  final public Exp from() throws ParseException {
  final Span span;
  final Map<Id, Exp> sources = new LinkedHashMap<Id, Exp>();
  Exp filterExp = null;
  Exp yieldExp = null;
  final List<Pair<Exp, Id>> groupExps;
  final List<Aggregate> aggregates;
    jj_consume_token(FROM);
           span = Span.of(getPos());
    fromSource(sources);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      fromSource(sources);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      filterExp = expression();
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GROUP:
      jj_consume_token(GROUP);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case FROM:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case LABEL:
        groupExps = expressionAsCommaList();
        break;
      default:
        jj_la1[11] = jj_gen;
        groupExps = ImmutableList.of();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMPUTE:
        jj_consume_token(COMPUTE);
        aggregates = aggregateCommaList();
        break;
      default:
        jj_la1[12] = jj_gen;
        aggregates = ImmutableList.of();
      }
      {if (true) return ast.from(span.end(this), sources, filterExp, yieldExp, groupExps,
          aggregates);}
      break;
    default:
      jj_la1[14] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case YIELD:
        jj_consume_token(YIELD);
        yieldExp = expression();
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      {if (true) return ast.from(span.end(this), sources, filterExp, yieldExp, null, null);}
    }
    throw new Error("Missing return statement in function");
  }

  final public void fromSource(Map/*<String, Exp>*/ sources) throws ParseException {
  final Exp exp;
  final Id id;
    id = identifier();
    jj_consume_token(IN);
    exp = expression();
    sources.put(id, exp);
  }

  final public List aggregateCommaList() throws ParseException {
  final List<Aggregate> list = new ArrayList<Aggregate>();
  Aggregate e;
    e = aggregate();
                    list.add(e);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      e = aggregate();
                              list.add(e);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public Aggregate aggregate() throws ParseException {
  final Exp folder;
  final Exp argument;
  final Id id;
    folder = expression();
    jj_consume_token(OF);
    argument = expression();
    jj_consume_token(AS);
    id = identifier();
    {if (true) return ast.aggregate(folder.pos.plus(id.pos), folder, argument, id);}
    throw new Error("Missing return statement in function");
  }

/** Parses a "{@code fn arg => expression}" lambda expression. */
  final public Exp fn() throws ParseException {
  final Span span;
  final Match match;
    jj_consume_token(FN);
         span = Span.of(getPos());
    match = match();
    {if (true) return ast.fn(span.end(this), match);}
    throw new Error("Missing return statement in function");
  }

  final public List matchList() throws ParseException {
  Match match;
  final List<Match> matchList = new ArrayList<Match>();
    match = match();
                    matchList.add(match);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BAR:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_6;
      }
      jj_consume_token(BAR);
      match = match();
                            matchList.add(match);
    }
    {if (true) return matchList;}
    throw new Error("Missing return statement in function");
  }

/** Parses a "{@code pat => expression}" match. */
  final public Match match() throws ParseException {
  final Pat pat;
  final Exp e;
    pat = pat();
    jj_consume_token(RARROW);
    e = expression();
    {if (true) return ast.match(pat.pos.plus(e.pos), pat, e);}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression.
 *
 * <p>8 is the highest level of precedence in standard ML,
 and the '.field' extension is at level 9.
 The full list is as follows:
 *
 * <ul>
 * <li>infix 9 {@code .}
 * <li>infix 8 (application)
 * <li>infix 7 {@code * / div mod}
 * <li>infix 6 {@code + - ^}
 * <li>infixr 5 {@code :: @}
 * <li>infix 4 {@code = <> > >= < <=}
 * <li>infix 3 {@code := o}
 * <li>infix 0 {@code before}
 * </ul>
 */
  final public Exp expression9() throws ParseException {
  Exp e;
  Id id;
    e = atom();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_7;
      }
      jj_consume_token(DOT);
      id = identifier();
      final Exp s = ast.recordSelector(pos(), id.name);
      e = ast.apply(s, e);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence level 8 (function application). */
  final public Exp expression8() throws ParseException {
  Exp e;
  Exp e2;
    e = expression9();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case FROM:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
      case LABEL:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_8;
      }
      e2 = expression9();
      e = ast.apply(e, e2);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence level 7 (*, /, div, mod). */
  final public Exp expression7() throws ParseException {
  Exp e;
  Exp e2;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TILDE:
      jj_consume_token(TILDE);
      e = expression7();
                              {if (true) return ast.negate(getPos(), e);}
      break;
    case CASE:
    case FN:
    case IF:
    case LET:
    case FROM:
    case NATURAL_LITERAL:
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case IDENTIFIER:
    case LABEL:
      e = expression8();
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIV:
        case MOD:
        case STAR:
        case SLASH:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_9;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STAR:
          jj_consume_token(STAR);
          e2 = expression8();
      e = ast.times(e, e2);
          break;
        case SLASH:
          jj_consume_token(SLASH);
          e2 = expression8();
      e = ast.divide(e, e2);
          break;
        case DIV:
          jj_consume_token(DIV);
          e2 = expression8();
      e = ast.div(e, e2);
          break;
        case MOD:
          jj_consume_token(MOD);
          e2 = expression8();
      e = ast.mod(e, e2);
          break;
        default:
          jj_la1[20] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    {if (true) return e;}
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence level 6 (+, -, ^). */
  final public Exp expression6() throws ParseException {
  Exp e;
  Exp e2;
    e = expression7();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case CARET:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        e2 = expression7();
      e = ast.plus(e, e2);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        e2 = expression7();
      e = ast.minus(e, e2);
        break;
      case CARET:
        jj_consume_token(CARET);
        e2 = expression7();
      e = ast.caret(e, e2);
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence level 5 ({@code ::}),
* right-associative. */
  final public Exp expression5() throws ParseException {
  Exp e;
  final List<Exp> list = new ArrayList<Ast.Exp>();
    e = expression6();
                      list.add(e);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONS:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_11;
      }
      jj_consume_token(CONS);
      e = expression6();
                               list.add(e);
    }
    {if (true) return ast.foldCons(list);}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence level 4 ({@code =}, {@code <>},
  * {@code >}, {@code >=}, {@code <}, {@code <=}). */
  final public Exp expression4() throws ParseException {
  Exp e;
  Exp e2;
    e = expression5();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case GT:
      case LT:
      case LE:
      case GE:
      case NE:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
        e2 = expression5();
      e = ast.equal(e, e2);
        break;
      case NE:
        jj_consume_token(NE);
        e2 = expression5();
      e = ast.notEqual(e, e2);
        break;
      case LT:
        jj_consume_token(LT);
        e2 = expression5();
      e = ast.lessThan(e, e2);
        break;
      case GT:
        jj_consume_token(GT);
        e2 = expression5();
      e = ast.greaterThan(e, e2);
        break;
      case LE:
        jj_consume_token(LE);
        e2 = expression5();
      e = ast.lessThanOrEqual(e, e2);
        break;
      case GE:
        jj_consume_token(GE);
        e2 = expression5();
      e = ast.greaterThanOrEqual(e, e2);
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence level 2 (andalso). */
  final public Exp expression2() throws ParseException {
  Exp e;
  Exp e2;
    e = expression4();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANDALSO:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_13;
      }
      jj_consume_token(ANDALSO);
      e2 = expression4();
      e = ast.andAlso(e, e2);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses an expression of precedence level 1 (orelse). */
  final public Exp expression1() throws ParseException {
  Exp e;
  Exp e2;
    e = expression2();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ORELSE:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_14;
      }
      jj_consume_token(ORELSE);
      e2 = expression2();
      e = ast.orElse(e, e2);
    }
    {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public Exp expression() throws ParseException {
  Exp e;
    e = expression1();
                      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** List of expressions "e1 as id1, e2 as id2, e3 as id3". */
  final public List expressionAsCommaList() throws ParseException {
  final List<Pair<Exp, Id>> list = new ArrayList<Pair<Exp, Id>>();
  Pair<Exp, Id> p;
    p = expressionAs();
                       list.add(p);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_15;
      }
      jj_consume_token(COMMA);
      p = expressionAs();
                         list.add(p);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/** Expression with optional "as", e.g. "e1 as id1";
 * "#deptno e" and "e.deptno" are equivalent to "e.deptno as deptno";
 * "x" is equivalent to "x as x". */
  final public Pair expressionAs() throws ParseException {
  final Exp exp;
  final Id id;
    exp = expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      id = identifier();
                             {if (true) return Pair.of(exp, id);}
      break;
    default:
      jj_la1[30] = jj_gen;
      final String label = ast.implicitLabel(exp);
      {if (true) return Pair.of(exp, ast.id(exp.pos, label));}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an atomic expression. */
  final public Exp atom() throws ParseException {
  final Exp e;
  final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      e = identifier();
                     {if (true) return e;}
      break;
    case LABEL:
      e = recordSelector();
                         {if (true) return e;}
      break;
    case NATURAL_LITERAL:
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
      e = literal();
                  {if (true) return e;}
      break;
    case LET:
      e = let();
              {if (true) return e;}
      break;
    case FN:
      e = fn();
             {if (true) return e;}
      break;
    case IF:
      e = ifThenElse();
                     {if (true) return e;}
      break;
    case CASE:
      e = caseOf();
                 {if (true) return e;}
      break;
    case FROM:
      e = from();
               {if (true) return e;}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
    span = Span.of(getPos());
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RPAREN:
        jj_consume_token(RPAREN);
               {if (true) return ast.unitLiteral(span.end(this));}
        break;
      case CASE:
      case FN:
      case IF:
      case LET:
      case FROM:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case LABEL:
        e = expression();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RPAREN:
          jj_consume_token(RPAREN);
                 {if (true) return e;}
          break;
        case COMMA:
        final List<Exp> list = new ArrayList<Exp>();
        list.add(e);
        Exp e2;
          label_16:
          while (true) {
            jj_consume_token(COMMA);
            e2 = expression();
                                    list.add(e2);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[31] = jj_gen;
              break label_16;
            }
          }
          jj_consume_token(RPAREN);
        {if (true) return ast.tuple(span.end(this), list);}
          break;
        default:
          jj_la1[32] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
    span = Span.of(getPos());
    final List<Exp> list = new ArrayList<Exp>();
    Exp e2;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case FROM:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case LABEL:
        e2 = expression();
                        list.add(e2);
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[34] = jj_gen;
            break label_17;
          }
          jj_consume_token(COMMA);
          e2 = expression();
                                  list.add(e2);
        }
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
    {if (true) return ast.list(span.end(this), list);}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
    span = Span.of(getPos());
    final Map<String, Exp> map = new LinkedHashMap<String, Exp>();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case FROM:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case LABEL:
        recordExp(map);
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[36] = jj_gen;
            break label_18;
          }
          jj_consume_token(COMMA);
          recordExp(map);
        }
        break;
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    {if (true) return ast.record(span.end(this), map);}
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a "label = expression" inside a record. */
  final public void recordExp(Map/*<String, Exp>*/ map) throws ParseException {
  final String id;
  final Ast.Exp exp;
    if (jj_2_1(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NATURAL_LITERAL:
        jj_consume_token(NATURAL_LITERAL);
        break;
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                         id = token.image;
      jj_consume_token(EQ);
      exp = expression();
                            map.put(id, exp);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case FN:
      case IF:
      case LET:
      case FROM:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case TILDE:
      case IDENTIFIER:
      case LABEL:
        exp = expression();
    final String label = ast.implicitLabel(exp);
    map.put(label, exp);
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/** Parses a value declaration, and adds it to a list. */
  final public void addValDecl(List decls) throws ParseException {
  final ValDecl decl;
    decl = valDecl();
    decls.add(decl);
  }

/** Parses a value declaration. */
  final public ValDecl valDecl() throws ParseException {
  final Span span;
  final List<Ast.ValBind> valBinds = new ArrayList<ValBind>();
    jj_consume_token(VAL);
          span = Span.of(getPos());
    valBind(valBinds);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[41] = jj_gen;
        break label_19;
      }
      jj_consume_token(AND);
      valBind(valBinds);
    }
    {if (true) return ast.valDecl(span.end(this), valBinds);}
    throw new Error("Missing return statement in function");
  }

  final public void valBind(List/*<Ast.ValBind>*/ valBinds) throws ParseException {
  final Pat pat;
  final Exp e;
  boolean rec = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REC:
      jj_consume_token(REC);
            rec = true;
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    pat = pat();
    jj_consume_token(EQ);
    e = expression();
    valBinds.add(ast.valBind(pat.pos.plus(e.pos), rec, pat, e));
  }

/** Parses a declaration. */
  final public Ast.Decl decl() throws ParseException {
  final Ast.Decl n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATATYPE:
      n = datatypeDecl();
                       {if (true) return n;}
      break;
    case VAL:
      n = valDecl();
                  {if (true) return n;}
      break;
    case FUN:
      n = funDecl();
                  {if (true) return n;}
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a type declaration, e.g.
 * {@code datatype 'a option = NONE | SOME of 'a}
 */
  final public Ast.DatatypeDecl datatypeDecl() throws ParseException {
  final Span span;
  final List<DatatypeBind> binds = new ArrayList<DatatypeBind>();
    jj_consume_token(DATATYPE);
               span = Span.of(getPos());
    datatypeBind(binds);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_20;
      }
      jj_consume_token(AND);
      datatypeBind(binds);
    }
    {if (true) return ast.datatypeDecl(span.end(this), binds);}
    throw new Error("Missing return statement in function");
  }

  final public void datatypeBind(List/*<Ast.DatatypeBind>*/ datatypeBinds) throws ParseException {
  final List<TyVar> tyVars = new ArrayList<TyVar>();
  TyVar tyVar;
  final Ast.Id id;
  final List<TyCon> tyCons = new ArrayList<TyCon>();
  TyCon tyCon;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case TY_VAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TY_VAR:
        tyVar = tyVar();
                      tyVars.add(tyVar);
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
        tyVar = tyVar();
                      tyVars.add(tyVar);
        label_21:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[45] = jj_gen;
            break label_21;
          }
          jj_consume_token(COMMA);
          tyVar = tyVar();
        tyVars.add(tyVar);
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    id = identifier();
    jj_consume_token(EQ);
    tyCon = typeConstructor();
    tyCons.add(tyCon);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BAR:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_22;
      }
      jj_consume_token(BAR);
      tyCon = typeConstructor();
      tyCons.add(tyCon);
    }
    final List<AstNode> nodes = ImmutableList.<AstNode>builder().addAll(tyVars)
        .add(id).addAll(tyCons).build();
    datatypeBinds.add(ast.datatypeBind(Pos.sum(nodes), id, tyVars, tyCons));
  }

  final public Ast.TyCon typeConstructor() throws ParseException {
  final Ast.Id tag;
  final Ast.Type type;
    tag = identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OF:
      jj_consume_token(OF);
      type = type();
      break;
    default:
      jj_la1[49] = jj_gen;
      type = null;
    }
    final Pos pos = type == null ? tag.pos : tag.pos.plus(type.pos);
    {if (true) return ast.typeConstructor(pos, tag, type);}
    throw new Error("Missing return statement in function");
  }

/** Parses a function declaration, e.g.
* {@code fun f 1 y = y + 1 | f x y = 0 and g x = 0}. */
  final public Ast.FunDecl funDecl() throws ParseException {
  final Span span;
  final List<FunBind> funBindList = new ArrayList<FunBind>();
    jj_consume_token(FUN);
          span = Span.of(getPos());
    funBind(funBindList);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[50] = jj_gen;
        break label_23;
      }
      jj_consume_token(AND);
      funBind(funBindList);
    }
    {if (true) return ast.funDecl(span.end(this), funBindList);}
    throw new Error("Missing return statement in function");
  }

/** Parses a function binding, e.g.
* {@code f 1 y = y + 1 | f x y = 0},
* and adds it to a list. */
  final public void funBind(List/*<FunBind>*/ list) throws ParseException {
  final List<FunMatch> matchList = new ArrayList<FunMatch>();
    funMatch(matchList);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BAR:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_24;
      }
      jj_consume_token(BAR);
      funMatch(matchList);
    }
    list.add(ast.funBind(Pos.sum(matchList), matchList));
  }

/** Parses a function match, e.g.
* {@code f 1 y = y + 1},
* and adds it to a list. */
  final public void funMatch(List/*<FunMatch>*/ list) throws ParseException {
  final Ast.Id id;
  Ast.Pat pat;
  final List<Ast.Pat> patList = new ArrayList<Ast.Pat>();
  final Ast.Exp expression;
    id = identifier();
    label_25:
    while (true) {
      pat = atomPat();
                      patList.add(pat);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 1:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_25;
      }
    }
    jj_consume_token(EQ);
    expression = expression();
    list.add(
      ast.funMatch(id.pos.plus(expression.pos), id.name, patList, expression));
  }

/** Parses a pattern. */
  final public Pat pat() throws ParseException {
  Pat pat;
  Type type;
    pat = pat5();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        ;
        break;
      default:
        jj_la1[53] = jj_gen;
        break label_26;
      }
      jj_consume_token(COLON);
      type = type();
      pat = ast.annotatedPat(pat.pos.plus(type.pos), pat, type);
    }
    {if (true) return pat;}
    throw new Error("Missing return statement in function");
  }

/** Parses a pattern of precedence level 5 ({@code ::}),
* right-associative. */
  final public Pat pat5() throws ParseException {
  Pat pat;
  final List<Pat> list = new ArrayList<Ast.Pat>();
    pat = pat4();
                 list.add(pat);
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONS:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_27;
      }
      jj_consume_token(CONS);
      pat = pat4();
                          list.add(pat);
    }
    pat = list.get(list.size() - 1);
    for (int i = list.size() - 2; i >= 0; i--) {
      pat = ast.consPat(list.get(i), pat);
    }
    {if (true) return pat;}
    throw new Error("Missing return statement in function");
  }

/** Parses a pattern that is a type constructor (an identifier) followed by a
 * pattern. For now, assume that it has precedence level 4. */
  final public Pat pat4() throws ParseException {
  final Id id;
  final Pat pat;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      id = identifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 1:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
        pat = pat();
                  {if (true) return ast.conPat(id.pos.plus(pat.pos), id, pat);}
        break;
      default:
        jj_la1[55] = jj_gen;
      {if (true) return ast.idPat(id.pos, id.name);}
      }
      break;
    case 1:
    case NATURAL_LITERAL:
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
      pat = atomPat();
                    {if (true) return pat;}
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an atomic pattern. */
  final public Pat atomPat() throws ParseException {
  final Span span;
  final Ast.Id id;
  final Ast.Literal literal;
  final Ast.Pat p;
  Pat p2;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      id = identifier();
                      {if (true) return ast.idPat(id.pos, id.name);}
      break;
    case NATURAL_LITERAL:
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
      literal = literal();
    {if (true) return ast.literalPat(literal.pos, literal.op.toPat(), literal.value);}
      break;
    case 1:
      jj_consume_token(1);
    {if (true) return ast.wildcardPat(pos());}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      p = pat();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RPAREN:
        jj_consume_token(RPAREN);
               {if (true) return p;}
        break;
      case COMMA:
      span = Span.of(getPos());
      final List<Pat> list = new ArrayList<Pat>();
      list.add(p);
        label_28:
        while (true) {
          jj_consume_token(COMMA);
          p2 = pat();
                           list.add(p2);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[57] = jj_gen;
            break label_28;
          }
        }
        jj_consume_token(RPAREN);
      {if (true) return ast.tuplePat(span.end(this), list);}
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
    span = Span.of(getPos());
    final List<Pat> list = new ArrayList<Pat>();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 1:
      case NATURAL_LITERAL:
      case INTEGER_LITERAL:
      case REAL_LITERAL:
      case SCIENTIFIC_LITERAL:
      case QUOTED_STRING:
      case CHAR_LITERAL:
      case LPAREN:
      case LBRACE:
      case LBRACKET:
      case IDENTIFIER:
        p2 = pat();
                 list.add(p2);
        label_29:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[59] = jj_gen;
            break label_29;
          }
          jj_consume_token(COMMA);
          p2 = pat();
                           list.add(p2);
        }
        break;
      default:
        jj_la1[60] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
    {if (true) return ast.listPat(span.end(this), list);}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
    span = Span.of(getPos());
    final Map<String, Pat> map = new LinkedHashMap<String, Pat>();
    final boolean[] ellipsis = {false};
      recordPat(ellipsis, map);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_30;
        }
        jj_consume_token(COMMA);
        recordPat(ellipsis, map);
      }
      jj_consume_token(RBRACE);
    {if (true) return ast.recordPat(span.end(this), ellipsis[0], map);}
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a "label = pat" inside a record pattern. */
  final public void recordPat(boolean[] ellipsis, Map/*<String, Pat>*/ map) throws ParseException {
  final String id;
  final Ast.Pat pat;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELLIPSIS:
      jj_consume_token(ELLIPSIS);
               ellipsis[0] = true;
      break;
    case NATURAL_LITERAL:
    case IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NATURAL_LITERAL:
        jj_consume_token(NATURAL_LITERAL);
        break;
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                         id = token.image;
      jj_consume_token(EQ);
      pat = pat();
                     map.put(id, pat);
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** Parses a type. */
  final public Ast.Type atomicType() throws ParseException {
  final Span span;
  final Type type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TY_VAR:
      type = tyVar();
                   {if (true) return type;}
      break;
    case IDENTIFIER:
      type = namedType();
                       {if (true) return type;}
      break;
    case LBRACE:
      type = recordType();
                        {if (true) return type;}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
    span = Span.of(getPos());
      type = type();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RPAREN:
        jj_consume_token(RPAREN);
                 {if (true) return type;}
        break;
      case COMMA:
        final List<Type> list = new ArrayList<Type>();
        list.add(type);
        Type type2;
        label_31:
        while (true) {
          jj_consume_token(COMMA);
          type2 = type();
                                 list.add(type2);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[65] = jj_gen;
            break label_31;
          }
        }
        jj_consume_token(RPAREN);
        {if (true) return ast.compositeType(span.end(this), list);}
        break;
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Ast.Type type7() throws ParseException {
  Type t;
    t = atomicType();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[68] = jj_gen;
        break label_32;
      }
      jj_consume_token(IDENTIFIER);
      final List<Type> types =
        t instanceof Ast.CompositeType
          ? ((Ast.CompositeType) t).types
          : ImmutableList.of(t);
      t = ast.namedType(t.pos.plus(pos()), types, token.image);
    }
    {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Ast.Type type6() throws ParseException {
  final List<Type> types = new ArrayList<Type>();
  Type t;
    t = type7();
                types.add(t);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_33;
      }
      jj_consume_token(STAR);
      t = type7();
                         types.add(t);
    }
    {if (true) return types.size() == 1 ? t
      : ast.tupleType(Pos.sum(types), types);}
    throw new Error("Missing return statement in function");
  }

  final public Ast.Type type() throws ParseException {
  final List<Type> types = new ArrayList<Type>();
  Type t;
    t = type6();
                types.add(t);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RTHINARROW:
        ;
        break;
      default:
        jj_la1[70] = jj_gen;
        break label_34;
      }
      jj_consume_token(RTHINARROW);
      t = type6();
                               types.add(t);
    }
    {if (true) return types.size() == 1 ? t
        : ast.foldFunctionType(types);}
    throw new Error("Missing return statement in function");
  }

  final public Ast.Type namedType() throws ParseException {
    jj_consume_token(IDENTIFIER);
    {if (true) return ast.namedType(pos(), ImmutableList.of(), token.image);}
    throw new Error("Missing return statement in function");
  }

  final public AstNode statement() throws ParseException {
  final AstNode n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
    case FN:
    case IF:
    case LET:
    case FROM:
    case NATURAL_LITERAL:
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case SCIENTIFIC_LITERAL:
    case QUOTED_STRING:
    case CHAR_LITERAL:
    case LPAREN:
    case LBRACE:
    case LBRACKET:
    case TILDE:
    case IDENTIFIER:
    case LABEL:
      n = expression();
                     {if (true) return n;}
      break;
    case DATATYPE:
    case FUN:
    case VAL:
      n = decl();
               {if (true) return n;}
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AstNode statementSemicolon() throws ParseException {
  final AstNode n;
    n = statement();
    jj_consume_token(SEMICOLON);
                                {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) return true;
    }
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  public MorelParserImplTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[72];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x3c000000,0xc000000,0x3c000000,0x0,0x0,0x0,0x0,0x0,0x80420,0x0,0x1000000,0x3c402a10,0x200000,0x2000000,0x800000,0x0,0x0,0x0,0x3c402a10,0x4040,0x4040,0x3c402a10,0x0,0x0,0x0,0x0,0x0,0x8,0x10000,0x0,0x100000,0x0,0x0,0x3c402a10,0x0,0x3c402a10,0x0,0x3c402a10,0x3c402a10,0x4000000,0x3c402a10,0x4,0x20000,0x80420,0x4,0x0,0x0,0x0,0x0,0x8000,0x4,0x0,0x3c000002,0x0,0x0,0x3c000002,0x3c000002,0x0,0x0,0x0,0x3c000002,0x0,0x3c000002,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x3c482e30,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x3,0x0,0x0,0x800,0x4,0x800,0x0,0x100,0x0,0x800,0x0,0x4000057,0x0,0x0,0x0,0x800,0x200,0x400,0x57,0x3000000,0x3000000,0x4000057,0xe00000,0xe00000,0x8000000,0x1dc000,0x1dc000,0x0,0x0,0x800,0x0,0x800,0x808,0x400005f,0x800,0x4000057,0x800,0x4000057,0x57,0x0,0x4000057,0x0,0x0,0x0,0x0,0x800,0x4,0x4,0x200,0x0,0x0,0x200,0x57,0x20000,0x8000000,0x57,0x57,0x800,0x808,0x800,0x57,0x800,0x57,0x0,0x10000000,0x800,0x808,0x14,0x0,0x1000000,0x2000,0x4000057,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x800,0x0,0x400,0x0,0x0,0x0,0x0,0x1400,0x0,0x0,0x0,0x0,0x0,0x0,0x1400,0x0,0x0,0x1400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400,0x0,0x1400,0x0,0x1400,0x1400,0x400,0x1400,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x400,0x0,0x400,0x400,0x400,0x0,0x0,0xc00,0x400,0x0,0x0,0x1400,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public MorelParserImpl(java.io.InputStream stream) {
     this(stream, null);
  }
  public MorelParserImpl(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new MorelParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public MorelParserImpl(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new MorelParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public MorelParserImpl(MorelParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(MorelParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[79];
    for (int i = 0; i < 79; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 72; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 79; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
