(*
 * Licensed to Julian Hyde under one or more contributor license
 * agreements.  See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Julian Hyde licenses this file to you under the Apache
 * License, Version 2.0 (the "License"); you may not use this
 * file except in compliance with the License.  You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 *
 * Solves the Wordle word puzzle. It includes the corpus of words and
 * solutions used by the actual web site, and has a mechanism for
 * choosing the optimal guess given the information from previous
 * guesses.
 *)
Sys.set ("lineWidth", 78);
Sys.set ("printLength", 64);

(*) Set this to false in tests, true if you want to do some slow/clever stuff.
val slow = false;

val words = [
  "aahed", "aalii", "aargh", "aarti", "abaca", "abaci", "aback", "abacs",
  "abaft", "abaka", "abamp", "aband", "abase", "abash", "abask", "abate",
  "abaya", "abbas", "abbed", "abbes", "abbey", "abbot", "abcee", "abeam",
  "abear", "abele", "abers", "abets", "abhor", "abide", "abies", "abled",
  "abler", "ables", "ablet", "ablow", "abmho", "abode", "abohm", "aboil",
  "aboma", "aboon", "abord", "abore", "abort", "about", "above", "abram",
  "abray", "abrim", "abrin", "abris", "absey", "absit", "abuna", "abune",
  "abuse", "abuts", "abuzz", "abyes", "abysm", "abyss", "acais", "acari",
  "accas", "accoy", "acerb", "acers", "aceta", "achar", "ached", "aches",
  "achoo", "acids", "acidy", "acing", "acini", "ackee", "acker", "acmes",
  "acmic", "acned", "acnes", "acock", "acold", "acorn", "acred", "acres",
  "acrid", "acros", "acted", "actin", "acton", "actor", "acute", "acyls",
  "adage", "adapt", "adaws", "adays", "adbot", "addax", "added", "adder",
  "addio", "addle", "adeem", "adept", "adhan", "adieu", "adios", "adits",
  "adman", "admen", "admin", "admit", "admix", "adobe", "adobo", "adopt",
  "adore", "adorn", "adown", "adoze", "adrad", "adred", "adsum", "aduki",
  "adult", "adunc", "adust", "advew", "adyta", "adzed", "adzes", "aecia",
  "aedes", "aegis", "aeons", "aerie", "aeros", "aesir", "afald", "afara",
  "afars", "afear", "affix", "afire", "aflaj", "afoot", "afore", "afoul",
  "afrit", "afros", "after", "again", "agama", "agami", "agape", "agars",
  "agast", "agate", "agave", "agaze", "agene", "agent", "agers", "agger",
  "aggie", "aggri", "aggro", "aggry", "aghas", "agila", "agile", "aging",
  "agios", "agism", "agist", "agita", "aglee", "aglet", "agley", "agloo",
  "aglow", "aglus", "agmas", "agoge", "agone", "agons", "agony", "agood",
  "agora", "agree", "agria", "agrin", "agros", "agued", "agues", "aguna",
  "aguti", "ahead", "aheap", "ahent", "ahigh", "ahind", "ahing", "ahint",
  "ahold", "ahull", "ahuru", "aidas", "aided", "aider", "aides", "aidoi",
  "aidos", "aiery", "aigas", "aight", "ailed", "aimed", "aimer", "ainee",
  "ainga", "aioli", "aired", "airer", "airns", "airth", "airts", "aisle",
  "aitch", "aitus", "aiver", "aiyee", "aizle", "ajies", "ajiva", "ajuga",
  "ajwan", "akees", "akela", "akene", "aking", "akita", "akkas", "alaap",
  "alack", "alamo", "aland", "alane", "alang", "alans", "alant", "alapa",
  "alaps", "alarm", "alary", "alate", "alays", "albas", "albee", "album",
  "alcid", "alcos", "aldea", "alder", "aldol", "aleck", "alecs", "alefs",
  "aleft", "aleph", "alert", "alews", "aleye", "alfas", "algae", "algal",
  "algas", "algid", "algin", "algor", "algum", "alias", "alibi", "alien",
  "alifs", "align", "alike", "aline", "alist", "alive", "aliya", "alkie",
  "alkos", "alkyd", "alkyl", "allay", "allee", "allel", "alley", "allis",
  "allod", "allot", "allow", "alloy", "allyl", "almah", "almas", "almeh",
  "almes", "almud", "almug", "alods", "aloed", "aloes", "aloft", "aloha",
  "aloin", "alone", "along", "aloof", "aloos", "aloud", "alowe", "alpha",
  "altar", "alter", "altho", "altos", "alula", "alums", "alure", "alvar",
  "alway", "amahs", "amain", "amass", "amate", "amaut", "amaze", "amban",
  "amber", "ambit", "amble", "ambos", "ambry", "ameba", "ameer", "amend",
  "amene", "amens", "ament", "amias", "amice", "amici", "amide", "amido",
  "amids", "amies", "amiga", "amigo", "amine", "amino", "amins", "amirs",
  "amiss", "amity", "amlas", "amman", "ammon", "ammos", "amnia", "amnic",
  "amnio", "amoks", "amole", "among", "amort", "amour", "amove", "amowt",
  "amped", "ample", "amply", "ampul", "amrit", "amuck", "amuse", "amyls",
  "anana", "anata", "ancho", "ancle", "ancon", "andro", "anear", "anele",
  "anent", "angas", "angel", "anger", "angle", "anglo", "angry", "angst",
  "anigh", "anile", "anils", "anima", "anime", "animi", "anion", "anise",
  "anker", "ankhs", "ankle", "ankus", "anlas", "annal", "annas", "annat",
  "annex", "annoy", "annul", "anoas", "anode", "anole", "anomy", "ansae",
  "antae", "antar", "antas", "anted", "antes", "antic", "antis", "antra",
  "antre", "antsy", "anura", "anvil", "anyon", "aorta", "apace", "apage",
  "apaid", "apart", "apayd", "apays", "apeak", "apeek", "apers", "apert",
  "apery", "apgar", "aphid", "aphis", "apian", "aping", "apiol", "apish",
  "apism", "apnea", "apode", "apods", "apoop", "aport", "appal", "appay",
  "appel", "apple", "apply", "appro", "appui", "appuy", "apres", "apron",
  "apses", "apsis", "apsos", "apted", "apter", "aptly", "aquae", "aquas",
  "araba", "araks", "arame", "arars", "arbas", "arbor", "arced", "archi",
  "arcos", "arcus", "ardeb", "ardor", "ardri", "aread", "areae", "areal",
  "arear", "areas", "areca", "aredd", "arede", "arefy", "areic", "arena",
  "arene", "arepa", "arere", "arete", "arets", "arett", "argal", "argan",
  "argil", "argle", "argol", "argon", "argot", "argue", "argus", "arhat",
  "arias", "ariel", "ariki", "arils", "ariot", "arise", "arish", "arked",
  "arled", "arles", "armed", "armer", "armet", "armil", "armor", "arnas",
  "arnut", "aroba", "aroha", "aroid", "aroma", "arose", "arpas", "arpen",
  "arrah", "arras", "array", "arret", "arris", "arrow", "arroz", "arsed",
  "arses", "arsey", "arsis", "arson", "artal", "artel", "artic", "artis",
  "artsy", "aruhe", "arums", "arval", "arvee", "arvos", "aryls", "asana",
  "ascon", "ascot", "ascus", "asdic", "ashed", "ashen", "ashes", "ashet",
  "aside", "asked", "asker", "askew", "askoi", "askos", "aspen", "asper",
  "aspic", "aspie", "aspis", "aspro", "assai", "assam", "assay", "asses",
  "asset", "assez", "assot", "aster", "astir", "astun", "asura", "asway",
  "aswim", "asyla", "ataps", "ataxy", "atigi", "atilt", "atimy", "atlas",
  "atman", "atmas", "atmos", "atocs", "atoke", "atoks", "atoll", "atoms",
  "atomy", "atone", "atony", "atopy", "atria", "atrip", "attap", "attar",
  "attic", "atuas", "audad", "audio", "audit", "auger", "aught", "augur",
  "aulas", "aulic", "auloi", "aulos", "aumil", "aunes", "aunts", "aunty",
  "aurae", "aural", "aurar", "auras", "aurei", "aures", "auric", "auris",
  "aurum", "autos", "auxin", "avail", "avale", "avant", "avast", "avels",
  "avens", "avers", "avert", "avgas", "avian", "avine", "avion", "avise",
  "aviso", "avize", "avoid", "avows", "avyze", "await", "awake", "award",
  "aware", "awarn", "awash", "awato", "awave", "aways", "awdls", "aweel",
  "aweto", "awful", "awing", "awmry", "awned", "awner", "awoke", "awols",
  "awork", "axels", "axial", "axile", "axils", "axing", "axiom", "axion",
  "axite", "axled", "axles", "axman", "axmen", "axoid", "axone", "axons",
  "ayahs", "ayaya", "ayelp", "aygre", "ayins", "ayont", "ayres", "ayrie",
  "azans", "azide", "azido", "azine", "azlon", "azoic", "azole", "azons",
  "azote", "azoth", "azuki", "azure", "azurn", "azury", "azygy", "azyme",
  "azyms", "baaed", "baals", "babas", "babel", "babes", "babka", "baboo",
  "babul", "babus", "bacca", "bacco", "baccy", "bacha", "bachs", "backs",
  "bacon", "baddy", "badge", "badly", "baels", "baffs", "baffy", "bafts",
  "bagel", "baggy", "baghs", "bagie", "bahts", "bahus", "bahut", "bails",
  "bairn", "baisa", "baith", "baits", "baiza", "baize", "bajan", "bajra",
  "bajri", "bajus", "baked", "baken", "baker", "bakes", "bakra", "balas",
  "balds", "baldy", "baled", "baler", "bales", "balks", "balky", "balls",
  "bally", "balms", "balmy", "baloo", "balsa", "balti", "balun", "balus",
  "bambi", "banak", "banal", "banco", "bancs", "banda", "bandh", "bands",
  "bandy", "baned", "banes", "bangs", "bania", "banjo", "banks", "banns",
  "bants", "bantu", "banty", "banya", "bapus", "barbe", "barbs", "barby",
  "barca", "barde", "bardo", "bards", "bardy", "bared", "barer", "bares",
  "barfi", "barfs", "barge", "baric", "barks", "barky", "barms", "barmy",
  "barns", "barny", "baron", "barps", "barra", "barre", "barro", "barry",
  "barye", "basal", "basan", "based", "basen", "baser", "bases", "basho",
  "basic", "basij", "basil", "basin", "basis", "basks", "bason", "basse",
  "bassi", "basso", "bassy", "basta", "baste", "basti", "basto", "basts",
  "batch", "bated", "bates", "bathe", "baths", "batik", "baton", "batta",
  "batts", "battu", "batty", "bauds", "bauks", "baulk", "baurs", "bavin",
  "bawds", "bawdy", "bawks", "bawls", "bawns", "bawrs", "bawty", "bayed",
  "bayer", "bayes", "bayle", "bayou", "bayts", "bazar", "bazoo", "beach",
  "beads", "beady", "beaks", "beaky", "beals", "beams", "beamy", "beano",
  "beans", "beany", "beard", "beare", "bears", "beast", "beath", "beats",
  "beaty", "beaus", "beaut", "beaux", "bebop", "becap", "becke", "becks",
  "bedad", "bedel", "bedes", "bedew", "bedim", "bedye", "beech", "beedi",
  "beefs", "beefy", "beeps", "beers", "beery", "beets", "befit", "befog",
  "begad", "began", "begar", "begat", "begem", "beget", "begin", "begot",
  "begum", "begun", "beige", "beigy", "being", "beins", "bekah", "belah",
  "belar", "belay", "belch", "belee", "belga", "belie", "belle", "bells",
  "belly", "belon", "below", "belts", "bemad", "bemas", "bemix", "bemud",
  "bench", "bends", "bendy", "benes", "benet", "benga", "benis", "benne",
  "benni", "benny", "bento", "bents", "benty", "bepat", "beray", "beres",
  "beret", "bergs", "berko", "berks", "berme", "berms", "berob", "berry",
  "berth", "beryl", "besat", "besaw", "besee", "beses", "beset", "besit",
  "besom", "besot", "besti", "bests", "betas", "beted", "betel", "betes",
  "beths", "betid", "beton", "betta", "betty", "bevel", "bever", "bevor",
  "bevue", "bevvy", "bewet", "bewig", "bezel", "bezes", "bezil", "bezzy",
  "bhais", "bhaji", "bhang", "bhats", "bhels", "bhoot", "bhuna", "bhuts",
  "biach", "biali", "bialy", "bibbs", "bibes", "bible", "biccy", "bicep",
  "bices", "biddy", "bided", "bider", "bides", "bidet", "bidis", "bidon",
  "bield", "biers", "biffo", "biffs", "biffy", "bifid", "bigae", "biggs",
  "biggy", "bigha", "bight", "bigly", "bigos", "bigot", "bijou", "biked",
  "biker", "bikes", "bikie", "bilbo", "bilby", "biled", "biles", "bilge",
  "bilgy", "bilks", "bills", "billy", "bimah", "bimas", "bimbo", "binal",
  "bindi", "binds", "biner", "bines", "binge", "bingo", "bings", "bingy",
  "binit", "binks", "bints", "biogs", "biome", "biont", "biota", "biped",
  "bipod", "birch", "birds", "birks", "birle", "birls", "biros", "birrs",
  "birse", "birsy", "birth", "bises", "bisks", "bisom", "bison", "bitch",
  "biter", "bites", "bitos", "bitou", "bitsy", "bitte", "bitts", "bitty",
  "bivia", "bivvy", "bizes", "bizzo", "bizzy", "blabs", "black", "blade",
  "blads", "blady", "blaer", "blaes", "blaff", "blags", "blahs", "blain",
  "blame", "blams", "bland", "blank", "blare", "blart", "blase", "blash",
  "blast", "blate", "blats", "blatt", "blaud", "blawn", "blaws", "blays",
  "blaze", "bleak", "blear", "bleat", "blebs", "blech", "bleed", "bleep",
  "blees", "blend", "blent", "blert", "bless", "blest", "blets", "bleys",
  "blimp", "blimy", "blind", "bling", "blini", "blink", "blins", "bliny",
  "blips", "bliss", "blist", "blite", "blits", "blitz", "blive", "bloat",
  "blobs", "block", "blocs", "blogs", "bloke", "blond", "blood", "blook",
  "bloom", "bloop", "blore", "blots", "blown", "blows", "blowy", "blubs",
  "blude", "bluds", "bludy", "blued", "bluer", "blues", "bluet", "bluey",
  "bluff", "bluid", "blume", "blunk", "blunt", "blurb", "blurs", "blurt",
  "blush", "blype", "boabs", "boaks", "board", "boars", "boart", "boast",
  "boats", "bobac", "bobak", "bobas", "bobby", "bobol", "bobos", "bocca",
  "bocce", "bocci", "boche", "bocks", "boded", "bodes", "bodge", "bodhi",
  "bodle", "boeps", "boets", "boeuf", "boffo", "boffs", "bogan", "bogey",
  "boggy", "bogie", "bogle", "bogue", "bogus", "bohea", "bohos", "boils",
  "boing", "boink", "boite", "boked", "bokeh", "bokes", "bokos", "bolar",
  "bolas", "bolds", "boles", "bolix", "bolls", "bolos", "bolts", "bolus",
  "bomas", "bombe", "bombo", "bombs", "bonce", "bonds", "boned", "boner",
  "bones", "boney", "bongo", "bongs", "bonie", "bonks", "bonne", "bonny",
  "bonus", "bonza", "bonze", "booai", "booay", "boobs", "booby", "boody",
  "booed", "boofy", "boogy", "boohs", "books", "booky", "bools", "booms",
  "boomy", "boong", "boons", "boord", "boors", "boose", "boost", "booth",
  "boots", "booty", "booze", "boozy", "boppy", "borak", "boral", "boras",
  "borax", "borde", "bords", "bored", "boree", "borel", "borer", "bores",
  "borgo", "boric", "borks", "borms", "borna", "borne", "boron", "borts",
  "borty", "bortz", "bosie", "bosks", "bosky", "bosom", "boson", "bossy",
  "bosun", "botas", "botch", "botel", "botes", "bothy", "botte", "botts",
  "botty", "bouge", "bough", "bouks", "boule", "boult", "bound", "bouns",
  "bourd", "bourg", "bourn", "bouse", "bousy", "bouts", "bovid", "bowat",
  "bowed", "bowel", "bower", "bowes", "bowet", "bowie", "bowls", "bowne",
  "bowrs", "bowse", "boxed", "boxen", "boxer", "boxes", "boxla", "boxty",
  "boyar", "boyau", "boyed", "boyfs", "boygs", "boyla", "boyos", "boysy",
  "bozos", "braai", "brace", "brach", "brack", "bract", "brads", "braes",
  "brags", "braid", "brail", "brain", "brake", "braks", "braky", "brame",
  "brand", "brane", "brank", "brans", "brant", "brash", "brass", "brast",
  "brats", "brava", "brave", "bravi", "bravo", "brawl", "brawn", "braws",
  "braxy", "brays", "braza", "braze", "bread", "break", "bream", "brede",
  "breds", "breed", "breem", "breer", "brees", "breid", "breis", "breme",
  "brens", "brent", "brere", "brers", "breve", "brews", "breys", "briar",
  "bribe", "brick", "bride", "brief", "brier", "bries", "brigs", "briki",
  "briks", "brill", "brims", "brine", "bring", "brink", "brins", "briny",
  "brios", "brise", "brisk", "briss", "brith", "brits", "britt", "brize",
  "broad", "broch", "brock", "brods", "brogh", "brogs", "broil", "broke",
  "brome", "bromo", "bronc", "brond", "brood", "brook", "brool", "broom",
  "broos", "brose", "brosy", "broth", "brown", "brows", "brugh", "bruin",
  "bruit", "brule", "brume", "brung", "brunt", "brush", "brusk", "brust",
  "brute", "bruts", "buats", "buaze", "bubal", "bubas", "bubba", "bubbe",
  "bubby", "bubus", "buchu", "bucko", "bucks", "bucku", "budas", "buddy",
  "budge", "budis", "budos", "buffa", "buffe", "buffi", "buffo", "buffs",
  "buffy", "bufos", "bufty", "buggy", "bugle", "buhls", "buhrs", "buiks",
  "build", "built", "buist", "bukes", "bulbs", "bulge", "bulgy", "bulks",
  "bulky", "bulla", "bulls", "bully", "bulse", "bumbo", "bumfs", "bumph",
  "bumps", "bumpy", "bunas", "bunce", "bunch", "bunco", "bunde", "bundh",
  "bunds", "bundt", "bundu", "bundy", "bungs", "bungy", "bunia", "bunje",
  "bunjy", "bunko", "bunks", "bunns", "bunny", "bunts", "bunty", "bunya",
  "buoys", "buppy", "buran", "buras", "burbs", "burds", "buret", "burfi",
  "burgh", "burgs", "burin", "burka", "burke", "burks", "burls", "burly",
  "burns", "burnt", "buroo", "burps", "burqa", "burro", "burrs", "burry",
  "bursa", "burse", "burst", "busby", "bused", "buses", "bushy", "busks",
  "busky", "bussu", "busti", "busts", "busty", "butch", "buteo", "butes",
  "butle", "butoh", "butte", "butts", "butty", "butut", "butyl", "buxom",
  "buyer", "buzzy", "bwana", "bwazi", "byded", "bydes", "byked", "bykes",
  "bylaw", "byres", "byrls", "byssi", "bytes", "byway", "caaed", "cabal",
  "cabas", "cabby", "caber", "cabin", "cable", "cabob", "caboc", "cabre",
  "cacao", "cacas", "cache", "cacks", "cacky", "cacti", "caddy", "cadee",
  "cades", "cadet", "cadge", "cadgy", "cadie", "cadis", "cadre", "caeca",
  "caese", "cafes", "caffs", "caged", "cager", "cages", "cagey", "cagot",
  "cahow", "caids", "cains", "caird", "cairn", "cajon", "cajun", "caked",
  "cakes", "cakey", "calfs", "calid", "calif", "calix", "calks", "calla",
  "calls", "calms", "calmy", "calos", "calpa", "calps", "calve", "calyx",
  "caman", "camas", "camel", "cameo", "cames", "camis", "camos", "campi",
  "campo", "camps", "campy", "camus", "canal", "candy", "caned", "caneh",
  "caner", "canes", "cangs", "canid", "canna", "canns", "canny", "canoe",
  "canon", "canso", "canst", "canto", "cants", "canty", "capas", "caped",
  "caper", "capes", "capex", "caphs", "capiz", "caple", "capon", "capos",
  "capot", "capri", "capul", "caput", "carap", "carat", "carbo", "carbs",
  "carby", "cardi", "cards", "cardy", "cared", "carer", "cares", "caret",
  "carex", "cargo", "carks", "carle", "carls", "carns", "carny", "carob",
  "carol", "carom", "caron", "carpi", "carps", "carrs", "carry", "carse",
  "carta", "carte", "carts", "carve", "carvy", "casas", "casco", "cased",
  "cases", "casks", "casky", "caste", "casts", "casus", "catch", "cater",
  "cates", "catty", "cauda", "cauks", "cauld", "caulk", "cauls", "caums",
  "caups", "cauri", "causa", "cause", "cavas", "caved", "cavel", "caver",
  "caves", "cavie", "cavil", "cawed", "cawks", "caxon", "cease", "ceaze",
  "cebid", "cecal", "cecum", "cedar", "ceded", "ceder", "cedes", "cedis",
  "ceiba", "ceili", "ceils", "celeb", "cella", "celli", "cello", "cells",
  "celom", "celts", "cense", "cento", "cents", "centu", "ceorl", "cepes",
  "cerci", "cered", "ceres", "cerge", "ceria", "ceric", "cerne", "ceroc",
  "ceros", "certs", "certy", "cesse", "cesta", "cesti", "cetes", "cetyl",
  "cezve", "chace", "chack", "chaco", "chado", "chads", "chafe", "chaff",
  "chaft", "chain", "chair", "chais", "chalk", "chals", "champ", "chams",
  "chana", "chang", "chank", "chant", "chaos", "chape", "chaps", "chapt",
  "chara", "chard", "chare", "chark", "charm", "charr", "chars", "chart",
  "chary", "chase", "chasm", "chats", "chave", "chavs", "chawk", "chaws",
  "chaya", "chays", "cheap", "cheat", "check", "cheek", "cheep", "cheer",
  "chefs", "cheka", "chela", "chelp", "chemo", "chems", "chere", "chert",
  "chess", "chest", "cheth", "chevy", "chews", "chewy", "chiao", "chias",
  "chibs", "chica", "chich", "chick", "chico", "chics", "chide", "chief",
  "chiel", "chiks", "child", "chile", "chili", "chill", "chimb", "chime",
  "chimo", "chimp", "china", "chine", "ching", "chink", "chino", "chins",
  "chips", "chirk", "chirl", "chirm", "chiro", "chirp", "chirr", "chirt",
  "chiru", "chits", "chive", "chivs", "chivy", "chizz", "chock", "choco",
  "chocs", "chode", "chogs", "choil", "choir", "choke", "choko", "choky",
  "chola", "choli", "cholo", "chomp", "chons", "choof", "chook", "choom",
  "choon", "chops", "chord", "chore", "chose", "chota", "chott", "chout",
  "choux", "chowk", "chows", "chubs", "chuck", "chufa", "chuff", "chugs",
  "chump", "chums", "chunk", "churl", "churn", "churr", "chuse", "chute",
  "chuts", "chyle", "chyme", "chynd", "cibol", "cided", "cider", "cides",
  "ciels", "cigar", "ciggy", "cilia", "cills", "cimar", "cimex", "cinch",
  "cinct", "cines", "cinqs", "cions", "cippi", "circa", "circs", "cires",
  "cirls", "cirri", "cisco", "cissy", "cists", "cital", "cited", "citer",
  "cites", "cives", "civet", "civic", "civie", "civil", "civvy", "clach",
  "clack", "clade", "clads", "claes", "clags", "claim", "clame", "clamp",
  "clams", "clang", "clank", "clans", "claps", "clapt", "claro", "clart",
  "clary", "clash", "clasp", "class", "clast", "clats", "claut", "clave",
  "clavi", "claws", "clays", "clean", "clear", "cleat", "cleck", "cleek",
  "cleep", "clefs", "cleft", "clegs", "cleik", "clems", "clepe", "clept",
  "clerk", "cleve", "clews", "click", "clied", "clies", "cliff", "clift",
  "climb", "clime", "cline", "cling", "clink", "clint", "clipe", "clips",
  "clipt", "clits", "cloak", "cloam", "clock", "clods", "cloff", "clogs",
  "cloke", "clomb", "clomp", "clone", "clonk", "clons", "cloop", "cloot",
  "clops", "close", "clote", "cloth", "clots", "cloud", "clour", "clous",
  "clout", "clove", "clown", "clows", "cloye", "cloys", "cloze", "clubs",
  "cluck", "clued", "clues", "cluey", "clump", "clung", "clunk", "clype",
  "cnida", "coach", "coact", "coady", "coala", "coals", "coaly", "coapt",
  "coarb", "coast", "coate", "coati", "coats", "cobbs", "cobby", "cobia",
  "coble", "cobra", "cobza", "cocas", "cocci", "cocco", "cocks", "cocky",
  "cocoa", "cocos", "codas", "codec", "coded", "coden", "coder", "codes",
  "codex", "codon", "coeds", "coffs", "cogie", "cogon", "cogue", "cohab",
  "cohen", "cohoe", "cohog", "cohos", "coifs", "coign", "coils", "coins",
  "coirs", "coits", "coked", "cokes", "colas", "colby", "colds", "coled",
  "coles", "coley", "colic", "colin", "colls", "colly", "colog", "colon",
  "color", "colts", "colza", "comae", "comal", "comas", "combe", "combi",
  "combo", "combs", "comby", "comer", "comes", "comet", "comfy", "comic",
  "comix", "comma", "commo", "comms", "commy", "compo", "comps", "compt",
  "comte", "comus", "conch", "condo", "coned", "cones", "coney", "confs",
  "conga", "conge", "congo", "conia", "conic", "conin", "conks", "conky",
  "conne", "conns", "conte", "conto", "conus", "convo", "cooch", "cooed",
  "cooee", "cooer", "cooey", "coofs", "cooks", "cooky", "cools", "cooly",
  "coomb", "cooms", "coomy", "coons", "coops", "coopt", "coost", "coots",
  "cooze", "copal", "copay", "coped", "copen", "coper", "copes", "coppy",
  "copra", "copse", "copsy", "coqui", "coral", "coram", "corbe", "corby",
  "cords", "cored", "corer", "cores", "corey", "corgi", "coria", "corks",
  "corky", "corms", "corni", "corno", "corns", "cornu", "corny", "corps",
  "corse", "corso", "cosec", "cosed", "coses", "coset", "cosey", "cosie",
  "costa", "coste", "costs", "cotan", "coted", "cotes", "coths", "cotta",
  "cotts", "couch", "coude", "cough", "could", "count", "coupe", "coups",
  "courb", "courd", "coure", "cours", "court", "couta", "couth", "coved",
  "coven", "cover", "coves", "covet", "covey", "covin", "cowal", "cowan",
  "cowed", "cower", "cowks", "cowls", "cowps", "cowry", "coxae", "coxal",
  "coxed", "coxes", "coxib", "coyau", "coyed", "coyer", "coyly", "coypu",
  "cozed", "cozen", "cozes", "cozey", "cozie", "craal", "crabs", "crack",
  "craft", "crags", "craic", "craig", "crake", "crame", "cramp", "crams",
  "crane", "crank", "crans", "crape", "craps", "crapy", "crare", "crash",
  "crass", "crate", "crave", "crawl", "craws", "crays", "craze", "crazy",
  "creak", "cream", "credo", "creds", "creed", "creek", "creel", "creep",
  "crees", "creme", "crems", "crena", "crepe", "creps", "crept", "crepy",
  "cress", "crest", "crewe", "crews", "crias", "cribs", "crick", "cried",
  "crier", "cries", "crime", "crimp", "crims", "crine", "crios", "cripe",
  "crips", "crise", "crisp", "crith", "crits", "croak", "croci", "crock",
  "crocs", "croft", "crogs", "cromb", "crome", "crone", "cronk", "crons",
  "crony", "crook", "crool", "croon", "crops", "crore", "cross", "crost",
  "croup", "crout", "crowd", "crown", "crows", "croze", "cruck", "crude",
  "crudo", "cruds", "crudy", "cruel", "crues", "cruet", "cruft", "crumb",
  "crump", "crunk", "cruor", "crura", "cruse", "crush", "crust", "crusy",
  "cruve", "crwth", "cryer", "crypt", "ctene", "cubby", "cubeb", "cubed",
  "cuber", "cubes", "cubic", "cubit", "cuddy", "cuffo", "cuffs", "cuifs",
  "cuing", "cuish", "cuits", "cukes", "culch", "culet", "culex", "culls",
  "cully", "culms", "culpa", "culti", "cults", "culty", "cumec", "cumin",
  "cundy", "cunei", "cunit", "cunts", "cupel", "cupid", "cuppa", "cuppy",
  "curat", "curbs", "curch", "curds", "curdy", "cured", "curer", "cures",
  "curet", "curfs", "curia", "curie", "curio", "curli", "curls", "curly",
  "curns", "curny", "currs", "curry", "curse", "cursi", "curst", "curve",
  "curvy", "cusec", "cushy", "cusks", "cusps", "cuspy", "cusso", "cusum",
  "cutch", "cuter", "cutes", "cutey", "cutie", "cutin", "cutis", "cutto",
  "cutty", "cutup", "cuvee", "cuzes", "cwtch", "cyano", "cyans", "cyber",
  "cycad", "cycas", "cycle", "cyclo", "cyder", "cylix", "cymae", "cymar",
  "cymas", "cymes", "cymol", "cynic", "cysts", "cytes", "cyton", "czars",
  "daals", "dabba", "daces", "dacha", "dacks", "dadah", "dadas", "daddy",
  "dados", "daffs", "daffy", "dagga", "daggy", "dagos", "dahls", "daiko",
  "daily", "daine", "daint", "dairy", "daisy", "daker", "daled", "dales",
  "dalis", "dalle", "dally", "dalts", "daman", "damar", "dames", "damme",
  "damns", "damps", "dampy", "dance", "dancy", "dandy", "dangs", "danio",
  "danks", "danny", "dants", "daraf", "darbs", "darcy", "dared", "darer",
  "dares", "darga", "dargs", "daric", "daris", "darks", "darky", "darns",
  "darre", "darts", "darzi", "dashi", "dashy", "datal", "dated", "dater",
  "dates", "datos", "datto", "datum", "daube", "daubs", "dauby", "dauds",
  "dault", "daunt", "daurs", "dauts", "daven", "davit", "dawah", "dawds",
  "dawed", "dawen", "dawks", "dawns", "dawts", "dayan", "daych", "daynt",
  "dazed", "dazer", "dazes", "deads", "deair", "deals", "dealt", "deans",
  "deare", "dearn", "dears", "deary", "deash", "death", "deave", "deaws",
  "deawy", "debag", "debar", "debby", "debel", "debes", "debit", "debts",
  "debud", "debug", "debur", "debus", "debut", "debye", "decad", "decaf",
  "decal", "decan", "decay", "decko", "decks", "decor", "decos", "decoy",
  "decry", "dedal", "deeds", "deedy", "deely", "deems", "deens", "deeps",
  "deere", "deers", "deets", "deeve", "deevs", "defat", "defer", "deffo",
  "defis", "defog", "degas", "degum", "degus", "deice", "deids", "deify",
  "deign", "deils", "deism", "deist", "deity", "deked", "dekes", "dekko",
  "delay", "deled", "deles", "delfs", "delft", "delis", "dells", "delly",
  "delos", "delph", "delta", "delts", "delve", "deman", "demes", "demic",
  "demit", "demob", "demoi", "demon", "demos", "dempt", "demur", "denar",
  "denay", "dench", "denes", "denet", "denim", "denis", "dense", "dents",
  "deoxy", "depot", "depth", "derat", "deray", "derby", "dered", "deres",
  "derig", "derma", "derms", "derns", "derny", "deros", "derro", "derry",
  "derth", "dervs", "desex", "deshi", "desis", "desks", "desse", "deter",
  "detox", "deuce", "devas", "devel", "devil", "devis", "devon", "devos",
  "devot", "dewan", "dewar", "dewax", "dewed", "dexes", "dexie", "dhaba",
  "dhaks", "dhals", "dhikr", "dhobi", "dhole", "dholl", "dhols", "dhoti",
  "dhows", "dhuti", "diact", "dials", "diane", "diary", "diazo", "dibbs",
  "diced", "dicer", "dices", "dicey", "dicht", "dicks", "dicky", "dicot",
  "dicta", "dicts", "dicty", "diddy", "didie", "didos", "didst", "diebs",
  "diels", "diene", "diets", "diffs", "dight", "digit", "dikas", "diked",
  "diker", "dikes", "dikey", "dildo", "dilli", "dills", "dilly", "dimbo",
  "dimer", "dimes", "dimly", "dimps", "dinar", "dined", "diner", "dines",
  "dinge", "dingo", "dings", "dingy", "dinic", "dinks", "dinky", "dinna",
  "dinos", "dints", "diode", "diols", "diota", "dippy", "dipso", "diram",
  "direr", "dirge", "dirke", "dirks", "dirls", "dirts", "dirty", "disas",
  "disci", "disco", "discs", "dishy", "disks", "disme", "dital", "ditas",
  "ditch", "dited", "dites", "ditsy", "ditto", "ditts", "ditty", "ditzy",
  "divan", "divas", "dived", "diver", "dives", "divis", "divna", "divos",
  "divot", "divvy", "diwan", "dixie", "dixit", "diyas", "dizen", "dizzy",
  "djinn", "djins", "doabs", "doats", "dobby", "dobes", "dobie", "dobla",
  "dobra", "dobro", "docht", "docks", "docos", "docus", "doddy", "dodge",
  "dodgy", "dodos", "doeks", "doers", "doest", "doeth", "doffs", "dogan",
  "doges", "dogey", "doggo", "doggy", "dogie", "dogma", "dohyo", "doilt",
  "doily", "doing", "doits", "dojos", "dolce", "dolci", "doled", "doles",
  "dolia", "dolls", "dolly", "dolma", "dolor", "dolos", "dolts", "domal",
  "domed", "domes", "domic", "donah", "donas", "donee", "doner", "donga",
  "dongs", "donko", "donna", "donne", "donny", "donor", "donsy", "donut",
  "doobs", "dooce", "doody", "dooks", "doole", "dools", "dooly", "dooms",
  "doomy", "doona", "doorn", "doors", "doozy", "dopas", "doped", "doper",
  "dopes", "dopey", "dorad", "dorba", "dorbs", "doree", "dores", "doric",
  "doris", "dorks", "dorky", "dorms", "dormy", "dorps", "dorrs", "dorsa",
  "dorse", "dorts", "dorty", "dosai", "dosas", "dosed", "doseh", "doser",
  "doses", "dosha", "dotal", "doted", "doter", "dotes", "dotty", "douar",
  "doubt", "douce", "doucs", "dough", "douks", "doula", "douma", "doums",
  "doups", "doura", "douse", "douts", "doved", "doven", "dover", "doves",
  "dovie", "dowar", "dowds", "dowdy", "dowed", "dowel", "dower", "dowie",
  "dowle", "dowls", "dowly", "downa", "downs", "downy", "dowps", "dowry",
  "dowse", "dowts", "doxed", "doxes", "doxie", "doyen", "doyly", "dozed",
  "dozen", "dozer", "dozes", "drabs", "drack", "draco", "draff", "draft",
  "drags", "drail", "drain", "drake", "drama", "drams", "drank", "drant",
  "drape", "draps", "drats", "drave", "drawl", "drawn", "draws", "drays",
  "dread", "dream", "drear", "dreck", "dreed", "dreer", "drees", "dregs",
  "dreks", "drent", "drere", "dress", "drest", "dreys", "dribs", "drice",
  "dried", "drier", "dries", "drift", "drill", "drily", "drink", "drips",
  "dript", "drive", "droid", "droil", "droit", "droke", "drole", "droll",
  "drome", "drone", "drony", "droob", "droog", "drook", "drool", "droop",
  "drops", "dropt", "dross", "drouk", "drove", "drown", "drows", "drubs",
  "drugs", "druid", "drums", "drunk", "drupe", "druse", "drusy", "druxy",
  "dryad", "dryas", "dryer", "dryly", "dsobo", "dsomo", "duads", "duals",
  "duans", "duars", "dubbo", "ducal", "ducat", "duces", "duchy", "ducks",
  "ducky", "ducts", "duddy", "duded", "dudes", "duels", "duets", "duett",
  "duffs", "dufus", "duing", "duits", "dukas", "duked", "dukes", "dukka",
  "dulce", "dules", "dulia", "dulls", "dully", "dulse", "dumas", "dumbo",
  "dumbs", "dumka", "dumky", "dummy", "dumps", "dumpy", "dunam", "dunce",
  "dunch", "dunes", "dungs", "dungy", "dunks", "dunno", "dunny", "dunsh",
  "dunts", "duomi", "duomo", "duped", "duper", "dupes", "duple", "duply",
  "duppy", "dural", "duras", "dured", "dures", "durgy", "durns", "duroc",
  "duros", "duroy", "durra", "durrs", "durry", "durst", "durum", "durzi",
  "dusks", "dusky", "dusts", "dusty", "dutch", "duvet", "duxes", "dwaal",
  "dwale", "dwalm", "dwams", "dwang", "dwarf", "dwaum", "dweeb", "dwell",
  "dwelt", "dwile", "dwine", "dyads", "dyers", "dying", "dyked", "dykes",
  "dykey", "dykon", "dynel", "dynes", "dzhos", "eager", "eagle", "eagre",
  "ealed", "eales", "eaned", "eards", "eared", "earls", "early", "earns",
  "earnt", "earst", "earth", "eased", "easel", "easer", "eases", "easle",
  "easts", "eaten", "eater", "eathe", "eaved", "eaves", "ebbed", "ebbet",
  "ebons", "ebony", "ebook", "ecads", "eched", "eches", "echos", "eclat",
  "ecrus", "edema", "edged", "edger", "edges", "edict", "edify", "edile",
  "edits", "educe", "educt", "eejit", "eensy", "eerie", "eeven", "eevns",
  "effed", "egads", "egers", "egest", "eggar", "egged", "egger", "egmas",
  "egret", "ehing", "eider", "eidos", "eight", "eigne", "eiked", "eikon",
  "eilds", "eisel", "eject", "ejido", "eking", "ekkas", "elain", "eland",
  "elans", "elate", "elbow", "elchi", "elder", "eldin", "elect", "elegy",
  "elemi", "elfed", "elfin", "eliad", "elide", "elint", "elite", "elmen",
  "eloge", "elogy", "eloin", "elope", "elops", "elpee", "elsin", "elude",
  "elute", "elvan", "elven", "elver", "elves", "emacs", "email", "embar",
  "embay", "embed", "ember", "embog", "embow", "embox", "embus", "emcee",
  "emeer", "emend", "emerg", "emery", "emeus", "emics", "emirs", "emits",
  "emmas", "emmer", "emmet", "emmew", "emmys", "emoji", "emong", "emote",
  "emove", "empts", "empty", "emule", "emure", "emyde", "emyds", "enact",
  "enarm", "enate", "ended", "ender", "endew", "endow", "endue", "enema",
  "enemy", "enews", "enfix", "eniac", "enjoy", "enlit", "enmew", "ennog",
  "ennui", "enoki", "enols", "enorm", "enows", "enrol", "ensew", "ensky",
  "ensue", "enter", "entia", "entry", "enure", "enurn", "envoi", "envoy",
  "enzym", "eorls", "eosin", "epact", "epees", "ephah", "ephas", "ephod",
  "ephor", "epics", "epoch", "epode", "epopt", "epoxy", "epris", "equal",
  "eques", "equid", "equip", "erase", "erbia", "erect", "erevs", "ergon",
  "ergos", "ergot", "erhus", "erica", "erick", "erics", "ering", "erned",
  "ernes", "erode", "erose", "erred", "error", "erses", "eruct", "erugo",
  "erupt", "eruvs", "erven", "ervil", "escar", "escot", "esile", "eskar",
  "esker", "esnes", "essay", "esses", "ester", "estoc", "estop", "estro",
  "etage", "etape", "etats", "etens", "ethal", "ether", "ethic", "ethne",
  "ethos", "ethyl", "etics", "etnas", "ettin", "ettle", "etude", "etuis",
  "etwee", "etyma", "eughs", "euked", "eupad", "euros", "eusol", "evade",
  "evens", "event", "evert", "every", "evets", "evhoe", "evict", "evils",
  "evite", "evohe", "evoke", "ewers", "ewest", "ewhow", "ewked", "exact",
  "exalt", "exams", "excel", "exeat", "execs", "exeem", "exeme", "exert",
  "exfil", "exies", "exile", "exine", "exing", "exist", "exits", "exode",
  "exome", "exons", "expat", "expel", "expos", "extol", "extra", "exude",
  "exuls", "exult", "exurb", "eyass", "eyers", "eying", "eyots", "eyras",
  "eyres", "eyrie", "eyrir", "ezine", "fabby", "fable", "faced", "facer",
  "faces", "facet", "facia", "facta", "facts", "faddy", "faded", "fader",
  "fades", "fadge", "fados", "faena", "faery", "faffs", "faffy", "faggy",
  "fagin", "fagot", "faiks", "fails", "faine", "fains", "faint", "fairs",
  "fairy", "faith", "faked", "faker", "fakes", "fakey", "fakie", "fakir",
  "falaj", "falls", "false", "famed", "fames", "fanal", "fancy", "fands",
  "fanes", "fanga", "fango", "fangs", "fanks", "fanny", "fanon", "fanos",
  "fanum", "faqir", "farad", "farce", "farci", "farcy", "fards", "fared",
  "farer", "fares", "farle", "farls", "farms", "faros", "farro", "farse",
  "farts", "fasci", "fasti", "fasts", "fatal", "fated", "fates", "fatly",
  "fatso", "fatty", "fatwa", "faugh", "fauld", "fault", "fauna", "fauns",
  "faurd", "fauts", "fauve", "favas", "favel", "faver", "faves", "favor",
  "favus", "fawns", "fawny", "faxed", "faxes", "fayed", "fayer", "fayne",
  "fayre", "fazed", "fazes", "feals", "feare", "fears", "feart", "fease",
  "feast", "feats", "feaze", "fecal", "feces", "fecht", "fecit", "fecks",
  "fedex", "feebs", "feeds", "feels", "feens", "feers", "feese", "feeze",
  "fehme", "feign", "feint", "feist", "felch", "felid", "fella", "fells",
  "felly", "felon", "felts", "felty", "femal", "femes", "femme", "femmy",
  "femur", "fence", "fends", "fendy", "fenis", "fenks", "fenny", "fents",
  "feods", "feoff", "feral", "ferer", "feres", "feria", "ferly", "fermi",
  "ferms", "ferns", "ferny", "ferry", "fesse", "festa", "fests", "festy",
  "fetal", "fetas", "fetch", "feted", "fetes", "fetid", "fetor", "fetta",
  "fetts", "fetus", "fetwa", "feuar", "feuds", "feued", "fever", "fewer",
  "feyed", "feyer", "feyly", "fezes", "fezzy", "fiars", "fiats", "fiber",
  "fibre", "fibro", "fices", "fiche", "fichu", "ficin", "ficos", "ficus",
  "fides", "fidge", "fidos", "fiefs", "field", "fiend", "fient", "fiere",
  "fiers", "fiery", "fiest", "fifed", "fifer", "fifes", "fifis", "fifth",
  "fifty", "figgy", "fight", "figos", "fiked", "fikes", "filar", "filch",
  "filed", "filer", "files", "filet", "filii", "filks", "fille", "fillo",
  "fills", "filly", "filmi", "films", "filmy", "filos", "filth", "filum",
  "final", "finca", "finch", "finds", "fined", "finer", "fines", "finis",
  "finks", "finny", "finos", "fiord", "fiqhs", "fique", "fired", "firer",
  "fires", "firie", "firks", "firms", "firns", "firry", "first", "firth",
  "fiscs", "fishy", "fisks", "fists", "fisty", "fitch", "fitly", "fitna",
  "fitte", "fitts", "fiver", "fives", "fixed", "fixer", "fixes", "fixit",
  "fizzy", "fjeld", "fjord", "flabs", "flack", "flaff", "flags", "flail",
  "flair", "flake", "flaks", "flaky", "flame", "flamm", "flams", "flamy",
  "flane", "flank", "flans", "flaps", "flare", "flary", "flash", "flask",
  "flats", "flava", "flawn", "flaws", "flawy", "flaxy", "flays", "fleam",
  "fleas", "fleck", "fleek", "fleer", "flees", "fleet", "flegs", "fleme",
  "flesh", "fleur", "flews", "flexi", "flexo", "fleys", "flick", "flics",
  "flied", "flier", "flies", "flimp", "flims", "fling", "flint", "flips",
  "flirs", "flirt", "flisk", "flite", "flits", "flitt", "float", "flobs",
  "flock", "flocs", "floes", "flogs", "flong", "flood", "floor", "flops",
  "flora", "flors", "flory", "flosh", "floss", "flota", "flote", "flour",
  "flout", "flown", "flows", "flubs", "flued", "flues", "fluey", "fluff",
  "fluid", "fluke", "fluky", "flume", "flump", "flung", "flunk", "fluor",
  "flurr", "flush", "flute", "fluty", "fluyt", "flyby", "flyer", "flype",
  "flyte", "foals", "foams", "foamy", "focal", "focus", "foehn", "fogey",
  "foggy", "fogie", "fogle", "fogou", "fohns", "foids", "foils", "foins",
  "foist", "folds", "foley", "folia", "folic", "folie", "folio", "folks",
  "folky", "folly", "fomes", "fonda", "fonds", "fondu", "fones", "fonly",
  "fonts", "foods", "foody", "fools", "foots", "footy", "foram", "foray",
  "forbs", "forby", "force", "fordo", "fords", "forel", "fores", "forex",
  "forge", "forgo", "forks", "forky", "forme", "forms", "forte", "forth",
  "forts", "forty", "forum", "forza", "forze", "fossa", "fosse", "fouat",
  "fouds", "fouer", "fouet", "foule", "fouls", "found", "fount", "fours",
  "fouth", "fovea", "fowls", "fowth", "foxed", "foxes", "foxie", "foyer",
  "foyle", "foyne", "frabs", "frack", "fract", "frags", "frail", "fraim",
  "frame", "franc", "frank", "frape", "fraps", "frass", "frate", "frati",
  "frats", "fraud", "fraus", "frays", "freak", "freed", "freer", "frees",
  "freet", "freit", "fremd", "frena", "freon", "frere", "fresh", "frets",
  "friar", "fribs", "fried", "frier", "fries", "frigs", "frill", "frise",
  "frisk", "frist", "frith", "frits", "fritt", "fritz", "frize", "frizz",
  "frock", "froes", "frogs", "frond", "frons", "front", "frore", "frorn",
  "frory", "frosh", "frost", "froth", "frown", "frows", "frowy", "froze",
  "frugs", "fruit", "frump", "frush", "frust", "fryer", "fubar", "fubby",
  "fubsy", "fucks", "fucus", "fuddy", "fudge", "fudgy", "fuels", "fuero",
  "fuffs", "fuffy", "fugal", "fuggy", "fugie", "fugio", "fugle", "fugly",
  "fugue", "fugus", "fujis", "fulls", "fully", "fumed", "fumer", "fumes",
  "fumet", "fundi", "funds", "fundy", "fungi", "fungo", "fungs", "funks",
  "funky", "funny", "fural", "furan", "furca", "furls", "furol", "furor",
  "furrs", "furry", "furth", "furze", "furzy", "fused", "fusee", "fusel",
  "fuses", "fusil", "fusks", "fussy", "fusts", "fusty", "futon", "fuzed",
  "fuzee", "fuzes", "fuzil", "fuzzy", "fyces", "fyked", "fykes", "fyles",
  "fyrds", "fytte", "gabba", "gabby", "gable", "gaddi", "gades", "gadge",
  "gadid", "gadis", "gadje", "gadjo", "gadso", "gaffe", "gaffs", "gaged",
  "gager", "gages", "gaids", "gaily", "gains", "gairs", "gaita", "gaits",
  "gaitt", "gajos", "galah", "galas", "galax", "galea", "galed", "gales",
  "galls", "gally", "galop", "galut", "galvo", "gamas", "gamay", "gamba",
  "gambe", "gambo", "gambs", "gamed", "gamer", "games", "gamey", "gamic",
  "gamin", "gamma", "gamme", "gammy", "gamps", "gamut", "ganch", "gandy",
  "ganef", "ganev", "gangs", "ganja", "ganof", "gants", "gaols", "gaped",
  "gaper", "gapes", "gapos", "gappy", "garbe", "garbo", "garbs", "garda",
  "gares", "garis", "garms", "garni", "garre", "garth", "garum", "gases",
  "gasps", "gaspy", "gassy", "gasts", "gatch", "gated", "gater", "gates",
  "gaths", "gator", "gauch", "gaucy", "gauds", "gaudy", "gauge", "gauje",
  "gault", "gaums", "gaumy", "gaunt", "gaups", "gaurs", "gauss", "gauze",
  "gauzy", "gavel", "gavot", "gawcy", "gawds", "gawks", "gawky", "gawps",
  "gawsy", "gayal", "gayer", "gayly", "gazal", "gazar", "gazed", "gazer",
  "gazes", "gazon", "gazoo", "geals", "geans", "geare", "gears", "geats",
  "gebur", "gecko", "gecks", "geeks", "geeky", "geeps", "geese", "geest",
  "geist", "geits", "gelds", "gelee", "gelid", "gelly", "gelts", "gemel",
  "gemma", "gemmy", "gemot", "genal", "genas", "genes", "genet", "genic",
  "genie", "genii", "genip", "genny", "genoa", "genom", "genre", "genro",
  "gents", "genty", "genua", "genus", "geode", "geoid", "gerah", "gerbe",
  "geres", "gerle", "germs", "germy", "gerne", "gesse", "gesso", "geste",
  "gests", "getas", "getup", "geums", "geyan", "geyer", "ghast", "ghats",
  "ghaut", "ghazi", "ghees", "ghest", "ghost", "ghoul", "ghyll", "giant",
  "gibed", "gibel", "giber", "gibes", "gibli", "gibus", "giddy", "gifts",
  "gigas", "gighe", "gigot", "gigue", "gilas", "gilds", "gilet", "gills",
  "gilly", "gilpy", "gilts", "gimel", "gimme", "gimps", "gimpy", "ginch",
  "ginge", "gings", "ginks", "ginny", "ginzo", "gipon", "gippo", "gippy",
  "gipsy", "girds", "girls", "girly", "girns", "giron", "giros", "girrs",
  "girsh", "girth", "girts", "gismo", "gisms", "gists", "gitch", "gites",
  "giust", "gived", "given", "giver", "gives", "gizmo", "glace", "glade",
  "glads", "glady", "glaik", "glair", "glams", "gland", "glans", "glare",
  "glary", "glass", "glaum", "glaur", "glaze", "glazy", "gleam", "glean",
  "gleba", "glebe", "gleby", "glede", "gleds", "gleed", "gleek", "glees",
  "gleet", "gleis", "glens", "glent", "gleys", "glial", "glias", "glibs",
  "glide", "gliff", "glift", "glike", "glime", "glims", "glint", "glisk",
  "glits", "glitz", "gloam", "gloat", "globe", "globi", "globs", "globy",
  "glode", "glogg", "gloms", "gloom", "gloop", "glops", "glory", "gloss",
  "glost", "glout", "glove", "glows", "gloze", "glued", "gluer", "glues",
  "gluey", "glugs", "glume", "glums", "gluon", "glute", "gluts", "glyph",
  "gnarl", "gnarr", "gnars", "gnash", "gnats", "gnawn", "gnaws", "gnome",
  "gnows", "goads", "goafs", "goals", "goary", "goats", "goaty", "goban",
  "gobar", "gobbi", "gobbo", "gobby", "gobis", "gobos", "godet", "godly",
  "godso", "goels", "goers", "goest", "goeth", "goety", "gofer", "goffs",
  "gogga", "gogos", "goier", "going", "gojis", "golds", "goldy", "golem",
  "goles", "golfs", "golly", "golpe", "golps", "gombo", "gomer", "gompa",
  "gonad", "gonch", "gonef", "goner", "gongs", "gonia", "gonif", "gonks",
  "gonna", "gonof", "gonys", "gonzo", "gooby", "goods", "goody", "gooey",
  "goofs", "goofy", "googs", "gooks", "gooky", "goold", "gools", "gooly",
  "goons", "goony", "goops", "goopy", "goors", "goory", "goose", "goosy",
  "gopak", "gopik", "goral", "goras", "gored", "gores", "gorge", "goris",
  "gorms", "gormy", "gorps", "gorse", "gorsy", "gosht", "gosse", "gotch",
  "goths", "gothy", "gotta", "gouch", "gouge", "gouks", "goura", "gourd",
  "gouts", "gouty", "gowan", "gowds", "gowfs", "gowks", "gowls", "gowns",
  "goxes", "goyim", "goyle", "graal", "grabs", "grace", "grade", "grads",
  "graff", "graft", "grail", "grain", "graip", "grama", "grame", "gramp",
  "grams", "grana", "grand", "grans", "grant", "grape", "graph", "grapy",
  "grasp", "grass", "grate", "grave", "gravs", "gravy", "grays", "graze",
  "great", "grebe", "grebo", "grece", "greed", "greek", "green", "grees",
  "greet", "grege", "grego", "grein", "grens", "grese", "greve", "grews",
  "greys", "grice", "gride", "grids", "grief", "griff", "grift", "grigs",
  "grike", "grill", "grime", "grimy", "grind", "grins", "griot", "gripe",
  "grips", "gript", "gripy", "grise", "grist", "grisy", "grith", "grits",
  "grize", "groan", "groat", "grody", "grogs", "groin", "groks", "groma",
  "grone", "groof", "groom", "grope", "gross", "grosz", "grots", "grouf",
  "group", "grout", "grove", "grovy", "growl", "grown", "grows", "grrls",
  "grrrl", "grubs", "grued", "gruel", "grues", "grufe", "gruff", "grume",
  "grump", "grund", "grunt", "gryce", "gryde", "gryke", "grype", "grypt",
  "guaco", "guana", "guano", "guans", "guard", "guars", "guava", "gucks",
  "gucky", "gudes", "guess", "guest", "guffs", "gugas", "guide", "guids",
  "guild", "guile", "guilt", "guimp", "guiro", "guise", "gulag", "gular",
  "gulas", "gulch", "gules", "gulet", "gulfs", "gulfy", "gulls", "gully",
  "gulph", "gulps", "gulpy", "gumbo", "gumma", "gummi", "gummy", "gumps",
  "gundy", "gunge", "gungy", "gunks", "gunky", "gunny", "guppy", "guqin",
  "gurdy", "gurge", "gurls", "gurly", "gurns", "gurry", "gursh", "gurus",
  "gushy", "gusla", "gusle", "gusli", "gussy", "gusto", "gusts", "gusty",
  "gutsy", "gutta", "gutty", "guyed", "guyle", "guyot", "guyse", "gwine",
  "gyals", "gyans", "gybed", "gybes", "gyeld", "gymps", "gynae", "gynie",
  "gynny", "gynos", "gyoza", "gypos", "gyppo", "gyppy", "gypsy", "gyral",
  "gyred", "gyres", "gyron", "gyros", "gyrus", "gytes", "gyved", "gyves",
  "haafs", "haars", "habit", "hable", "habus", "hacek", "hacks", "hadal",
  "haded", "hades", "hadji", "hadst", "haems", "haets", "haffs", "hafiz",
  "hafts", "haggs", "hahas", "haick", "haika", "haiks", "haiku", "hails",
  "haily", "hains", "haint", "hairs", "hairy", "haith", "hajes", "hajis",
  "hajji", "hakam", "hakas", "hakea", "hakes", "hakim", "hakus", "halal",
  "haled", "haler", "hales", "halfa", "halfs", "halid", "hallo", "halls",
  "halma", "halms", "halon", "halos", "halse", "halts", "halva", "halve",
  "halwa", "hamal", "hamba", "hamed", "hames", "hammy", "hamza", "hanap",
  "hance", "hanch", "hands", "handy", "hangi", "hangs", "hanks", "hanky",
  "hansa", "hanse", "hants", "haole", "haoma", "hapax", "haply", "happi",
  "happy", "hapus", "haram", "hards", "hardy", "hared", "harem", "hares",
  "harim", "harks", "harls", "harms", "harns", "haros", "harps", "harpy",
  "harry", "harsh", "harts", "hashy", "hasks", "hasps", "hasta", "haste",
  "hasty", "hatch", "hated", "hater", "hates", "hatha", "hauds", "haufs",
  "haugh", "hauld", "haulm", "hauls", "hault", "hauns", "haunt", "hause",
  "haute", "haven", "haver", "haves", "havoc", "hawed", "hawks", "hawms",
  "hawse", "hayed", "hayer", "hayey", "hayle", "hazan", "hazed", "hazel",
  "hazer", "hazes", "heads", "heady", "heald", "heals", "heame", "heaps",
  "heapy", "heard", "heare", "hears", "heart", "heast", "heath", "heats",
  "heave", "heavy", "heben", "hebes", "hecht", "hecks", "heder", "hedge",
  "hedgy", "heeds", "heedy", "heels", "heeze", "hefte", "hefts", "hefty",
  "heids", "heigh", "heils", "heirs", "heist", "hejab", "hejra", "heled",
  "heles", "helio", "helix", "hello", "hells", "helms", "helos", "helot",
  "helps", "helve", "hemal", "hemes", "hemic", "hemin", "hemps", "hempy",
  "hence", "hench", "hends", "henge", "henna", "henny", "henry", "hents",
  "hepar", "herbs", "herby", "herds", "heres", "herls", "herma", "herms",
  "herns", "heron", "heros", "herry", "herse", "hertz", "herye", "hesps",
  "hests", "hetes", "heths", "heuch", "heugh", "hevea", "hewed", "hewer",
  "hewgh", "hexad", "hexed", "hexer", "hexes", "hexyl", "heyed", "hiant",
  "hicks", "hided", "hider", "hides", "hiems", "highs", "hight", "hijab",
  "hijra", "hiked", "hiker", "hikes", "hikoi", "hilar", "hilch", "hillo",
  "hills", "hilly", "hilts", "hilum", "hilus", "himbo", "hinau", "hinds",
  "hinge", "hings", "hinky", "hinny", "hints", "hiois", "hiply", "hippo",
  "hippy", "hired", "hiree", "hirer", "hires", "hissy", "hists", "hitch",
  "hithe", "hived", "hiver", "hives", "hizen", "hoaed", "hoagy", "hoard",
  "hoars", "hoary", "hoast", "hobby", "hobos", "hocks", "hocus", "hodad",
  "hodja", "hoers", "hogan", "hogen", "hoggs", "hoghs", "hohed", "hoick",
  "hoied", "hoiks", "hoing", "hoise", "hoist", "hokas", "hoked", "hokes",
  "hokey", "hokis", "hokku", "hokum", "holds", "holed", "holes", "holey",
  "holks", "holla", "hollo", "holly", "holme", "holms", "holon", "holos",
  "holts", "homas", "homed", "homer", "homes", "homey", "homie", "homme",
  "homos", "honan", "honda", "honds", "honed", "honer", "hones", "honey",
  "hongi", "hongs", "honks", "honky", "honor", "hooch", "hoods", "hoody",
  "hooey", "hoofs", "hooka", "hooks", "hooky", "hooly", "hoons", "hoops",
  "hoord", "hoors", "hoosh", "hoots", "hooty", "hoove", "hopak", "hoped",
  "hoper", "hopes", "hoppy", "horah", "horal", "horas", "horde", "horis",
  "horks", "horme", "horns", "horny", "horse", "horst", "horsy", "hosed",
  "hosel", "hosen", "hoser", "hoses", "hosey", "hosta", "hosts", "hotch",
  "hotel", "hoten", "hotly", "hotty", "houff", "houfs", "hough", "hound",
  "houri", "hours", "house", "houts", "hovea", "hoved", "hovel", "hoven",
  "hover", "hoves", "howbe", "howdy", "howes", "howff", "howfs", "howks",
  "howls", "howre", "howso", "hoxed", "hoxes", "hoyas", "hoyed", "hoyle",
  "hubby", "hucks", "hudna", "hudud", "huers", "huffs", "huffy", "huger",
  "huggy", "huhus", "huias", "hulas", "hules", "hulks", "hulky", "hullo",
  "hulls", "hully", "human", "humas", "humfs", "humic", "humid", "humor",
  "humph", "humps", "humpy", "humus", "hunch", "hunks", "hunky", "hunts",
  "hurds", "hurls", "hurly", "hurra", "hurry", "hurst", "hurts", "hushy",
  "husks", "husky", "husos", "hussy", "hutch", "hutia", "huzza", "huzzy",
  "hwyls", "hydra", "hydro", "hyena", "hyens", "hygge", "hying", "hykes",
  "hylas", "hyleg", "hyles", "hylic", "hymen", "hymns", "hynde", "hyoid",
  "hyped", "hyper", "hypes", "hypha", "hyphy", "hypos", "hyrax", "hyson",
  "hythe", "iambi", "iambs", "ibrik", "icers", "iched", "iches", "ichor",
  "icier", "icily", "icing", "icker", "ickle", "icons", "ictal", "ictic",
  "ictus", "idant", "ideal", "ideas", "idees", "ident", "idiom", "idiot",
  "idled", "idler", "idles", "idola", "idols", "idyll", "idyls", "iftar",
  "igapo", "igged", "igloo", "iglus", "ihram", "ikans", "ikats", "ikons",
  "ileac", "ileal", "ileum", "ileus", "iliac", "iliad", "ilial", "ilium",
  "iller", "illth", "image", "imago", "imams", "imari", "imaum", "imbar",
  "imbed", "imbue", "imide", "imido", "imids", "imine", "imino", "immew",
  "immit", "immix", "imped", "impel", "impis", "imply", "impot", "impro",
  "imshi", "imshy", "inane", "inapt", "inarm", "inbox", "inbye", "incel",
  "incle", "incog", "incur", "incus", "incut", "indew", "index", "india",
  "indie", "indol", "indow", "indri", "indue", "inept", "inerm", "inert",
  "infer", "infix", "infos", "infra", "ingan", "ingle", "ingot", "inion",
  "inked", "inker", "inkle", "inlay", "inlet", "inned", "inner", "innit",
  "inorb", "input", "inrun", "inset", "inspo", "intel", "inter", "intil",
  "intis", "intra", "intro", "inula", "inure", "inurn", "inust", "invar",
  "inwit", "iodic", "iodid", "iodin", "ionic", "iotas", "ippon", "irade",
  "irate", "irids", "iring", "irked", "iroko", "irone", "irons", "irony",
  "isbas", "ishes", "isled", "isles", "islet", "isnae", "issei", "issue",
  "istle", "itchy", "items", "ither", "ivied", "ivies", "ivory", "ixias",
  "ixnay", "ixora", "ixtle", "izard", "izars", "izzat", "jaaps", "jabot",
  "jacal", "jacks", "jacky", "jaded", "jades", "jafas", "jaffa", "jagas",
  "jager", "jaggs", "jaggy", "jagir", "jagra", "jails", "jaker", "jakes",
  "jakey", "jalap", "jalop", "jambe", "jambo", "jambs", "jambu", "james",
  "jammy", "jamon", "janes", "janns", "janny", "janty", "japan", "japed",
  "japer", "japes", "jarks", "jarls", "jarps", "jarta", "jarul", "jasey",
  "jaspe", "jasps", "jatos", "jauks", "jaunt", "jaups", "javas", "javel",
  "jawan", "jawed", "jaxie", "jazzy", "jeans", "jeats", "jebel", "jedis",
  "jeels", "jeely", "jeeps", "jeers", "jeeze", "jefes", "jeffs", "jehad",
  "jehus", "jelab", "jello", "jells", "jelly", "jembe", "jemmy", "jenny",
  "jeons", "jerid", "jerks", "jerky", "jerry", "jesse", "jests", "jesus",
  "jetes", "jeton", "jetty", "jeune", "jewed", "jewel", "jewie", "jhala",
  "jiaos", "jibba", "jibbs", "jibed", "jiber", "jibes", "jiffs", "jiffy",
  "jiggy", "jigot", "jihad", "jills", "jilts", "jimmy", "jimpy", "jingo",
  "jinks", "jinne", "jinni", "jinns", "jirds", "jirga", "jirre", "jisms",
  "jived", "jiver", "jives", "jivey", "jnana", "jobed", "jobes", "jocko",
  "jocks", "jocky", "jocos", "jodel", "joeys", "johns", "joins", "joint",
  "joist", "joked", "joker", "jokes", "jokey", "jokol", "joled", "joles",
  "jolls", "jolly", "jolts", "jolty", "jomon", "jomos", "jones", "jongs",
  "jonty", "jooks", "joram", "jorum", "jotas", "jotty", "jotun", "joual",
  "jougs", "jouks", "joule", "jours", "joust", "jowar", "jowed", "jowls",
  "jowly", "joyed", "jubas", "jubes", "jucos", "judas", "judge", "judgy",
  "judos", "jugal", "jugum", "juice", "juicy", "jujus", "juked", "jukes",
  "jukus", "julep", "jumar", "jumbo", "jumby", "jumps", "jumpy", "junco",
  "junks", "junky", "junta", "junto", "jupes", "jupon", "jural", "jurat",
  "jurel", "jures", "juror", "justs", "jutes", "jutty", "juves", "juvie",
  "kaama", "kabab", "kabar", "kabob", "kacha", "kacks", "kadai", "kades",
  "kadis", "kafir", "kagos", "kagus", "kahal", "kaiak", "kaids", "kaies",
  "kaifs", "kaika", "kaiks", "kails", "kaims", "kaing", "kains", "kakas",
  "kakis", "kalam", "kales", "kalif", "kalis", "kalpa", "kamas", "kames",
  "kamik", "kamis", "kamme", "kanae", "kanas", "kandy", "kaneh", "kanes",
  "kanga", "kangs", "kanji", "kants", "kanzu", "kaons", "kapas", "kaphs",
  "kapok", "kapow", "kappa", "kapus", "kaput", "karas", "karat", "karks",
  "karma", "karns", "karoo", "karos", "karri", "karst", "karsy", "karts",
  "karzy", "kasha", "kasme", "katal", "katas", "katis", "katti", "kaugh",
  "kauri", "kauru", "kaury", "kaval", "kavas", "kawas", "kawau", "kawed",
  "kayak", "kayle", "kayos", "kazis", "kazoo", "kbars", "kebab", "kebar",
  "kebob", "kecks", "kedge", "kedgy", "keech", "keefs", "keeks", "keels",
  "keema", "keeno", "keens", "keeps", "keets", "keeve", "kefir", "kehua",
  "keirs", "kelep", "kelim", "kells", "kelly", "kelps", "kelpy", "kelts",
  "kelty", "kembo", "kembs", "kemps", "kempt", "kempy", "kenaf", "kench",
  "kendo", "kenos", "kente", "kents", "kepis", "kerbs", "kerel", "kerfs",
  "kerky", "kerma", "kerne", "kerns", "keros", "kerry", "kerve", "kesar",
  "kests", "ketas", "ketch", "ketes", "ketol", "kevel", "kevil", "kexes",
  "keyed", "keyer", "khadi", "khafs", "khaki", "khans", "khaph", "khats",
  "khaya", "khazi", "kheda", "kheth", "khets", "khoja", "khors", "khoum",
  "khuds", "kiaat", "kiack", "kiang", "kibbe", "kibbi", "kibei", "kibes",
  "kibla", "kicks", "kicky", "kiddo", "kiddy", "kidel", "kidge", "kiefs",
  "kiers", "kieve", "kievs", "kight", "kikes", "kikoi", "kiley", "kilim",
  "kills", "kilns", "kilos", "kilps", "kilts", "kilty", "kimbo", "kinas",
  "kinda", "kinds", "kindy", "kines", "kings", "kinin", "kinks", "kinky",
  "kinos", "kiore", "kiosk", "kipes", "kippa", "kipps", "kirby", "kirks",
  "kirns", "kirri", "kisan", "kissy", "kists", "kited", "kiter", "kites",
  "kithe", "kiths", "kitty", "kitul", "kivas", "kiwis", "klang", "klaps",
  "klett", "klick", "klieg", "kliks", "klong", "kloof", "kluge", "klutz",
  "knack", "knags", "knaps", "knarl", "knars", "knaur", "knave", "knawe",
  "knead", "kneed", "kneel", "knees", "knell", "knelt", "knife", "knish",
  "knits", "knive", "knobs", "knock", "knoll", "knops", "knosp", "knots",
  "knout", "knowe", "known", "knows", "knubs", "knurl", "knurr", "knurs",
  "knuts", "koala", "koans", "koaps", "koban", "kobos", "koels", "koffs",
  "kofta", "kogal", "kohas", "kohen", "kohls", "koine", "kojis", "kokam",
  "kokas", "koker", "kokra", "kokum", "kolas", "kolos", "kombu", "konbu",
  "kondo", "konks", "kooks", "kooky", "koori", "kopek", "kophs", "kopje",
  "koppa", "korai", "koras", "korat", "kores", "korma", "koros", "korun",
  "korus", "koses", "kotch", "kotos", "kotow", "koura", "kraal", "krabs",
  "kraft", "krais", "krait", "krang", "krans", "kranz", "kraut", "krays",
  "kreep", "kreng", "krewe", "krill", "krona", "krone", "kroon", "krubi",
  "krunk", "ksars", "kubie", "kudos", "kudus", "kudzu", "kufis", "kugel",
  "kuias", "kukri", "kukus", "kulak", "kulan", "kulas", "kulfi", "kumis",
  "kumys", "kuris", "kurre", "kurta", "kurus", "kusso", "kutas", "kutch",
  "kutis", "kutus", "kuzus", "kvass", "kvell", "kwela", "kyack", "kyaks",
  "kyang", "kyars", "kyats", "kybos", "kydst", "kyles", "kylie", "kylin",
  "kylix", "kyloe", "kynde", "kynds", "kypes", "kyrie", "kytes", "kythe",
  "laari", "labda", "label", "labia", "labis", "labor", "labra", "laced",
  "lacer", "laces", "lacet", "lacey", "lacks", "laddy", "laded", "laden",
  "lader", "lades", "ladle", "laers", "laevo", "lagan", "lager", "lahal",
  "lahar", "laich", "laics", "laids", "laigh", "laika", "laiks", "laird",
  "lairs", "lairy", "laith", "laity", "laked", "laker", "lakes", "lakhs",
  "lakin", "laksa", "laldy", "lalls", "lamas", "lambs", "lamby", "lamed",
  "lamer", "lames", "lamia", "lammy", "lamps", "lanai", "lanas", "lance",
  "lanch", "lande", "lands", "lanes", "lanks", "lanky", "lants", "lapel",
  "lapin", "lapis", "lapje", "lapse", "larch", "lards", "lardy", "laree",
  "lares", "large", "largo", "laris", "larks", "larky", "larns", "larnt",
  "larum", "larva", "lased", "laser", "lases", "lassi", "lasso", "lassu",
  "lassy", "lasts", "latah", "latch", "lated", "laten", "later", "latex",
  "lathe", "lathi", "laths", "lathy", "latke", "latte", "latus", "lauan",
  "lauch", "lauds", "laufs", "laugh", "laund", "laura", "laval", "lavas",
  "laved", "laver", "laves", "lavra", "lavvy", "lawed", "lawer", "lawin",
  "lawks", "lawns", "lawny", "laxed", "laxer", "laxes", "laxly", "layed",
  "layer", "layin", "layup", "lazar", "lazed", "lazes", "lazos", "lazzi",
  "lazzo", "leach", "leads", "leady", "leafs", "leafy", "leaks", "leaky",
  "leams", "leans", "leant", "leany", "leaps", "leapt", "leare", "learn",
  "lears", "leary", "lease", "leash", "least", "leats", "leave", "leavy",
  "leaze", "leben", "leccy", "ledes", "ledge", "ledgy", "ledum", "leear",
  "leech", "leeks", "leeps", "leers", "leery", "leese", "leets", "leeze",
  "lefte", "lefts", "lefty", "legal", "leger", "leges", "legge", "leggo",
  "leggy", "legit", "lehrs", "lehua", "leirs", "leish", "leman", "lemed",
  "lemel", "lemes", "lemma", "lemme", "lemon", "lemur", "lends", "lenes",
  "lengs", "lenis", "lenos", "lense", "lenti", "lento", "leone", "leper",
  "lepid", "lepra", "lepta", "lered", "leres", "lerps", "lesbo", "leses",
  "lests", "letch", "lethe", "letup", "leuch", "leuco", "leuds", "leugh",
  "levas", "levee", "level", "lever", "leves", "levin", "levis", "lewis",
  "lexes", "lexis", "lezes", "lezza", "lezzy", "liana", "liane", "liang",
  "liard", "liars", "liart", "libel", "liber", "libra", "libri", "lichi",
  "licht", "licit", "licks", "lidar", "lidos", "liefs", "liege", "liens",
  "liers", "lieus", "lieve", "lifer", "lifes", "lifts", "ligan", "liger",
  "ligge", "light", "ligne", "liked", "liken", "liker", "likes", "likin",
  "lilac", "lills", "lilos", "lilts", "liman", "limas", "limax", "limba",
  "limbi", "limbo", "limbs", "limby", "limed", "limen", "limes", "limey",
  "limit", "limma", "limns", "limos", "limpa", "limps", "linac", "linch",
  "linds", "lindy", "lined", "linen", "liner", "lines", "liney", "linga",
  "lingo", "lings", "lingy", "linin", "links", "linky", "linns", "linny",
  "linos", "lints", "linty", "linum", "linux", "lions", "lipas", "lipes",
  "lipid", "lipin", "lipos", "lippy", "liras", "lirks", "lirot", "lisks",
  "lisle", "lisps", "lists", "litai", "litas", "lited", "liter", "lites",
  "lithe", "litho", "liths", "litre", "lived", "liven", "liver", "lives",
  "livid", "livor", "livre", "llama", "llano", "loach", "loads", "loafs",
  "loams", "loamy", "loans", "loast", "loath", "loave", "lobar", "lobby",
  "lobed", "lobes", "lobos", "lobus", "local", "loche", "lochs", "locie",
  "locis", "locks", "locos", "locum", "locus", "loden", "lodes", "lodge",
  "loess", "lofts", "lofty", "logan", "loges", "loggy", "logia", "logic",
  "logie", "login", "logoi", "logon", "logos", "lohan", "loids", "loins",
  "loipe", "loirs", "lokes", "lolls", "lolly", "lolog", "lomas", "lomed",
  "lomes", "loner", "longa", "longe", "longs", "looby", "looed", "looey",
  "loofa", "loofs", "looie", "looks", "looky", "looms", "loons", "loony",
  "loops", "loopy", "loord", "loose", "loots", "loped", "loper", "lopes",
  "loppy", "loral", "loran", "lords", "lordy", "lorel", "lores", "loric",
  "loris", "lorry", "losed", "losel", "losen", "loser", "loses", "lossy",
  "lotah", "lotas", "lotes", "lotic", "lotos", "lotsa", "lotta", "lotte",
  "lotto", "lotus", "loued", "lough", "louie", "louis", "louma", "lound",
  "louns", "loupe", "loups", "loure", "lours", "loury", "louse", "lousy",
  "louts", "lovat", "loved", "lover", "loves", "lovey", "lovie", "lowan",
  "lowed", "lower", "lowes", "lowly", "lownd", "lowne", "lowns", "lowps",
  "lowry", "lowse", "lowts", "loxed", "loxes", "loyal", "lozen", "luach",
  "luaus", "lubed", "lubes", "lubra", "luces", "lucid", "lucks", "lucky",
  "lucre", "ludes", "ludic", "ludos", "luffa", "luffs", "luged", "luger",
  "luges", "lulls", "lulus", "lumas", "lumbi", "lumen", "lumme", "lummy",
  "lumps", "lumpy", "lunar", "lunas", "lunch", "lunes", "lunet", "lunge",
  "lungi", "lungs", "lunks", "lunts", "lupin", "lupus", "lurch", "lured",
  "lurer", "lures", "lurex", "lurgi", "lurgy", "lurid", "lurks", "lurry",
  "lurve", "luser", "lushy", "lusks", "lusts", "lusty", "lusus", "lutea",
  "luted", "luter", "lutes", "luvvy", "luxed", "luxer", "luxes", "lweis",
  "lyams", "lyard", "lyart", "lyase", "lycea", "lycee", "lycra", "lying",
  "lymes", "lymph", "lynch", "lynes", "lyres", "lyric", "lysed", "lyses",
  "lysin", "lysis", "lysol", "lyssa", "lyted", "lytes", "lythe", "lytic",
  "lytta", "maaed", "maare", "maars", "mabes", "macas", "macaw", "maced",
  "macer", "maces", "mache", "machi", "macho", "machs", "macks", "macle",
  "macon", "macro", "madam", "madge", "madid", "madly", "madre", "maerl",
  "mafia", "mafic", "mages", "maggs", "magic", "magma", "magot", "magus",
  "mahoe", "mahua", "mahwa", "maids", "maiko", "maiks", "maile", "maill",
  "mails", "maims", "mains", "maire", "mairs", "maise", "maist", "maize",
  "major", "makar", "maker", "makes", "makis", "makos", "malam", "malar",
  "malas", "malax", "males", "malic", "malik", "malis", "malls", "malms",
  "malmy", "malts", "malty", "malus", "malva", "malwa", "mamas", "mamba",
  "mambo", "mamee", "mamey", "mamie", "mamma", "mammy", "manas", "manat",
  "mandi", "maneb", "maned", "maneh", "manes", "manet", "manga", "mange",
  "mango", "mangs", "mangy", "mania", "manic", "manis", "manky", "manly",
  "manna", "manor", "manos", "manse", "manta", "manto", "manty", "manul",
  "manus", "mapau", "maple", "maqui", "marae", "marah", "maras", "march",
  "marcs", "mardy", "mares", "marge", "margs", "maria", "marid", "marka",
  "marks", "marle", "marls", "marly", "marms", "maron", "maror", "marra",
  "marri", "marry", "marse", "marsh", "marts", "marvy", "masas", "mased",
  "maser", "mases", "mashy", "masks", "mason", "massa", "masse", "massy",
  "masts", "masty", "masus", "matai", "match", "mated", "mater", "mates",
  "matey", "maths", "matin", "matlo", "matte", "matts", "matza", "matzo",
  "mauby", "mauds", "mauls", "maund", "mauri", "mausy", "mauts", "mauve",
  "mauzy", "maven", "mavie", "mavin", "mavis", "mawed", "mawks", "mawky",
  "mawns", "mawrs", "maxed", "maxes", "maxim", "maxis", "mayan", "mayas",
  "maybe", "mayed", "mayor", "mayos", "mayst", "mazed", "mazer", "mazes",
  "mazey", "mazut", "mbira", "meads", "meals", "mealy", "meane", "means",
  "meant", "meany", "meare", "mease", "meath", "meats", "meaty", "mebos",
  "mecca", "mechs", "mecks", "medal", "media", "medic", "medii", "medle",
  "meeds", "meers", "meets", "meffs", "meins", "meint", "meiny", "meith",
  "mekka", "melas", "melba", "melds", "melee", "melic", "melik", "mells",
  "melon", "melts", "melty", "memes", "memos", "menad", "mends", "mened",
  "menes", "menge", "mengs", "mensa", "mense", "mensh", "menta", "mento",
  "menus", "meous", "meows", "merch", "mercs", "mercy", "merde", "mered",
  "merel", "merer", "meres", "merge", "meril", "meris", "merit", "merks",
  "merle", "merls", "merry", "merse", "mesal", "mesas", "mesel", "meses",
  "meshy", "mesic", "mesne", "meson", "messy", "mesto", "metal", "meted",
  "meter", "metes", "metho", "meths", "metic", "metif", "metis", "metol",
  "metre", "metro", "meuse", "meved", "meves", "mewed", "mewls", "meynt",
  "mezes", "mezze", "mezzo", "mhorr", "miaou", "miaow", "miasm", "miaul",
  "micas", "miche", "micht", "micks", "micky", "micos", "micra", "micro",
  "middy", "midge", "midgy", "midis", "midst", "miens", "mieve", "miffs",
  "miffy", "mifty", "miggs", "might", "mihas", "mihis", "miked", "mikes",
  "mikra", "mikva", "milch", "milds", "miler", "miles", "milfs", "milia",
  "milko", "milks", "milky", "mille", "mills", "milor", "milos", "milpa",
  "milts", "milty", "miltz", "mimed", "mimeo", "mimer", "mimes", "mimic",
  "mimsy", "minae", "minar", "minas", "mince", "mincy", "minds", "mined",
  "miner", "mines", "minge", "mings", "mingy", "minim", "minis", "minke",
  "minks", "minny", "minor", "minos", "mints", "minty", "minus", "mired",
  "mires", "mirex", "mirid", "mirin", "mirks", "mirky", "mirly", "miros",
  "mirth", "mirvs", "mirza", "misch", "misdo", "miser", "mises", "misgo",
  "misos", "missa", "missy", "mists", "misty", "mitch", "miter", "mites",
  "mitis", "mitre", "mitts", "mixed", "mixen", "mixer", "mixes", "mixte",
  "mixup", "mizen", "mizzy", "mneme", "moans", "moats", "mobby", "mobes",
  "mobey", "mobie", "moble", "mocha", "mochi", "mochs", "mochy", "mocks",
  "modal", "model", "modem", "moder", "modes", "modge", "modii", "modus",
  "moers", "mofos", "moggy", "mogul", "mohel", "mohos", "mohrs", "mohua",
  "mohur", "moile", "moils", "moira", "moire", "moist", "moits", "mojos",
  "mokes", "mokis", "mokos", "molal", "molar", "molas", "molds", "moldy",
  "moled", "moles", "molla", "molls", "molly", "molto", "molts", "molys",
  "momes", "momma", "mommy", "momus", "monad", "monal", "monas", "monde",
  "mondo", "moner", "money", "mongo", "mongs", "monic", "monie", "monks",
  "monos", "monte", "month", "monty", "moobs", "mooch", "moods", "moody",
  "mooed", "mooks", "moola", "mooli", "mools", "mooly", "moong", "moons",
  "moony", "moops", "moors", "moory", "moose", "moots", "moove", "moped",
  "moper", "mopes", "mopey", "moppy", "mopsy", "mopus", "morae", "moral",
  "moras", "morat", "moray", "morel", "mores", "moria", "morne", "morns",
  "moron", "morph", "morra", "morro", "morse", "morts", "mosed", "moses",
  "mosey", "mosks", "mosso", "mossy", "moste", "mosts", "moted", "motel",
  "moten", "motes", "motet", "motey", "moths", "mothy", "motif", "motis",
  "motor", "motte", "motto", "motts", "motty", "motus", "motza", "mouch",
  "moues", "mould", "mouls", "moult", "mound", "mount", "moups", "mourn",
  "mouse", "moust", "mousy", "mouth", "moved", "mover", "moves", "movie",
  "mowas", "mowed", "mower", "mowra", "moxas", "moxie", "moyas", "moyle",
  "moyls", "mozed", "mozes", "mozos", "mpret", "mucho", "mucic", "mucid",
  "mucin", "mucks", "mucky", "mucor", "mucro", "mucus", "muddy", "mudge",
  "mudir", "mudra", "muffs", "mufti", "mugga", "muggs", "muggy", "muhly",
  "muids", "muils", "muirs", "muist", "mujik", "mulch", "mulct", "muled",
  "mules", "muley", "mulga", "mulie", "mulla", "mulls", "mulse", "mulsh",
  "mumms", "mummy", "mumps", "mumsy", "mumus", "munch", "munga", "munge",
  "mungo", "mungs", "munis", "munts", "muntu", "muons", "mural", "muras",
  "mured", "mures", "murex", "murid", "murks", "murky", "murls", "murly",
  "murra", "murre", "murri", "murrs", "murry", "murti", "murva", "musar",
  "musca", "mused", "muser", "muses", "muset", "musha", "mushy", "music",
  "musit", "musks", "musky", "musos", "musse", "mussy", "musth", "musts",
  "musty", "mutch", "muted", "muter", "mutes", "mutha", "mutis", "muton",
  "mutts", "muxed", "muxes", "muzak", "muzzy", "mvule", "myall", "mylar",
  "mynah", "mynas", "myoid", "myoma", "myope", "myops", "myopy", "myrrh",
  "mysid", "mythi", "myths", "mythy", "myxos", "mzees", "naams", "naans",
  "nabes", "nabis", "nabks", "nabla", "nabob", "nache", "nacho", "nacre",
  "nadas", "nadir", "naeve", "naevi", "naffs", "nagas", "naggy", "nagor",
  "nahal", "naiad", "naifs", "naiks", "nails", "naira", "nairu", "naive",
  "naked", "naker", "nakfa", "nalas", "naled", "nalla", "named", "namer",
  "names", "namma", "namus", "nanas", "nance", "nancy", "nandu", "nanna",
  "nanny", "nanos", "nanua", "napas", "naped", "napes", "napoo", "nappa",
  "nappe", "nappy", "naras", "narco", "narcs", "nards", "nares", "naric",
  "naris", "narks", "narky", "narre", "nasal", "nashi", "nasty", "natal",
  "natch", "nates", "natis", "natty", "nauch", "naunt", "naval", "navar",
  "navel", "naves", "navew", "navvy", "nawab", "nazes", "nazir", "nazis",
  "nduja", "neafe", "neals", "neaps", "nears", "neath", "neats", "nebek",
  "nebel", "necks", "neddy", "needs", "needy", "neeld", "neele", "neemb",
  "neems", "neeps", "neese", "neeze", "negro", "negus", "neifs", "neigh",
  "neist", "neive", "nelis", "nelly", "nemas", "nemns", "nempt", "nenes",
  "neons", "neper", "nepit", "neral", "nerds", "nerdy", "nerka", "nerks",
  "nerol", "nerts", "nertz", "nerve", "nervy", "nests", "netes", "netop",
  "netts", "netty", "neuks", "neume", "neums", "nevel", "never", "neves",
  "nevus", "newbs", "newed", "newel", "newer", "newie", "newly", "newsy",
  "newts", "nexts", "nexus", "ngaio", "ngana", "ngati", "ngoma", "ngwee",
  "nicad", "nicer", "niche", "nicht", "nicks", "nicol", "nidal", "nided",
  "nides", "nidor", "nidus", "niece", "niefs", "nieve", "nifes", "niffs",
  "niffy", "nifty", "niger", "nighs", "night", "nihil", "nikab", "nikah",
  "nikau", "nills", "nimbi", "nimbs", "nimps", "niner", "nines", "ninja",
  "ninny", "ninon", "ninth", "nipas", "nippy", "niqab", "nirls", "nirly",
  "nisei", "nisse", "nisus", "niter", "nites", "nitid", "niton", "nitre",
  "nitro", "nitry", "nitty", "nival", "nixed", "nixer", "nixes", "nixie",
  "nizam", "nkosi", "noahs", "nobby", "noble", "nobly", "nocks", "nodal",
  "noddy", "nodes", "nodus", "noels", "noggs", "nohow", "noils", "noily",
  "noint", "noirs", "noise", "noisy", "noles", "nolls", "nolos", "nomad",
  "nomas", "nomen", "nomes", "nomic", "nomoi", "nomos", "nonas", "nonce",
  "nones", "nonet", "nongs", "nonis", "nonny", "nonyl", "noobs", "nooit",
  "nooks", "nooky", "noons", "noops", "noose", "nopal", "noria", "noris",
  "norks", "norma", "norms", "north", "nosed", "noser", "noses", "nosey",
  "notal", "notch", "noted", "noter", "notes", "notum", "nould", "noule",
  "nouls", "nouns", "nouny", "noups", "novae", "novas", "novel", "novum",
  "noway", "nowed", "nowls", "nowts", "nowty", "noxal", "noxes", "noyau",
  "noyed", "noyes", "nubby", "nubia", "nucha", "nuddy", "nuder", "nudes",
  "nudge", "nudie", "nudzh", "nuffs", "nugae", "nuked", "nukes", "nulla",
  "nulls", "numbs", "numen", "nummy", "nunny", "nurds", "nurdy", "nurls",
  "nurrs", "nurse", "nutso", "nutsy", "nutty", "nyaff", "nyala", "nying",
  "nylon", "nymph", "nyssa", "oaked", "oaken", "oaker", "oakum", "oared",
  "oases", "oasis", "oasts", "oaten", "oater", "oaths", "oaves", "obang",
  "obeah", "obeli", "obese", "obeys", "obias", "obied", "obiit", "obits",
  "objet", "oboes", "obole", "oboli", "obols", "occam", "occur", "ocean",
  "ocher", "oches", "ochre", "ochry", "ocker", "ocrea", "octad", "octal",
  "octan", "octas", "octet", "octyl", "oculi", "odahs", "odals", "odder",
  "oddly", "odeon", "odeum", "odism", "odist", "odium", "odors", "odour",
  "odyle", "odyls", "ofays", "offal", "offed", "offer", "offie", "oflag",
  "often", "ofter", "ogams", "ogeed", "ogees", "oggin", "ogham", "ogive",
  "ogled", "ogler", "ogles", "ogmic", "ogres", "ohias", "ohing", "ohmic",
  "ohone", "oidia", "oiled", "oiler", "oinks", "oints", "ojime", "okapi",
  "okays", "okehs", "okras", "oktas", "olden", "older", "oldie", "oleic",
  "olein", "olent", "oleos", "oleum", "olios", "olive", "ollas", "ollav",
  "oller", "ollie", "ology", "olpae", "olpes", "omasa", "omber", "ombre",
  "ombus", "omega", "omens", "omers", "omits", "omlah", "omovs", "omrah",
  "oncer", "onces", "oncet", "oncus", "onely", "oners", "onery", "onion",
  "onium", "onkus", "onlay", "onned", "onset", "ontic", "oobit", "oohed",
  "oomph", "oonts", "ooped", "oorie", "ooses", "ootid", "oozed", "oozes",
  "opahs", "opals", "opens", "opepe", "opera", "opine", "oping", "opium",
  "oppos", "opsin", "opted", "opter", "optic", "orach", "oracy", "orals",
  "orang", "orant", "orate", "orbed", "orbit", "orcas", "orcin", "order",
  "ordos", "oread", "orfes", "organ", "orgia", "orgic", "orgue", "oribi",
  "oriel", "orixa", "orles", "orlon", "orlop", "ormer", "ornis", "orpin",
  "orris", "ortho", "orval", "orzos", "oscar", "oshac", "osier", "osmic",
  "osmol", "ossia", "ostia", "otaku", "otary", "other", "ottar", "otter",
  "ottos", "oubit", "oucht", "ouens", "ought", "ouija", "oulks", "oumas",
  "ounce", "oundy", "oupas", "ouped", "ouphe", "ouphs", "ourie", "ousel",
  "ousts", "outby", "outdo", "outed", "outer", "outgo", "outre", "outro",
  "outta", "ouzel", "ouzos", "ovals", "ovary", "ovate", "ovels", "ovens",
  "overs", "overt", "ovine", "ovist", "ovoid", "ovoli", "ovolo", "ovule",
  "owche", "owies", "owing", "owled", "owler", "owlet", "owned", "owner",
  "owres", "owrie", "owsen", "oxbow", "oxers", "oxeye", "oxide", "oxids",
  "oxies", "oxime", "oxims", "oxlip", "oxter", "oyers", "ozeki", "ozone",
  "ozzie", "paals", "paans", "pacas", "paced", "pacer", "paces", "pacey",
  "pacha", "packs", "pacos", "pacta", "pacts", "paddy", "padis", "padle",
  "padma", "padre", "padri", "paean", "paedo", "paeon", "pagan", "paged",
  "pager", "pages", "pagle", "pagod", "pagri", "paiks", "pails", "pains",
  "paint", "paire", "pairs", "paisa", "paise", "pakka", "palas", "palay",
  "palea", "paled", "paler", "pales", "palet", "palis", "palki", "palla",
  "palls", "pally", "palms", "palmy", "palpi", "palps", "palsa", "palsy",
  "pampa", "panax", "pance", "panda", "pands", "pandy", "paned", "panel",
  "panes", "panga", "pangs", "panic", "panim", "panko", "panne", "panni",
  "pansy", "panto", "pants", "panty", "paoli", "paolo", "papal", "papas",
  "papaw", "paper", "papes", "pappi", "pappy", "parae", "paras", "parch",
  "pardi", "pards", "pardy", "pared", "paren", "pareo", "parer", "pares",
  "pareu", "parev", "parge", "pargo", "paris", "parka", "parki", "parks",
  "parky", "parle", "parly", "parma", "parol", "parps", "parra", "parrs",
  "parry", "parse", "parti", "parts", "party", "parve", "parvo", "paseo",
  "pases", "pasha", "pashm", "paska", "paspy", "passe", "pasta", "paste",
  "pasts", "pasty", "patch", "pated", "paten", "pater", "pates", "paths",
  "patin", "patio", "patka", "patly", "patsy", "patte", "patty", "patus",
  "pauas", "pauls", "pause", "pavan", "paved", "paven", "paver", "paves",
  "pavid", "pavin", "pavis", "pawas", "pawaw", "pawed", "pawer", "pawks",
  "pawky", "pawls", "pawns", "paxes", "payed", "payee", "payer", "payor",
  "paysd", "peace", "peach", "peage", "peags", "peaks", "peaky", "peals",
  "peans", "peare", "pearl", "pears", "peart", "pease", "peats", "peaty",
  "peavy", "peaze", "pebas", "pecan", "pechs", "pecke", "pecks", "pecky",
  "pedal", "pedes", "pedis", "pedro", "peece", "peeks", "peels", "peens",
  "peeoy", "peepe", "peeps", "peers", "peery", "peeve", "peggy", "peghs",
  "peins", "peise", "peize", "pekan", "pekes", "pekin", "pekoe", "pelas",
  "pelau", "peles", "pelfs", "pells", "pelma", "pelon", "pelta", "pelts",
  "penal", "pence", "pends", "pendu", "pened", "penes", "pengo", "penie",
  "penis", "penks", "penna", "penne", "penni", "penny", "pents", "peons",
  "peony", "pepla", "pepos", "peppy", "pepsi", "perai", "perce", "perch",
  "percs", "perdu", "perdy", "perea", "peres", "peril", "peris", "perks",
  "perky", "perms", "perns", "perog", "perps", "perry", "perse", "perst",
  "perts", "perve", "pervo", "pervs", "pervy", "pesky", "pesos", "pesto",
  "pests", "pesty", "petal", "petar", "peter", "petit", "petre", "petri",
  "petti", "petto", "petty", "pewee", "pewit", "peyse", "phage", "phang",
  "phare", "pharm", "phase", "pheer", "phene", "pheon", "phese", "phial",
  "phish", "phizz", "phlox", "phoca", "phone", "phono", "phons", "phony",
  "photo", "phots", "phpht", "phuts", "phyla", "phyle", "piani", "piano",
  "pians", "pibal", "pical", "picas", "piccy", "picks", "picky", "picot",
  "picra", "picul", "piece", "piend", "piers", "piert", "pieta", "piets",
  "piety", "piezo", "piggy", "pight", "pigmy", "piing", "pikas", "pikau",
  "piked", "piker", "pikes", "pikey", "pikis", "pikul", "pilae", "pilaf",
  "pilao", "pilar", "pilau", "pilaw", "pilch", "pilea", "piled", "pilei",
  "piler", "piles", "pilis", "pills", "pilot", "pilow", "pilum", "pilus",
  "pimas", "pimps", "pinas", "pinch", "pined", "pines", "piney", "pingo",
  "pings", "pinko", "pinks", "pinky", "pinna", "pinny", "pinon", "pinot",
  "pinta", "pinto", "pints", "pinup", "pions", "piony", "pious", "pioye",
  "pioys", "pipal", "pipas", "piped", "piper", "pipes", "pipet", "pipis",
  "pipit", "pippy", "pipul", "pique", "pirai", "pirls", "pirns", "pirog",
  "pisco", "pises", "pisky", "pisos", "pissy", "piste", "pitas", "pitch",
  "piths", "pithy", "piton", "pitot", "pitta", "piums", "pivot", "pixel",
  "pixes", "pixie", "pized", "pizes", "pizza", "plaas", "place", "plack",
  "plage", "plaid", "plain", "plait", "plane", "plank", "plans", "plant",
  "plaps", "plash", "plasm", "plast", "plate", "plats", "platt", "platy",
  "playa", "plays", "plaza", "plead", "pleas", "pleat", "plebe", "plebs",
  "plena", "pleon", "plesh", "plews", "plica", "plied", "plier", "plies",
  "plims", "pling", "plink", "ploat", "plods", "plong", "plonk", "plook",
  "plops", "plots", "plotz", "plouk", "plows", "ploye", "ploys", "pluck",
  "plues", "pluff", "plugs", "plumb", "plume", "plump", "plums", "plumy",
  "plunk", "pluot", "plush", "pluto", "plyer", "poach", "poaka", "poake",
  "poboy", "pocks", "pocky", "podal", "poddy", "podex", "podge", "podgy",
  "podia", "poems", "poeps", "poesy", "poets", "pogey", "pogge", "pogos",
  "pohed", "poilu", "poind", "point", "poise", "pokal", "poked", "poker",
  "pokes", "pokey", "pokie", "polar", "poled", "poler", "poles", "poley",
  "polio", "polis", "polje", "polka", "polks", "polls", "polly", "polos",
  "polts", "polyp", "polys", "pombe", "pomes", "pommy", "pomos", "pomps",
  "ponce", "poncy", "ponds", "pones", "poney", "ponga", "pongo", "pongs",
  "pongy", "ponks", "ponts", "ponty", "ponzu", "pooch", "poods", "pooed",
  "poofs", "poofy", "poohs", "pooja", "pooka", "pooks", "pools", "poons",
  "poops", "poopy", "poori", "poort", "poots", "poove", "poovy", "popes",
  "poppa", "poppy", "popsy", "porae", "poral", "porch", "pored", "porer",
  "pores", "porge", "porgy", "porin", "porks", "porky", "porno", "porns",
  "porny", "porta", "ports", "porty", "posed", "poser", "poses", "posey",
  "posho", "posit", "posse", "posts", "potae", "potch", "poted", "potes",
  "potin", "potoo", "potsy", "potto", "potts", "potty", "pouch", "pouff",
  "poufs", "pouke", "pouks", "poule", "poulp", "poult", "pound", "poupe",
  "poupt", "pours", "pouts", "pouty", "powan", "power", "powin", "pownd",
  "powns", "powny", "powre", "poxed", "poxes", "poynt", "poyou", "poyse",
  "pozzy", "praam", "prads", "prahu", "prams", "prana", "prang", "prank",
  "praos", "prase", "prate", "prats", "pratt", "praty", "praus", "prawn",
  "prays", "predy", "preed", "preen", "prees", "preif", "prems", "premy",
  "prent", "preon", "preop", "preps", "presa", "prese", "press", "prest",
  "preve", "prexy", "preys", "prial", "price", "prick", "pricy", "pride",
  "pried", "prief", "prier", "pries", "prigs", "prill", "prima", "prime",
  "primi", "primo", "primp", "prims", "primy", "prink", "print", "prion",
  "prior", "prise", "prism", "priss", "privy", "prize", "proas", "probe",
  "probs", "prods", "proem", "profs", "progs", "proin", "proke", "prole",
  "proll", "promo", "proms", "prone", "prong", "pronk", "proof", "props",
  "prore", "prose", "proso", "pross", "prost", "prosy", "proto", "proud",
  "proul", "prove", "prowl", "prows", "proxy", "proyn", "prude", "prune",
  "prunt", "pruta", "pryer", "pryse", "psalm", "pseud", "pshaw", "psion",
  "psoae", "psoai", "psoas", "psora", "psych", "psyop", "pubco", "pubes",
  "pubic", "pubis", "pucan", "pucer", "puces", "pucka", "pucks", "puddy",
  "pudge", "pudgy", "pudic", "pudor", "pudsy", "pudus", "puers", "puffa",
  "puffs", "puffy", "puggy", "pugil", "puhas", "pujah", "pujas", "pukas",
  "puked", "puker", "pukes", "pukey", "pukka", "pukus", "pulao", "pulas",
  "puled", "puler", "pules", "pulik", "pulis", "pulka", "pulks", "pulli",
  "pulls", "pully", "pulmo", "pulps", "pulpy", "pulse", "pulus", "pumas",
  "pumie", "pumps", "punas", "punce", "punch", "punga", "pungs", "punji",
  "punka", "punks", "punky", "punny", "punto", "punts", "punty", "pupae",
  "pupal", "pupas", "pupil", "puppy", "pupus", "purda", "pured", "puree",
  "purer", "pures", "purge", "purin", "puris", "purls", "purpy", "purrs",
  "purse", "pursy", "purty", "puses", "pushy", "pusle", "pussy", "putid",
  "puton", "putti", "putto", "putts", "putty", "puzel", "pwned", "pyats",
  "pyets", "pygal", "pygmy", "pyins", "pylon", "pyned", "pynes", "pyoid",
  "pyots", "pyral", "pyran", "pyres", "pyrex", "pyric", "pyros", "pyxed",
  "pyxes", "pyxie", "pyxis", "pzazz", "qadis", "qaids", "qajaq", "qanat",
  "qapik", "qibla", "qophs", "qorma", "quack", "quads", "quaff", "quags",
  "quail", "quair", "quais", "quake", "quaky", "quale", "qualm", "quant",
  "quare", "quark", "quart", "quash", "quasi", "quass", "quate", "quats",
  "quayd", "quays", "qubit", "quean", "queen", "queer", "quell", "queme",
  "quena", "quern", "query", "quest", "queue", "queyn", "queys", "quich",
  "quick", "quids", "quiet", "quiff", "quill", "quilt", "quims", "quina",
  "quine", "quino", "quins", "quint", "quipo", "quips", "quipu", "quire",
  "quirk", "quirt", "quist", "quite", "quits", "quoad", "quods", "quoif",
  "quoin", "quoit", "quoll", "quonk", "quops", "quota", "quote", "quoth",
  "qursh", "quyte", "rabat", "rabbi", "rabic", "rabid", "rabis", "raced",
  "racer", "races", "rache", "racks", "racon", "radar", "radge", "radii",
  "radio", "radix", "radon", "raffs", "rafts", "ragas", "ragde", "raged",
  "ragee", "rager", "rages", "ragga", "raggs", "raggy", "ragis", "ragus",
  "rahed", "rahui", "raias", "raids", "raiks", "raile", "rails", "raine",
  "rains", "rainy", "raird", "raise", "raita", "raits", "rajah", "rajas",
  "rajes", "raked", "rakee", "raker", "rakes", "rakia", "rakis", "rakus",
  "rales", "rally", "ralph", "ramal", "ramee", "ramen", "ramet", "ramie",
  "ramin", "ramis", "rammy", "ramps", "ramus", "ranas", "rance", "ranch",
  "rands", "randy", "ranee", "ranga", "range", "rangi", "rangs", "rangy",
  "ranid", "ranis", "ranke", "ranks", "rants", "raped", "raper", "rapes",
  "raphe", "rapid", "rappe", "rared", "raree", "rarer", "rares", "rarks",
  "rased", "raser", "rases", "rasps", "raspy", "rasse", "rasta", "ratal",
  "ratan", "ratas", "ratch", "rated", "ratel", "rater", "rates", "ratha",
  "rathe", "raths", "ratio", "ratoo", "ratos", "ratty", "ratus", "rauns",
  "raupo", "raved", "ravel", "raven", "raver", "raves", "ravey", "ravin",
  "rawer", "rawin", "rawly", "rawns", "raxed", "raxes", "rayah", "rayas",
  "rayed", "rayle", "rayne", "rayon", "razed", "razee", "razer", "razes",
  "razoo", "razor", "reach", "react", "readd", "reads", "ready", "reais",
  "reaks", "realm", "realo", "reals", "reame", "reams", "reamy", "reans",
  "reaps", "rearm", "rears", "reast", "reata", "reate", "reave", "rebar",
  "rebbe", "rebec", "rebel", "rebid", "rebit", "rebop", "rebus", "rebut",
  "rebuy", "recal", "recap", "recce", "recco", "reccy", "recit", "recks",
  "recon", "recta", "recti", "recto", "recur", "recut", "redan", "redds",
  "reddy", "reded", "redes", "redia", "redid", "redip", "redly", "redon",
  "redos", "redox", "redry", "redub", "redux", "redye", "reech", "reede",
  "reeds", "reedy", "reefs", "reefy", "reeks", "reeky", "reels", "reens",
  "reest", "reeve", "refed", "refel", "refer", "reffo", "refis", "refit",
  "refix", "refly", "refry", "regal", "regar", "reges", "reggo", "regie",
  "regma", "regna", "regos", "regur", "rehab", "rehem", "reifs", "reify",
  "reign", "reiki", "reiks", "reink", "reins", "reird", "reist", "reive",
  "rejig", "rejon", "reked", "rekes", "rekey", "relax", "relay", "relet",
  "relic", "relie", "relit", "rello", "reman", "remap", "remen", "remet",
  "remex", "remit", "remix", "renal", "renay", "rends", "renew", "reney",
  "renga", "renig", "renin", "renne", "renos", "rente", "rents", "reoil",
  "reorg", "repay", "repeg", "repel", "repin", "repla", "reply", "repos",
  "repot", "repps", "repro", "reran", "rerig", "rerun", "resat", "resaw",
  "resay", "resee", "reses", "reset", "resew", "resid", "resin", "resit",
  "resod", "resow", "resto", "rests", "resty", "resus", "retag", "retax",
  "retch", "retem", "retia", "retie", "retox", "retro", "retry", "reuse",
  "revel", "revet", "revie", "revue", "rewan", "rewax", "rewed", "rewet",
  "rewin", "rewon", "rewth", "rexes", "rezes", "rheas", "rheme", "rheum",
  "rhies", "rhime", "rhine", "rhino", "rhody", "rhomb", "rhone", "rhumb",
  "rhyme", "rhyne", "rhyta", "riads", "rials", "riant", "riata", "ribas",
  "ribby", "ribes", "riced", "ricer", "rices", "ricey", "richt", "ricin",
  "ricks", "rider", "rides", "ridge", "ridgy", "ridic", "riels", "riems",
  "rieve", "rifer", "riffs", "rifle", "rifte", "rifts", "rifty", "riggs",
  "right", "rigid", "rigol", "rigor", "riled", "riles", "riley", "rille",
  "rills", "rimae", "rimed", "rimer", "rimes", "rimus", "rinds", "rindy",
  "rines", "rings", "rinks", "rinse", "rioja", "riots", "riped", "ripen",
  "riper", "ripes", "ripps", "risen", "riser", "rises", "rishi", "risks",
  "risky", "risps", "risus", "rites", "ritts", "ritzy", "rival", "rivas",
  "rived", "rivel", "riven", "river", "rives", "rivet", "riyal", "rizas",
  "roach", "roads", "roams", "roans", "roars", "roary", "roast", "roate",
  "robed", "robes", "robin", "roble", "robot", "rocks", "rocky", "roded",
  "rodeo", "rodes", "roger", "rogue", "roguy", "rohes", "roids", "roils",
  "roily", "roins", "roist", "rojak", "rojis", "roked", "roker", "rokes",
  "rolag", "roles", "rolfs", "rolls", "romal", "roman", "romeo", "romps",
  "ronde", "rondo", "roneo", "rones", "ronin", "ronne", "ronte", "ronts",
  "roods", "roofs", "roofy", "rooks", "rooky", "rooms", "roomy", "roons",
  "roops", "roopy", "roosa", "roose", "roost", "roots", "rooty", "roped",
  "roper", "ropes", "ropey", "roque", "roral", "rores", "roric", "rorid",
  "rorie", "rorts", "rorty", "rosed", "roses", "roset", "roshi", "rosin",
  "rosit", "rosti", "rosts", "rotal", "rotan", "rotas", "rotch", "roted",
  "rotes", "rotis", "rotls", "roton", "rotor", "rotos", "rotte", "rouen",
  "roues", "rouge", "rough", "roule", "rouls", "roums", "round", "roups",
  "roupy", "rouse", "roust", "route", "routh", "routs", "roved", "roven",
  "rover", "roves", "rowan", "rowdy", "rowed", "rowel", "rowen", "rower",
  "rowie", "rowme", "rownd", "rowth", "rowts", "royal", "royne", "royst",
  "rozet", "rozit", "ruana", "rubai", "rubby", "rubel", "rubes", "rubin",
  "ruble", "rubli", "rubus", "ruche", "rucks", "rudas", "rudds", "ruddy",
  "ruder", "rudes", "rudie", "rudis", "rueda", "ruers", "ruffe", "ruffs",
  "rugae", "rugal", "rugby", "ruggy", "ruing", "ruins", "rukhs", "ruled",
  "ruler", "rules", "rumal", "rumba", "rumbo", "rumen", "rumes", "rumly",
  "rummy", "rumor", "rumpo", "rumps", "rumpy", "runch", "runds", "runed",
  "runes", "rungs", "runic", "runny", "runts", "runty", "rupee", "rupia",
  "rural", "rurps", "rurus", "rusas", "ruses", "rushy", "rusks", "rusma",
  "russe", "rusts", "rusty", "ruths", "rutin", "rutty", "ryals", "rybat",
  "ryked", "rykes", "rymme", "rynds", "ryots", "ryper", "saags", "sabal",
  "sabed", "saber", "sabes", "sabha", "sabin", "sabir", "sable", "sabot",
  "sabra", "sabre", "sacks", "sacra", "saddo", "sades", "sadhe", "sadhu",
  "sadis", "sadly", "sados", "sadza", "safed", "safer", "safes", "sagas",
  "sager", "sages", "saggy", "sagos", "sagum", "saheb", "sahib", "saice",
  "saick", "saics", "saids", "saiga", "sails", "saims", "saine", "sains",
  "saint", "sairs", "saist", "saith", "sajou", "sakai", "saker", "sakes",
  "sakia", "sakis", "sakti", "salad", "salal", "salat", "salep", "sales",
  "salet", "salic", "salix", "salle", "sally", "salmi", "salol", "salon",
  "salop", "salpa", "salps", "salsa", "salse", "salto", "salts", "salty",
  "salue", "salut", "salve", "salvo", "saman", "samas", "samba", "sambo",
  "samek", "samel", "samen", "sames", "samey", "samfu", "sammy", "sampi",
  "samps", "sands", "sandy", "saned", "saner", "sanes", "sanga", "sangh",
  "sango", "sangs", "sanko", "sansa", "santo", "sants", "saola", "sapan",
  "sapid", "sapor", "sappy", "saran", "sards", "sared", "saree", "sarge",
  "sargo", "sarin", "saris", "sarks", "sarky", "sarod", "saros", "sarus",
  "saser", "sasin", "sasse", "sassy", "satai", "satay", "sated", "satem",
  "sates", "satin", "satis", "satyr", "sauba", "sauce", "sauch", "saucy",
  "saugh", "sauls", "sault", "sauna", "saunt", "saury", "saute", "sauts",
  "saved", "saver", "saves", "savey", "savin", "savor", "savoy", "savvy",
  "sawah", "sawed", "sawer", "saxes", "sayed", "sayer", "sayid", "sayne",
  "sayon", "sayst", "sazes", "scabs", "scads", "scaff", "scags", "scail",
  "scala", "scald", "scale", "scall", "scalp", "scaly", "scamp", "scams",
  "scand", "scans", "scant", "scapa", "scape", "scapi", "scare", "scarf",
  "scarp", "scars", "scart", "scary", "scath", "scats", "scatt", "scaud",
  "scaup", "scaur", "scaws", "sceat", "scena", "scend", "scene", "scent",
  "schav", "schmo", "schul", "schwa", "scion", "sclim", "scody", "scoff",
  "scogs", "scold", "scone", "scoog", "scoop", "scoot", "scopa", "scope",
  "scops", "score", "scorn", "scots", "scoug", "scoup", "scour", "scout",
  "scowl", "scowp", "scows", "scrab", "scrae", "scrag", "scram", "scran",
  "scrap", "scrat", "scraw", "scray", "scree", "screw", "scrim", "scrip",
  "scrob", "scrod", "scrog", "scrow", "scrub", "scrum", "scuba", "scudi",
  "scudo", "scuds", "scuff", "scuft", "scugs", "sculk", "scull", "sculp",
  "sculs", "scums", "scups", "scurf", "scurs", "scuse", "scuta", "scute",
  "scuts", "scuzz", "scyes", "sdayn", "sdein", "seals", "seame", "seams",
  "seamy", "seans", "seare", "sears", "sease", "seats", "seaze", "sebum",
  "secco", "sechs", "sects", "sedan", "seder", "sedes", "sedge", "sedgy",
  "sedum", "seeds", "seedy", "seeks", "seeld", "seels", "seely", "seems",
  "seeps", "seepy", "seers", "sefer", "segar", "segni", "segno", "segol",
  "segos", "segue", "sehri", "seifs", "seils", "seine", "seirs", "seise",
  "seism", "seity", "seiza", "seize", "sekos", "sekts", "selah", "seles",
  "selfs", "sella", "selle", "sells", "selva", "semee", "semen", "semes",
  "semie", "semis", "senas", "sends", "senes", "sengi", "senna", "senor",
  "sensa", "sense", "sensi", "sente", "senti", "sents", "senvy", "senza",
  "sepad", "sepal", "sepia", "sepic", "sepoy", "septa", "septs", "serac",
  "serai", "seral", "sered", "serer", "seres", "serfs", "serge", "seric",
  "serif", "serin", "serks", "seron", "serow", "serra", "serre", "serrs",
  "serry", "serum", "serve", "servo", "sesey", "sessa", "setae", "setal",
  "seton", "setts", "setup", "seven", "sever", "sewan", "sewar", "sewed",
  "sewel", "sewen", "sewer", "sewin", "sexed", "sexer", "sexes", "sexto",
  "sexts", "seyen", "shack", "shade", "shads", "shady", "shaft", "shags",
  "shahs", "shake", "shako", "shakt", "shaky", "shale", "shall", "shalm",
  "shalt", "shaly", "shama", "shame", "shams", "shand", "shank", "shans",
  "shape", "shaps", "shard", "share", "shark", "sharn", "sharp", "shash",
  "shaul", "shave", "shawl", "shawm", "shawn", "shaws", "shaya", "shays",
  "shchi", "sheaf", "sheal", "shear", "sheas", "sheds", "sheel", "sheen",
  "sheep", "sheer", "sheet", "sheik", "shelf", "shell", "shend", "shent",
  "sheol", "sherd", "shere", "shero", "shets", "sheva", "shewn", "shews",
  "shiai", "shied", "shiel", "shier", "shies", "shift", "shill", "shily",
  "shims", "shine", "shins", "shiny", "ships", "shire", "shirk", "shirr",
  "shirs", "shirt", "shish", "shiso", "shist", "shite", "shits", "shiur",
  "shiva", "shive", "shivs", "shlep", "shlub", "shmek", "shmoe", "shoal",
  "shoat", "shock", "shoed", "shoer", "shoes", "shogi", "shogs", "shoji",
  "shojo", "shola", "shone", "shook", "shool", "shoon", "shoos", "shoot",
  "shope", "shops", "shore", "shorl", "shorn", "short", "shote", "shots",
  "shott", "shout", "shove", "showd", "shown", "shows", "showy", "shoyu",
  "shred", "shrew", "shris", "shrow", "shrub", "shrug", "shtik", "shtum",
  "shtup", "shuck", "shule", "shuln", "shuls", "shuns", "shunt", "shura",
  "shush", "shute", "shuts", "shwas", "shyer", "shyly", "sials", "sibbs",
  "sibyl", "sices", "sicht", "sicko", "sicks", "sicky", "sidas", "sided",
  "sider", "sides", "sidha", "sidhe", "sidle", "siege", "sield", "siens",
  "sient", "sieth", "sieur", "sieve", "sifts", "sighs", "sight", "sigil",
  "sigla", "sigma", "signa", "signs", "sijos", "sikas", "siker", "sikes",
  "silds", "siled", "silen", "siler", "siles", "silex", "silks", "silky",
  "sills", "silly", "silos", "silts", "silty", "silva", "simar", "simas",
  "simba", "simis", "simps", "simul", "since", "sinds", "sined", "sines",
  "sinew", "singe", "sings", "sinhs", "sinks", "sinky", "sinus", "siped",
  "sipes", "sippy", "sired", "siree", "siren", "sires", "sirih", "siris",
  "siroc", "sirra", "sirup", "sisal", "sises", "sissy", "sista", "sists",
  "sitar", "sited", "sites", "sithe", "sitka", "situp", "situs", "siver",
  "sixer", "sixes", "sixmo", "sixte", "sixth", "sixty", "sizar", "sized",
  "sizel", "sizer", "sizes", "skags", "skail", "skald", "skank", "skart",
  "skate", "skats", "skatt", "skaws", "skean", "skear", "skeds", "skeed",
  "skeef", "skeen", "skeer", "skees", "skeet", "skegg", "skegs", "skein",
  "skelf", "skell", "skelm", "skelp", "skene", "skens", "skeos", "skeps",
  "skers", "skets", "skews", "skids", "skied", "skier", "skies", "skiey",
  "skiff", "skill", "skimo", "skimp", "skims", "skink", "skins", "skint",
  "skios", "skips", "skirl", "skirr", "skirt", "skite", "skits", "skive",
  "skivy", "sklim", "skoal", "skody", "skoff", "skogs", "skols", "skool",
  "skort", "skosh", "skran", "skrik", "skuas", "skugs", "skulk", "skull",
  "skunk", "skyed", "skyer", "skyey", "skyfs", "skyre", "skyrs", "skyte",
  "slabs", "slack", "slade", "slaes", "slags", "slaid", "slain", "slake",
  "slams", "slane", "slang", "slank", "slant", "slaps", "slart", "slash",
  "slate", "slats", "slaty", "slave", "slaws", "slays", "slebs", "sleds",
  "sleek", "sleep", "sleer", "sleet", "slept", "slews", "sleys", "slice",
  "slick", "slide", "slier", "slily", "slime", "slims", "slimy", "sling",
  "slink", "slipe", "slips", "slipt", "slish", "slits", "slive", "sloan",
  "slobs", "sloes", "slogs", "sloid", "slojd", "slomo", "sloom", "sloop",
  "sloot", "slope", "slops", "slopy", "slorm", "slosh", "sloth", "slots",
  "slove", "slows", "sloyd", "slubb", "slubs", "slued", "slues", "sluff",
  "slugs", "sluit", "slump", "slums", "slung", "slunk", "slurb", "slurp",
  "slurs", "sluse", "slush", "sluts", "slyer", "slyly", "slype", "smaak",
  "smack", "smaik", "small", "smalm", "smalt", "smarm", "smart", "smash",
  "smaze", "smear", "smeek", "smees", "smeik", "smeke", "smell", "smelt",
  "smerk", "smews", "smile", "smirk", "smirr", "smirs", "smite", "smith",
  "smits", "smock", "smogs", "smoke", "smoko", "smoky", "smolt", "smoor",
  "smoot", "smore", "smorg", "smote", "smout", "smowt", "smugs", "smurs",
  "smush", "smuts", "snabs", "snack", "snafu", "snags", "snail", "snake",
  "snaky", "snaps", "snare", "snarf", "snark", "snarl", "snars", "snary",
  "snash", "snath", "snaws", "snead", "sneak", "sneap", "snebs", "sneck",
  "sneds", "sneed", "sneer", "snees", "snell", "snibs", "snick", "snide",
  "snies", "sniff", "snift", "snigs", "snipe", "snips", "snipy", "snirt",
  "snits", "snobs", "snods", "snoek", "snoep", "snogs", "snoke", "snood",
  "snook", "snool", "snoop", "snoot", "snore", "snort", "snots", "snout",
  "snowk", "snows", "snowy", "snubs", "snuck", "snuff", "snugs", "snush",
  "snyes", "soaks", "soaps", "soapy", "soare", "soars", "soave", "sobas",
  "sober", "socas", "soces", "socko", "socks", "socle", "sodas", "soddy",
  "sodic", "sodom", "sofar", "sofas", "softa", "softs", "softy", "soger",
  "soggy", "sohur", "soils", "soily", "sojas", "sojus", "sokah", "soken",
  "sokes", "sokol", "solah", "solan", "solar", "solas", "solde", "soldi",
  "soldo", "solds", "soled", "solei", "soler", "soles", "solid", "solon",
  "solos", "solum", "solus", "solve", "soman", "somas", "sonar", "sonce",
  "sonde", "sones", "songs", "sonic", "sonly", "sonne", "sonny", "sonse",
  "sonsy", "sooey", "sooks", "sooky", "soole", "sools", "sooms", "soops",
  "soote", "sooth", "soots", "sooty", "sophs", "sophy", "sopor", "soppy",
  "sopra", "soral", "soras", "sorbo", "sorbs", "sorda", "sordo", "sords",
  "sored", "soree", "sorel", "sorer", "sores", "sorex", "sorgo", "sorns",
  "sorra", "sorry", "sorta", "sorts", "sorus", "soths", "sotol", "souce",
  "souct", "sough", "souks", "souls", "soums", "sound", "soups", "soupy",
  "sours", "souse", "south", "souts", "sowar", "sowce", "sowed", "sower",
  "sowff", "sowfs", "sowle", "sowls", "sowms", "sownd", "sowne", "sowps",
  "sowse", "sowth", "soyas", "soyle", "soyuz", "sozin", "space", "spacy",
  "spade", "spado", "spaed", "spaer", "spaes", "spags", "spahi", "spail",
  "spain", "spait", "spake", "spald", "spale", "spall", "spalt", "spams",
  "spane", "spang", "spank", "spans", "spard", "spare", "spark", "spars",
  "spart", "spasm", "spate", "spats", "spaul", "spawl", "spawn", "spaws",
  "spayd", "spays", "spaza", "spazz", "speak", "speal", "spean", "spear",
  "speat", "speck", "specs", "spect", "speed", "speel", "speer", "speil",
  "speir", "speks", "speld", "spelk", "spell", "spelt", "spend", "spent",
  "speos", "sperm", "spets", "speug", "spews", "spewy", "spial", "spica",
  "spice", "spick", "spics", "spicy", "spide", "spied", "spiel", "spier",
  "spies", "spiff", "spifs", "spike", "spiks", "spiky", "spile", "spill",
  "spilt", "spims", "spina", "spine", "spink", "spins", "spiny", "spire",
  "spirt", "spiry", "spite", "spits", "spitz", "spivs", "splat", "splay",
  "split", "splog", "spode", "spods", "spoil", "spoke", "spoof", "spook",
  "spool", "spoom", "spoon", "spoor", "spoot", "spore", "spork", "sport",
  "sposh", "spots", "spout", "sprad", "sprag", "sprat", "spray", "spred",
  "spree", "sprew", "sprig", "sprit", "sprod", "sprog", "sprue", "sprug",
  "spuds", "spued", "spuer", "spues", "spugs", "spule", "spume", "spumy",
  "spunk", "spurn", "spurs", "spurt", "sputa", "spyal", "spyre", "squab",
  "squad", "squat", "squaw", "squeg", "squib", "squid", "squit", "squiz",
  "stabs", "stack", "stade", "staff", "stage", "stags", "stagy", "staid",
  "staig", "stain", "stair", "stake", "stale", "stalk", "stall", "stamp",
  "stand", "stane", "stang", "stank", "staph", "staps", "stare", "stark",
  "starn", "starr", "stars", "start", "stash", "state", "stats", "staun",
  "stave", "staws", "stays", "stead", "steak", "steal", "steam", "stean",
  "stear", "stedd", "stede", "steds", "steed", "steek", "steel", "steem",
  "steen", "steep", "steer", "steil", "stein", "stela", "stele", "stell",
  "steme", "stems", "stend", "steno", "stens", "stent", "steps", "stept",
  "stere", "stern", "stets", "stews", "stewy", "steys", "stich", "stick",
  "stied", "sties", "stiff", "stilb", "stile", "still", "stilt", "stime",
  "stims", "stimy", "sting", "stink", "stint", "stipa", "stipe", "stire",
  "stirk", "stirp", "stirs", "stive", "stivy", "stoae", "stoai", "stoas",
  "stoat", "stobs", "stock", "stoep", "stogy", "stoic", "stoit", "stoke",
  "stole", "stoln", "stoma", "stomp", "stond", "stone", "stong", "stonk",
  "stonn", "stony", "stood", "stook", "stool", "stoop", "stoor", "stope",
  "stops", "stopt", "store", "stork", "storm", "story", "stoss", "stots",
  "stott", "stoun", "stoup", "stour", "stout", "stove", "stown", "stowp",
  "stows", "strad", "strae", "strag", "strak", "strap", "straw", "stray",
  "strep", "strew", "stria", "strig", "strim", "strip", "strop", "strow",
  "stroy", "strum", "strut", "stubs", "stuck", "stude", "studs", "study",
  "stuff", "stull", "stulm", "stumm", "stump", "stums", "stung", "stunk",
  "stuns", "stunt", "stupa", "stupe", "sture", "sturt", "styed", "styes",
  "style", "styli", "stylo", "styme", "stymy", "styre", "styte", "suave",
  "subah", "subas", "subby", "suber", "subha", "succi", "sucks", "sucky",
  "sucre", "sudds", "sudor", "sudsy", "suede", "suent", "suers", "suete",
  "suets", "suety", "sugan", "sugar", "sughs", "sugos", "suhur", "suids",
  "suing", "suint", "suite", "suits", "sujee", "sukhs", "sukuk", "sulci",
  "sulfa", "sulfo", "sulks", "sulky", "sully", "sulph", "sulus", "sumac",
  "sumis", "summa", "sumos", "sumph", "sumps", "sunis", "sunks", "sunna",
  "sunns", "sunny", "sunup", "super", "supes", "supra", "surah", "sural",
  "suras", "surat", "surds", "sured", "surer", "sures", "surfs", "surfy",
  "surge", "surgy", "surly", "surra", "sused", "suses", "sushi", "susus",
  "sutor", "sutra", "sutta", "swabs", "swack", "swads", "swage", "swags",
  "swail", "swain", "swale", "swaly", "swami", "swamp", "swamy", "swang",
  "swank", "swans", "swaps", "swapt", "sward", "sware", "swarf", "swarm",
  "swart", "swash", "swath", "swats", "swayl", "sways", "sweal", "swear",
  "sweat", "swede", "sweed", "sweel", "sweep", "sweer", "swees", "sweet",
  "sweir", "swell", "swelt", "swept", "swerf", "sweys", "swies", "swift",
  "swigs", "swile", "swill", "swims", "swine", "swing", "swink", "swipe",
  "swire", "swirl", "swish", "swiss", "swith", "swits", "swive", "swizz",
  "swobs", "swole", "swoln", "swoon", "swoop", "swops", "swopt", "sword",
  "swore", "sworn", "swots", "swoun", "swung", "sybbe", "sybil", "syboe",
  "sybow", "sycee", "syces", "sycon", "syens", "syker", "sykes", "sylis",
  "sylph", "sylva", "symar", "synch", "syncs", "synds", "syned", "synes",
  "synod", "synth", "syped", "sypes", "syphs", "syrah", "syren", "syrup",
  "sysop", "sythe", "syver", "taals", "taata", "tabby", "taber", "tabes",
  "tabid", "tabis", "tabla", "table", "taboo", "tabor", "tabun", "tabus",
  "tacan", "taces", "tacet", "tache", "tacho", "tachs", "tacit", "tacks",
  "tacky", "tacos", "tacts", "taels", "taffy", "tafia", "taggy", "tagma",
  "tahas", "tahrs", "taiga", "taigs", "taiko", "tails", "tains", "taint",
  "taira", "taish", "taits", "tajes", "takas", "taken", "taker", "takes",
  "takhi", "takin", "takis", "takky", "talak", "talaq", "talar", "talas",
  "talcs", "talcy", "talea", "taler", "tales", "talks", "talky", "talls",
  "tally", "talma", "talon", "talpa", "taluk", "talus", "tamal", "tamed",
  "tamer", "tames", "tamin", "tamis", "tammy", "tamps", "tanas", "tanga",
  "tangi", "tango", "tangs", "tangy", "tanhs", "tanka", "tanks", "tanky",
  "tanna", "tansy", "tanti", "tanto", "tanty", "tapas", "taped", "tapen",
  "taper", "tapes", "tapet", "tapir", "tapis", "tappa", "tapus", "taras",
  "tardo", "tardy", "tared", "tares", "targa", "targe", "tarns", "taroc",
  "tarok", "taros", "tarot", "tarps", "tarre", "tarry", "tarsi", "tarts",
  "tarty", "tasar", "tased", "taser", "tases", "tasks", "tassa", "tasse",
  "tasso", "taste", "tasty", "tatar", "tater", "tates", "taths", "tatie",
  "tatou", "tatts", "tatty", "tatus", "taube", "tauld", "taunt", "tauon",
  "taupe", "tauts", "tavah", "tavas", "taver", "tawai", "tawas", "tawed",
  "tawer", "tawie", "tawny", "tawse", "tawts", "taxed", "taxer", "taxes",
  "taxis", "taxol", "taxon", "taxor", "taxus", "tayra", "tazza", "tazze",
  "teach", "teade", "teads", "teaed", "teaks", "teals", "teams", "tears",
  "teary", "tease", "teats", "teaze", "techs", "techy", "tecta", "teddy",
  "teels", "teems", "teend", "teene", "teens", "teeny", "teers", "teeth",
  "teffs", "teggs", "tegua", "tegus", "tehrs", "teiid", "teils", "teind",
  "teins", "telae", "telco", "teles", "telex", "telia", "telic", "tells",
  "telly", "teloi", "telos", "temed", "temes", "tempi", "tempo", "temps",
  "tempt", "temse", "tench", "tends", "tendu", "tenes", "tenet", "tenge",
  "tenia", "tenne", "tenno", "tenny", "tenon", "tenor", "tense", "tenth",
  "tents", "tenty", "tenue", "tepal", "tepas", "tepee", "tepid", "tepoy",
  "terai", "teras", "terce", "terek", "teres", "terfe", "terfs", "terga",
  "terms", "terne", "terns", "terra", "terry", "terse", "terts", "tesla",
  "testa", "teste", "tests", "testy", "tetes", "teths", "tetra", "tetri",
  "teuch", "teugh", "tewed", "tewel", "tewit", "texas", "texes", "texts",
  "thack", "thagi", "thaim", "thale", "thali", "thana", "thane", "thang",
  "thank", "thans", "thanx", "tharm", "thars", "thaws", "thawy", "thebe",
  "theca", "theed", "theek", "thees", "theft", "thegn", "theic", "thein",
  "their", "thelf", "thema", "theme", "thens", "theow", "there", "therm",
  "these", "thesp", "theta", "thete", "thews", "thewy", "thick", "thief",
  "thigh", "thigs", "thilk", "thill", "thine", "thing", "think", "thins",
  "thiol", "third", "thirl", "thoft", "thole", "tholi", "thong", "thorn",
  "thoro", "thorp", "those", "thous", "thowl", "thrae", "thraw", "three",
  "threw", "thrid", "thrip", "throb", "throe", "throw", "thrum", "thuds",
  "thugs", "thuja", "thumb", "thump", "thunk", "thurl", "thuya", "thyme",
  "thymi", "thymy", "tians", "tiara", "tiars", "tibia", "tical", "ticca",
  "ticed", "tices", "tichy", "ticks", "ticky", "tidal", "tiddy", "tided",
  "tides", "tiers", "tiffs", "tifos", "tifts", "tiger", "tiges", "tight",
  "tigon", "tikas", "tikes", "tikis", "tikka", "tilak", "tilde", "tiled",
  "tiler", "tiles", "tills", "tilly", "tilth", "tilts", "timbo", "timed",
  "timer", "times", "timid", "timon", "timps", "tinas", "tinct", "tinds",
  "tinea", "tined", "tines", "tinge", "tings", "tinks", "tinny", "tints",
  "tinty", "tipis", "tippy", "tipsy", "tired", "tires", "tirls", "tiros",
  "tirrs", "titan", "titch", "titer", "tithe", "titis", "title", "titre",
  "titty", "titup", "tiyin", "tiyns", "tizes", "tizzy", "toads", "toady",
  "toast", "toaze", "tocks", "tocky", "tocos", "today", "todde", "toddy",
  "toeas", "toffs", "toffy", "tofts", "tofus", "togae", "togas", "toged",
  "toges", "togue", "tohos", "toile", "toils", "toing", "toise", "toits",
  "tokay", "toked", "token", "toker", "tokes", "tokos", "tolan", "tolar",
  "tolas", "toled", "toles", "tolls", "tolly", "tolts", "tolus", "tolyl",
  "toman", "tombs", "tomes", "tomia", "tommy", "tomos", "tonal", "tondi",
  "tondo", "toned", "toner", "tones", "toney", "tonga", "tongs", "tonic",
  "tonka", "tonks", "tonne", "tonus", "tools", "tooms", "toons", "tooth",
  "toots", "topaz", "toped", "topee", "topek", "toper", "topes", "tophe",
  "tophi", "tophs", "topic", "topis", "topoi", "topos", "toppy", "toque",
  "torah", "toran", "toras", "torch", "torcs", "tores", "toric", "torii",
  "toros", "torot", "torrs", "torse", "torsi", "torsk", "torso", "torta",
  "torte", "torts", "torus", "tosas", "tosed", "toses", "toshy", "tossy",
  "total", "toted", "totem", "toter", "totes", "totty", "touch", "tough",
  "touks", "touns", "tours", "touse", "tousy", "touts", "touze", "touzy",
  "towed", "towel", "tower", "towie", "towns", "towny", "towse", "towsy",
  "towts", "towze", "towzy", "toxic", "toxin", "toyed", "toyer", "toyon",
  "toyos", "tozed", "tozes", "tozie", "trabs", "trace", "track", "tract",
  "trade", "trads", "tragi", "traik", "trail", "train", "trait", "tramp",
  "trams", "trank", "tranq", "trans", "trant", "trape", "traps", "trapt",
  "trash", "trass", "trats", "tratt", "trave", "trawl", "trayf", "trays",
  "tread", "treat", "treck", "treed", "treen", "trees", "trefa", "treif",
  "treks", "trema", "trems", "trend", "tress", "trest", "trets", "trews",
  "treyf", "treys", "triac", "triad", "trial", "tribe", "trice", "trick",
  "tride", "tried", "trier", "tries", "triff", "trigo", "trigs", "trike",
  "trild", "trill", "trims", "trine", "trins", "triol", "trior", "trios",
  "tripe", "trips", "tripy", "trist", "trite", "troad", "troak", "troat",
  "trock", "trode", "trods", "trogs", "trois", "troke", "troll", "tromp",
  "trona", "tronc", "trone", "tronk", "trons", "troop", "trooz", "trope",
  "troth", "trots", "trout", "trove", "trows", "troys", "truce", "truck",
  "trued", "truer", "trues", "trugo", "trugs", "trull", "truly", "trump",
  "trunk", "truss", "trust", "truth", "tryer", "tryke", "tryma", "tryps",
  "tryst", "tsade", "tsadi", "tsars", "tsked", "tsuba", "tsubo", "tuans",
  "tuart", "tuath", "tubae", "tubal", "tubar", "tubas", "tubby", "tubed",
  "tuber", "tubes", "tucks", "tufas", "tuffe", "tuffs", "tufts", "tufty",
  "tugra", "tuile", "tuina", "tuism", "tuktu", "tules", "tulip", "tulle",
  "tulpa", "tulsi", "tumid", "tummy", "tumor", "tumps", "tumpy", "tunas",
  "tunds", "tuned", "tuner", "tunes", "tungs", "tunic", "tunny", "tupek",
  "tupik", "tuple", "tuque", "turbo", "turds", "turfs", "turfy", "turks",
  "turme", "turms", "turns", "turnt", "turps", "turrs", "tushy", "tusks",
  "tusky", "tutee", "tutor", "tutti", "tutty", "tutus", "tuxes", "tuyer",
  "twaes", "twain", "twals", "twang", "twank", "twats", "tways", "tweak",
  "tweed", "tweel", "tween", "tweep", "tweer", "tweet", "twerk", "twerp",
  "twice", "twier", "twigs", "twill", "twilt", "twine", "twink", "twins",
  "twiny", "twire", "twirl", "twirp", "twist", "twite", "twits", "twixt",
  "twoer", "twyer", "tyees", "tyers", "tying", "tyiyn", "tykes", "tyler",
  "tymps", "tynde", "tyned", "tynes", "typal", "typed", "types", "typey",
  "typic", "typos", "typps", "typto", "tyran", "tyred", "tyres", "tyros",
  "tythe", "tzars", "udals", "udder", "udons", "ugali", "ugged", "uhlan",
  "uhuru", "ukase", "ulama", "ulans", "ulcer", "ulema", "ulmin", "ulnad",
  "ulnae", "ulnar", "ulnas", "ulpan", "ultra", "ulvas", "ulyie", "ulzie",
  "umami", "umbel", "umber", "umble", "umbos", "umbra", "umbre", "umiac",
  "umiak", "umiaq", "ummah", "ummas", "ummed", "umped", "umphs", "umpie",
  "umpty", "umrah", "umras", "unais", "unapt", "unarm", "unary", "unaus",
  "unbag", "unban", "unbar", "unbed", "unbid", "unbox", "uncap", "unces",
  "uncia", "uncle", "uncos", "uncoy", "uncus", "uncut", "undam", "undee",
  "under", "undid", "undos", "undue", "undug", "uneth", "unfed", "unfit",
  "unfix", "ungag", "unget", "ungod", "ungot", "ungum", "unhat", "unhip",
  "unica", "unify", "union", "unite", "units", "unity", "unjam", "unked",
  "unket", "unkid", "unlaw", "unlay", "unled", "unlet", "unlid", "unlit",
  "unman", "unmet", "unmew", "unmix", "unpay", "unpeg", "unpen", "unpin",
  "unred", "unrid", "unrig", "unrip", "unsaw", "unsay", "unsee", "unset",
  "unsew", "unsex", "unsod", "untax", "untie", "until", "untin", "unwed",
  "unwet", "unwit", "unwon", "unzip", "upbow", "upbye", "updos", "updry",
  "upend", "upjet", "uplay", "upled", "uplit", "upped", "upper", "upran",
  "uprun", "upsee", "upset", "upsey", "uptak", "upter", "uptie", "uraei",
  "urali", "uraos", "urare", "urari", "urase", "urate", "urban", "urbex",
  "urbia", "urdee", "ureal", "ureas", "uredo", "ureic", "urena", "urent",
  "urged", "urger", "urges", "urial", "urine", "urite", "urman", "urnal",
  "urned", "urped", "ursae", "ursid", "urson", "urubu", "urvas", "usage",
  "users", "usher", "using", "usnea", "usque", "usual", "usure", "usurp",
  "usury", "uteri", "utile", "utter", "uveal", "uveas", "uvula", "vacua",
  "vaded", "vades", "vagal", "vague", "vagus", "vails", "vaire", "vairs",
  "vairy", "vakas", "vakil", "vales", "valet", "valid", "valis", "valor",
  "valse", "value", "valve", "vamps", "vampy", "vanda", "vaned", "vanes",
  "vangs", "vants", "vaped", "vaper", "vapes", "vapid", "vapor", "varan",
  "varas", "vardy", "varec", "vares", "varia", "varix", "varna", "varus",
  "varve", "vasal", "vases", "vasts", "vasty", "vatic", "vatus", "vauch",
  "vault", "vaunt", "vaute", "vauts", "vawte", "vaxes", "veale", "veals",
  "vealy", "veena", "veeps", "veers", "veery", "vegan", "vegas", "veges",
  "vegie", "vegos", "vehme", "veils", "veily", "veins", "veiny", "velar",
  "velds", "veldt", "veles", "vells", "velum", "venae", "venal", "vends",
  "vendu", "veney", "venge", "venin", "venom", "vents", "venue", "venus",
  "verbs", "verge", "verra", "verry", "verse", "verso", "verst", "verts",
  "vertu", "verve", "vespa", "vesta", "vests", "vetch", "vexed", "vexer",
  "vexes", "vexil", "vezir", "vials", "viand", "vibes", "vibex", "vibey",
  "vicar", "viced", "vices", "vichy", "video", "viers", "views", "viewy",
  "vifda", "viffs", "vigas", "vigia", "vigil", "vigor", "vilde", "viler",
  "villa", "villi", "vills", "vimen", "vinal", "vinas", "vinca", "vined",
  "viner", "vines", "vinew", "vinic", "vinos", "vints", "vinyl", "viola",
  "viold", "viols", "viper", "viral", "vired", "vireo", "vires", "virga",
  "virge", "virid", "virls", "virtu", "virus", "visas", "vised", "vises",
  "visie", "visit", "visne", "vison", "visor", "vista", "visto", "vitae",
  "vital", "vitas", "vitex", "vitro", "vitta", "vivas", "vivat", "vivda",
  "viver", "vives", "vivid", "vixen", "vizir", "vizor", "vleis", "vlies",
  "vlogs", "voars", "vocab", "vocal", "voces", "voddy", "vodka", "vodou",
  "vodun", "voema", "vogie", "vogue", "voice", "voids", "voila", "voile",
  "voips", "volae", "volar", "voled", "voles", "volet", "volks", "volta",
  "volte", "volti", "volts", "volva", "volve", "vomer", "vomit", "voted",
  "voter", "votes", "vouch", "vouge", "voulu", "vowed", "vowel", "vower",
  "voxel", "vozhd", "vraic", "vrils", "vroom", "vrous", "vrouw", "vrows",
  "vuggs", "vuggy", "vughs", "vughy", "vulgo", "vulns", "vulva", "vutty",
  "vying", "waacs", "wacke", "wacko", "wacks", "wacky", "wadds", "waddy",
  "waded", "wader", "wades", "wadge", "wadis", "wadts", "wafer", "waffs",
  "wafts", "waged", "wager", "wages", "wagga", "wagon", "wagyu", "wahoo",
  "waide", "waifs", "waift", "wails", "wains", "wairs", "waist", "waite",
  "waits", "waive", "wakas", "waked", "waken", "waker", "wakes", "wakfs",
  "waldo", "walds", "waled", "waler", "wales", "walie", "walis", "walks",
  "walla", "walls", "wally", "walty", "waltz", "wamed", "wames", "wamus",
  "wands", "waned", "wanes", "waney", "wangs", "wanks", "wanky", "wanle",
  "wanly", "wanna", "wants", "wanty", "wanze", "waqfs", "warbs", "warby",
  "wards", "wared", "wares", "warez", "warks", "warms", "warns", "warps",
  "warre", "warst", "warts", "warty", "wases", "washy", "wasms", "wasps",
  "waspy", "waste", "wasts", "watap", "watch", "water", "watts", "wauff",
  "waugh", "wauks", "waulk", "wauls", "waurs", "waved", "waver", "waves",
  "wavey", "wawas", "wawes", "wawls", "waxed", "waxen", "waxer", "waxes",
  "wayed", "wazir", "wazoo", "weald", "weals", "weamb", "weans", "wears",
  "weary", "weave", "webby", "weber", "wecht", "wedel", "wedge", "wedgy",
  "weeds", "weedy", "weeke", "weeks", "weels", "weems", "weens", "weeny",
  "weeps", "weepy", "weest", "weete", "weets", "wefte", "wefts", "weids",
  "weigh", "weils", "weird", "weirs", "weise", "weize", "wekas", "welch",
  "welds", "welke", "welks", "welkt", "wells", "welly", "welsh", "welts",
  "wembs", "wench", "wends", "wenge", "wenny", "wents", "weros", "wersh",
  "wests", "wetas", "wetly", "wexed", "wexes", "whack", "whale", "whamo",
  "whams", "whang", "whaps", "whare", "wharf", "whata", "whats", "whaup",
  "whaur", "wheal", "whear", "wheat", "wheel", "wheen", "wheep", "wheft",
  "whelk", "whelm", "whelp", "whens", "where", "whets", "whews", "wheys",
  "which", "whids", "whiff", "whift", "whigs", "while", "whilk", "whims",
  "whine", "whins", "whiny", "whios", "whips", "whipt", "whirl", "whirr",
  "whirs", "whish", "whisk", "whiss", "whist", "white", "whits", "whity",
  "whizz", "whole", "whomp", "whoof", "whoop", "whoot", "whops", "whore",
  "whorl", "whort", "whose", "whoso", "whows", "whump", "whups", "whyda",
  "wicca", "wicks", "wicky", "widdy", "widen", "wider", "wides", "widow",
  "width", "wield", "wiels", "wifed", "wifes", "wifey", "wifie", "wifty",
  "wigan", "wigga", "wiggy", "wight", "wikis", "wilco", "wilds", "wiled",
  "wiles", "wilga", "wilis", "wilja", "wills", "willy", "wilts", "wimps",
  "wimpy", "wince", "winch", "winds", "windy", "wined", "wines", "winey",
  "winge", "wings", "wingy", "winks", "winna", "winns", "winos", "winze",
  "wiped", "wiper", "wipes", "wired", "wirer", "wires", "wirra", "wised",
  "wiser", "wises", "wisha", "wisht", "wisps", "wispy", "wists", "witan",
  "witch", "wited", "wites", "withe", "withs", "withy", "witty", "wived",
  "wiver", "wives", "wizen", "wizes", "woads", "woald", "wocks", "wodge",
  "woful", "wojus", "woken", "woker", "wokka", "wolds", "wolfs", "wolly",
  "wolve", "woman", "wombs", "womby", "women", "womyn", "wonga", "wongi",
  "wonks", "wonky", "wonts", "woods", "woody", "wooed", "wooer", "woofs",
  "woofy", "woold", "wools", "wooly", "woons", "woops", "woopy", "woose",
  "woosh", "wootz", "woozy", "words", "wordy", "works", "world", "worms",
  "wormy", "worry", "worse", "worst", "worth", "worts", "would", "wound",
  "woven", "wowed", "wowee", "woxen", "wrack", "wrang", "wraps", "wrapt",
  "wrast", "wrate", "wrath", "wrawl", "wreak", "wreck", "wrens", "wrest",
  "wrick", "wried", "wrier", "wries", "wring", "wrist", "write", "writs",
  "wroke", "wrong", "wroot", "wrote", "wroth", "wrung", "wryer", "wryly",
  "wuddy", "wudus", "wulls", "wurst", "wuses", "wushu", "wussy", "wuxia",
  "wyled", "wyles", "wynds", "wynns", "wyted", "wytes", "xebec", "xenia",
  "xenic", "xenon", "xeric", "xerox", "xerus", "xoana", "xrays", "xylan",
  "xylem", "xylic", "xylol", "xylyl", "xysti", "xysts", "yaars", "yabas",
  "yabba", "yabby", "yacca", "yacht", "yacka", "yacks", "yaffs", "yager",
  "yages", "yagis", "yahoo", "yaird", "yakka", "yakow", "yales", "yamen",
  "yampy", "yamun", "yangs", "yanks", "yapok", "yapon", "yapps", "yappy",
  "yarak", "yarco", "yards", "yarer", "yarfa", "yarks", "yarns", "yarrs",
  "yarta", "yarto", "yates", "yauds", "yauld", "yaups", "yawed", "yawey",
  "yawls", "yawns", "yawny", "yawps", "ybore", "yclad", "ycled", "ycond",
  "ydrad", "ydred", "yeads", "yeahs", "yealm", "yeans", "yeard", "yearn",
  "years", "yeast", "yecch", "yechs", "yechy", "yedes", "yeeds", "yeesh",
  "yeggs", "yelks", "yells", "yelms", "yelps", "yelts", "yenta", "yente",
  "yerba", "yerds", "yerks", "yeses", "yesks", "yests", "yesty", "yetis",
  "yetts", "yeuks", "yeuky", "yeven", "yeves", "yewen", "yexed", "yexes",
  "yfere", "yield", "yiked", "yikes", "yills", "yince", "yipes", "yippy",
  "yirds", "yirks", "yirrs", "yirth", "yites", "yitie", "ylems", "ylike",
  "ylkes", "ymolt", "ympes", "yobbo", "yobby", "yocks", "yodel", "yodhs",
  "yodle", "yogas", "yogee", "yoghs", "yogic", "yogin", "yogis", "yoick",
  "yojan", "yoked", "yokel", "yoker", "yokes", "yokul", "yolks", "yolky",
  "yomim", "yomps", "yonic", "yonis", "yonks", "yoofs", "yoops", "yores",
  "yorks", "yorps", "youks", "young", "yourn", "yours", "yourt", "youse",
  "youth", "yowed", "yowes", "yowie", "yowls", "yowza", "yrapt", "yrent",
  "yrivd", "yrneh", "ysame", "ytost", "yuans", "yucas", "yucca", "yucch",
  "yucko", "yucks", "yucky", "yufts", "yugas", "yuked", "yukes", "yukky",
  "yukos", "yulan", "yules", "yummo", "yummy", "yumps", "yupon", "yuppy",
  "yurta", "yurts", "yuzus", "zabra", "zacks", "zaida", "zaidy", "zaire",
  "zakat", "zaman", "zambo", "zamia", "zanja", "zante", "zanza", "zanze",
  "zappy", "zarfs", "zaris", "zatis", "zaxes", "zayin", "zazen", "zeals",
  "zebec", "zebra", "zebub", "zebus", "zedas", "zeins", "zendo", "zerda",
  "zerks", "zeros", "zests", "zesty", "zetas", "zexes", "zezes", "zhomo",
  "zibet", "ziffs", "zigan", "zilas", "zilch", "zilla", "zills", "zimbi",
  "zimbs", "zinco", "zincs", "zincy", "zineb", "zines", "zings", "zingy",
  "zinke", "zinky", "zippo", "zippy", "ziram", "zitis", "zizel", "zizit",
  "zlote", "zloty", "zoaea", "zobos", "zobus", "zocco", "zoeae", "zoeal",
  "zoeas", "zoism", "zoist", "zombi", "zonae", "zonal", "zonda", "zoned",
  "zoner", "zones", "zonks", "zooea", "zooey", "zooid", "zooks", "zooms",
  "zoons", "zooty", "zoppa", "zoppo", "zoril", "zoris", "zorro", "zouks",
  "zowee", "zowie", "zulus", "zupan", "zupas", "zuppa", "zurfs", "zuzim",
  "zygal", "zygon", "zymes", "zymic"];
val answers = [
  2009, 8991, 10069, 5232, 678, 1224, 3940, 3503, 7366, 9818, 4942, 3236,
  7025, 5704, 10731, 4590, 8786, 976, 15, 3681, 6648, 2669, 4046, 2462,
  10764, 2199, 12, 6729, 8963, 882, 8551, 3908, 4970, 2421, 10651, 7961,
  11894, 12450, 11605, 7834, 117, 2383, 10479, 9097, 2837, 2377, 2128, 10571,
  6951, 8494, 6780, 6323, 11921, 3872, 1302, 3991, 3814, 10664, 968, 5438,
  9738, 8566, 12743, 3074, 1456, 10780, 7943, 2376, 3923, 7675, 193, 3460,
  10961, 525, 1166, 2738, 3878, 11546, 12598, 4069, 9972, 7992, 1100, 6087,
  10675, 4624, 4523, 4511, 6565, 6441, 9342, 636, 6583, 4201, 6029, 5428,
  2035, 3984, 2294, 7155, 856, 9499, 161, 10563, 10614, 3474, 3834, 10550,
  5734, 4712, 6, 7144, 321, 4897, 5273, 11354, 3055, 7820, 962, 3228,
  8236, 11776, 2213, 5492, 3399, 10692, 61, 4676, 3885, 3064, 1323, 3457,
  12614, 4572, 2083, 1455, 4616, 328, 8668, 1223, 2145, 3158, 4661, 3829,
  4672, 9259, 755, 10262, 8289, 4245, 1933, 5001, 12206, 3797, 10892, 8832,
  9337, 8127, 9128, 12651, 2100, 11390, 10770, 8601, 1468, 10411, 1899, 4642,
  3545, 12001, 3434, 11627, 1437, 9155, 12163, 2236, 6742, 10419, 12184, 11581,
  12002, 8050, 1870, 878, 1412, 8351, 2382, 4647, 12376, 8198, 94, 3715,
  584, 11107, 11662, 11905, 8990, 1318, 11689, 10005, 11381, 802, 10242, 2369,
  4558, 8778, 3110, 3647, 20, 11091, 7947, 10396, 9917, 8604, 8387, 9252,
  8549, 12529, 2411, 5900, 10851, 12429, 7157, 8136, 2316, 12653, 6289, 11338,
  7045, 9866, 8325, 318, 10129, 3332, 4024, 5231, 8026, 11836, 11844, 9250,
  2563, 192, 548, 1797, 9849, 8688, 2927, 10954, 11030, 7813, 11335, 11675,
  1196, 12194, 10575, 1875, 1965, 9422, 7358, 7159, 201, 1467, 2115, 5071,
  10943, 7082, 6091, 12348, 11445, 3941, 10271, 11185, 1791, 7167, 6586, 9590,
  306, 9086, 11304, 10229, 8698, 1913, 2761, 3437, 7617, 4005, 9854, 4888,
  10781, 6499, 10351, 11671, 3735, 9874, 7359, 3744, 2217, 3975, 9630, 10658,
  1134, 10640, 9365, 1994, 6956, 10187, 9859, 1901, 385, 3840, 4015, 1761,
  7870, 8311, 7717, 5375, 587, 4964, 9964, 12899, 4896, 11600, 3686, 6105,
  3985, 10773, 4820, 11589, 5115, 754, 6916, 1726, 3729, 1621, 3611, 10244,
  11419, 6878, 12777, 2740, 956, 9670, 4409, 4196, 9680, 7074, 5048, 263,
  12234, 600, 11363, 2398, 899, 622, 6697, 2384, 9966, 8170, 4075, 2762,
  4451, 3901, 11590, 4385, 8208, 8046, 4550, 3894, 2973, 625, 8561, 479,
  1204, 1656, 6461, 5393, 4443, 689, 1469, 10278, 905, 9434, 9133, 3119,
  4262, 5252, 8257, 4171, 3312, 6296, 9828, 3756, 3919, 5258, 3836, 158,
  12417, 12212, 10683, 10661, 1000, 6618, 7468, 1146, 6366, 12382, 639, 9294,
  12261, 3896, 406, 1236, 11652, 458, 11696, 6913, 8501, 3347, 2015, 7146,
  10755, 11962, 1216, 2366, 8762, 2350, 12832, 9160, 1539, 287, 10265, 11895,
  8022, 2091, 4415, 6026, 5238, 5796, 8391, 4683, 11784, 11771, 9973, 11609,
  11919, 12345, 6862, 12624, 7655, 7388, 2122, 12503, 5423, 9384, 4255, 1927,
  7748, 8573, 4116, 1884, 4727, 5398, 12484, 11150, 6196, 2059, 11307, 6402,
  11365, 1322, 327, 11359, 3287, 3024, 7974, 1999, 10719, 11630, 290, 10433,
  8994, 9488, 6278, 4454, 4610, 115, 1474, 10384, 12007, 9617, 9666, 6182,
  11789, 10730, 1362, 6731, 10230, 2605, 12141, 5195, 3404, 12029, 5412, 3439,
  11935, 3902, 1790, 10496, 10700, 3533, 8800, 2756, 4674, 10566, 7217, 3637,
  3944, 3912, 1774, 10316, 6267, 12308, 485, 8246, 5373, 325, 8184, 3089,
  10660, 12230, 7727, 3605, 11907, 10309, 780, 11310, 4471, 8429, 5056, 10548,
  3961, 6486, 4721, 12064, 4495, 11344, 3869, 4611, 5354, 9937, 2378, 10586,
  12034, 10131, 2045, 8857, 7264, 8275, 2575, 8764, 533, 175, 12028, 7767,
  666, 10804, 9005, 7205, 4310, 8356, 9187, 2317, 5362, 11544, 12639, 7019,
  2783, 10807, 6491, 9469, 9237, 4121, 10283, 7156, 11891, 9731, 7902, 10956,
  4713, 4759, 3442, 11551, 1727, 1876, 2331, 5226, 11827, 6540, 1152, 10791,
  6686, 6828, 6202, 8784, 8007, 4394, 7658, 9219, 4657, 6167, 4644, 1779,
  6443, 9465, 10576, 473, 10169, 5127, 3792, 9887, 3301, 6973, 10200, 2765,
  12436, 10549, 2137, 3464, 10049, 8548, 10526, 3584, 5543, 3788, 10649, 1980,
  10193, 499, 7336, 7459, 12610, 4859, 4589, 2892, 10667, 2385, 12005, 2866,
  12031, 404, 7479, 7190, 1889, 9102, 8587, 10596, 4940, 9843, 2854, 563,
  7743, 10195, 3045, 2313, 7935, 1377, 10274, 3514, 2389, 6079, 3254, 5303,
  10060, 1545, 3361, 679, 3130, 426, 4534, 4076, 8017, 6039, 5230, 3342,
  6585, 3294, 6923, 9115, 12177, 4757, 8704, 12046, 2423, 12646, 10881, 6380,
  1863, 10201, 8773, 12100, 10663, 10457, 10725, 85, 461, 8708, 11080, 4899,
  6691, 694, 1430, 10951, 3530, 1105, 6519, 4038, 9224, 4340, 8334, 6538,
  12530, 10306, 7609, 5186, 1328, 7449, 6550, 3520, 45, 9599, 11572, 11741,
  8552, 5387, 1992, 6085, 2400, 3274, 3351, 2554, 5866, 1364, 7120, 11230,
  8302, 6383, 8362, 12140, 5366, 1181, 2133, 8758, 2440, 2092, 5620, 10652,
  2690, 7419, 3881, 9846, 2433, 2067, 1938, 9179, 12238, 4479, 10356, 5290,
  10582, 9195, 10302, 3913, 8821, 8593, 11288, 8449, 1528, 3743, 7055, 3043,
  5890, 11582, 1662, 8774, 3189, 7922, 10976, 8983, 9694, 10590, 3934, 5163,
  6740, 2945, 7879, 386, 7052, 7844, 1006, 8780, 2086, 6628, 11678, 10607,
  4061, 3293, 11794, 12108, 6371, 3273, 8892, 12474, 5190, 9052, 6606, 10017,
  10610, 12113, 10902, 3245, 3725, 1411, 1527, 11355, 9652, 1717, 1978, 859,
  6711, 2442, 493, 4267, 7258, 10657, 2594, 1172, 1428, 10814, 11430, 9400,
  5850, 1197, 3408, 6152, 3920, 11146, 9665, 2540, 12889, 834, 6752, 1212,
  213, 9947, 9235, 8572, 1014, 4056, 1290, 953, 731, 12377, 4304, 10469,
  4458, 1409, 9663, 12655, 9352, 598, 7647, 1200, 5416, 6118, 12578, 10031,
  12637, 3240, 10184, 10256, 10406, 342, 4927, 12645, 5585, 4444, 3886, 9345,
  2037, 12181, 9069, 2329, 293, 934, 5530, 1185, 12203, 7680, 2954, 3316,
  5578, 10044, 3505, 3416, 9982, 2899, 8469, 12619, 10940, 302, 2388, 412,
  6165, 1349, 3191, 10670, 8633, 12289, 1964, 10762, 10597, 7837, 2728, 1079,
  5298, 2058, 9763, 5178, 6131, 10011, 1193, 6800, 4605, 7548, 4876, 9905,
  3084, 2588, 8716, 10802, 1601, 11726, 2406, 5309, 12195, 4127, 4284, 2315,
  7319, 9935, 10771, 875, 647, 1900, 8559, 1422, 7836, 4129, 8961, 3334,
  3510, 5349, 2750, 8813, 4913, 1810, 10935, 2456, 3027, 4257, 12277, 9511,
  7592, 4878, 8287, 10977, 8690, 3522, 10761, 1651, 11947, 8772, 11674, 8409,
  3266, 10772, 11941, 11104, 3417, 1930, 119, 6970, 3633, 5249, 1426, 3779,
  10204, 4438, 11608, 10685, 9043, 4707, 3507, 7237, 9867, 10605, 5092, 1631,
  5390, 7815, 2850, 6250, 10871, 2975, 10726, 511, 9890, 9692, 3598, 10206,
  8058, 10033, 8453, 2857, 9794, 346, 9845, 1436, 4048, 9056, 2587, 8788,
  2438, 1492, 11712, 9883, 8473, 1147, 12144, 9862, 8210, 4036, 12456, 379,
  3667, 9893, 12622, 278, 6097, 8819, 190, 390, 1614, 2273, 10971, 5894,
  8486, 577, 8308, 2443, 11974, 10327, 9070, 29, 12159, 8862, 10790, 2846,
  2375, 339, 11329, 11631, 11762, 12596, 1221, 4636, 2881, 12452, 9571, 903,
  9587, 2215, 2129, 2391, 1787, 4615, 10357, 4064, 4520, 3139, 8588, 6557,
  10694, 4847, 1632, 12158, 12010, 10270, 96, 12617, 11138, 6388, 11584, 3794,
  581, 7024, 4251, 2121, 3391, 121, 9246, 10537, 9891, 6994, 4690, 10346,
  7996, 11550, 6624, 3367, 554, 10474, 12045, 5516, 10158, 407, 11707, 6497,
  2401, 10936, 2551, 120, 11113, 10916, 7561, 4666, 9240, 5063, 12827, 289,
  8966, 4067, 10789, 8695, 8969, 12102, 10927, 7677, 9827, 3146, 2813, 3147,
  3078, 88, 4931, 11314, 5635, 8297, 8815, 1296, 9856, 8115, 351, 2635,
  1544, 8191, 9892, 6399, 10856, 8977, 2276, 8877, 12620, 8612, 5376, 7849,
  6786, 7852, 4432, 11999, 8388, 8889, 1988, 8519, 3817, 11503, 3485, 3132,
  5305, 10930, 10732, 12461, 947, 474, 10178, 11122, 8829, 2386, 680, 1728,
  9909, 11400, 1640, 9817, 11343, 10684, 5324, 9918, 1220, 8691, 8104, 5576,
  1580, 9864, 949, 12444, 107, 10817, 10752, 11505, 1979, 3921, 149, 1191,
  1555, 2758, 1736, 10322, 1388, 5627, 6543, 10494, 659, 9957, 10247, 6509,
  3889, 8300, 2226, 11222, 3127, 8316, 1045, 8360, 151, 9598, 10697, 174,
  10659, 3239, 5886, 914, 549, 7142, 10263, 1486, 4407, 9962, 761, 6677,
  10917, 322, 9394, 12274, 8748, 10641, 10304, 2678, 6687, 10096, 7482, 5604,
  11591, 10633, 6811, 6911, 8986, 3849, 6175, 7305, 6706, 2214, 9081, 4686,
  3476, 6180, 7035, 3722, 1803, 7620, 184, 6806, 4165, 9989, 8824, 8602,
  11319, 10713, 8379, 9254, 11781, 12286, 10583, 4667, 4916, 8020, 11686, 3993,
  2724, 11881, 10962, 4395, 8531, 1021, 6221, 3071, 10225, 425, 6328, 1161,
  2894, 2519, 1819, 2873, 4677, 5158, 3126, 9977, 2467, 2495, 10746, 4613,
  6396, 12501, 1441, 8803, 1862, 1658, 1176, 2720, 3757, 6407, 1898, 3340,
  9193, 3594, 9083, 8105, 9355, 9951, 1160, 3423, 8474, 1459, 7430, 44,
  7160, 7186, 10867, 3761, 6812, 11688, 12745, 2068, 10160, 9620, 1127, 2006,
  5913, 3229, 9753, 2393, 10883, 4641, 154, 7863, 3362, 8962, 7509, 3386,
  10540, 4376, 9004, 10281, 3088, 6859, 1610, 5698, 369, 9852, 5192, 1768,
  10349, 11000, 3582, 4910, 3911, 1866, 2784, 9969, 11238, 8333, 8761, 1599,
  7574, 12365, 10749, 5523, 1189, 937, 6589, 5251, 11561, 8789, 970, 1093,
  12557, 1421, 9658, 11440, 3268, 9583, 12033, 10560, 5132, 9347, 9870, 889,
  8831, 10159, 8183, 5431, 6046, 10945, 11988, 4234, 11628, 3904, 11958, 6115,
  12515, 1457, 9134, 5107, 2688, 4609, 9842, 2941, 7165, 2710, 10368, 7772,
  2408, 12256, 7527, 3930, 5055, 9868, 3105, 7634, 1540, 11162, 1868, 3664,
  9383, 8072, 9631, 2451, 1163, 11373, 10250, 9774, 12532, 3227, 9508, 5314,
  7413, 5533, 9946, 12430, 5268, 56, 4104, 3330, 2455, 7952, 12414, 11007,
  11261, 10831, 4205, 10980, 3075, 4037, 147, 9921, 4673, 7664, 11428, 8305,
  3187, 1495, 1178, 11523, 3400, 155, 11804, 8149, 329, 4271, 7508, 3488,
  1458, 3541, 2693, 5075, 917, 5302, 12011, 11312, 10084, 257, 3443, 3335,
  10632, 8268, 9621, 9657, 4959, 1923, 10435, 1716, 12466, 10183, 8755, 5575,
  10947, 8606, 4945, 12505, 3694, 6110, 6647, 9853, 9685, 10616, 10285, 12458,
  9647, 4399, 10551, 8570, 10751, 9216, 7780, 2160, 4714, 5235, 9984, 11019,
  10275, 12649, 7523, 274, 9915, 3329, 9118, 12481, 5236, 8295, 8395, 5176,
  10975, 2069, 6688, 9403, 8641, 3785, 1083, 6179, 2120, 2603, 7845, 3561,
  1932, 7912, 6324, 2516, 9519, 635, 10303, 3557, 2098, 7368, 10635, 8151,
  794, 3854, 11943, 3262, 1996, 12385, 10812, 6178, 12566, 12528, 10598, 9540,
  1169, 9515, 11318, 12339, 6692, 1148, 10644, 10602, 8575, 2396, 5880, 3978,
  2684, 7783, 4895, 11199, 165, 12500, 5289, 10199, 5382, 2057, 5642, 1198,
  37, 11349, 11909, 8294, 10196, 11669, 10517, 9834, 7993, 7121, 1661, 11032,
  10600, 2747, 7087, 424, 950, 4147, 8010, 12349, 6537, 114, 7729, 6312,
  11013, 6612, 231, 10128, 860, 8309, 12105, 1354, 2379, 6487, 10174, 2474,
  8859, 12628, 4710, 3952, 1707, 11888, 93, 9139, 4033, 4887, 9660, 2088,
  9036, 7708, 2080, 2674, 11072, 3486, 1684, 11727, 4341, 5041, 2447, 449,
  9618, 7709, 8306, 10553, 1471, 21, 9109, 8779, 2418, 1366, 942, 3085,
  10858, 5433, 1903, 760, 4706, 1480, 702, 1881, 1747, 6170, 4889, 2524,
  8599, 10957, 7765, 11137, 6549, 4731, 6960, 4622, 1890, 6344, 11514, 542,
  1509, 2368, 7230, 31, 4794, 1351, 6650, 3225, 2911, 6360, 1493, 5499,
  3768, 9785, 4343, 10898, 6203, 3628, 3926, 945, 8607, 10258, 10180, 9655,
  11538, 7480, 2332, 12162, 11053, 7111, 12211, 7858, 11466, 3419, 1319, 12232,
  1926, 3338, 3281, 7399, 6965, 6832, 5889, 2695, 12214, 418, 557, 7254,
  11629, 1814, 3253, 1114, 4606, 7663, 11259, 12402, 11633, 2040, 2200, 9338,
  12400, 11885, 6042, 10797, 2360, 6974, 2819, 11425, 6517, 12128, 3099, 2888,
  4782, 8006, 11036, 3844, 10972, 323, 10014, 1487, 11184, 1887, 10085, 12612,
  9889, 6231, 7559, 1549, 9597, 2047, 4120, 3939, 11571, 1416, 8355, 2859,
  1626, 3108, 11648, 1047, 11237, 5971, 12618, 3076, 5259, 11326, 8930, 2153,
  858, 9693, 1612, 8180, 2324, 1706, 8590, 4937, 402, 8154, 8499, 11347,
  6784, 3720, 10618, 10579, 9961, 1665, 6617, 2928, 9579, 8909, 1092, 11619,
  7612, 6173, 368, 10592, 7287, 12504, 10414, 11562, 842, 3734, 12358, 10518,
  965, 10223, 3539, 10291, 787, 46, 7555, 12270, 9626, 4054, 682, 10299,
  9672, 4022, 3107, 6305, 3697, 7135, 7824, 12636, 9136, 11074, 8568, 5893,
  1830, 3841, 2681, 428, 2410, 9522, 9671, 5337, 8251, 10680, 12019, 1958,
  3770, 12132, 10757, 11176, 2074, 4074, 8527, 1321, 11796, 465, 10722, 8322,
  6188, 11775, 1228, 4604, 6813, 752, 1652, 1429, 10245, 8916, 3994, 3121,
  12588, 7189, 1231, 11447, 2328, 11732, 11681, 12634, 10662, 10686, 698, 8696,
  2584, 11588, 7450, 6797, 5619, 7616, 8357, 6866, 3839, 7958, 12443, 999,
  2337, 3445, 1512, 6208, 10332, 10048, 10125, 8117, 5630, 8873, 11853, 9635,
  7026, 4668, 668, 4620, 9577, 11495, 7981, 10329, 6368, 10671, 11687, 4350,
  9135, 11020, 674, 8814, 2788, 6292, 4455, 4266, 992, 7522, 4405, 2662,
  10207, 9409, 7764, 11320, 11493, 3852, 12623, 12477, 1552, 3494, 5164, 2021,
  7893, 5357, 3832, 4595, 3527, 10896, 4414, 966, 9523, 2461, 4081, 9554,
  11054, 11583, 7850, 10573, 4026, 9025, 3790, 10521, 4944, 6672, 9192, 2050,
  11690, 6533, 1341, 10599, 9581, 344, 6120, 1749, 2282, 2878, 10253, 146,
  307, 11047, 9888, 5847, 12603, 6767, 3925, 12691, 4050, 8752, 1508, 4643,
  2528, 1678, 9211, 2785, 10677, 4608, 6938, 1118, 4593, 9538, 868, 3855,
  4951, 4379, 10929, 1289, 2318, 3397, 28, 12407, 1135, 11383, 4286, 6989,
  6984, 2117, 1647, 6192, 2113, 11239, 8067, 3116, 4594, 2107, 4717, 8874,
  11089, 1049, 10279, 7170, 8045, 9808, 3080, 3767, 10514, 4412, 305, 11679,
  5728, 12172, 11267, 11245, 4108, 12941, 6889, 2523, 4602, 813, 703, 1028,
  7646, 1865, 7356, 4535, 3777, 1402, 299, 8624, 8939, 8323, 4475, 3843,
  7221, 3180, 3324, 11325, 10208, 5244, 11300, 9956, 8722, 8887, 12644, 6220,
  9954, 6676, 4079, 7436, 10824, 7100, 437, 3133, 12077, 1912, 4742, 11906,
  6251, 6457, 5330, 1649, 3137, 3519, 11691, 2993, 10535, 2407, 1935, 2432,
  10815, 11402, 872, 4246, 9332, 2359, 2527, 6125, 12560, 1564, 9099, 443,
  10363, 6880, 1499, 6621, 3104, 9646, 5906, 6629, 9300, 12585, 11334, 8676,
  8009, 3053, 5888, 12470, 8905, 2049, 403, 3113, 4537, 3358, 7255, 10808,
  1167, 9177, 6808, 3958, 9826, 12109, 8763, 3638, 4734, 4872, 7438, 4139,
  9072, 4702, 8933, 4092, 3696, 1949, 3990, 286, 12464, 8162, 4514, 8307,
  3865, 3689, 4575, 1500, 11350, 3751, 10676, 2696, 12552, 5634, 12180, 2641,
  9684, 5347, 677, 8542, 12490, 11747, 10765, 10532, 6690, 3549, 5388, 2429,
  8669, 7131, 10655, 4984, 8243, 11191, 10868, 10348, 9215, 10354, 632, 4507,
  6161, 7163, 5183, 2132, 11486, 1069, 8133, 8202, 1144, 4912, 10565, 11889,
  5402, 849, 9913, 4281, 9256, 4700, 10698, 6377, 9622, 9678, 6695, 4971,
  12065, 7787, 3706, 5899, 3542, 2227, 97, 12525, 8403, 8955, 10140, 3585,
  11534, 6748, 6853, 11246, 10192, 9220, 11799, 8049, 3929, 1793, 6409, 3322,
  9258, 9230, 11940, 9039, 445, 128, 5614, 9359, 568, 9424, 9873];

fun mask (guess, answer) =
  let
    fun mask2 (m, i, [], answer) = m
      | mask2 (m, i, letter :: rest, answer) =
          mask2 ((m * 3
            + (if String.sub (answer, i) = letter then 2
             else if String.isSubstring (str letter) answer then 1
             else 0)), i + 1, rest, answer)
  in
    mask2 (0, 0, explode guess, answer)
  end;

(*) should be 0 (no letters in common)
mask ("abcde", "troll");
(*) should be 2 (last letter is correct)
mask ("abcde", "sprue");
(*) should be 1 (last letter exists)
mask ("abcde", "sprew");
(*) should be 2 (last letter is correct and exists elsewhere)
mask ("abcde", "spree");
(*) should be 6 (second to last letter is correct)
mask ("abcde", "spuds");

Sys.set ("matchCoverageEnabled", false);
fun maskToString m =
  let
    fun maskToString2 (m, s, 0) = s
      | maskToString2 (m, s, k) =
        maskToString2 (m div 3,
          (case (m mod 3) of
              0 => "b"
            | 1 => "y"
            | 2 => "g") ^ s,
          k - 1)
  in
    maskToString2 (m, "", 5)
  end;
Sys.unset "matchCoverageEnabled";

maskToString 0;
maskToString 1;
maskToString 5;
maskToString (mask ("abcde", "spuds"));

(* For a guess, returns the number of mask groups.
   The expected size of a mask group is the number of remaining
   words divided by the number of groups. For all guesses, the
   number of remaining words is the same. Therefore the best guess
   is the one that returns the most mask groups. *)
fun f (guess, remainingWords) =
  from w in remainingWords
    group m = mask (guess, w) compute c = count
    compute count;

(* Returns the best guesses in "sampleWords".
   A good guess is one that, in the worst case scenario,
   namely a mask shared by a lot of words, minimizes the
   size of that set of words. *)
fun bestGuesses2 (sampleWords, remainingWords) =
  from w in sampleWords,
    f = f (w, remainingWords)
    order f desc;

fun bestGuesses words =
  bestGuesses2 (words, words);

(*) Run on a sample of 500 words; faster than the full set of 12,972 words.
val sampleWords = if slow then words else List.take (words, 200);
bestGuesses2 (sampleWords, words);

(* Returns the words left after applying a set of filters from previous
   guesses. *)
fun remaining (words, []) = words
  | remaining (words, (guess, m) :: rest) =
      from w in (remaining (words, rest))
        where maskToString (mask (guess, w)) = m;

fun remaining2 (words, guess, m) =
  from w in words
    where mask (guess, w) = m;

(*) Solve puzzle #164 by guessing "stage", "tumor" then "troll".
remaining (words, [("stage", "bybbb")]);
remaining (words, [("stage", "bybbb"),
                   ("tumor", "gbbyy")]);
remaining (words, [("stage", "bybbb"),
                   ("tumor", "gbbyy"),
                   ("troll", "ggggg")]);

(*) Solve puzzle #164 by taking the best guess at each step.
bestGuesses (remaining (words, [("serai", "bbybb")]));
bestGuesses (remaining (words, [("serai", "bbybb"),
                                ("court", "bybyy")]));
bestGuesses (remaining (words, [("serai", "bbybb"),
                                ("court", "bybyy"),
                                ("troop", "gggyb")]));
bestGuesses (remaining (words, [("serai", "bbybb"),
                                ("court", "bybyy"),
                                ("troop", "gggyb"),
                                ("troll", "ggggg")]));

(*) Solves the puzzle from a starting word.
fun solve (firstGuess, answer, words) =
  let
    fun solve2 ([], steps) = "*" :: steps
      | solve2 (remainingWord :: nil, steps) = remainingWord :: steps
      | solve2 (remainingWords, steps) =
      case (bestGuesses remainingWords) of
          [] => "*" :: steps
        | {f, w = guess} :: guesses =>
            solve3 (guess, remainingWords, steps)
    and solve3 (guess, remainingWords, steps) =
      if guess = answer then
        guess :: steps
      else
        solve2 (remaining2 (remainingWords,
                            guess,
                            mask (guess, answer)),
                guess :: steps)
  in
    List.rev (solve3 (firstGuess, words, []))
  end;

solve ("tares", "unify", words);
if slow then solve ("paseo", "unify", words) else [];
if slow then solve ("xenon", "unify", words) else [];

(*) End wordle.sml
