/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.CompiledStatement;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Environments;
import net.hydromatic.morel.compile.Tracer;
import net.hydromatic.morel.compile.Tracers;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.Prop;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.foreign.ForeignValue;
import net.hydromatic.morel.parse.MorelParserImpl;
import net.hydromatic.morel.parse.ParseException;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.MorelException;
import net.hydromatic.morel.util.Static;

public class Main {
    private final BufferedReader in;
    private final PrintWriter out;
    private final boolean echo;
    private final Map<String, ForeignValue> valueMap;
    final TypeSystem typeSystem = new TypeSystem();
    final boolean idempotent;
    final Session session;

    public static void main(String[] args) {
        ImmutableList argList = ImmutableList.copyOf((Object[])args);
        ImmutableMap valueMap = ImmutableMap.of();
        LinkedHashMap<Prop, Object> propMap = new LinkedHashMap<Prop, Object>();
        Prop.DIRECTORY.set(propMap, new File(System.getProperty("user.dir")));
        Main main = new Main((List<String>)argList, System.in, System.out, (Map<String, ForeignValue>)valueMap, propMap, false);
        try {
            main.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Main(List<String> args, InputStream in, PrintStream out, Map<String, ForeignValue> valueMap, Map<Prop, Object> propMap, boolean idempotent) {
        this(args, new InputStreamReader(in), new OutputStreamWriter(out), valueMap, propMap, idempotent);
    }

    public Main(List<String> argList, Reader in, Writer out, Map<String, ForeignValue> valueMap, Map<Prop, Object> propMap, boolean idempotent) {
        this.in = Main.buffer(idempotent ? Main.stripOutLines(in) : in);
        this.out = Main.buffer(out);
        this.echo = argList.contains("--echo");
        this.valueMap = ImmutableMap.copyOf(valueMap);
        this.session = new Session(propMap);
        this.idempotent = idempotent;
    }

    private static void readerToString(Reader r, StringBuilder b) {
        char[] chars = new char[1024];
        try {
            while (true) {
                int read;
                if ((read = r.read(chars)) < 0) {
                    return;
                }
                b.append(chars, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Reader stripOutLines(Reader in) {
        StringBuilder b = new StringBuilder();
        Main.readerToString(in, b);
        String s = Static.str(b);
        int i = 0;
        int n = s.length();
        while (true) {
            int k;
            int j3;
            int j2;
            int j1;
            int j0;
            int j;
            if ((j = Main.min(j0 = i == 0 && s.startsWith("> ") ? 0 : -1, j1 = s.indexOf("\n> ", i), j2 = s.indexOf("(*)", i), j3 = s.indexOf("(*", i))) < 0) break;
            if (j == j0 || j == j1) {
                b.append(s, i, j);
                k = s.indexOf("\n", j + 2);
                if (k < 0) {
                    k = n;
                }
                i = k;
                continue;
            }
            if (j == j2) {
                k = s.indexOf("\n", j + "(*)".length());
                if (k < 0) {
                    k = n;
                }
                b.append(s, i, k);
                i = k;
                continue;
            }
            if (j != j3) continue;
            k = s.indexOf("*)", j + "(*".length());
            if (k < 0) {
                k = n;
            }
            b.append(s, i, k);
            i = k;
        }
        b.append(s, i, n);
        return new StringReader(b.toString());
    }

    private static int min(int ... ints) {
        int count = 0;
        int min = Integer.MAX_VALUE;
        for (int i : ints) {
            if (i < 0) continue;
            ++count;
            if (i >= min) continue;
            min = i;
        }
        return count == 0 ? -1 : min;
    }

    private static PrintWriter buffer(Writer out) {
        if (out instanceof PrintWriter) {
            return (PrintWriter)out;
        }
        if (!(out instanceof BufferedWriter)) {
            out = new BufferedWriter(out);
        }
        return new PrintWriter(out);
    }

    private static BufferedReader buffer(Reader in) {
        if (in instanceof BufferedReader) {
            return (BufferedReader)in;
        }
        return new BufferedReader(in);
    }

    public void run() {
        Environment env = Environments.env(this.typeSystem, this.session, this.valueMap);
        Consumer<String> echoLines = this.out::println;
        Consumer<String> outLines = this.idempotent ? x -> this.out.println("> " + x.replace("\n", "\n> ")) : echoLines;
        LinkedHashMap<String, Binding> outBindings = new LinkedHashMap<String, Binding>();
        Shell shell = new Shell(this, env, echoLines, outLines, outBindings);
        this.session.withShell(shell, outLines, session1 -> shell.run((Session)session1, new BufferingReader(this.in)));
        this.out.flush();
    }

    static class Shell
    implements Session.Shell {
        protected final Main main;
        protected final Environment env0;
        protected final Consumer<String> echoLines;
        protected final Consumer<String> outLines;
        protected final Map<String, Binding> bindingMap;

        Shell(Main main, Environment env0, Consumer<String> echoLines, Consumer<String> outLines, Map<String, Binding> bindingMap) {
            this.main = main;
            this.env0 = env0;
            this.echoLines = echoLines;
            this.outLines = outLines;
            this.bindingMap = bindingMap;
        }

        void run(Session session, BufferingReader in2) {
            MorelParserImpl parser = new MorelParserImpl(in2);
            SubShell subShell = new SubShell(this.main, this.echoLines, this.outLines, this.bindingMap, this.env0);
            block2: while (true) {
                try {
                    while (true) {
                        parser.zero("stdIn");
                        AstNode statement = parser.statementSemicolonOrEof();
                        String code = in2.flush();
                        if (this.main.idempotent && code.startsWith("\n")) {
                            code = code.substring(1);
                        }
                        if (statement == null && code.endsWith("\n")) {
                            code = code.substring(0, code.length() - 1);
                        }
                        if (this.main.echo) {
                            this.echoLines.accept(code);
                        }
                        if (statement == null) break block2;
                        session.withShell(subShell, this.outLines, session1 -> subShell.command(statement, this.outLines));
                    }
                }
                catch (ParseException e) {
                    String message = e.getMessage();
                    if (message.startsWith("Encountered \"<EOF>\" ")) break;
                    String code = in2.flush();
                    if (this.main.echo) {
                        this.outLines.accept(code);
                    }
                    this.outLines.accept(message);
                    if (code.length() != 0) continue;
                }
                break;
            }
        }

        @Override
        public void use(String fileName, Pos pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handle(RuntimeException e, StringBuilder buf) {
            if (e instanceof MorelException) {
                MorelException me = (MorelException)((Object)e);
                me.describeTo(buf).append("\n").append("  raised at: ");
                me.pos().describeTo(buf);
            } else {
                buf.append(e);
            }
        }
    }

    static class BufferingReader
    extends FilterReader {
        final StringBuilder buf = new StringBuilder();

        protected BufferingReader(Reader in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int c = super.read();
            this.buf.append(c);
            return c;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int n = super.read(cbuf, off, 1);
            if (n > 0) {
                this.buf.append(cbuf, off, n);
            }
            return n;
        }

        public String flush() {
            return Static.str(this.buf);
        }
    }

    static class SubShell
    extends Shell {
        SubShell(Main main, Consumer<String> echoLines, Consumer<String> outLines, Map<String, Binding> outBindings, Environment env0) {
            super(main, env0, echoLines, outLines, outBindings);
        }

        @Override
        public void use(String fileName, Pos pos) {
            this.outLines.accept("[opening " + fileName + "]");
            File file = new File(fileName);
            if (!file.isAbsolute()) {
                File directory = Prop.SCRIPT_DIRECTORY.fileValue(this.main.session.map);
                file = new File(directory, fileName);
            }
            if (!file.exists()) {
                this.outLines.accept("[use failed: Io: openIn failed on " + fileName + ", No such file or directory]");
                throw new Codes.MorelRuntimeException(Codes.BuiltInExn.ERROR, pos);
            }
            try (FileReader fileReader = new FileReader(file);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                this.run(this.main.session, new BufferingReader(bufferedReader));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        void command(AstNode statement, Consumer<String> outLines) {
            try {
                Environment env = this.env0.bindAll(this.bindingMap.values());
                Tracer tracer = Tracers.empty();
                CompiledStatement compiled = Compiles.prepareStatement(this.main.typeSystem, this.main.session, env, statement, null, e -> this.appendToOutput((MorelException)e, outLines), tracer);
                ArrayList bindings = new ArrayList();
                compiled.eval(this.main.session, env, outLines, bindings::add);
                bindings.forEach(b -> this.bindingMap.put(b.id.name, b));
            }
            catch (Codes.MorelRuntimeException e2) {
                this.appendToOutput(e2, outLines);
            }
        }

        private void appendToOutput(MorelException e, Consumer<String> outLines) {
            StringBuilder buf = new StringBuilder();
            this.main.session.handle(e, buf);
            outLines.accept(buf.toString());
        }
    }
}

