/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Runnables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.compile.CompiledStatement;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Environments;
import net.hydromatic.morel.compile.Tracer;
import net.hydromatic.morel.compile.Tracers;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.eval.Prop;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.foreign.Calcite;
import net.hydromatic.morel.foreign.ForeignValue;
import net.hydromatic.morel.parse.MorelParserImpl;
import net.hydromatic.morel.parse.ParseException;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.MorelException;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class Shell {
    private final ConfigImpl config;
    private final Terminal terminal;

    public static void main(String[] args) {
        try {
            Config config = Shell.parse(ConfigImpl.DEFAULT.withDirectory(new File(System.getProperty("user.dir"))), (List<String>)ImmutableList.copyOf((Object[])args));
            Shell main = Shell.create(config, System.in, (OutputStream)System.out);
            main.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Shell create(List<String> args, InputStream in, OutputStream out) throws IOException {
        Config config = Shell.parse(ConfigImpl.DEFAULT, args);
        return Shell.create(config, in, out);
    }

    public static Shell create(Config config, InputStream in, OutputStream out) throws IOException {
        TerminalBuilder builder = TerminalBuilder.builder();
        builder.streams(in, out);
        ConfigImpl configImpl = (ConfigImpl)config;
        builder.system(configImpl.system);
        builder.dumb(configImpl.dumb);
        if (configImpl.dumb) {
            builder.type("dumb");
        }
        Terminal terminal = builder.build();
        return new Shell(config, terminal);
    }

    public Shell(Config config, Terminal terminal) {
        this.config = (ConfigImpl)config;
        this.terminal = terminal;
    }

    public static Config parse(Config config, List<String> argList) {
        ConfigImpl c = (ConfigImpl)config;
        ImmutableMap.Builder valueMapBuilder = ImmutableMap.builder();
        for (String arg : argList) {
            if (arg.equals("--banner=false")) {
                c = c.withBanner(false);
            }
            if (arg.equals("--terminal=dumb")) {
                c = c.withDumb(true);
            }
            if (arg.equals("--echo")) {
                c = c.withEcho(true);
            }
            if (arg.equals("--help")) {
                c = c.withHelp(true);
            }
            if (arg.equals("--system=false")) {
                c = c.withSystem(false);
            }
            if (arg.startsWith("--foreign=")) {
                String className = arg.substring("--foreign=".length());
                Map map = Shell.instantiate(className, Map.class);
                valueMapBuilder.putAll(Calcite.withDataSets(map).foreignValues());
            }
            if (arg.startsWith("--directory=")) {
                String directoryPath = arg.substring("--directory=".length());
                c = c.withDirectory(new File(directoryPath));
            }
            if (!arg.startsWith("--maxUseDepth=")) continue;
            int maxUseDepth = Integer.parseInt(arg.substring("--maxUseDepth=".length()));
            c = c.withMaxUseDepth(maxUseDepth);
        }
        return c.withValueMap((Map)valueMapBuilder.build());
    }

    static void usage(Consumer<String> outLines) {
        String[] usageLines = new String[]{"Usage: java " + Shell.class.getName()};
        Arrays.asList(usageLines).forEach(outLines);
    }

    static void help(Consumer<String> outLines) {
        String[] helpLines = new String[]{"List of available commands:", "    help   Print this help", "    quit   Quit shell"};
        Arrays.asList(helpLines).forEach(outLines);
    }

    protected final void pause() {
        this.config.pauseFn.run();
    }

    private static boolean canIgnoreLine(StringBuilder buf, String line) {
        String trimmedLine = line.replaceAll("\\(\\*.*\\*\\)", "").replaceAll("\\(\\*\\) .*$", "").trim();
        return buf.length() == 0 && (trimmedLine.isEmpty() || trimmedLine.equals(";"));
    }

    private String banner() {
        return "morel version 0.4.0 (java version \"" + System.getProperty("java.version") + "\", JRE " + System.getProperty("java.vendor.version") + " (build " + System.getProperty("java.vm.version") + "), " + this.terminal.getName() + ", " + this.terminal.getType() + ")";
    }

    public void run() {
        if (this.config.help) {
            Shell.usage(this.terminal.writer()::println);
            return;
        }
        DefaultParser parser = new DefaultParser(){
            {
                this.setEofOnUnclosedQuote(true);
                this.setEofOnUnclosedBracket(new DefaultParser.Bracket[]{DefaultParser.Bracket.CURLY, DefaultParser.Bracket.ROUND, DefaultParser.Bracket.SQUARE});
            }

            public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
                if (line.matches(".*\\(\\*\\).*")) {
                    line = line.replaceAll("\\(\\*\\).*$", "");
                }
                return super.parse(line, cursor, context);
            }
        };
        String equalsPrompt = new AttributedStringBuilder().style(AttributedStyle.DEFAULT.bold()).append((CharSequence)"=").style(AttributedStyle.DEFAULT).append((CharSequence)" ").toAnsi(this.terminal);
        String minusPrompt = new AttributedStringBuilder().style(AttributedStyle.DEFAULT.bold()).append((CharSequence)"-").style(AttributedStyle.DEFAULT).append((CharSequence)" ").toAnsi(this.terminal);
        if (this.config.banner) {
            this.terminal.writer().println(this.banner());
        }
        LineReader lineReader = LineReaderBuilder.builder().appName("morel").terminal(this.terminal).parser((Parser)parser).variable("secondary-prompt-pattern", (Object)equalsPrompt).build();
        this.pause();
        TypeSystem typeSystem = new TypeSystem();
        LinkedHashMap<Prop, Object> map = new LinkedHashMap<Prop, Object>();
        Prop.DIRECTORY.set(map, this.config.directory);
        Prop.SCRIPT_DIRECTORY.set(map, this.config.directory);
        Session session = new Session(map);
        Environment env = Environments.env(typeSystem, session, (Map<String, ForeignValue>)this.config.valueMap);
        TerminalLineFn lineFn = new TerminalLineFn(minusPrompt, equalsPrompt, lineReader);
        SubShell subShell = new SubShell(1, this.config.maxUseDepth, lineFn, this.config.echo, typeSystem, env, this.terminal.writer()::println, session, this.config.directory);
        LinkedHashMap<String, Binding> bindings = new LinkedHashMap<String, Binding>();
        subShell.extracted(bindings);
    }

    @Nonnull
    private static <T> T instantiate(String className, Class<T> clazz) {
        try {
            Class<?> aClass = Class.forName(className);
            return clazz.cast(aClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot load class: " + className, e);
        }
    }

    private static class ConfigImpl
    implements Config {
        private final boolean banner;
        private final boolean dumb;
        private final boolean echo;
        private final boolean help;
        private final boolean system;
        private final ImmutableMap<String, ForeignValue> valueMap;
        private final File directory;
        private final Runnable pauseFn;
        private final int maxUseDepth;

        private ConfigImpl(boolean banner, boolean dumb, boolean system, boolean echo, boolean help, ImmutableMap<String, ForeignValue> valueMap, File directory, Runnable pauseFn, int maxUseDepth) {
            this.banner = banner;
            this.dumb = dumb;
            this.system = system;
            this.echo = echo;
            this.help = help;
            this.valueMap = Objects.requireNonNull(valueMap, "valueMap");
            this.directory = Objects.requireNonNull(directory, "directory");
            this.pauseFn = Objects.requireNonNull(pauseFn, "pauseFn");
            this.maxUseDepth = maxUseDepth;
        }

        @Override
        public ConfigImpl withBanner(boolean banner) {
            if (this.banner == banner) {
                return this;
            }
            return new ConfigImpl(banner, this.dumb, this.system, this.echo, this.help, this.valueMap, this.directory, this.pauseFn, this.maxUseDepth);
        }

        @Override
        public ConfigImpl withDumb(boolean dumb) {
            if (this.dumb == dumb) {
                return this;
            }
            return new ConfigImpl(this.banner, dumb, this.system, this.echo, this.help, this.valueMap, this.directory, this.pauseFn, this.maxUseDepth);
        }

        @Override
        public ConfigImpl withSystem(boolean system) {
            if (this.system == system) {
                return this;
            }
            return new ConfigImpl(this.banner, this.dumb, system, this.echo, this.help, this.valueMap, this.directory, this.pauseFn, this.maxUseDepth);
        }

        @Override
        public ConfigImpl withEcho(boolean echo) {
            if (this.echo == echo) {
                return this;
            }
            return new ConfigImpl(this.banner, this.dumb, this.system, echo, this.help, this.valueMap, this.directory, this.pauseFn, this.maxUseDepth);
        }

        @Override
        public ConfigImpl withHelp(boolean help) {
            if (this.help == help) {
                return this;
            }
            return new ConfigImpl(this.banner, this.dumb, this.system, this.echo, help, this.valueMap, this.directory, this.pauseFn, this.maxUseDepth);
        }

        @Override
        public ConfigImpl withValueMap(Map<String, ForeignValue> valueMap) {
            if (this.valueMap.equals(valueMap)) {
                return this;
            }
            ImmutableMap immutableValueMap = ImmutableMap.copyOf(valueMap);
            return new ConfigImpl(this.banner, this.dumb, this.system, this.echo, this.help, (ImmutableMap<String, ForeignValue>)immutableValueMap, this.directory, this.pauseFn, this.maxUseDepth);
        }

        @Override
        public ConfigImpl withDirectory(File directory) {
            if (this.directory.equals(directory)) {
                return this;
            }
            return new ConfigImpl(this.banner, this.dumb, this.system, this.echo, this.help, this.valueMap, directory, this.pauseFn, this.maxUseDepth);
        }

        @Override
        public Config withPauseFn(Runnable pauseFn) {
            if (this.pauseFn.equals(pauseFn)) {
                return this;
            }
            return new ConfigImpl(this.banner, this.dumb, this.system, this.echo, this.help, this.valueMap, this.directory, pauseFn, this.maxUseDepth);
        }

        @Override
        public ConfigImpl withMaxUseDepth(int maxUseDepth) {
            if (this.maxUseDepth == maxUseDepth) {
                return this;
            }
            return new ConfigImpl(this.banner, this.dumb, this.system, this.echo, this.help, this.valueMap, this.directory, this.pauseFn, maxUseDepth);
        }
    }

    public static interface Config {
        public static final Config DEFAULT = new ConfigImpl(true, false, true, false, false, ImmutableMap.of(), new File(""), Runnables.doNothing(), -1);

        public Config withBanner(boolean var1);

        public Config withDumb(boolean var1);

        public Config withSystem(boolean var1);

        public Config withEcho(boolean var1);

        public Config withHelp(boolean var1);

        public Config withValueMap(Map<String, ForeignValue> var1);

        public Config withDirectory(File var1);

        public Config withPauseFn(Runnable var1);

        public Config withMaxUseDepth(int var1);
    }

    private static class TerminalLineFn
    implements LineFn {
        private final String minusPrompt;
        private final String equalsPrompt;
        private final LineReader lineReader;

        TerminalLineFn(String minusPrompt, String equalsPrompt, LineReader lineReader) {
            this.minusPrompt = minusPrompt;
            this.equalsPrompt = equalsPrompt;
            this.lineReader = lineReader;
        }

        @Override
        public Pair<LineType, String> read(StringBuilder buf) {
            String line;
            try {
                String prompt = buf.length() == 0 ? this.minusPrompt : this.equalsPrompt;
                String rightPrompt = null;
                line = this.lineReader.readLine(prompt, rightPrompt, (MaskingCallback)null, null);
            }
            catch (UserInterruptException e) {
                return Pair.of(LineType.INTERRUPT, "");
            }
            catch (EndOfFileException e) {
                return Pair.of(LineType.EOF, "");
            }
            if (Shell.canIgnoreLine(buf, line)) {
                return Pair.of(LineType.IGNORE, "");
            }
            if (line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) {
                return Pair.of(LineType.QUIT, "");
            }
            ParsedLine pl = this.lineReader.getParser().parse(line, 0);
            if ("help".equals(pl.word()) || "?".equals(pl.word())) {
                return Pair.of(LineType.HELP, "");
            }
            return Pair.of(LineType.REGULAR, pl.line());
        }
    }

    static class SubShell {
        private final int depth;
        private final int maxDepth;
        private final LineFn lineFn;
        private final boolean echo;
        private final TypeSystem typeSystem;
        private final Environment env;
        private final Consumer<String> outLines;
        private final Session session;
        private final File directory;

        SubShell(int depth, int maxDepth, LineFn lineFn, boolean echo, TypeSystem typeSystem, Environment env, Consumer<String> outLines, Session session, File directory) {
            this.depth = depth;
            this.maxDepth = maxDepth;
            this.lineFn = lineFn;
            this.echo = echo;
            this.typeSystem = typeSystem;
            this.env = env;
            this.outLines = outLines;
            this.session = session;
            this.directory = directory;
        }

        void extracted(@Nullable Map<String, Binding> outBindings) {
            StringBuilder buf = new StringBuilder();
            LinkedHashMap<String, Binding> bindingMap = new LinkedHashMap<String, Binding>();
            ArrayList bindings = new ArrayList();
            Environment env1 = this.env;
            while (true) {
                Pair<LineType, String> line = this.lineFn.read(buf);
                switch (((LineType)((Object)line.left)).ordinal()) {
                    case 0: 
                    case 1: {
                        return;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        Shell.help(this.outLines);
                        buf.append((String)line.right).append("\n");
                        break;
                    }
                    case 5: {
                        try {
                            buf.append((String)line.right);
                            if (((String)line.right).endsWith(";")) {
                                String code = Static.str(buf);
                                MorelParserImpl smlParser = new MorelParserImpl(new StringReader(code));
                                try {
                                    smlParser.zero("stdIn");
                                    AstNode statement = smlParser.statementSemicolon();
                                    Environment env0 = env1;
                                    ArrayList warningList = new ArrayList();
                                    Tracer tracer = Tracers.empty();
                                    CompiledStatement compiled = Compiles.prepareStatement(this.typeSystem, this.session, env0, statement, null, warningList::add, tracer);
                                    Use shell = new Use(env0, bindingMap);
                                    this.session.withShell(shell, this.outLines, session1 -> compiled.eval((Session)session1, env0, this.outLines, bindings::add));
                                    bindings.forEach(b -> bindingMap.put(b.id.name, (Binding)b));
                                    env1 = env0.bindAll(bindingMap.values());
                                    if (outBindings != null) {
                                        outBindings.putAll(bindingMap);
                                    }
                                    bindingMap.clear();
                                    bindings.clear();
                                }
                                catch (CompileException | ParseException e) {
                                    this.outLines.accept(e.getMessage());
                                }
                                if (!this.echo) break;
                                this.outLines.accept(code);
                                break;
                            }
                            buf.append("\n");
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            this.outLines.accept(e.getMessage());
                        }
                    }
                }
            }
        }

        private class Use
        implements Session.Shell {
            private final Environment env;
            private final Map<String, Binding> bindings;

            Use(Environment env, Map<String, Binding> bindings) {
                this.env = env;
                this.bindings = bindings;
            }

            @Override
            public void use(String fileName, Pos pos) {
                SubShell.this.outLines.accept("[opening " + fileName + "]");
                File file = new File(fileName);
                if (!file.isAbsolute()) {
                    file = new File(SubShell.this.directory, fileName);
                }
                if (!file.exists()) {
                    SubShell.this.outLines.accept("[use failed: Io: openIn failed on " + fileName + ", No such file or directory]");
                    throw new Codes.MorelRuntimeException(Codes.BuiltInExn.ERROR, pos);
                }
                if (SubShell.this.depth > SubShell.this.maxDepth && SubShell.this.maxDepth >= 0) {
                    SubShell.this.outLines.accept("[use failed: Io: openIn failed on " + fileName + ", Too many open files]");
                    throw new Codes.MorelRuntimeException(Codes.BuiltInExn.ERROR, pos);
                }
                try (FileReader fileReader = new FileReader(file);
                     BufferedReader bufferedReader = new BufferedReader(fileReader);){
                    SubShell subShell = new SubShell(SubShell.this.depth + 1, SubShell.this.maxDepth, new ReaderLineFn(bufferedReader), false, SubShell.this.typeSystem, this.env, SubShell.this.outLines, SubShell.this.session, SubShell.this.directory);
                    subShell.extracted(this.bindings);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void handle(RuntimeException e, StringBuilder buf) {
                if (SubShell.this.depth != 1) {
                    throw e;
                }
                if (e instanceof MorelException) {
                    MorelException me = (MorelException)((Object)e);
                    me.describeTo(buf).append("\n").append("  raised at: ");
                    me.pos().describeTo(buf);
                } else {
                    buf.append(e);
                }
            }
        }
    }

    static interface LineFn {
        public Pair<LineType, String> read(StringBuilder var1);
    }

    static class ReaderLineFn
    implements LineFn {
        private final BufferedReader reader;

        ReaderLineFn(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public Pair<LineType, String> read(StringBuilder buf) {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    return Pair.of(LineType.EOF, "");
                }
                if (Shell.canIgnoreLine(buf, line)) {
                    return Pair.of(LineType.IGNORE, "");
                }
                return Pair.of(LineType.REGULAR, line);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static enum LineType {
        QUIT,
        EOF,
        INTERRUPT,
        IGNORE,
        HELP,
        REGULAR;

    }
}

