/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.util.Pair;
import org.apache.calcite.util.mapping.IntPair;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Pos {
    public static final Pos ZERO = new Pos("", 0, 0, 0, 0);
    public final String file;
    public final int startLine;
    public final int startColumn;
    public final int endLine;
    public final int endColumn;

    public Pos(String file, int startLine, int startColumn, int endLine, int endColumn) {
        this.file = file;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public static Pos of(String ml, String file, int startOffset, int endOffset) {
        IntPair start = Pos.lineCol(ml, startOffset);
        IntPair end = Pos.lineCol(ml, endOffset);
        return new Pos(file, start.source, start.target, end.source, end.target);
    }

    public static Pair<@NonNull String, @NonNull Pos> split(String s, char delimiter, String file) {
        int i = s.indexOf(delimiter);
        int j = s.indexOf(delimiter, i + 1);
        int k = s.indexOf(delimiter, j + 1);
        if (i < 0 || j <= i || k >= 0) {
            throw new IllegalArgumentException("expected exactly two occurrences of delimiter, '" + delimiter + "'");
        }
        String s2 = s.substring(0, i) + s.substring(i + 1, j) + s.substring(j + 1);
        Pos pos = Pos.of(s2, file, i, j - 1);
        return Pair.of(s2, pos);
    }

    public int hashCode() {
        return Objects.hash(this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Pos && this.startLine == ((Pos)o).startLine && this.startColumn == ((Pos)o).startColumn && this.endLine == ((Pos)o).endLine && this.endColumn == ((Pos)o).endColumn;
    }

    public String toString() {
        return this.describeTo(new StringBuilder()).toString();
    }

    public StringBuilder describeTo(StringBuilder buf) {
        buf.append(this.file).append(this.file.isEmpty() ? "" : ":").append(this.startLine).append('.').append(this.startColumn);
        if (this.endColumn != this.startColumn + 1 || this.endLine != this.startLine) {
            buf.append('-').append(this.endLine).append('.').append(this.endColumn);
        }
        return buf;
    }

    public static Pos sum(Iterable<Pos> poses) {
        List list = poses instanceof List ? (List)poses : Lists.newArrayList(poses);
        return Pos.sum_(list);
    }

    public static <E> Pos sum(Iterable<E> elements, Function<E, Pos> fn) {
        return Pos.sum(Iterables.transform(elements, fn::apply));
    }

    public static Pos sum(List<? extends AstNode> nodes) {
        return Pos.sum(nodes, node -> node.pos);
    }

    private static Pos sum_(final List<Pos> positions) {
        switch (positions.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return positions.get(0);
            }
        }
        AbstractList<Pos> poses = new AbstractList<Pos>(){

            @Override
            public Pos get(int index) {
                return (Pos)positions.get(index + 1);
            }

            @Override
            public int size() {
                return positions.size() - 1;
            }
        };
        Pos p = positions.get(0);
        return Pos.sum((Iterable<Pos>)poses, p.startLine, p.startColumn, p.endLine, p.endColumn);
    }

    private static Pos sum(Iterable<Pos> poses, int line, int column, int endLine, int endColumn) {
        String file = Pos.ZERO.file;
        for (Pos pos : poses) {
            if (pos == null || pos.equals(ZERO)) continue;
            file = pos.file;
            int testLine = pos.startLine;
            int testColumn = pos.startColumn;
            if (testLine < line || testLine == line && testColumn < column) {
                line = testLine;
                column = testColumn;
            }
            testLine = pos.endLine;
            testColumn = pos.endColumn;
            if (testLine <= endLine && (testLine != endLine || testColumn <= endColumn)) continue;
            endLine = testLine;
            endColumn = testColumn;
        }
        return new Pos(file, line, column, endLine, endColumn);
    }

    public Pos plus(Pos pos) {
        int startLine = this.startLine;
        int startColumn = this.startColumn;
        if (pos.startLine < startLine || pos.startLine == startLine && pos.startColumn < startColumn) {
            startLine = pos.startLine;
            startColumn = pos.startColumn;
        }
        int endLine = pos.endLine;
        int endColumn = pos.endColumn;
        if (this.endLine > endLine || this.endLine == endLine && this.endColumn > endColumn) {
            endLine = this.endLine;
            endColumn = this.endColumn;
        }
        return new Pos(this.file, startLine, startColumn, endLine, endColumn);
    }

    public Pos plusAll(Iterable<Pos> poses) {
        return Pos.sum(poses, this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public Pos plusAll(@Nonnull List<? extends AstNode> nodes) {
        return this.plusAll(Lists.transform(nodes, node -> node.pos));
    }

    private static IntPair lineCol(String s, int offset) {
        int i;
        int line = 1;
        int lineStart = 0;
        int n = Math.min(s.length(), offset);
        for (i = 0; i < n; ++i) {
            if (s.charAt(i) != '\n') continue;
            ++line;
            lineStart = i + 1;
        }
        if (i == offset) {
            return IntPair.of((int)line, (int)(offset - lineStart + 1));
        }
        throw new IllegalArgumentException("not found");
    }
}

