/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.compile.EnvVisitor;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.type.TypeSystem;

public class Analyzer
extends EnvVisitor {
    private final Map<Core.NamedPat, MutableUse> map;

    private static Analyzer of(TypeSystem typeSystem, Environment env) {
        return new Analyzer(typeSystem, env, new HashMap<Core.NamedPat, MutableUse>(), new ArrayDeque<EnvVisitor.FromContext>());
    }

    private Analyzer(TypeSystem typeSystem, Environment env, Map<Core.NamedPat, MutableUse> map, Deque<EnvVisitor.FromContext> fromStack) {
        super(typeSystem, env, fromStack);
        this.map = map;
    }

    public static Analysis analyze(TypeSystem typeSystem, Environment env, AstNode node) {
        Analyzer analyzer = Analyzer.of(typeSystem, env);
        if (node instanceof Core.NonRecValDecl) {
            analyzer.use((Core.NamedPat)((Core.NonRecValDecl)node).pat).top = true;
        }
        node.accept(analyzer);
        return analyzer.result();
    }

    private Analysis result() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.map.forEach((k, v) -> b.put(k, (Object)v.fix()));
        return new Analysis((ImmutableMap<Core.NamedPat, Use>)b.build());
    }

    @Override
    protected Analyzer push(Environment env) {
        return new Analyzer(this.typeSystem, env, this.map, this.fromStack);
    }

    @Override
    protected void visit(Core.IdPat idPat) {
        this.use(idPat);
    }

    @Override
    public void visit(Core.Id id) {
        ++this.use((Core.NamedPat)id.idPat).useCount;
        super.visit(id);
    }

    private MutableUse use(Core.NamedPat name) {
        return this.map.computeIfAbsent(name, k -> new MutableUse());
    }

    @Override
    protected void visit(Core.NonRecValDecl valDecl) {
        super.visit(valDecl);
        if (Analyzer.isAtom(valDecl.exp)) {
            this.use((Core.NamedPat)valDecl.pat).atomic = true;
        }
    }

    private static boolean isAtom(Core.Exp exp) {
        switch (exp.op) {
            case ID: 
            case BOOL_LITERAL: 
            case CHAR_LITERAL: 
            case INT_LITERAL: 
            case REAL_LITERAL: 
            case STRING_LITERAL: 
            case UNIT_LITERAL: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void visit(Core.Case case_) {
        case_.exp.accept(this);
        if (case_.matchList.size() == 1) {
            case_.matchList.get(0).accept(this);
        } else {
            HashMultimap multimap = HashMultimap.create();
            HashMap<Core.NamedPat, MutableUse> subMap = new HashMap<Core.NamedPat, MutableUse>();
            Analyzer analyzer = new Analyzer(this.typeSystem, this.env, subMap, new ArrayDeque<EnvVisitor.FromContext>());
            case_.matchList.forEach(arg_0 -> Analyzer.lambda$visit$2(subMap, analyzer, (Multimap)multimap, arg_0));
            multimap.asMap().forEach((id, uses) -> {
                MutableUse baseUse = this.use((Core.NamedPat)id);
                int maxCount = MutableUse.max(uses);
                if (uses.size() > 1) {
                    baseUse.parallel = true;
                }
                baseUse.useCount += maxCount;
            });
        }
    }

    private static /* synthetic */ void lambda$visit$2(Map subMap, Analyzer analyzer, Multimap multimap, Core.Match e) {
        subMap.clear();
        e.accept(analyzer);
        subMap.forEach((arg_0, arg_1) -> ((Multimap)multimap).put(arg_0, arg_1));
    }

    private static class MutableUse {
        boolean top;
        boolean atomic;
        boolean parallel;
        int useCount;

        private MutableUse() {
        }

        static int max(Collection<MutableUse> uses) {
            int max = 0;
            for (MutableUse use : uses) {
                max = Math.max(max, use.useCount);
            }
            return max;
        }

        public String toString() {
            return "[" + this.useCount + (this.parallel ? " parallel]" : "]");
        }

        Use fix() {
            return this.top ? Use.MULTI_UNSAFE : (this.useCount == 0 ? Use.DEAD : (this.atomic ? Use.ATOMIC : (this.useCount == 1 ? (this.parallel ? Use.MULTI_SAFE : Use.ONCE_SAFE) : Use.MULTI_UNSAFE)));
        }
    }

    public static class Analysis {
        public final ImmutableMap<Core.NamedPat, Use> map;

        Analysis(ImmutableMap<Core.NamedPat, Use> map) {
            this.map = map;
        }
    }

    public static enum Use {
        LOOP_BREAKER,
        DEAD,
        ONCE_SAFE,
        ATOMIC,
        MULTI_SAFE,
        ONCE_UNSAFE,
        MULTI_UNSAFE;

    }
}

