/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Static;

abstract class EnvVisitor
extends Visitor {
    final TypeSystem typeSystem;
    final Environment env;
    final Deque<FromContext> fromStack;

    protected EnvVisitor(TypeSystem typeSystem, Environment env, Deque<FromContext> fromStack) {
        this.typeSystem = typeSystem;
        this.env = env;
        this.fromStack = fromStack;
    }

    protected abstract EnvVisitor push(Environment var1);

    protected EnvVisitor bind(Binding binding) {
        return this.push(this.env.bind(binding));
    }

    protected EnvVisitor bind(Iterable<Binding> bindingList) {
        Environment env2 = this.env.bindAll(bindingList);
        if (env2 != this.env) {
            return this.push(env2);
        }
        return this;
    }

    @Override
    protected void visit(Core.Fn fn) {
        fn.idPat.accept(this);
        fn.exp.accept(this.bind(Binding.of(fn.idPat)));
    }

    @Override
    protected void visit(Core.Match match) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        match.pat.accept(this);
        Compiles.bindPattern(this.typeSystem, bindings, match.pat);
        match.exp.accept(this.bind(bindings));
    }

    @Override
    protected void visit(Core.Let let) {
        let.decl.accept(this);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Compiles.bindPattern(this.typeSystem, bindings, let.decl);
        let.exp.accept(this.bind(bindings));
    }

    @Override
    protected void visit(Core.Local local) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Compiles.bindDataType(this.typeSystem, bindings, local.dataType);
        local.exp.accept(this.bind(bindings));
    }

    @Override
    protected void visit(Core.RecValDecl recValDecl) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        recValDecl.list.forEach(decl -> Compiles.bindPattern(this.typeSystem, (List<Binding>)bindings, decl.pat));
        EnvVisitor v2 = this.bind(bindings);
        recValDecl.list.forEach(x$0 -> v2.accept(x$0));
    }

    @Override
    protected void visit(Core.From from) {
        ImmutableList<Binding> bindings = ImmutableList.of();
        for (Core.FromStep step : from.steps) {
            this.visitStep(step, (List<Binding>)bindings);
            bindings = step.bindings;
        }
    }

    public void visitStep(Core.FromStep step, List<Binding> bindings) {
        try {
            this.fromStack.push(new FromContext(this, step));
            step.accept(this.bind(bindings));
        }
        finally {
            this.fromStack.pop();
        }
    }

    @Override
    protected void visit(Core.Aggregate aggregate) {
        EnvVisitor v2 = this.fromStack.element().visitor;
        Core.Group group = (Core.Group)this.fromStack.element().step;
        EnvVisitor v3 = v2.bind(Static.transform(group.groupExps.keySet(), Binding::of));
        aggregate.aggregate.accept(v3);
        if (aggregate.argument != null) {
            aggregate.argument.accept(this);
        }
    }

    public static class FromContext {
        final EnvVisitor visitor;
        final Core.FromStep step;

        FromContext(EnvVisitor visitor, Core.FromStep step) {
            this.visitor = visitor;
            this.step = step;
        }
    }
}

