/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.compile.Environments;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Environment {
    abstract void visit(Consumer<Binding> var1);

    public String asString() {
        StringBuilder b = new StringBuilder();
        this.getValueMap().forEach((k, v) -> b.append(v).append("\n"));
        return b.toString();
    }

    public abstract @Nullable Binding getOpt(String var1);

    public abstract @Nullable Binding getOpt(Core.NamedPat var1);

    public Environment bind(Core.IdPat id, Object value) {
        return this.bind(Binding.of((Core.NamedPat)id, value));
    }

    protected Environment bind(Binding binding) {
        return new Environments.SubEnvironment(this, binding);
    }

    public void forEachType(TypeSystem typeSystem, BiConsumer<String, Type> consumer) {
        HashSet names = new HashSet();
        this.visit(binding -> {
            if (names.add(binding.id.name)) {
                Type type = binding.value instanceof TypedValue ? ((TypedValue)binding.value).typeKey().toType(typeSystem) : binding.id.type;
                consumer.accept(binding.id.name, type);
            }
        });
    }

    public void forEachValue(BiConsumer<String, Object> consumer) {
        HashSet names = new HashSet();
        this.visit(binding -> {
            if (names.add(binding.id.name) && binding.value != Unit.INSTANCE) {
                consumer.accept(binding.id.name, binding.value);
            }
        });
    }

    public final Map<String, Binding> getValueMap() {
        HashMap<String, Binding> valueMap = new HashMap<String, Binding>();
        this.visit(binding -> valueMap.putIfAbsent(binding.id.name, (Binding)binding));
        return valueMap;
    }

    public final Environment bindAll(Iterable<Binding> bindings) {
        return Environments.bind(this, bindings);
    }

    abstract Environment nearestAncestorNotObscuredBy(Set<Core.NamedPat> var1);

    abstract int distance(int var1, Core.NamedPat var2);

    public Environment plus(Environment env) {
        ArrayList bindingList = new ArrayList();
        env.visit(bindingList::add);
        return this.bindAll(Lists.reverse(bindingList));
    }
}

