/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Pair;
import org.apache.calcite.util.Util;

public class Extents {
    private Extents() {
    }

    public static Core.Exp generator(TypeSystem typeSystem, Core.Pat pat, Core.Exp exp) {
        return Extents.create((TypeSystem)typeSystem, (Core.Pat)pat, (SortedMap<Core.NamedPat, Core.Exp>)ImmutableSortedMap.of(), (Core.Exp)exp).extentExp;
    }

    public static Analysis create(TypeSystem typeSystem, Core.Pat pat, SortedMap<Core.NamedPat, Core.Exp> boundPats, Core.Exp exp) {
        Extent extent = new Extent(typeSystem, pat, boundPats);
        LinkedListMultimap map = LinkedListMultimap.create();
        extent.g3((Multimap<Core.Pat, Core.Exp>)map, exp);
        List exps = map.get((Object)pat);
        if (exps.isEmpty()) {
            throw new AssertionError();
        }
        Pair<Core.Exp, List<Core.Exp>> pair = CoreBuilder.core.mergeExtents(typeSystem, exps, true);
        return new Analysis(boundPats, extent.goalPats, (Core.Exp)pair.left, (List)pair.right);
    }

    private static List<Core.IdPat> flatten(Core.Pat pat) {
        switch (pat.op) {
            case ID_PAT: {
                return ImmutableList.of((Object)((Core.IdPat)pat));
            }
            case TUPLE_PAT: {
                Core.TuplePat tuplePat = (Core.TuplePat)pat;
                for (Core.Pat arg : tuplePat.args) {
                    if (arg.op == Op.ID_PAT) continue;
                    throw new CompileException("must be id", false, arg.pos);
                }
                return tuplePat.args;
            }
        }
        throw new CompileException("must be id", false, pat.pos);
    }

    public static class Analysis {
        final SortedMap<Core.NamedPat, Core.Exp> boundPats;
        final Set<Core.NamedPat> goalPats;
        final Core.Exp extentExp;
        final List<Core.Exp> remainingFilters;

        Analysis(SortedMap<Core.NamedPat, Core.Exp> boundPats, Set<Core.NamedPat> goalPats, Core.Exp extentExp, List<Core.Exp> remainingFilters) {
            this.boundPats = boundPats;
            this.goalPats = goalPats;
            this.extentExp = extentExp;
            this.remainingFilters = remainingFilters;
        }

        Set<Core.NamedPat> unboundPats() {
            return Util.minus(this.goalPats, this.boundPats.keySet());
        }
    }

    private static class Extent {
        private final TypeSystem typeSystem;
        final Set<Core.NamedPat> goalPats;
        final SortedMap<Core.NamedPat, Core.Exp> boundPats;

        Extent(TypeSystem typeSystem, Core.Pat pat, SortedMap<Core.NamedPat, Core.Exp> boundPats) {
            this.typeSystem = typeSystem;
            this.goalPats = ImmutableSet.copyOf((Collection)Extents.flatten(pat));
            this.boundPats = ImmutableSortedMap.copyOf(boundPats);
        }

        void g3(Multimap<Core.Pat, Core.Exp> map, Core.Exp exp) {
            switch (exp.op) {
                case APPLY: {
                    Core.Apply apply = (Core.Apply)exp;
                    block3 : switch (apply.fn.op) {
                        case FN_LITERAL: {
                            BuiltIn builtIn = ((Core.Literal)apply.fn).unwrap(BuiltIn.class);
                            switch (builtIn) {
                                case Z_ANDALSO: {
                                    apply.arg.forEachArg((arg, i) -> this.g3(map, (Core.Exp)arg));
                                    break block3;
                                }
                                case Z_ORELSE: {
                                    LinkedListMultimap map2 = LinkedListMultimap.create();
                                    apply.arg.forEachArg((arg_0, arg_1) -> this.lambda$g3$2((Multimap)map2, arg_0, arg_1));
                                    map2.asMap().forEach((k, vs) -> map.put(k, (Object)CoreBuilder.core.union(this.typeSystem, (Iterable<Core.Exp>)vs)));
                                    break block3;
                                }
                                case OP_EQ: 
                                case OP_NE: 
                                case OP_GE: 
                                case OP_GT: 
                                case OP_LT: 
                                case OP_LE: {
                                    this.g4(map, builtIn, apply.arg(0), apply.arg(1));
                                }
                            }
                        }
                    }
                    break;
                }
            }
        }

        private void g4(Multimap<Core.Pat, Core.Exp> map, BuiltIn builtIn, Core.Exp arg0, Core.Exp arg1) {
            block0 : switch (builtIn) {
                case OP_EQ: 
                case OP_NE: 
                case OP_GE: 
                case OP_GT: 
                case OP_LT: 
                case OP_LE: {
                    switch (arg0.op) {
                        case ID: {
                            Core.Id id = (Core.Id)arg0;
                            if (!arg1.isConstant()) break block0;
                            map.put((Object)id.idPat, (Object)this.baz(builtIn, arg1));
                            break;
                        }
                        default: {
                            if (!arg0.isConstant() || arg1.op != Op.ID) break block0;
                            this.g4(map, builtIn.reverse(), arg1, arg0);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected: " + (Object)((Object)builtIn)));
                }
            }
        }

        private Core.Exp baz(BuiltIn builtIn, Core.Exp arg) {
            switch (builtIn) {
                case OP_EQ: {
                    return CoreBuilder.core.list(this.typeSystem, arg, new Core.Exp[0]);
                }
                case OP_NE: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet<Comparable>)ImmutableRangeSet.of((Range)Range.singleton((Comparable)((Core.Literal)arg).value)).complement());
                }
                case OP_GE: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet<Comparable>)ImmutableRangeSet.of((Range)Range.atLeast((Comparable)((Core.Literal)arg).value)));
                }
                case OP_GT: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet<Comparable>)ImmutableRangeSet.of((Range)Range.greaterThan((Comparable)((Core.Literal)arg).value)));
                }
                case OP_LE: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet<Comparable>)ImmutableRangeSet.of((Range)Range.atMost((Comparable)((Core.Literal)arg).value)));
                }
                case OP_LT: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet<Comparable>)ImmutableRangeSet.of((Range)Range.lessThan((Comparable)((Core.Literal)arg).value)));
                }
            }
            throw new AssertionError((Object)("unexpected: " + (Object)((Object)builtIn)));
        }

        ExtentFilter extent(Core.Scan scan) {
            Core.Exp extent;
            ArrayList<Core.Exp> extents = new ArrayList<Core.Exp>();
            ArrayList<Core.Exp> filters = new ArrayList<Core.Exp>();
            this.extent(scan.pat, scan.exp, extents, filters);
            if (extents.isEmpty()) {
                extent = CoreBuilder.core.extent(this.typeSystem, scan.pat.type, (RangeSet<Comparable>)ImmutableRangeSet.of((Range)Range.all()));
            } else {
                extent = (Core.Exp)extents.get(0);
                filters.addAll(Util.skip(extents));
            }
            return new ExtentFilter(extent, (ImmutableList<Core.Exp>)ImmutableList.copyOf(filters));
        }

        private void extent(Core.Pat pat, Core.Exp exp, List<Core.Exp> extents, List<Core.Exp> filters) {
            block0 : switch (exp.op) {
                case APPLY: {
                    Core.Apply apply = (Core.Apply)exp;
                    switch (apply.fn.op) {
                        case FN_LITERAL: {
                            switch ((BuiltIn)((Object)((Core.Literal)apply.fn).value)) {
                                case OP_ELEM: {
                                    List<Core.Exp> args = ((Core.Tuple)apply.arg).args;
                                    if (!Extent.matches(args.get(0), pat)) break block0;
                                    extents.add(args.get(1));
                                    break block0;
                                }
                                case Z_ANDALSO: {
                                    Iterator<Core.Exp> iterator = ((Core.Tuple)apply.arg).args.iterator();
                                    if (!iterator.hasNext()) break block0;
                                    Core.Exp e = iterator.next();
                                    this.extent(pat, e, extents, filters);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            filters.add(exp);
        }

        private static boolean matches(Core.Exp exp, Core.Pat pat) {
            if (exp.op == Op.ID && pat.op == Op.ID_PAT) {
                return ((Core.Id)exp).idPat.equals(pat);
            }
            if (exp.op == Op.TUPLE && pat.op == Op.TUPLE_PAT) {
                Core.Tuple tuple = (Core.Tuple)exp;
                Core.TuplePat tuplePat = (Core.TuplePat)pat;
                if (tuple.args.size() == tuplePat.args.size()) {
                    return Pair.allMatch(tuple.args, tuplePat.args, Extent::matches);
                }
            }
            return false;
        }

        private /* synthetic */ void lambda$g3$2(Multimap map2, Core.Exp arg, int i) {
            LinkedListMultimap map3 = LinkedListMultimap.create();
            this.g3((Multimap<Core.Pat, Core.Exp>)map3, arg);
            map3.asMap().forEach((k, vs) -> map2.put(k, (Object)CoreBuilder.core.intersect(this.typeSystem, (Iterable<Core.Exp>)vs)));
        }
    }

    static class ExtentFilter {
        final Core.Exp extent;
        final ImmutableList<Core.Exp> filters;

        ExtentFilter(Core.Exp extent, ImmutableList<Core.Exp> filters) {
            this.extent = extent;
            this.filters = filters;
        }
    }
}

