/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Sat;
import org.apache.calcite.util.Util;

class PatternCoverageChecker {
    final TypeSystem typeSystem;
    final Sat sat = new Sat();
    final Map<Path, DataTypeSlot> pathSlots = new HashMap<Path, DataTypeSlot>();

    private PatternCoverageChecker(TypeSystem typeSystem) {
        this.typeSystem = Objects.requireNonNull(typeSystem, "typeSystem");
    }

    static boolean isCoveredBy(TypeSystem typeSystem, List<Core.Pat> prevPatList, Core.Pat pat) {
        if (prevPatList.isEmpty()) {
            return false;
        }
        return new PatternCoverageChecker(typeSystem).isCoveredBy(pat, prevPatList);
    }

    static boolean isExhaustive(TypeSystem typeSystem, List<Core.Pat> patList) {
        if (patList.isEmpty()) {
            return false;
        }
        if (Iterables.any(patList, p -> p.op == Op.WILDCARD_PAT || p.op == Op.ID_PAT)) {
            return true;
        }
        Core.WildcardPat wildcardPat = CoreBuilder.core.wildcardPat(patList.get((int)0).type);
        return PatternCoverageChecker.isCoveredBy(typeSystem, patList, wildcardPat);
    }

    private Sat.Term toTerm(Core.Pat pat) {
        ArrayList<Sat.Term> terms = new ArrayList<Sat.Term>();
        this.toTerm(pat, Path.ROOT, terms);
        return terms.size() == 1 ? (Sat.Term)terms.get(0) : this.sat.and(terms);
    }

    private void toTerm(Core.Pat pat, Path path, List<Sat.Term> terms) {
        switch (pat.op) {
            case WILDCARD_PAT: 
            case ID_PAT: {
                return;
            }
            case AS_PAT: {
                this.toTerm(((Core.AsPat)pat).pat, path, terms);
                return;
            }
            case BOOL_LITERAL_PAT: {
                DataType boolDataType = (DataType)this.typeSystem.lookupInternal("$bool");
                Core.LiteralPat literalPat0 = (Core.LiteralPat)pat;
                Boolean value = (Boolean)literalPat0.value;
                this.toTerm(CoreBuilder.core.con0Pat(boolDataType, value != false ? "TRUE" : "FALSE"), path, terms);
                return;
            }
            case CHAR_LITERAL_PAT: 
            case INT_LITERAL_PAT: 
            case REAL_LITERAL_PAT: 
            case STRING_LITERAL_PAT: {
                Core.LiteralPat literalPat = (Core.LiteralPat)pat;
                terms.add(this.sat.variable(path.toVar(literalPat.value.toString())));
                return;
            }
            case CON0_PAT: {
                Core.Con0Pat con0Pat = (Core.Con0Pat)pat;
                terms.add(this.typeConstructorTerm(path, con0Pat.tyCon));
                return;
            }
            case CON_PAT: {
                Core.ConPat conPat = (Core.ConPat)pat;
                terms.add(this.typeConstructorTerm(path, conPat.tyCon));
                int j = ImmutableList.copyOf(((DataType)conPat.type).typeConstructors.keySet()).indexOf((Object)conPat.tyCon);
                if (j < 0) {
                    throw new AssertionError((Object)("type constructor not found: " + conPat));
                }
                this.toTerm(conPat.pat, path.sub(j), terms);
                return;
            }
            case CONS_PAT: {
                Core.ConPat consPat = (Core.ConPat)pat;
                this.addConsTerms(path, terms, (Core.TuplePat)consPat.pat);
                return;
            }
            case TUPLE_PAT: {
                Core.TuplePat tuplePat = (Core.TuplePat)pat;
                Ord.forEachIndexed(tuplePat.args, (pat2, i) -> this.toTerm((Core.Pat)pat2, path.sub(i), terms));
                return;
            }
            case RECORD_PAT: {
                Core.RecordPat recordPat = (Core.RecordPat)pat;
                Ord.forEachIndexed(recordPat.args, (pat2, i) -> this.toTerm((Core.Pat)pat2, path.sub(i), terms));
                return;
            }
            case LIST_PAT: {
                this.toTerm(this.listToCons((Core.ListPat)pat), path, terms);
                return;
            }
        }
        throw new AssertionError((Object)pat.op);
    }

    private Core.Pat listToCons(Core.ListPat listPat) {
        Type listType = this.typeSystem.lookupInternal("$list");
        DataType listDataType = (DataType)((ForallType)listType).type;
        return this.listToConsRecurse(listDataType, listPat.args);
    }

    private Core.Pat listToConsRecurse(DataType listDataType, List<Core.Pat> args) {
        if (args.isEmpty()) {
            return CoreBuilder.core.con0Pat(listDataType, "NIL");
        }
        return CoreBuilder.core.consPat(listDataType, "CONS", CoreBuilder.core.tuplePat(this.typeSystem, (List<Core.Pat>)ImmutableList.of((Object)args.get(0), (Object)this.listToConsRecurse(listDataType, Util.skip(args)))));
    }

    private void addConsTerms(Path path, List<Sat.Term> terms, Core.TuplePat tuplePat) {
        terms.add(this.typeConstructorTerm(path, "CONS"));
        this.toTerm(tuplePat, path, terms);
    }

    private Sat.Variable typeConstructorTerm(Path path, String con) {
        Pair<DataType, Type.Key> pair = this.typeSystem.lookupTyCon(con);
        DataType dataType = (DataType)pair.left;
        DataTypeSlot slot = this.pathSlots.computeIfAbsent(path, p -> new DataTypeSlot(dataType, (Path)p, this.sat));
        return (Sat.Variable)slot.constructorMap.get((Object)con);
    }

    public boolean isCoveredBy(Core.Pat pat, List<Core.Pat> patList) {
        ArrayList terms = new ArrayList();
        patList.forEach(p -> terms.add(this.toTerm((Core.Pat)p)));
        Sat.Term term = this.toTerm(pat);
        ArrayList<Sat.Term> terms1 = new ArrayList<Sat.Term>();
        terms1.add(term);
        terms.forEach(t -> terms1.add(this.sat.not((Sat.Term)t)));
        this.pathSlots.values().forEach(slot -> {
            ArrayList terms2 = new ArrayList(slot.constructorMap.values());
            terms1.add(this.sat.or(terms2));
            ArrayList<Sat.Term> terms3 = new ArrayList<Sat.Term>();
            for (int i = 0; i < terms2.size(); ++i) {
                terms3.add(this.sat.not(this.sat.or(new ElideList(terms2, i))));
            }
            terms1.add(this.sat.or(terms3));
        });
        Sat.Term formula = this.sat.and(terms1);
        Map<Sat.Variable, Boolean> solve = this.sat.solve(formula);
        return solve == null;
    }

    private static abstract class Path {
        static final Path ROOT = new Path(){

            @Override
            protected void path(StringBuilder b) {
            }
        };

        private Path() {
        }

        public String toString() {
            return this.toVar("");
        }

        Path sub(int i) {
            return new SubPath(this, i);
        }

        String toVar(String name) {
            StringBuilder builder = new StringBuilder();
            this.path(builder);
            builder.append(name);
            return builder.toString();
        }

        protected abstract void path(StringBuilder var1);
    }

    private static class DataTypeSlot {
        final DataType dataType;
        final ImmutableMap<String, Sat.Variable> constructorMap;

        DataTypeSlot(DataType dataType, Path path, Sat sat) {
            this.dataType = dataType;
            ImmutableMap.Builder b = ImmutableMap.builder();
            dataType.typeConstructors.forEach((name, type) -> b.put(name, (Object)sat.variable(path.toVar((String)name))));
            this.constructorMap = b.build();
        }
    }

    private static class ElideList<E>
    extends AbstractList<E> {
        private final List<E> list;
        private final int elide;

        ElideList(List<E> list, int elide) {
            this.list = Objects.requireNonNull(list, "list");
            this.elide = elide;
        }

        @Override
        public E get(int index) {
            return this.list.get(index < this.elide ? index : index + 1);
        }

        @Override
        public int size() {
            return this.list.size() - 1;
        }
    }

    private static class SubPath
    extends Path {
        final Path parent;
        final int ordinal;

        SubPath(Path parent, int ordinal) {
            this.parent = parent;
            this.ordinal = ordinal;
        }

        @Override
        protected void path(StringBuilder b) {
            this.parent.path(b);
            b.append(this.ordinal).append('.');
        }
    }
}

