/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.eval.Codes;
import net.hydromatic.morel.foreign.RelList;
import net.hydromatic.morel.parse.Parsers;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;

class Pretty {
    private final TypeSystem typeSystem;
    private final int lineWidth;
    private final int printLength;
    private final int printDepth;
    private final int stringDepth;

    Pretty(TypeSystem typeSystem, int lineWidth, int printLength, int printDepth, int stringDepth) {
        this.typeSystem = Objects.requireNonNull(typeSystem);
        this.lineWidth = lineWidth;
        this.printLength = printLength;
        this.printDepth = printDepth;
        this.stringDepth = stringDepth;
    }

    StringBuilder pretty(@Nonnull StringBuilder buf, @Nonnull Type type, @Nonnull Object value) {
        int lineEnd = this.lineWidth < 0 ? -1 : buf.length() + this.lineWidth;
        return this.pretty1(buf, 0, new int[]{lineEnd}, 0, type, value, 0, 0);
    }

    private StringBuilder pretty1(@Nonnull StringBuilder buf, int indent, int[] lineEnd, int depth, @Nonnull Type type, @Nonnull Object value, int leftPrec, int rightPrec) {
        int start = buf.length();
        int end = lineEnd[0];
        this.pretty2(buf, indent, lineEnd, depth, type, value, leftPrec, rightPrec);
        if (end >= 0 && buf.length() > end) {
            buf.setLength(start);
            while (buf.length() > 0 && (buf.charAt(buf.length() - 1) == ' ' || buf.charAt(buf.length() - 1) == '\n')) {
                buf.setLength(buf.length() - 1);
            }
            if (buf.length() > 0) {
                buf.append("\n");
            }
            lineEnd[0] = this.lineWidth < 0 ? -1 : buf.length() + this.lineWidth;
            Pretty.indent(buf, indent);
            this.pretty2(buf, indent, lineEnd, depth, type, value, leftPrec, rightPrec);
        }
        return buf;
    }

    private static void indent(@Nonnull StringBuilder buf, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
    }

    private StringBuilder pretty2(@Nonnull StringBuilder buf, int indent, int[] lineEnd, int depth, @Nonnull Type type, @Nonnull Object value, int leftPrec, int rightPrec) {
        if (value instanceof TypedVal) {
            TypedVal typedVal = (TypedVal)value;
            StringBuilder buf2 = new StringBuilder("val ");
            Parsers.appendId(buf2, typedVal.name).append(" = ");
            this.pretty1(buf, indent, lineEnd, depth, PrimitiveType.BOOL, buf2.toString(), 0, 0);
            this.pretty1(buf, indent + 2, lineEnd, depth + 1, typedVal.type, typedVal.o, 0, 0);
            buf.append(' ');
            this.pretty1(buf, indent + 2, lineEnd, depth, PrimitiveType.BOOL, new TypeVal(": ", Pretty.unqualified(typedVal.type)), 0, 0);
            return buf;
        }
        if (value instanceof NamedVal) {
            NamedVal namedVal = (NamedVal)value;
            Parsers.appendId(buf, namedVal.name).append('=');
            this.pretty1(buf, indent, lineEnd, depth, type, namedVal.o, 0, 0);
            return buf;
        }
        if (value instanceof LabelVal) {
            LabelVal labelVal = (LabelVal)value;
            String prefix = Parsers.appendId(new StringBuilder(), labelVal.label).append(':').toString();
            this.pretty1(buf, indent, lineEnd, depth, type, new TypeVal(prefix, labelVal.type), 0, 0);
            return buf;
        }
        if (value instanceof TypeVal) {
            return this.prettyType(buf, indent, lineEnd, depth, type, (TypeVal)value, leftPrec, rightPrec);
        }
        if (this.printDepth >= 0 && depth > this.printDepth) {
            buf.append('#');
            return buf;
        }
        switch (type.op()) {
            case ID: {
                switch ((PrimitiveType)type) {
                    case UNIT: {
                        return buf.append("()");
                    }
                    case CHAR: {
                        String s = ((Character)value).toString();
                        return buf.append('#').append('\"').append(s.replace("\\", "\\\\").replace("\"", "\\\"")).append('\"');
                    }
                    case STRING: {
                        String s = (String)value;
                        if (this.stringDepth >= 0 && s.length() > this.stringDepth) {
                            s = s.substring(0, this.stringDepth) + "#";
                        }
                        return buf.append('\"').append(s.replace("\\", "\\\\").replace("\"", "\\\"")).append('\"');
                    }
                    case INT: {
                        int i = (Integer)value;
                        if (i < 0) {
                            if (i == Integer.MIN_VALUE) {
                                return buf.append("~2147483648");
                            }
                            buf.append('~');
                            i = -i;
                        }
                        return buf.append(i);
                    }
                    case REAL: {
                        return Codes.appendFloat(buf, ((Float)value).floatValue());
                    }
                }
                return buf.append(value);
            }
            case FUNCTION_TYPE: {
                return buf.append("fn");
            }
            case LIST: {
                ListType listType = (ListType)type;
                List<Object> list = Pretty.toList(value);
                if (list instanceof RelList) {
                    return buf.append("<relation>");
                }
                if (value instanceof TypedValue) {
                    return buf.append("<relation>");
                }
                return this.printList(buf, indent, lineEnd, depth, listType.elementType, list);
            }
            case RECORD_TYPE: {
                RecordType recordType = (RecordType)type;
                List<Object> list = Pretty.toList(value);
                buf.append("{");
                int start = buf.length();
                Pair.forEachIndexed(list, recordType.argNameTypes.entrySet(), (ordinal, o, nameType) -> {
                    if (buf.length() > start) {
                        buf.append(",");
                    }
                    this.pretty1(buf, indent + 1, lineEnd, depth + 1, (Type)nameType.getValue(), new NamedVal((String)nameType.getKey(), o), 0, 0);
                });
                return buf.append("}");
            }
            case TUPLE_TYPE: {
                TupleType tupleType = (TupleType)type;
                List<Object> list = Pretty.toList(value);
                buf.append("(");
                int start = buf.length();
                Pair.forEachIndexed(list, tupleType.argTypes, (ordinal, o, elementType) -> {
                    if (buf.length() > start) {
                        buf.append(",");
                    }
                    this.pretty1(buf, indent + 1, lineEnd, depth + 1, (Type)elementType, o, 0, 0);
                });
                return buf.append(")");
            }
            case FORALL_TYPE: {
                return this.pretty2(buf, indent, lineEnd, depth + 1, ((ForallType)type).type, value, 0, 0);
            }
            case DATA_TYPE: {
                DataType dataType = (DataType)type;
                List<Object> list = Pretty.toList(value);
                if (dataType.name.equals("vector")) {
                    Type argType = (Type)Iterables.getOnlyElement(dataType.arguments);
                    return this.printList(buf.append('#'), indent, lineEnd, depth, argType, list);
                }
                String tyConName = (String)list.get(0);
                buf.append(tyConName);
                Type typeConArgType = (Type)dataType.typeConstructors(this.typeSystem).get(tyConName);
                Objects.requireNonNull(typeConArgType);
                if (list.size() == 2) {
                    boolean needParentheses;
                    Object arg = list.get(1);
                    buf.append(' ');
                    boolean bl = needParentheses = typeConArgType.op() == Op.DATA_TYPE && arg instanceof List;
                    if (needParentheses) {
                        buf.append('(');
                    }
                    this.pretty2(buf, indent, lineEnd, depth + 1, typeConArgType, arg, 0, 0);
                    if (needParentheses) {
                        buf.append(')');
                    }
                }
                return buf;
            }
        }
        return buf.append(value);
    }

    private StringBuilder prettyType(StringBuilder buf, int indent, int[] lineEnd, int depth, Type type, TypeVal typeVal, int leftPrec, int rightPrec) {
        buf.append(typeVal.prefix);
        int indent2 = indent + typeVal.prefix.length();
        switch (typeVal.type.op()) {
            case ID: 
            case DATA_TYPE: 
            case TY_VAR: {
                return this.pretty1(buf, indent2, lineEnd, depth, type, typeVal.type.moniker(), 0, 0);
            }
            case LIST: {
                if (leftPrec > Op.LIST.left || rightPrec > Op.LIST.right) {
                    this.pretty1(buf, indent2, lineEnd, depth, type, "(", 0, 0);
                    this.pretty1(buf, indent2, lineEnd, depth, type, typeVal, 0, 0);
                    this.pretty1(buf, indent2, lineEnd, depth, type, ")", 0, 0);
                    return buf;
                }
                ListType listType = (ListType)typeVal.type;
                this.pretty1(buf, indent2, lineEnd, depth, type, new TypeVal("", listType.elementType), leftPrec, Op.LIST.left);
                return buf.append(" list");
            }
            case TUPLE_TYPE: {
                if (leftPrec > Op.TUPLE_TYPE.left || rightPrec > Op.TUPLE_TYPE.right) {
                    this.pretty1(buf, indent2, lineEnd, depth, type, "(", 0, 0);
                    this.pretty1(buf, indent2, lineEnd, depth, type, typeVal, 0, 0);
                    this.pretty1(buf, indent2, lineEnd, depth, type, ")", 0, 0);
                    return buf;
                }
                TupleType tupleType = (TupleType)typeVal.type;
                int start = buf.length();
                List<Type> argTypes = tupleType.argTypes;
                for (int i = 0; i < argTypes.size(); ++i) {
                    Type argType = argTypes.get(i);
                    if (buf.length() > start) {
                        this.pretty1(buf, indent2, lineEnd, depth, type, " * ", 0, 0);
                    }
                    this.pretty1(buf, indent2, lineEnd, depth, type, new TypeVal("", argType), i == 0 ? leftPrec : Op.TUPLE_TYPE.right, i == argTypes.size() - 1 ? rightPrec : Op.TUPLE_TYPE.left);
                }
                return buf;
            }
            case RECORD_TYPE: 
            case PROGRESSIVE_RECORD_TYPE: {
                RecordType recordType = (RecordType)typeVal.type;
                boolean progressive = typeVal.type.isProgressive();
                buf.append("{");
                int start = buf.length();
                recordType.argNameTypes.forEach((name, elementType) -> {
                    if (buf.length() > start) {
                        buf.append(", ");
                    }
                    this.pretty1(buf, indent2 + 1, lineEnd, depth, type, new LabelVal((String)name, (Type)elementType), 0, 0);
                });
                if (progressive) {
                    if (buf.length() > start) {
                        buf.append(", ");
                    }
                    this.pretty1(buf, indent2 + 1, lineEnd, depth, type, "...", 0, 0);
                }
                return buf.append("}");
            }
            case FUNCTION_TYPE: {
                if (leftPrec > Op.FUNCTION_TYPE.left || rightPrec > Op.FUNCTION_TYPE.right) {
                    this.pretty1(buf, indent2, lineEnd, depth, type, "(", 0, 0);
                    this.pretty1(buf, indent2, lineEnd, depth, type, typeVal, 0, 0);
                    this.pretty1(buf, indent2, lineEnd, depth, type, ")", 0, 0);
                    return buf;
                }
                FnType fnType = (FnType)typeVal.type;
                this.pretty1(buf, indent2 + 1, lineEnd, depth, type, new TypeVal("", fnType.paramType), leftPrec, Op.FUNCTION_TYPE.left);
                this.pretty1(buf, indent2 + 1, lineEnd, depth, type, " -> ", 0, 0);
                this.pretty1(buf, indent2 + 1, lineEnd, depth, type, new TypeVal("", fnType.resultType), Op.FUNCTION_TYPE.right, rightPrec);
                return buf;
            }
        }
        throw new AssertionError((Object)("unknown type " + typeVal.type));
    }

    private static List<Object> toList(Object value) {
        if (value instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)value;
            return typedValue.valueAs(List.class);
        }
        return (List)value;
    }

    private static Type unqualified(Type type) {
        return type instanceof ForallType ? Pretty.unqualified(((ForallType)type).type) : type;
    }

    private StringBuilder printList(@Nonnull StringBuilder buf, int indent, int[] lineEnd, int depth, @Nonnull Type elementType, @Nonnull List<Object> list) {
        buf.append("[");
        int start = buf.length();
        for (Ord<Object> o : Ord.zip(list)) {
            if (buf.length() > start) {
                buf.append(",");
            }
            if (this.printLength >= 0 && o.i >= this.printLength) {
                this.pretty1(buf, indent + 1, lineEnd, depth + 1, PrimitiveType.BOOL, "...", 0, 0);
                break;
            }
            this.pretty1(buf, indent + 1, lineEnd, depth + 1, elementType, o.e, 0, 0);
        }
        return buf.append("]");
    }

    static class TypedVal {
        final String name;
        final Object o;
        final Type type;

        TypedVal(String name, Object o, Type type) {
            this.name = name;
            this.o = o;
            this.type = type;
        }
    }

    private static class TypeVal {
        final String prefix;
        final Type type;

        TypeVal(String prefix, Type type) {
            this.prefix = prefix;
            this.type = type;
        }
    }

    private static class NamedVal {
        final String name;
        final Object o;

        NamedVal(String name, Object o) {
            this.name = name;
            this.o = o;
        }
    }

    private static class LabelVal {
        final String label;
        final Type type;

        LabelVal(String label, Type type) {
            this.label = label;
            this.type = type;
        }
    }
}

