/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.EnvShuttle;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Static;
import org.apache.calcite.util.Util;

public class Relationalizer
extends EnvShuttle {
    private Relationalizer(TypeSystem typeSystem, Environment env) {
        super(typeSystem, env);
    }

    public static Relationalizer of(TypeSystem typeSystem, Environment env) {
        return new Relationalizer(typeSystem, env);
    }

    @Override
    protected Relationalizer push(Environment env) {
        return new Relationalizer(this.typeSystem, env);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Core.Exp visit(Core.Apply apply) {
        switch (apply.fn.op) {
            case APPLY: {
                Core.Apply apply2 = (Core.Apply)apply.fn;
                switch (apply2.fn.op) {
                    case FN_LITERAL: {
                        Core.Literal literal = (Core.Literal)apply2.fn;
                        if (literal.value == BuiltIn.LIST_MAP) {
                            Core.Exp f = apply2.arg;
                            FnType fnType = (FnType)f.type;
                            Core.From from = this.toFrom(apply.arg);
                            Core.Yield yieldStep = CoreBuilder.core.yield_(this.typeSystem, (Core.Exp)CoreBuilder.core.apply(apply.pos, fnType.resultType, f, CoreBuilder.core.implicitYieldExp(this.typeSystem, (List<Core.FromStep>)from.steps)));
                            return CoreBuilder.core.from(this.typeSystem, Static.append(from.steps, yieldStep));
                        }
                        if (literal.value != BuiltIn.LIST_FILTER) return super.visit(apply);
                        Core.Exp f = apply2.arg;
                        FnType fnType = (FnType)f.type;
                        Core.From from = this.toFrom(apply.arg);
                        Core.Where whereStep = CoreBuilder.core.where(CoreBuilder.lastBindings(from.steps), CoreBuilder.core.apply(apply.pos, fnType.resultType, f, CoreBuilder.core.implicitYieldExp(this.typeSystem, (List<Core.FromStep>)from.steps)));
                        return CoreBuilder.core.from(this.typeSystem, Static.append(from.steps, whereStep));
                    }
                }
                return super.visit(apply);
            }
        }
        return super.visit(apply);
    }

    private Core.From toFrom(Core.Exp exp) {
        if (exp instanceof Core.From) {
            return (Core.From)exp;
        }
        ListType listType = (ListType)exp.type;
        String name = this.typeSystem.nameGenerator.get();
        Core.IdPat id = CoreBuilder.core.idPat(listType.elementType, name, this.typeSystem.nameGenerator);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Compiles.acceptBinding(this.typeSystem, id, bindings);
        Core.Scan scan = CoreBuilder.core.scan(Op.INNER_JOIN, bindings, id, exp, CoreBuilder.core.boolLiteral(true));
        return CoreBuilder.core.from(this.typeSystem, (List<Core.FromStep>)ImmutableList.of((Object)scan));
    }

    @Override
    public Core.Exp visit(Core.From from) {
        Core.FromStep step;
        Core.From from2 = (Core.From)super.visit(from);
        if (from2.steps.size() > 0 && (step = (Core.FromStep)from2.steps.get(0)) instanceof Core.Scan && ((Core.Scan)step).exp.op == Op.FROM && ((Core.Scan)step).pat.op == Op.ID_PAT) {
            Core.From from3 = (Core.From)((Core.Scan)step).exp;
            Core.IdPat idPat3 = (Core.IdPat)((Core.Scan)step).pat;
            ArrayList<Core.FromStep> steps = new ArrayList<Core.FromStep>((Collection<Core.FromStep>)from3.steps);
            Core.Exp exp = steps.isEmpty() ? CoreBuilder.core.unitLiteral() : (Iterables.getLast(steps) instanceof Core.Yield ? ((Core.Yield)steps.remove((int)(steps.size() - 1))).exp : CoreBuilder.core.implicitYieldExp(this.typeSystem, (List<Core.FromStep>)from3.steps));
            ImmutableSortedMap.Builder argNameTypes = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
            RecordLikeType recordType = this.typeSystem.recordType((SortedMap<String, ? extends Type>)argNameTypes.put((Object)idPat3.name, (Object)exp.type).build());
            steps.add(CoreBuilder.core.yield_((List<Binding>)step.bindings, (Core.Exp)CoreBuilder.core.tuple(recordType, exp)));
            steps.addAll(Util.skip(from2.steps));
            return CoreBuilder.core.from(this.typeSystem, steps);
        }
        return from2;
    }
}

