/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.FromBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Shuttle;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Extents;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.Static;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

class SuchThatShuttle
extends Shuttle {
    final Deque<FromState> fromStates = new ArrayDeque<FromState>();
    final Environment env;

    SuchThatShuttle(TypeSystem typeSystem, Environment env) {
        super(typeSystem);
        this.env = env;
    }

    static boolean containsSuchThat(Core.Decl decl) {
        final Holder found = Holder.of((Object)false);
        decl.accept(new Visitor(){

            @Override
            protected void visit(Core.Scan scan) {
                super.visit(scan);
                if (scan.op == Op.SUCH_THAT) {
                    found.set((Object)true);
                }
            }
        });
        return (Boolean)found.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Core.Exp visit(Core.From from) {
        try {
            FromState fromState = new FromState(from);
            this.fromStates.push(fromState);
            for (Core.FromStep node : from.steps) {
                fromState.steps.add(node.accept(this));
            }
            Object object = from.copy(this.typeSystem, this.env, fromState.steps);
            return object;
        }
        finally {
            this.fromStates.pop();
        }
    }

    @Override
    protected Core.Scan visit(Core.Scan scan) {
        if (scan.op != Op.SUCH_THAT) {
            return super.visit(scan);
        }
        ImmutableSortedMap.Builder boundPatBuilder = ImmutableSortedMap.orderedBy(Core.NamedPat.ORDERING);
        if (!this.fromStates.element().steps.isEmpty()) {
            ((Core.FromStep)Iterables.getLast(this.fromStates.element().steps)).bindings.forEach(b -> boundPatBuilder.put((Object)b.id, (Object)CoreBuilder.core.id(b.id)));
        }
        ImmutableSortedMap boundPats = boundPatBuilder.build();
        Core.Exp rewritten = this.rewrite0((SortedMap<Core.NamedPat, Core.Exp>)boundPats, scan.pat, scan.exp);
        return CoreBuilder.core.scan(Op.INNER_JOIN, (List<Binding>)scan.bindings, scan.pat, rewritten, scan.condition);
    }

    private Core.Exp rewrite0(SortedMap<Core.NamedPat, Core.Exp> boundPats, Core.Pat pat, Core.Exp exp) {
        try {
            ImmutableMap scans = ImmutableMap.of();
            ImmutableList filters = ImmutableList.of();
            UnaryOperator<Core.NamedPat> originalPats = UnaryOperator.identity();
            return this.rewrite(originalPats, boundPats, (Map<Core.IdPat, Core.Exp>)scans, (List<Core.Exp>)filters, SuchThatShuttle.conjunctions(exp));
        }
        catch (RewriteFailedException e) {
            Core.Exp generator = Extents.generator(this.typeSystem, pat, exp);
            FromBuilder fromBuilder = CoreBuilder.core.fromBuilder(this.typeSystem);
            return fromBuilder.scan(pat, generator).where(exp).build();
        }
    }

    private Core.Exp rewrite(UnaryOperator<Core.NamedPat> mapper, SortedMap<Core.NamedPat, Core.Exp> boundPats, Map<Core.IdPat, Core.Exp> scans, List<Core.Exp> filters, List<Core.Exp> exps) {
        if (exps.isEmpty()) {
            ImmutableSortedMap.Builder b = ImmutableSortedMap.naturalOrder();
            boundPats.forEach((p, e) -> b.put((Object)((Core.NamedPat)mapper.apply((Core.NamedPat)p)), e));
            ImmutableSortedMap boundPats2 = b.build();
            TreeMap nameExps = new TreeMap((Comparator<String>)RecordType.ORDERING);
            if (scans.isEmpty()) {
                Core.Scan scan = (Core.Scan)this.fromStates.element().currentStep();
                Extents.Analysis extent = Extents.create(this.typeSystem, scan.pat, (SortedMap<Core.NamedPat, Core.Exp>)boundPats2, scan.exp);
                Set<Core.NamedPat> unboundPats = extent.unboundPats();
                if (!unboundPats.isEmpty()) {
                    throw new RewriteFailedException("Cannot implement 'suchthat'; variables " + unboundPats + " are not grounded]");
                }
                boundPats2.forEach((p, e) -> {
                    if (extent.goalPats.contains(p)) {
                        nameExps.put(p.name, e);
                    }
                });
            } else {
                boundPats2.forEach((p, e) -> nameExps.put(p.name, e));
            }
            FromBuilder fromBuilder = CoreBuilder.core.fromBuilder(this.typeSystem);
            scans.forEach(fromBuilder::scan);
            filters.forEach(fromBuilder::where);
            fromBuilder.yield_(nameExps.size() == 1 ? (Core.Exp)Iterables.getOnlyElement(nameExps.values()) : CoreBuilder.core.record(this.typeSystem, nameExps));
            return fromBuilder.build();
        }
        Core.Exp exp = exps.get(0);
        List exps2 = Util.skip(exps);
        switch (exp.op) {
            case APPLY: {
                Core.Apply apply = (Core.Apply)exp;
                if (exp.isCallTo(BuiltIn.OP_ELEM)) {
                    Core.Exp a1;
                    Core.Exp a0 = apply.args().get(0);
                    @Nullable Core.Exp e2 = this.rewriteElem(this.typeSystem, mapper, boundPats, scans, filters, a0, a1 = apply.args().get(1), exps2);
                    if (e2 != null) {
                        return e2;
                    }
                    throw new AssertionError(exp);
                }
                if (exp.isCallTo(BuiltIn.OP_EQ)) {
                    Core.Exp a1List;
                    Core.Exp e3;
                    Core.Exp a0 = apply.args().get(0);
                    Core.Exp a1 = apply.args().get(1);
                    if (a1.op == Op.ID && a0.op != Op.ID) {
                        Core.Exp tmp = a0;
                        a0 = a1;
                        a1 = tmp;
                    }
                    if ((e3 = this.rewriteElem(this.typeSystem, mapper, boundPats, scans, filters, a0, a1List = CoreBuilder.core.list(this.typeSystem, a1, new Core.Exp[0]), exps2)) != null) {
                        return e3;
                    }
                }
                List<Core.Exp> filters2 = Static.append(filters, exp);
                return this.rewrite(mapper, boundPats, scans, filters2, exps2);
            }
            case CASE: {
                Core.Case case_ = (Core.Case)exp;
                if (case_.matchList.size() != 1) break;
                Core.Match match = case_.matchList.get(0);
                TreeMap<Core.NamedPat, Core.Exp> boundPats2 = new TreeMap<Core.NamedPat, Core.Exp>(boundPats.comparator());
                boundPats.forEach((p, e) -> boundPats2.put((Core.NamedPat)mapper.apply((Core.NamedPat)p), (Core.Exp)e));
                PatMap patMap = PatMap.of(match.pat, case_.exp);
                return this.rewrite(mapper.andThen(patMap::apply)::apply, boundPats2, scans, filters, Static.plus(match.exp, exps2));
            }
        }
        throw new RewriteFailedException("not implemented: suchthat " + (Object)((Object)exp.op) + " [" + exp + "]");
    }

    private @Nullable Core.Exp rewriteElem(TypeSystem typeSystem, UnaryOperator<Core.NamedPat> mapper, SortedMap<Core.NamedPat, Core.Exp> boundPats, Map<Core.IdPat, Core.Exp> scans, List<Core.Exp> filters, Core.Exp a0, Core.Exp a1, List<Core.Exp> exps2) {
        if (a0.op == Op.ID) {
            Core.IdPat idPat = (Core.IdPat)((Core.Id)a0).idPat;
            if (!boundPats.containsKey(idPat)) {
                SortedMap<Core.NamedPat, Core.Exp> boundPats2 = Static.plus(boundPats, idPat, CoreBuilder.core.id(idPat));
                Map<Core.IdPat, Core.Exp> scans2 = Static.plus(scans, idPat, a1);
                return this.rewrite(mapper, boundPats2, scans2, filters, exps2);
            }
            Core.Exp e = (Core.Exp)boundPats.get(idPat);
            List<Core.Exp> filters2 = Static.append(filters, CoreBuilder.core.elem(typeSystem, e, a1));
            return this.rewrite(mapper, boundPats, scans, filters2, exps2);
        }
        if (a0.op == Op.TUPLE) {
            Core.Tuple tuple = (Core.Tuple)a0;
            Core.IdPat idPat = CoreBuilder.core.idPat(((ListType)a1.type).elementType, typeSystem.nameGenerator);
            Core.Id id = CoreBuilder.core.id(idPat);
            SortedMap<Core.NamedPat, Core.Exp> boundPats2 = boundPats;
            List<Core.Exp> filters2 = filters;
            for (Ord<Core.Exp> arg : Ord.zip(tuple.args)) {
                Core.Exp e = CoreBuilder.core.field(typeSystem, id, arg.i);
                if (arg.e instanceof Core.Id) {
                    Core.NamedPat idPat2 = ((Core.Id)arg.e).idPat;
                    if (!boundPats2.containsKey(idPat2)) {
                        boundPats2 = Static.plus(boundPats2, idPat2, e);
                        continue;
                    }
                    filters2 = Static.append(filters, CoreBuilder.core.equal(typeSystem, e, (Core.Exp)arg.e));
                    continue;
                }
                filters2 = Static.append(filters, CoreBuilder.core.equal(typeSystem, e, (Core.Exp)arg.e));
            }
            Map<Core.IdPat, Core.Exp> scans2 = Static.plus(scans, idPat, a1);
            return this.rewrite(mapper, boundPats2, scans2, filters2, exps2);
        }
        return null;
    }

    static List<Core.Exp> conjunctions(Core.Exp e) {
        ImmutableList.Builder b = ImmutableList.builder();
        SuchThatShuttle.addConjunctions((ImmutableList.Builder<Core.Exp>)b, e);
        return b.build();
    }

    private static void addConjunctions(ImmutableList.Builder<Core.Exp> b, Core.Exp e) {
        if (e.op == Op.APPLY && ((Core.Apply)e).fn.op == Op.FN_LITERAL && ((Core.Literal)((Core.Apply)e).fn).value == BuiltIn.Z_ANDALSO) {
            ((Core.Apply)e).args().forEach(a -> SuchThatShuttle.addConjunctions(b, a));
        } else if (e.op != Op.BOOL_LITERAL || !((Boolean)((Core.Literal)e).value).booleanValue()) {
            b.add((Object)e);
        }
    }

    static class FromState {
        final Core.From from;
        final List<Core.FromStep> steps = new ArrayList<Core.FromStep>();

        FromState(Core.From from) {
            this.from = from;
        }

        Core.FromStep currentStep() {
            return (Core.FromStep)this.from.steps.get(this.steps.size());
        }
    }

    private static class RewriteFailedException
    extends RuntimeException {
        RewriteFailedException(String message) {
            super(message);
        }
    }

    private static class PatMap {
        private final ImmutableMap<Core.NamedPat, Core.NamedPat> map;

        PatMap(ImmutableMap<Core.NamedPat, Core.NamedPat> map) {
            this.map = map;
        }

        static PatMap of(Core.Pat pat, Core.Exp exp) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            PatMap.populate(pat, exp, (ImmutableMap.Builder<Core.NamedPat, Core.NamedPat>)builder);
            return new PatMap((ImmutableMap<Core.NamedPat, Core.NamedPat>)builder.build());
        }

        private static void populate(Core.Pat pat, Core.Exp exp, ImmutableMap.Builder<Core.NamedPat, Core.NamedPat> nameBuilder) {
            switch (pat.op) {
                case ID_PAT: {
                    nameBuilder.put(Pair.of(((Core.Id)exp).idPat, (Core.IdPat)pat));
                    break;
                }
                case TUPLE_PAT: {
                    Core.TuplePat tuplePat = (Core.TuplePat)pat;
                    Core.Tuple tuple = (Core.Tuple)exp;
                    for (Pair<Core.Pat, Core.Exp> pair : Pair.zip(tuplePat.args, tuple.args)) {
                        PatMap.populate((Core.Pat)pair.left, (Core.Exp)pair.right, nameBuilder);
                    }
                    break;
                }
            }
        }

        Core.NamedPat apply(Core.NamedPat p) {
            for (Map.Entry pair : this.map.entrySet()) {
                if (!((Core.NamedPat)pair.getValue()).equals(p)) continue;
                p = (Core.NamedPat)pair.getKey();
            }
            return p;
        }
    }
}

