/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstBuilder;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.compile.EnvVisitor;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.TypeMap;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.MapList;
import net.hydromatic.morel.util.MartelliUnifier;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.Tracers;
import net.hydromatic.morel.util.Unifier;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeResolver {
    private final TypeSystem typeSystem;
    private final Unifier unifier = new MartelliUnifier();
    private final List<TermVariable> terms = new ArrayList<TermVariable>();
    private final Map<AstNode, Unifier.Term> map = new HashMap<AstNode, Unifier.Term>();
    private final Map<Unifier.Variable, Unifier.Action> actionMap = new HashMap<Unifier.Variable, Unifier.Action>();
    private final PairList<Unifier.Variable, PrimitiveType> preferredTypes = PairList.of();
    static final String TUPLE_TY_CON = "tuple";
    static final String LIST_TY_CON = "list";
    static final String RECORD_TY_CON = "record";
    static final String FN_TY_CON = "fn";
    static final String PROGRESSIVE_LABEL = "z$dummy";

    private TypeResolver(TypeSystem typeSystem) {
        this.typeSystem = Objects.requireNonNull(typeSystem);
    }

    public static Resolved deduceType(Environment env, Ast.Decl decl, TypeSystem typeSystem) {
        Resolved resolved;
        int original;
        TypeResolver typeResolver = new TypeResolver(typeSystem);
        int attempt = 0;
        do {
            original = typeSystem.expandCount.get();
            resolved = typeResolver.deduceType_(env, decl);
        } while (typeSystem.expandCount.get() != original && attempt++ <= 1);
        return resolved;
    }

    public static Type toType(Ast.Type type, TypeSystem typeSystem) {
        return typeSystem.typeFor(TypeResolver.toTypeKey(type));
    }

    public static Type.Key toTypeKey(Ast.Type type) {
        return new Foo().toTypeKey(type);
    }

    private Resolved deduceType_(Environment env, Ast.Decl decl) {
        TypeMap typeMap;
        TypeEnvHolder typeEnvs = new TypeEnvHolder(EmptyTypeEnv.INSTANCE);
        BuiltIn.forEach(this.typeSystem, (builtIn, type) -> {
            if (builtIn.structure == null) {
                typeEnvs.accept(builtIn.mlName, (Type)type);
            }
            if (builtIn.alias != null) {
                typeEnvs.accept(builtIn.alias, (Type)type);
            }
        });
        BuiltIn.forEachStructure(this.typeSystem, (structure, type) -> typeEnvs.accept(structure.name, (Type)type));
        env.forEachType(this.typeSystem, typeEnvs);
        TypeEnv typeEnv = typeEnvs.typeEnv;
        LinkedHashMap<Ast.IdPat, Unifier.Term> termMap = new LinkedHashMap<Ast.IdPat, Unifier.Term>();
        Ast.Decl node2 = this.deduceDeclType(typeEnv, decl, termMap);
        boolean debug = false;
        Unifier.Tracer tracer = Tracers.nullTracer();
        block0: while (true) {
            ArrayList<Unifier.TermTerm> termPairs = new ArrayList<Unifier.TermTerm>();
            this.terms.forEach(tv -> termPairs.add(new Unifier.TermTerm(tv.term, tv.variable)));
            Unifier.Result result = this.unifier.unify(termPairs, this.actionMap, tracer);
            if (!(result instanceof Unifier.Substitution)) {
                String extra = ";\n term pairs:\n" + String.join((CharSequence)"\n", Static.transform(this.terms, Object::toString));
                throw new TypeException("Cannot deduce type: " + result, Pos.ZERO);
            }
            typeMap = new TypeMap(this.typeSystem, this.map, (Unifier.Substitution)((Object)result));
            while (!this.preferredTypes.isEmpty()) {
                Object x = this.preferredTypes.remove(0);
                Type type2 = typeMap.termToType(typeMap.substitution.resultMap.get(x.getKey()));
                if (!(type2 instanceof TypeVar)) continue;
                this.equiv(this.toTerm((PrimitiveType)x.getValue()), (Unifier.Variable)x.getKey());
                continue block0;
            }
            break;
        }
        AtomicBoolean progressive = new AtomicBoolean();
        TypeResolver.forEachUnresolvedField(node2, typeMap, apply -> {
            Type type = typeMap.getType(apply.arg);
            if (type.isProgressive()) {
                progressive.set(true);
            }
        });
        if (progressive.get()) {
            node2.accept(FieldExpander.create(this.typeSystem, env));
        } else {
            TypeResolver.checkNoUnresolvedFieldRefs(node2, typeMap);
        }
        return Resolved.of(env, decl, node2, typeMap);
    }

    private static void checkNoUnresolvedFieldRefs(Ast.Decl decl, TypeMap typeMap) {
        TypeResolver.forEachUnresolvedField(decl, typeMap, apply -> {
            throw new TypeException("unresolved flex record (can't tell what fields there are besides " + apply.fn + ")", apply.arg.pos);
        });
    }

    private static void forEachUnresolvedField(Ast.Decl decl, final TypeMap typeMap, final Consumer<Ast.Apply> consumer) {
        decl.accept(new Visitor(){

            @Override
            protected void visit(Ast.Apply apply) {
                if (apply.fn.op == Op.RECORD_SELECTOR && typeMap.typeIsVariable(apply.arg)) {
                    consumer.accept(apply);
                }
                super.visit(apply);
            }
        });
    }

    private <E extends AstNode> E reg(E node, Unifier.Variable variable, Unifier.Term term) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(term);
        this.map.put(node, term);
        if (variable != null) {
            this.equiv(term, variable);
        }
        return node;
    }

    private Ast.Exp deduceType(TypeEnv env, Ast.Exp node, Unifier.Variable v) {
        Unifier.Variable v3 = null;
        switch (node.op) {
            case BOOL_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.BOOL));
            }
            case CHAR_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.CHAR));
            }
            case INT_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.INT));
            }
            case REAL_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.REAL));
            }
            case STRING_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.STRING));
            }
            case UNIT_LITERAL: {
                return this.reg(node, v, this.toTerm(PrimitiveType.UNIT));
            }
            case ANNOTATED_EXP: {
                Ast.AnnotatedExp annotatedExp = (Ast.AnnotatedExp)node;
                Type type = TypeResolver.toType(annotatedExp.type, this.typeSystem);
                this.deduceType(env, annotatedExp.exp, v);
                return this.reg(node, v, this.toTerm(type, Subst.EMPTY));
            }
            case ANDALSO: 
            case ORELSE: {
                return this.infix(env, (Ast.InfixCall)node, v, PrimitiveType.BOOL);
            }
            case TUPLE: {
                Ast.Tuple tuple = (Ast.Tuple)node;
                ArrayList<Unifier.Term> types = new ArrayList<Unifier.Term>();
                ArrayList<Ast.Exp> args2 = new ArrayList<Ast.Exp>();
                for (Ast.Exp arg : tuple.args) {
                    Unifier.Variable vArg = this.unifier.variable();
                    args2.add(this.deduceType(env, arg, vArg));
                    types.add(vArg);
                }
                return this.reg(tuple.copy(args2), v, this.tuple(types));
            }
            case LIST: {
                Ast.ListExp list = (Ast.ListExp)node;
                Unifier.Variable vArg2 = this.unifier.variable();
                ArrayList<Ast.Exp> args2 = new ArrayList<Ast.Exp>();
                for (Ast.Exp arg : list.args) {
                    args2.add(this.deduceType(env, arg, vArg2));
                }
                return this.reg(list.copy(args2), v, this.unifier.apply(LIST_TY_CON, vArg2));
            }
            case RECORD: {
                Ast.Record record = (Ast.Record)node;
                TreeMap labelTypes = new TreeMap();
                TreeMap<String, Ast.Exp> map2 = new TreeMap<String, Ast.Exp>();
                record.args.forEach((name, exp) -> {
                    Unifier.Variable vArg = this.unifier.variable();
                    Ast.Exp e2 = this.deduceType(env, (Ast.Exp)exp, vArg);
                    labelTypes.put(name, vArg);
                    map2.put((String)name, e2);
                });
                return this.reg(record.copy(map2), v, this.record(labelTypes));
            }
            case LET: {
                Ast.Let let = (Ast.Let)node;
                LinkedHashMap<Ast.IdPat, Unifier.Term> termMap = new LinkedHashMap<Ast.IdPat, Unifier.Term>();
                TypeEnv env2 = env;
                ArrayList<Ast.Decl> decls = new ArrayList<Ast.Decl>();
                for (Ast.Decl decl : let.decls) {
                    decls.add(this.deduceDeclType(env2, decl, termMap));
                    env2 = TypeResolver.bindAll(env2, termMap);
                    termMap.clear();
                }
                Ast.Exp e2 = this.deduceType(env2, let.exp, v);
                Ast.Let let2 = let.copy(decls, e2);
                return this.reg(let2, null, v);
            }
            case RECORD_SELECTOR: {
                Ast.RecordSelector recordSelector = (Ast.RecordSelector)node;
                throw new RuntimeException("Error: unresolved flex record\n   (can't tell what fields there are besides #" + recordSelector.name + ")");
            }
            case IF: {
                Ast.If if_ = (Ast.If)node;
                Unifier.Variable v2 = this.unifier.variable();
                Ast.Exp condition2 = this.deduceType(env, if_.condition, v2);
                this.equiv((Unifier.Term)v2, this.toTerm(PrimitiveType.BOOL));
                Ast.Exp ifTrue2 = this.deduceType(env, if_.ifTrue, v);
                Ast.Exp ifFalse2 = this.deduceType(env, if_.ifFalse, v);
                Ast.If if2 = if_.copy(condition2, ifTrue2, ifFalse2);
                return this.reg(if2, null, v);
            }
            case CASE: {
                List<String> fieldList;
                Ast.Case case_ = (Ast.Case)node;
                Unifier.Variable v2 = this.unifier.variable();
                Ast.Exp e2b = this.deduceType(env, case_.exp, v2);
                TreeSet<String> labelNames = new TreeSet<String>();
                Unifier.Term argType = this.map.get(e2b);
                if (argType instanceof Unifier.Sequence && (fieldList = TypeResolver.fieldList((Unifier.Sequence)argType)) != null) {
                    labelNames.addAll(fieldList);
                }
                List<Ast.Match> matchList2 = this.deduceMatchListType(env, case_.matchList, labelNames, v2, v);
                return this.reg(case_.copy(e2b, matchList2), null, v);
            }
            case FROM: {
                Ast.Exp yieldExp2;
                Ast.From from = (Ast.From)node;
                TypeEnv env3 = env;
                LinkedHashMap<Ast.Id, Unifier.Variable> fieldVars = new LinkedHashMap<Ast.Id, Unifier.Variable>();
                ArrayList<Ast.FromStep> fromSteps = new ArrayList<Ast.FromStep>();
                for (Ord<Ast.FromStep> step : Ord.zip(from.steps)) {
                    Pair<TypeEnv, Unifier.Variable> p = this.deduceStepType(env, (Ast.FromStep)step.e, v3, env3, fieldVars, fromSteps);
                    if (((Ast.FromStep)step.e).op == Op.COMPUTE && step.i != from.steps.size() - 1) {
                        throw new AssertionError((Object)"'compute' step must be last in 'from'");
                    }
                    env3 = (TypeEnv)p.left;
                    v3 = (Unifier.Variable)p.right;
                }
                if (from.implicitYieldExp != null) {
                    v3 = this.unifier.variable();
                    yieldExp2 = this.deduceType(env3, from.implicitYieldExp, v3);
                } else {
                    Objects.requireNonNull(v3);
                    yieldExp2 = null;
                }
                Ast.From from2 = from.copy(fromSteps, from.implicitYieldExp != null ? yieldExp2 : null);
                return this.reg(from2, v, from.isCompute() ? v3 : this.unifier.apply(LIST_TY_CON, v3));
            }
            case ID: {
                Ast.Id id = (Ast.Id)node;
                Unifier.Term term = env.get(this.typeSystem, id.name, name -> new CompileException("unbound variable or constructor: " + name, false, id.pos));
                return this.reg(id, v, term);
            }
            case FN: {
                Ast.Fn fn = (Ast.Fn)node;
                Unifier.Variable resultVariable = this.unifier.variable();
                ArrayList<Ast.Match> matchList = new ArrayList<Ast.Match>();
                for (Ast.Match match : fn.matchList) {
                    matchList.add(this.deduceMatchType(env, match, new HashMap<Ast.IdPat, Unifier.Term>(), v, resultVariable));
                }
                Ast.Fn fn2b = fn.copy(matchList);
                return this.reg(fn2b, null, v);
            }
            case APPLY: {
                BuiltIn builtIn;
                Ast.Exp fn2;
                Ast.Exp arg2;
                Ast.Apply apply = (Ast.Apply)node;
                Unifier.Variable vFn = this.unifier.variable();
                Unifier.Variable vArg = this.unifier.variable();
                this.equiv((Unifier.Term)this.unifier.apply(FN_TY_CON, vArg, v), vFn);
                if (apply.arg instanceof Ast.RecordSelector) {
                    Unifier.Variable vRec = this.unifier.variable();
                    Unifier.Variable vField = this.unifier.variable();
                    this.deduceRecordSelectorType(env, vField, vRec, (Ast.RecordSelector)apply.arg);
                    arg2 = this.reg(apply.arg, vArg, this.unifier.apply(FN_TY_CON, vRec, vField));
                } else {
                    arg2 = this.deduceType(env, apply.arg, vArg);
                }
                if (apply.fn instanceof Ast.RecordSelector) {
                    this.deduceRecordSelectorType(env, v, vArg, (Ast.RecordSelector)apply.fn);
                    fn2 = apply.fn;
                } else {
                    fn2 = this.deduceType(env, apply.fn, vFn);
                }
                if (fn2 instanceof Ast.Id && (builtIn = (BuiltIn)((Object)BuiltIn.BY_ML_NAME.get((Object)((Ast.Id)fn2).name))) != null) {
                    builtIn.prefer(t -> this.preferredTypes.add(v, (PrimitiveType)t));
                }
                return this.reg(apply.copy(fn2, arg2), null, v);
            }
            case AT: 
            case CARET: 
            case COMPOSE: 
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case DIVIDE: 
            case DIV: 
            case MOD: 
            case EQ: 
            case NE: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case ELEM: 
            case NOT_ELEM: 
            case CONS: 
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                return this.infix(env, (Ast.InfixCall)node, v);
            }
            case NEGATE: {
                return this.prefix(env, (Ast.PrefixCall)node, v);
            }
        }
        throw new AssertionError((Object)("cannot deduce type for " + (Object)((Object)node.op)));
    }

    private Pair<TypeEnv, Unifier.Variable> deduceStepType(TypeEnv env, Ast.FromStep step, Unifier.Variable v, TypeEnv env2, Map<Ast.Id, Unifier.Variable> fieldVars, List<Ast.FromStep> fromSteps) {
        switch (step.op) {
            case SCAN: 
            case INNER_JOIN: {
                Object scanCondition22;
                Ast.Exp scanExp;
                boolean eq;
                Ast.Scan scan = (Ast.Scan)step;
                Unifier.Variable v15 = this.unifier.variable();
                Unifier.Variable v16 = this.unifier.variable();
                HashMap<Ast.IdPat, Unifier.Term> termMap1 = new HashMap<Ast.IdPat, Unifier.Term>();
                switch (scan.exp.op) {
                    case SUCH_THAT: {
                        Ast.Exp scanCondition22;
                        Ast.Exp scanExp2 = ((Ast.PrefixCall)scan.exp).a;
                        Ast.Pat pat2 = this.deducePatType(env2, scan.pat, termMap1, null, v16);
                        TypeEnv env4 = env2;
                        for (Map.Entry e : termMap1.entrySet()) {
                            env4 = env4.bind(((Ast.IdPat)e.getKey()).name, (Unifier.Term)e.getValue());
                            fieldVars.put(AstBuilder.ast.id(Pos.ZERO, ((Ast.IdPat)e.getKey()).name), (Unifier.Variable)e.getValue());
                        }
                        Ast.Exp scanExp22 = this.deduceType(env4, scanExp2, v15);
                        Ast.Exp scanExp3 = AstBuilder.ast.fromSuchThat(scanExp22);
                        this.reg(scanExp2, v15, this.toTerm(PrimitiveType.BOOL));
                        if (scan.condition != null) {
                            Unifier.Variable v5 = this.unifier.variable();
                            scanCondition22 = this.deduceType(env4, scan.condition, v5);
                            this.equiv((Unifier.Term)v5, this.toTerm(PrimitiveType.BOOL));
                        } else {
                            scanCondition22 = null;
                        }
                        fromSteps.add(scan.copy(pat2, scanExp3, scanCondition22));
                        return Pair.of(env4, v);
                    }
                    case FROM_EQ: {
                        eq = true;
                        scanExp = ((Ast.PrefixCall)scan.exp).a;
                        break;
                    }
                    default: {
                        eq = false;
                        scanExp = scan.exp;
                    }
                }
                Ast.Exp scanExp2 = this.deduceType(env2, scanExp, v15);
                Ast.Exp scanExp3 = eq ? AstBuilder.ast.fromEq(scanExp2) : scanExp2;
                Ast.Pat pat2 = this.deducePatType(env2, scan.pat, termMap1, null, v16);
                this.reg(scanExp, v15, eq ? v16 : this.unifier.apply(LIST_TY_CON, v16));
                TypeEnv env4 = env2;
                for (Map.Entry e : termMap1.entrySet()) {
                    env4 = env4.bind(((Ast.IdPat)e.getKey()).name, (Unifier.Term)e.getValue());
                    fieldVars.put(AstBuilder.ast.id(Pos.ZERO, ((Ast.IdPat)e.getKey()).name), (Unifier.Variable)e.getValue());
                }
                if (scan.condition != null) {
                    Unifier.Variable v5 = this.unifier.variable();
                    scanCondition22 = this.deduceType(env4, scan.condition, v5);
                    this.equiv((Unifier.Term)v5, this.toTerm(PrimitiveType.BOOL));
                } else {
                    scanCondition22 = null;
                }
                fromSteps.add(scan.copy(pat2, scanExp3, (Ast.Exp)scanCondition22));
                return Pair.of(env4, v);
            }
            case WHERE: {
                Ast.Where where = (Ast.Where)step;
                Unifier.Variable v5 = this.unifier.variable();
                Ast.Exp filter2 = this.deduceType(env2, where.exp, v5);
                this.equiv((Unifier.Term)v5, this.toTerm(PrimitiveType.BOOL));
                fromSteps.add(where.copy(filter2));
                return Pair.of(env2, v);
            }
            case SKIP: {
                Ast.Skip skip = (Ast.Skip)step;
                Unifier.Variable v11 = this.unifier.variable();
                Ast.Exp skipCount = this.deduceType(env2, skip.exp, v11);
                this.equiv((Unifier.Term)v11, this.toTerm(PrimitiveType.INT));
                fromSteps.add(skip.copy(skipCount));
                return Pair.of(env2, v);
            }
            case TAKE: {
                Ast.Take take = (Ast.Take)step;
                Unifier.Variable v12 = this.unifier.variable();
                Ast.Exp takeCount = this.deduceType(env2, take.exp, v12);
                this.equiv((Unifier.Term)v12, this.toTerm(PrimitiveType.INT));
                fromSteps.add(take.copy(takeCount));
                return Pair.of(env2, v);
            }
            case YIELD: {
                Unifier.Variable v6;
                Ast.Yield yield = (Ast.Yield)step;
                v = v6 = this.unifier.variable();
                Ast.Exp yieldExp2 = this.deduceType(env2, yield.exp, v6);
                fromSteps.add(yield.copy(yieldExp2));
                if (yieldExp2.op == Op.RECORD) {
                    Unifier.Sequence sequence = (Unifier.Sequence)this.map.get(yieldExp2);
                    Ast.Record record2 = (Ast.Record)yieldExp2;
                    TypeEnv[] envs = new TypeEnv[]{env};
                    Pair.forEach(record2.args.keySet(), sequence.terms, (name, term) -> {
                        envs[0] = envs[0].bind((String)name, (Unifier.Term)term);
                    });
                    return Pair.of(envs[0], v);
                }
                return Pair.of(env2, v);
            }
            case ORDER: {
                Ast.Order order = (Ast.Order)step;
                ArrayList<Ast.OrderItem> orderItems = new ArrayList<Ast.OrderItem>();
                for (Ast.OrderItem orderItem : order.orderItems) {
                    orderItems.add(orderItem.copy(this.deduceType(env2, orderItem.exp, this.unifier.variable()), orderItem.direction));
                }
                fromSteps.add(order.copy(orderItems));
                return Pair.of(env2, v);
            }
            case GROUP: 
            case COMPUTE: {
                Ast.Group group = (Ast.Group)step;
                this.validateGroup(group);
                TypeEnv env3 = env;
                ImmutableMap inFieldVars = ImmutableMap.copyOf(fieldVars);
                fieldVars.clear();
                PairList<Ast.Id, Ast.Exp> groupExps = PairList.of();
                for (Map.Entry groupExp : group.groupExps) {
                    Ast.Id id = (Ast.Id)groupExp.getKey();
                    Ast.Exp exp = (Ast.Exp)groupExp.getValue();
                    Unifier.Variable v7 = this.unifier.variable();
                    Ast.Exp exp2 = this.deduceType(env2, exp, v7);
                    this.reg(id, null, v7);
                    env3 = env3.bind(id.name, v7);
                    fieldVars.put(id, v7);
                    groupExps.add(id, exp2);
                }
                ArrayList<Ast.Aggregate> aggregates = new ArrayList<Ast.Aggregate>();
                for (Ast.Aggregate aggregate : group.aggregates) {
                    Unifier.Term term2;
                    Ast.Exp arg2;
                    Ast.Id id = aggregate.id;
                    Unifier.Variable v8 = this.unifier.variable();
                    this.reg(id, null, v8);
                    Unifier.Variable v9 = this.unifier.variable();
                    Ast.Exp aggregateFn2 = this.deduceType(env2, aggregate.aggregate, v9);
                    if (aggregate.argument == null) {
                        arg2 = null;
                        term2 = this.fieldRecord((Map<Ast.Id, Unifier.Variable>)inFieldVars);
                    } else {
                        Unifier.Variable v10 = this.unifier.variable();
                        arg2 = this.deduceType(env2, aggregate.argument, v10);
                        term2 = v10;
                    }
                    this.reg(aggregate.aggregate, null, v9);
                    this.equiv((Unifier.Term)this.unifier.apply(FN_TY_CON, this.unifier.apply(LIST_TY_CON, term2), v8), v9);
                    env3 = env3.bind(id.name, v8);
                    fieldVars.put(id, v8);
                    Ast.Aggregate aggregate2 = aggregate.copy(aggregateFn2, arg2, aggregate.id);
                    aggregates.add(aggregate2);
                    this.reg(aggregate2, null, v8);
                }
                fromSteps.add(step.op == Op.GROUP ? group.copy(groupExps, aggregates) : ((Ast.Compute)step).copy(aggregates));
                return Pair.of(env3, v);
            }
        }
        throw new AssertionError((Object)("unknown step type " + (Object)((Object)step.op)));
    }

    private void validateGroup(Ast.Group group) {
        ArrayList names = new ArrayList();
        group.groupExps.leftList().forEach(id -> names.add(id.name));
        group.aggregates.forEach(aggregate -> names.add(aggregate.id.name));
        int duplicate = Util.firstDuplicate(names);
        if (duplicate >= 0) {
            throw new RuntimeException("Duplicate field name '" + (String)names.get(duplicate) + "' in group");
        }
    }

    private Unifier.Term fieldRecord(Map<Ast.Id, Unifier.Variable> fieldVars) {
        switch (fieldVars.size()) {
            case 0: {
                return this.toTerm(PrimitiveType.UNIT);
            }
            case 1: {
                return (Unifier.Term)Iterables.getOnlyElement(fieldVars.values());
            }
        }
        TreeMap map = new TreeMap();
        fieldVars.forEach((k, v) -> map.put(k.name, v));
        return this.record(map);
    }

    private Unifier.Term record(NavigableMap<String, ? extends Unifier.Term> labelTypes) {
        if (labelTypes.isEmpty()) {
            return this.toTerm(PrimitiveType.UNIT);
        }
        if (TypeSystem.areContiguousIntegers(labelTypes.navigableKeySet()) && labelTypes.size() != 1) {
            return this.unifier.apply(TUPLE_TY_CON, labelTypes.values());
        }
        StringBuilder b = new StringBuilder(RECORD_TY_CON);
        for (String label : labelTypes.navigableKeySet()) {
            b.append(':').append(label);
        }
        return this.unifier.apply(b.toString(), labelTypes.values());
    }

    private Unifier.Term tuple(List<Unifier.Term> types) {
        if (types.isEmpty()) {
            return this.toTerm(PrimitiveType.UNIT);
        }
        return this.unifier.apply(TUPLE_TY_CON, types);
    }

    private Ast.RecordSelector deduceRecordSelectorType(TypeEnv env, Unifier.Variable vResult, Unifier.Variable vArg, Ast.RecordSelector recordSelector) {
        String fieldName = recordSelector.name;
        this.actionMap.put(vArg, (v, t, substitution, termPairs) -> {
            int i;
            Unifier.Sequence sequence;
            List<String> fieldList;
            if (t instanceof Unifier.Sequence && (fieldList = TypeResolver.fieldList(sequence = (Unifier.Sequence)t)) != null && (i = fieldList.indexOf(fieldName)) >= 0) {
                Unifier.Term result2 = substitution.resolve(vResult);
                Unifier.Term term = sequence.terms.get(i);
                Unifier.Term term2 = substitution.resolve(term);
                termPairs.add(new Unifier.TermTerm(result2, term2));
            }
        });
        return recordSelector;
    }

    static List<String> fieldList(Unifier.Sequence sequence) {
        if (sequence.operator.equals(RECORD_TY_CON)) {
            return ImmutableList.of();
        }
        if (sequence.operator.startsWith("record:")) {
            String[] fields = sequence.operator.split(":");
            return Static.skip(Arrays.asList(fields));
        }
        if (sequence.operator.equals(TUPLE_TY_CON)) {
            int size = sequence.terms.size();
            return TupleType.ordinalNames(size);
        }
        return null;
    }

    private Ast.Match deduceMatchType(TypeEnv env, Ast.Match match, Map<Ast.IdPat, Unifier.Term> termMap, Unifier.Variable argVariable, Unifier.Variable resultVariable) {
        Unifier.Variable vPat = this.unifier.variable();
        Ast.Pat pat2 = this.deducePatType(env, match.pat, termMap, null, vPat);
        TypeEnv env2 = TypeResolver.bindAll(env, termMap);
        Ast.Exp e2 = this.deduceType(env2, match.exp, resultVariable);
        Ast.Match match2 = match.copy(pat2, e2);
        return this.reg(match2, argVariable, this.unifier.apply(FN_TY_CON, vPat, resultVariable));
    }

    private List<Ast.Match> deduceMatchListType(TypeEnv env, List<Ast.Match> matchList, NavigableSet<String> labelNames, Unifier.Variable argVariable, Unifier.Variable resultVariable) {
        for (Ast.Match match : matchList) {
            if (!(match.pat instanceof Ast.RecordPat)) continue;
            labelNames.addAll(((Ast.RecordPat)match.pat).args.keySet());
        }
        ArrayList<Ast.Match> matchList2 = new ArrayList<Ast.Match>();
        for (Ast.Match match : matchList) {
            HashMap<Ast.IdPat, Unifier.Term> termMap = new HashMap<Ast.IdPat, Unifier.Term>();
            Ast.Pat pat2 = this.deducePatType(env, match.pat, termMap, labelNames, argVariable);
            TypeEnv env2 = TypeResolver.bindAll(env, termMap);
            Ast.Exp e2 = this.deduceType(env2, match.exp, resultVariable);
            matchList2.add(match.copy(pat2, e2));
        }
        return matchList2;
    }

    private AstNode deduceValBindType(TypeEnv env, Ast.ValBind valBind, Map<Ast.IdPat, Unifier.Term> termMap, Unifier.Variable v, Unifier.Variable vPat) {
        this.deducePatType(env, valBind.pat, termMap, null, vPat);
        Ast.Exp e2 = this.deduceType(env, valBind.exp, vPat);
        Ast.ValBind valBind2 = valBind.copy(valBind.pat, e2);
        return this.reg(valBind2, v, this.unifier.apply(FN_TY_CON, vPat, vPat));
    }

    private static TypeEnv bindAll(TypeEnv env, Map<Ast.IdPat, Unifier.Term> termMap) {
        for (Map.Entry<Ast.IdPat, Unifier.Term> entry : termMap.entrySet()) {
            env = env.bind(entry.getKey().name, entry.getValue());
        }
        return env;
    }

    private Ast.Decl deduceDeclType(TypeEnv env, Ast.Decl node, Map<Ast.IdPat, Unifier.Term> termMap) {
        switch (node.op) {
            case VAL_DECL: {
                return this.deduceValDeclType(env, (Ast.ValDecl)node, termMap);
            }
            case FUN_DECL: {
                Ast.ValDecl valDecl = this.toValDecl(env, (Ast.FunDecl)node);
                return this.deduceValDeclType(env, valDecl, termMap);
            }
            case DATATYPE_DECL: {
                Ast.DatatypeDecl datatypeDecl = (Ast.DatatypeDecl)node;
                return this.deduceDataTypeDeclType(env, datatypeDecl, termMap);
            }
        }
        throw new AssertionError((Object)("cannot deduce type for " + (Object)((Object)node.op) + " [" + node + "]"));
    }

    private Ast.Decl deduceDataTypeDeclType(TypeEnv env, Ast.DatatypeDecl datatypeDecl, Map<Ast.IdPat, Unifier.Term> termMap) {
        ArrayList<Keys.DataTypeKey> keys = new ArrayList<Keys.DataTypeKey>();
        for (Ast.DatatypeBind bind : datatypeDecl.binds) {
            Foo foo = new Foo();
            bind.tyVars.forEach(foo::toTypeKey);
            TreeMap<String, Type.Key> tyCons = new TreeMap<String, Type.Key>();
            this.deduceDatatypeBindType(bind, tyCons);
            keys.add(Keys.datatype(bind.name.name, Keys.ordinals(foo.tyVarMap.size()), tyCons));
        }
        List<Type> types = this.typeSystem.dataTypes(keys);
        Pair.forEach(datatypeDecl.binds, types, (datatypeBind, type) -> {
            DataType dataType = (DataType)(type instanceof DataType ? type : ((ForallType)type).type);
            for (Ast.TyCon tyCon : datatypeBind.tyCons) {
                BaseType tyConType;
                if (tyCon.type != null) {
                    Type.Key conKey = TypeResolver.toTypeKey(tyCon.type);
                    tyConType = this.typeSystem.fnType(conKey.toType(this.typeSystem), dataType);
                } else {
                    tyConType = dataType;
                }
                termMap.put((Ast.IdPat)AstBuilder.ast.idPat(tyCon.pos, tyCon.id.name), this.toTerm(tyConType, Subst.EMPTY));
                this.map.put(tyCon, this.toTerm(tyConType, Subst.EMPTY));
            }
        });
        this.map.put(datatypeDecl, this.toTerm(PrimitiveType.UNIT));
        return datatypeDecl;
    }

    private Ast.Decl deduceValDeclType(TypeEnv env, Ast.ValDecl valDecl, Map<Ast.IdPat, Unifier.Term> termMap) {
        Holder envHolder = Holder.of((Object)env);
        LinkedHashMap<Ast.ValBind, Supplier> map0 = new LinkedHashMap<Ast.ValBind, Supplier>();
        valDecl.valBinds.forEach(b -> map0.put((Ast.ValBind)b, () -> ((com.google.common.base.Supplier)Suppliers.memoize(this.unifier::variable)).get()));
        map0.forEach((valBind, vPatSupplier) -> {
            if (valDecl.rec && valBind.pat instanceof Ast.IdPat) {
                envHolder.set((Object)((TypeEnv)envHolder.get()).bind(((Ast.IdPat)valBind.pat).name, (Unifier.Term)vPatSupplier.get()));
            }
        });
        ArrayList<Ast.ValBind> valBinds = new ArrayList<Ast.ValBind>();
        TypeEnv env2 = (TypeEnv)envHolder.get();
        map0.forEach((valBind, vPatSupplier) -> valBinds.add((Ast.ValBind)this.deduceValBindType(env2, (Ast.ValBind)valBind, termMap, this.unifier.variable(), (Unifier.Variable)vPatSupplier.get())));
        Ast.ValDecl node2 = valDecl.copy(valBinds);
        this.map.put(node2, this.toTerm(PrimitiveType.UNIT));
        return node2;
    }

    private void deduceDatatypeBindType(Ast.DatatypeBind datatypeBind, SortedMap<String, Type.Key> tyCons) {
        Foo foo = new Foo();
        for (Ast.TyCon tyCon : datatypeBind.tyCons) {
            tyCons.put(tyCon.id.name, tyCon.type == null ? Keys.dummy() : foo.toTypeKey(tyCon.type));
        }
    }

    private Ast.ValDecl toValDecl(TypeEnv env, Ast.FunDecl funDecl) {
        ArrayList<Ast.ValBind> valBindList = new ArrayList<Ast.ValBind>();
        for (Ast.FunBind funBind : funDecl.funBinds) {
            valBindList.add(this.toValBind(env, funBind));
        }
        return AstBuilder.ast.valDecl(funDecl.pos, true, valBindList);
    }

    private Ast.ValBind toValBind(TypeEnv env, Ast.FunBind funBind) {
        List vars;
        Ast.Exp exp;
        Ast.Type returnType = null;
        if (funBind.matchList.size() == 1) {
            Ast.FunMatch funMatch = funBind.matchList.get(0);
            exp = funMatch.exp;
            vars = funMatch.patList;
            returnType = funMatch.returnType;
        } else {
            MapList<String> varNames = MapList.of(funBind.matchList.get((int)0).patList.size(), index -> "v" + index);
            vars = Lists.transform(varNames, v -> AstBuilder.ast.idPat(Pos.ZERO, (String)v));
            ArrayList<Ast.Match> matchList = new ArrayList<Ast.Match>();
            Pos prevReturnTypePos = null;
            for (Ast.FunMatch funMatch : funBind.matchList) {
                matchList.add(AstBuilder.ast.match(funMatch.pos, this.patTuple(env, funMatch.patList), funMatch.exp));
                if (funMatch.returnType == null) continue;
                if (returnType != null && !returnType.equals(funMatch.returnType)) {
                    throw new CompileException("parameter or result constraints of clauses don't agree [tycon mismatch]", false, prevReturnTypePos.plus(funMatch.pos));
                }
                returnType = funMatch.returnType;
                prevReturnTypePos = funMatch.pos;
            }
            exp = AstBuilder.ast.caseOf(Pos.ZERO, TypeResolver.idTuple(varNames), matchList);
        }
        if (returnType != null) {
            exp = AstBuilder.ast.annotatedExp(exp.pos, exp, returnType);
        }
        Pos pos = funBind.pos;
        for (Ast.Pat var : Lists.reverse((List)vars)) {
            exp = AstBuilder.ast.fn(pos, AstBuilder.ast.match(pos, var, exp));
        }
        return AstBuilder.ast.valBind(pos, AstBuilder.ast.idPat(pos, funBind.name), exp);
    }

    private static Ast.Exp idTuple(List<String> vars) {
        List idList = Lists.transform(vars, v -> AstBuilder.ast.id(Pos.ZERO, (String)v));
        if (idList.size() == 1) {
            return (Ast.Exp)idList.get(0);
        }
        return AstBuilder.ast.tuple(Pos.ZERO, idList);
    }

    private Ast.Pat patTuple(TypeEnv env, List<Ast.Pat> patList) {
        ArrayList<Ast.Pat> list2 = new ArrayList<Ast.Pat>();
        block3: for (int i = 0; i < patList.size(); ++i) {
            Ast.Pat pat = patList.get(i);
            switch (pat.op) {
                case ID_PAT: {
                    Ast.IdPat idPat = (Ast.IdPat)pat;
                    if (env.has(idPat.name) && this.typeSystem.lookupTyCon(idPat.name) != null) {
                        Unifier.Term term = env.get(this.typeSystem, idPat.name, name -> new RuntimeException("oops, should have " + idPat.name));
                        if (term instanceof Unifier.Sequence && ((Unifier.Sequence)term).operator.equals(FN_TY_CON)) {
                            list2.add(AstBuilder.ast.conPat(idPat.pos, AstBuilder.ast.id(idPat.pos, idPat.name), patList.get(++i)));
                            continue block3;
                        }
                        list2.add(AstBuilder.ast.con0Pat(idPat.pos, AstBuilder.ast.id(idPat.pos, idPat.name)));
                        continue block3;
                    }
                }
                default: {
                    list2.add(pat);
                }
            }
        }
        if (list2.size() == 1) {
            return (Ast.Pat)list2.get(0);
        }
        return AstBuilder.ast.tuplePat(Pos.sum(list2), list2);
    }

    private Ast.Pat deducePatType(TypeEnv env, Ast.Pat pat, Map<Ast.IdPat, Unifier.Term> termMap, NavigableSet<String> labelNames, Unifier.Variable v) {
        switch (pat.op) {
            case BOOL_LITERAL_PAT: {
                return this.reg(pat, v, this.toTerm(PrimitiveType.BOOL));
            }
            case CHAR_LITERAL_PAT: {
                return this.reg(pat, v, this.toTerm(PrimitiveType.CHAR));
            }
            case INT_LITERAL_PAT: {
                return this.reg(pat, v, this.toTerm(PrimitiveType.INT));
            }
            case REAL_LITERAL_PAT: {
                return this.reg(pat, v, this.toTerm(PrimitiveType.REAL));
            }
            case STRING_LITERAL_PAT: {
                return this.reg(pat, v, this.toTerm(PrimitiveType.STRING));
            }
            case ID_PAT: {
                termMap.put((Ast.IdPat)pat, v);
            }
            case WILDCARD_PAT: {
                return this.reg(pat, null, v);
            }
            case AS_PAT: {
                Ast.AsPat asPat = (Ast.AsPat)pat;
                termMap.put(asPat.id, v);
                this.deducePatType(env, asPat.pat, termMap, null, v);
                return this.reg(pat, null, v);
            }
            case ANNOTATED_PAT: {
                Ast.AnnotatedPat annotatedPat = (Ast.AnnotatedPat)pat;
                Type type = TypeResolver.toType(annotatedPat.type, this.typeSystem);
                this.deducePatType(env, annotatedPat.pat, termMap, null, v);
                return this.reg(pat, v, this.toTerm(type, Subst.EMPTY));
            }
            case TUPLE_PAT: {
                ArrayList<Unifier.Term> typeTerms = new ArrayList<Unifier.Term>();
                Ast.TuplePat tuple = (Ast.TuplePat)pat;
                for (Ast.Pat arg : tuple.args) {
                    Unifier.Variable vArg = this.unifier.variable();
                    this.deducePatType(env, arg, termMap, null, vArg);
                    typeTerms.add(vArg);
                }
                return this.reg(pat, v, this.tuple(typeTerms));
            }
            case RECORD_PAT: {
                Ast.RecordPat recordPat = (Ast.RecordPat)pat;
                TreeMap<String, Unifier.Variable> labelTerms = new TreeMap<String, Unifier.Variable>((Comparator<String>)RecordType.ORDERING);
                if (labelNames == null) {
                    labelNames = new TreeSet<String>(recordPat.args.keySet());
                }
                TreeMap<String, Ast.Pat> args = new TreeMap<String, Ast.Pat>((Comparator<String>)RecordType.ORDERING);
                for (String labelName : labelNames) {
                    Unifier.Variable vArg = this.unifier.variable();
                    labelTerms.put(labelName, vArg);
                    Ast.Pat argPat = (Ast.Pat)recordPat.args.get(labelName);
                    if (argPat == null) continue;
                    args.put(labelName, this.deducePatType(env, argPat, termMap, null, vArg));
                }
                Unifier.Term record = this.record(labelTerms);
                Ast.RecordPat recordPat2 = recordPat.copy(recordPat.ellipsis, args);
                if (!recordPat.ellipsis) {
                    return this.reg(recordPat2, v, record);
                }
                Unifier.Variable v2 = this.unifier.variable();
                this.equiv(record, v2);
                this.actionMap.put(v, (v3, t, substitution, termPairs) -> {
                    Unifier.Sequence sequence;
                    List<String> fieldList;
                    assert (v == v3);
                    if (t instanceof Unifier.Sequence && (fieldList = TypeResolver.fieldList(sequence = (Unifier.Sequence)t)) != null) {
                        TreeMap labelTerms2 = new TreeMap((Comparator<String>)RecordType.ORDERING);
                        Ord.forEachIndexed(fieldList, (fieldName, i) -> {
                            if (labelTerms.containsKey(fieldName)) {
                                labelTerms2.put((String)fieldName, sequence.terms.get(i));
                            }
                        });
                        Unifier.Term result2 = substitution.resolve(v2);
                        Unifier.Term term2 = this.record(labelTerms2);
                        termPairs.add(new Unifier.TermTerm(result2, term2));
                    }
                });
                return this.reg(recordPat2, null, record);
            }
            case CON_PAT: {
                Ast.ConPat conPat = (Ast.ConPat)pat;
                Pair<DataType, Type.Key> pair = this.typeSystem.lookupTyCon(conPat.tyCon.name);
                if (pair == null) {
                    throw new AssertionError((Object)("not found: " + conPat.tyCon.name));
                }
                DataType dataType = (DataType)pair.left;
                Type argType = ((Type.Key)pair.right).toType(this.typeSystem);
                Unifier.Variable vArg = this.unifier.variable();
                this.deducePatType(env, conPat.pat, termMap, null, vArg);
                Unifier.Term argTerm = this.toTerm(argType, Subst.EMPTY);
                this.equiv((Unifier.Term)vArg, argTerm);
                Unifier.Term term = this.toTerm(dataType, Subst.EMPTY);
                if (argType instanceof TypeVar) {
                    this.equiv(argTerm, ((Unifier.Sequence)term).terms.get(((TypeVar)argType).ordinal));
                }
                return this.reg(pat, v, term);
            }
            case CON0_PAT: {
                Ast.Con0Pat con0Pat = (Ast.Con0Pat)pat;
                Pair<DataType, Type.Key> pair0 = this.typeSystem.lookupTyCon(con0Pat.tyCon.name);
                if (pair0 == null) {
                    throw new AssertionError();
                }
                DataType dataType0 = (DataType)pair0.left;
                return this.reg(pat, v, this.toTerm(dataType0, Subst.EMPTY));
            }
            case LIST_PAT: {
                Ast.ListPat list = (Ast.ListPat)pat;
                Unifier.Variable vArg2 = this.unifier.variable();
                for (Ast.Pat arg : list.args) {
                    this.deducePatType(env, arg, termMap, null, vArg2);
                }
                return this.reg(list, v, this.unifier.apply(LIST_TY_CON, vArg2));
            }
            case CONS_PAT: {
                Unifier.Variable elementType = this.unifier.variable();
                Ast.InfixPat call = (Ast.InfixPat)pat;
                this.deducePatType(env, call.p0, termMap, null, elementType);
                this.deducePatType(env, call.p1, termMap, null, v);
                return this.reg(call, v, this.unifier.apply(LIST_TY_CON, elementType));
            }
        }
        throw new AssertionError((Object)("cannot deduce type for pattern " + (Object)((Object)pat.op)));
    }

    private Ast.Exp infix(TypeEnv env, Ast.InfixCall call, Unifier.Variable v, Type type) {
        Unifier.Term term = this.toTerm(type, Subst.EMPTY);
        Ast.Exp a0 = this.deduceType(env, call.a0, v);
        Ast.Exp a1 = this.deduceType(env, call.a1, v);
        return this.reg(call.copy(a0, a1), v, term);
    }

    private Ast.Exp infix(TypeEnv env, Ast.InfixCall call, Unifier.Variable v) {
        return this.deduceType(env, AstBuilder.ast.apply(AstBuilder.ast.id(Pos.ZERO, call.op.opName), AstBuilder.ast.tuple(Pos.ZERO, (Iterable<? extends Ast.Exp>)ImmutableList.of((Object)call.a0, (Object)call.a1))), v);
    }

    private Ast.Exp prefix(TypeEnv env, Ast.PrefixCall call, Unifier.Variable v) {
        return this.deduceType(env, AstBuilder.ast.apply(AstBuilder.ast.id(Pos.ZERO, call.op.opName), call.a), v);
    }

    private void equiv(Unifier.Term term, Unifier.Variable atom) {
        this.terms.add(new TermVariable(term, atom));
    }

    private void equiv(Unifier.Term term, Unifier.Term term2) {
        if (term2 instanceof Unifier.Variable) {
            this.equiv(term, (Unifier.Variable)term2);
        } else if (term instanceof Unifier.Variable) {
            this.equiv(term2, (Unifier.Variable)term);
        } else {
            Unifier.Variable variable = this.unifier.variable();
            this.equiv(term, variable);
            this.equiv(term2, variable);
        }
    }

    private List<Unifier.Term> toTerms(Iterable<? extends Type> types, Subst subst) {
        return Static.transformEager(types, type -> this.toTerm((Type)type, subst));
    }

    private Unifier.Term toTerm(PrimitiveType type) {
        return this.unifier.atom(type.moniker);
    }

    private Unifier.Term toTerm(Type type, Subst subst) {
        switch (type.op()) {
            case ID: {
                return this.toTerm((PrimitiveType)type);
            }
            case TY_VAR: {
                Unifier.Variable variable = subst.get((TypeVar)type);
                return variable != null ? variable : this.unifier.variable();
            }
            case DATA_TYPE: {
                DataType dataType = (DataType)type;
                return this.unifier.apply(dataType.name(), this.toTerms(dataType.arguments, subst));
            }
            case FUNCTION_TYPE: {
                FnType fnType = (FnType)type;
                return this.unifier.apply(FN_TY_CON, this.toTerm(fnType.paramType, subst), this.toTerm(fnType.resultType, subst));
            }
            case TUPLE_TYPE: {
                TupleType tupleType = (TupleType)type;
                return this.unifier.apply(TUPLE_TY_CON, Static.transform(tupleType.argTypes, type1 -> this.toTerm((Type)type1, subst)));
            }
            case RECORD_TYPE: {
                String result;
                NavigableSet labelNames;
                RecordType recordType = (RecordType)type;
                SortedMap<String, Type> argNameTypes = recordType.argNameTypes;
                if (recordType.isProgressive()) {
                    argNameTypes = new TreeMap<String, Type>(argNameTypes);
                    argNameTypes.put(PROGRESSIVE_LABEL, PrimitiveType.UNIT);
                }
                if ((labelNames = (NavigableSet)argNameTypes.keySet()).isEmpty()) {
                    result = PrimitiveType.UNIT.name();
                } else if (TypeSystem.areContiguousIntegers(labelNames)) {
                    result = TUPLE_TY_CON;
                } else {
                    StringBuilder b = new StringBuilder(RECORD_TY_CON);
                    for (String label : labelNames) {
                        b.append(':').append(label);
                    }
                    result = b.toString();
                }
                ImmutableList<Unifier.Term> args = Static.transformEager(argNameTypes.values(), type1 -> this.toTerm((Type)type1, subst));
                return this.unifier.apply(result, (Iterable<? extends Unifier.Term>)args);
            }
            case LIST: {
                ListType listType = (ListType)type;
                return this.unifier.apply(LIST_TY_CON, this.toTerm(listType.elementType, subst));
            }
            case FORALL_TYPE: {
                ForallType forallType = (ForallType)type;
                Subst subst2 = subst;
                for (int i = 0; i < forallType.parameterCount; ++i) {
                    subst2 = subst2.plus(this.typeSystem.typeVariable(i), this.unifier.variable());
                }
                return this.toTerm(forallType.type, subst2);
            }
        }
        throw new AssertionError((Object)("unknown type: " + type.moniker()));
    }

    private static abstract class Subst {
        static final Subst EMPTY = new EmptySubst();

        private Subst() {
        }

        Subst plus(TypeVar typeVar, Unifier.Variable variable) {
            return new PlusSubst(this, typeVar, variable);
        }

        abstract Unifier.Variable get(TypeVar var1);
    }

    public static class Resolved {
        public final Environment env;
        public final Ast.Decl originalNode;
        public final Ast.Decl node;
        public final TypeMap typeMap;

        private Resolved(Environment env, Ast.Decl originalNode, Ast.Decl node, TypeMap typeMap) {
            this.env = env;
            this.originalNode = Objects.requireNonNull(originalNode);
            this.node = Objects.requireNonNull(node);
            this.typeMap = Objects.requireNonNull(typeMap);
            Preconditions.checkArgument((boolean)(originalNode instanceof Ast.FunDecl ? node instanceof Ast.ValDecl : originalNode.getClass() == node.getClass()));
        }

        static Resolved of(Environment env, Ast.Decl originalNode, Ast.Decl node, TypeMap typeMap) {
            return new Resolved(env, originalNode, node, typeMap);
        }

        public Ast.Exp exp() {
            if (this.node instanceof Ast.ValDecl) {
                Ast.ValDecl valDecl = (Ast.ValDecl)this.node;
                if (valDecl.valBinds.size() == 1) {
                    Ast.ValBind valBind = valDecl.valBinds.get(0);
                    return valBind.exp;
                }
            }
            throw new AssertionError((Object)("not an expression: " + this.node));
        }
    }

    private static class Foo {
        final Map<String, Integer> tyVarMap = new HashMap<String, Integer>();

        private Foo() {
        }

        Type.Key toTypeKey(Ast.Type type) {
            switch (type.op) {
                case TUPLE_TYPE: {
                    Ast.TupleType tupleType = (Ast.TupleType)type;
                    return Keys.tuple(this.toTypeKeys(tupleType.types));
                }
                case RECORD_TYPE: {
                    Ast.RecordType recordType = (Ast.RecordType)type;
                    ImmutableSortedMap.Builder argNameTypes = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
                    AtomicBoolean progressive = new AtomicBoolean(false);
                    recordType.fieldTypes.forEach((name, t) -> {
                        if (name.equals(TypeResolver.PROGRESSIVE_LABEL)) {
                            progressive.set(true);
                        } else {
                            argNameTypes.put(name, (Object)this.toTypeKey((Ast.Type)t));
                        }
                    });
                    return progressive.get() ? Keys.progressiveRecord((SortedMap<String, ? extends Type.Key>)argNameTypes.build()) : Keys.record((SortedMap<String, ? extends Type.Key>)argNameTypes.build());
                }
                case FUNCTION_TYPE: {
                    Ast.FunctionType functionType = (Ast.FunctionType)type;
                    Type.Key paramType = this.toTypeKey(functionType.paramType);
                    Type.Key resultType = this.toTypeKey(functionType.resultType);
                    return Keys.fn(paramType, resultType);
                }
                case NAMED_TYPE: {
                    Ast.NamedType namedType = (Ast.NamedType)type;
                    List<Type.Key> typeList = this.toTypeKeys(namedType.types);
                    if (namedType.name.equals(TypeResolver.LIST_TY_CON) && typeList.size() == 1) {
                        return Keys.list(typeList.get(0));
                    }
                    if (typeList.isEmpty()) {
                        return Keys.name(namedType.name);
                    }
                    return Keys.apply(Keys.name(namedType.name), typeList);
                }
                case TY_VAR: {
                    Ast.TyVar tyVar = (Ast.TyVar)type;
                    return Keys.ordinal(this.tyVarMap.computeIfAbsent(tyVar.name, name -> this.tyVarMap.size()));
                }
            }
            throw new AssertionError((Object)("cannot convert type " + type + " " + (Object)((Object)type.op)));
        }

        List<Type.Key> toTypeKeys(Iterable<? extends Ast.Type> types) {
            return Static.transformEager(types, this::toTypeKey);
        }
    }

    private class TypeEnvHolder
    implements BiConsumer<String, Type> {
        private TypeEnv typeEnv;

        TypeEnvHolder(TypeEnv typeEnv) {
            this.typeEnv = Objects.requireNonNull(typeEnv);
        }

        @Override
        public void accept(String name, final Type type) {
            this.typeEnv = this.typeEnv.bind(name, new Function<TypeSystem, Unifier.Term>(){

                @Override
                public Unifier.Term apply(TypeSystem typeSystem_) {
                    return TypeResolver.this.toTerm(type, Subst.EMPTY);
                }

                public String toString() {
                    return type.moniker();
                }
            });
        }
    }

    static enum EmptyTypeEnv implements TypeEnv
    {
        INSTANCE;


        @Override
        public Unifier.Term get(TypeSystem typeSystem, String name, Function<String, RuntimeException> exceptionFactory) {
            throw exceptionFactory.apply(name);
        }

        @Override
        public boolean has(String name) {
            return false;
        }

        @Override
        public TypeEnv bind(String name, Function<TypeSystem, Unifier.Term> termFactory) {
            return new BindTypeEnv(name, termFactory, this);
        }

        public String toString() {
            return "[]";
        }
    }

    static interface TypeEnv {
        public Unifier.Term get(TypeSystem var1, String var2, Function<String, RuntimeException> var3);

        public boolean has(String var1);

        public TypeEnv bind(String var1, Function<TypeSystem, Unifier.Term> var2);

        default public TypeEnv bind(String name, final Unifier.Term term) {
            return this.bind(name, new Function<TypeSystem, Unifier.Term>(){

                @Override
                public Unifier.Term apply(TypeSystem typeSystem) {
                    return term;
                }

                public String toString() {
                    return term.toString();
                }
            });
        }
    }

    public static class TypeException
    extends CompileException {
        public TypeException(String message, Pos pos) {
            super(message, false, pos);
        }
    }

    static class FieldExpander
    extends EnvVisitor {
        static FieldExpander create(TypeSystem typeSystem, Environment env) {
            return new FieldExpander(typeSystem, env, new ArrayDeque<EnvVisitor.FromContext>());
        }

        private FieldExpander(TypeSystem typeSystem, Environment env, Deque<EnvVisitor.FromContext> fromStack) {
            super(typeSystem, env, fromStack);
        }

        @Override
        protected EnvVisitor push(Environment env) {
            return new FieldExpander(this.typeSystem, env, this.fromStack);
        }

        @Override
        protected void visit(Ast.Apply apply) {
            super.visit(apply);
            this.expandField(this.env, apply);
        }

        @Override
        protected void visit(Ast.Id id) {
            super.visit(id);
            this.expandField(this.env, id);
        }

        private @Nullable TypedValue expandField(Environment env, Ast.Exp exp) {
            switch (exp.op) {
                case APPLY: {
                    Ast.Apply apply = (Ast.Apply)exp;
                    if (apply.fn.op == Op.RECORD_SELECTOR) {
                        Ast.RecordSelector selector = (Ast.RecordSelector)apply.fn;
                        TypedValue typedValue = this.expandField(env, apply.arg);
                        if (typedValue != null) {
                            typedValue.discoverField(this.typeSystem, selector.name);
                            return typedValue.fieldValueAs(selector.name, TypedValue.class);
                        }
                    }
                    return null;
                }
                case ID: {
                    Binding binding = env.getOpt(((Ast.Id)exp).name);
                    if (binding == null || !(binding.value instanceof TypedValue)) break;
                    return (TypedValue)binding.value;
                }
            }
            return null;
        }
    }

    private static class TermVariable {
        final Unifier.Term term;
        final Unifier.Variable variable;

        private TermVariable(Unifier.Term term, Unifier.Variable variable) {
            this.term = term;
            this.variable = variable;
        }

        public String toString() {
            return this.term + " = " + this.variable;
        }
    }

    private static class PlusSubst
    extends Subst {
        final Subst parent;
        final TypeVar typeVar;
        final Unifier.Variable variable;

        PlusSubst(Subst parent, TypeVar typeVar, Unifier.Variable variable) {
            this.parent = parent;
            this.typeVar = typeVar;
            this.variable = variable;
        }

        @Override
        Unifier.Variable get(TypeVar typeVar) {
            return typeVar.equals(this.typeVar) ? this.variable : this.parent.get(typeVar);
        }

        public String toString() {
            LinkedHashMap<TypeVar, Unifier.Variable> map = new LinkedHashMap<TypeVar, Unifier.Variable>();
            PlusSubst e = this;
            while (true) {
                map.putIfAbsent(e.typeVar, e.variable);
                if (!(e.parent instanceof PlusSubst)) break;
                e = (PlusSubst)e.parent;
            }
            return ((Object)map).toString();
        }
    }

    private static class EmptySubst
    extends Subst {
        private EmptySubst() {
        }

        public String toString() {
            return "[]";
        }

        @Override
        Unifier.Variable get(TypeVar typeVar) {
            return null;
        }
    }

    private static class BindTypeEnv
    implements TypeEnv {
        private final String definedName;
        private final Function<TypeSystem, Unifier.Term> termFactory;
        private final TypeEnv parent;

        BindTypeEnv(String definedName, Function<TypeSystem, Unifier.Term> termFactory, TypeEnv parent) {
            this.definedName = Objects.requireNonNull(definedName);
            this.termFactory = Objects.requireNonNull(termFactory);
            this.parent = Objects.requireNonNull(parent);
        }

        @Override
        public Unifier.Term get(TypeSystem typeSystem, String name, Function<String, RuntimeException> exceptionFactory) {
            BindTypeEnv e = this;
            while (!e.definedName.equals(name)) {
                if (!(e.parent instanceof BindTypeEnv)) {
                    return e.parent.get(typeSystem, name, exceptionFactory);
                }
                e = (BindTypeEnv)e.parent;
            }
            return e.termFactory.apply(typeSystem);
        }

        @Override
        public boolean has(String name) {
            return name.equals(this.definedName) || this.parent.has(name);
        }

        @Override
        public TypeEnv bind(String name, Function<TypeSystem, Unifier.Term> termFactory) {
            return new BindTypeEnv(name, termFactory, this);
        }

        public String toString() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            BindTypeEnv e = this;
            while (true) {
                map.putIfAbsent(e.definedName, e.termFactory.toString());
                if (!(e.parent instanceof BindTypeEnv)) break;
                e = (BindTypeEnv)e.parent;
            }
            return ((Object)map).toString();
        }
    }
}

