/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.foreign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.hydromatic.morel.foreign.Calcite;
import net.hydromatic.morel.foreign.Converter;
import net.hydromatic.morel.foreign.Converters;
import net.hydromatic.morel.foreign.ForeignValue;
import net.hydromatic.morel.foreign.RelList;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.Ord;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.tools.RelBuilder;

public class CalciteForeignValue
implements ForeignValue {
    private final Calcite calcite;
    private final SchemaPlus schema;
    private final boolean lower;

    public CalciteForeignValue(Calcite calcite, SchemaPlus schema, boolean lower) {
        this.calcite = Objects.requireNonNull(calcite);
        this.schema = Objects.requireNonNull(schema);
        this.lower = lower;
    }

    @Override
    public Type type(TypeSystem typeSystem) {
        return this.toType(this.schema, typeSystem);
    }

    private Type toType(SchemaPlus schema, TypeSystem typeSystem) {
        ImmutableSortedMap.Builder fields = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        schema.getTableNames().forEach(tableName -> {
            Table table = Objects.requireNonNull(schema.getTable(tableName));
            fields.put((Object)this.convert((String)tableName), (Object)this.toType(table, typeSystem));
        });
        schema.getSubSchemaNames().forEach(subSchemaName -> {
            SchemaPlus subSchema = Objects.requireNonNull(schema.getSubSchema(subSchemaName));
            fields.put((Object)this.convert((String)subSchemaName), (Object)this.toType(subSchema, typeSystem));
        });
        return typeSystem.recordType((SortedMap<String, ? extends Type>)fields.build());
    }

    private Type toType(Table table, TypeSystem typeSystem) {
        ImmutableSortedMap.Builder fields = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        table.getRowType((RelDataTypeFactory)this.calcite.typeFactory).getFieldList().forEach(field -> fields.put((Object)this.convert(field.getName()), (Object)Converters.fieldType(field)));
        return typeSystem.listType(typeSystem.recordType((SortedMap<String, ? extends Type>)fields.build()));
    }

    private String convert(String name) {
        return CalciteForeignValue.convert(this.lower, name);
    }

    private static String convert(boolean lower, String name) {
        return lower ? name.toLowerCase(Locale.ROOT) : name;
    }

    @Override
    public Object value() {
        return this.valueFor(this.schema);
    }

    private ImmutableList<Object> valueFor(SchemaPlus schema) {
        TreeMap fieldValues = new TreeMap((Comparator<String>)RecordType.ORDERING);
        List names = Schemas.path((SchemaPlus)schema).names();
        schema.getTableNames().forEach(tableName -> {
            RelBuilder b = this.calcite.relBuilder;
            b.scan(CalciteForeignValue.plus(names, tableName));
            List exprList = b.peek().getRowType().getFieldList().stream().map(f -> Ord.of(f.getIndex(), this.convert(f.getName()))).sorted(Map.Entry.comparingByValue()).map(p -> b.alias((RexNode)b.field(p.i), (String)p.e)).collect(Collectors.toList());
            b.project(exprList, (Iterable)ImmutableList.of(), true);
            RelNode rel = b.build();
            Converter<Object[]> converter = Converters.ofRow(rel.getRowType());
            fieldValues.put(this.convert((String)tableName), new RelList(rel, this.calcite.dataContext, converter));
        });
        schema.getSubSchemaNames().forEach(subSchemaName -> {
            SchemaPlus subSchema = Objects.requireNonNull(schema.getSubSchema(subSchemaName));
            fieldValues.put(this.convert((String)subSchemaName), this.valueFor(subSchema));
        });
        return ImmutableList.copyOf(fieldValues.values());
    }

    private static <E> List<E> plus(List<E> list, E e) {
        return ImmutableList.builder().addAll(list).add(e).build();
    }
}

