/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.SortedMap;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.ParameterizedType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVisitor;
import net.hydromatic.morel.util.Static;

public class DataType
extends ParameterizedType {
    public final List<Type> arguments;
    public final SortedMap<String, Type.Key> typeConstructors;

    DataType(String name, String moniker, List<? extends Type> arguments, SortedMap<String, Type.Key> typeConstructors) {
        this(Op.DATA_TYPE, name, moniker, arguments, typeConstructors);
    }

    protected DataType(Op op, String name, String moniker, List<? extends Type> arguments, SortedMap<String, Type.Key> typeConstructors) {
        super(op, name, moniker, arguments.size());
        this.arguments = ImmutableList.copyOf(arguments);
        this.typeConstructors = ImmutableSortedMap.copyOf(typeConstructors);
        Preconditions.checkArgument((typeConstructors.comparator() == null || typeConstructors.comparator() == Ordering.natural() ? 1 : 0) != 0);
    }

    @Override
    public Type.Key key() {
        return Keys.datatype(this.name, Keys.toKeys(this.arguments), this.typeConstructors);
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    public SortedMap<String, Type> typeConstructors(TypeSystem typeSystem) {
        return Maps.transformValues(this.typeConstructors, k -> k.copy(t -> t.substitute(this.arguments)).toType(typeSystem));
    }

    @Override
    public DataType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        ImmutableList arguments = Static.transformEager(this.arguments, transform);
        if (arguments.equals(this.arguments)) {
            return this;
        }
        return new DataType(this.name, this.moniker, (List<? extends Type>)arguments, this.typeConstructors);
    }

    public StringBuilder describe(StringBuilder buf) {
        buf.append("datatype ").append(this.moniker).append(" = ");
        int initialSize = buf.length();
        this.typeConstructors.forEach((name, typeKey) -> {
            if (buf.length() > initialSize) {
                buf.append(" | ");
            }
            buf.append((String)name);
            if (typeKey.op != Op.DUMMY_TYPE) {
                buf.append(" of ");
                typeKey.describe(buf, 0, 0);
            }
        });
        return buf;
    }
}

