/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVisitor;

public class FnType
extends BaseType {
    public final Type paramType;
    public final Type resultType;

    FnType(Type paramType, Type resultType) {
        super(Op.FUNCTION_TYPE);
        this.paramType = paramType;
        this.resultType = resultType;
    }

    @Override
    public Type.Key key() {
        return Keys.fn(this.paramType.key(), this.resultType.key());
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    @Override
    public FnType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        Type paramType2 = this.paramType.copy(typeSystem, transform);
        Type resultType2 = this.resultType.copy(typeSystem, transform);
        return paramType2 == this.paramType && resultType2 == this.resultType ? this : typeSystem.fnType(paramType2, resultType2);
    }
}

