/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.parse.Parsers;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.DummyType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ForallType;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.ProgressiveRecordType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.util.Static;

public class Keys {
    private Keys() {
    }

    public static Type.Key name(String name) {
        return new NameKey(name);
    }

    public static Type.Key dummy() {
        return Keys.name("");
    }

    public static Type.Key ordinal(int ordinal) {
        return new OrdinalKey(ordinal);
    }

    public static List<Type.Key> ordinals(final int size) {
        return new AbstractList<Type.Key>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public Type.Key get(int index) {
                return new OrdinalKey(index);
            }
        };
    }

    public static Type.Key apply(Type.Key type, Iterable<? extends Type.Key> args) {
        return new ApplyKey(type, (ImmutableList<Type.Key>)ImmutableList.copyOf(args));
    }

    public static Type.Key record(SortedMap<String, ? extends Type.Key> argNameTypes) {
        return new RecordKey((ImmutableSortedMap<String, Type.Key>)ImmutableSortedMap.copyOfSorted(argNameTypes));
    }

    public static Type.Key tuple(List<? extends Type.Key> args) {
        return new RecordKey(TupleType.recordMap(args));
    }

    public static Type.Key progressiveRecord(SortedMap<String, ? extends Type.Key> argNameTypes) {
        return new ProgressiveRecordKey((ImmutableSortedMap<String, Type.Key>)ImmutableSortedMap.copyOfSorted(argNameTypes));
    }

    public static Type.Key fn(Type.Key paramType, Type.Key resultType) {
        return new OpKey(Op.FN, (List<Type.Key>)ImmutableList.of((Object)paramType, (Object)resultType));
    }

    public static Type.Key list(Type.Key elementType) {
        return new OpKey(Op.LIST, (List<Type.Key>)ImmutableList.of((Object)elementType));
    }

    public static Type.Key forall(Type type, int parameterCount) {
        return new ForallKey(type, parameterCount);
    }

    public static DataTypeKey datatype(String name, List<? extends Type.Key> arguments, SortedMap<String, Type.Key> typeConstructors) {
        return new DataTypeKey(name, arguments, typeConstructors);
    }

    public static SortedMap<String, Type.Key> toKeys(SortedMap<String, ? extends Type> nameTypes) {
        ImmutableSortedMap.Builder keys = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        nameTypes.forEach((name, t) -> keys.put(name, (Object)t.key()));
        return keys.build();
    }

    public static List<Type.Key> toKeys(List<? extends Type> types) {
        return Static.transformEager(types, Type::key);
    }

    static StringBuilder describeRecordType(StringBuilder buf, int left, int right, SortedMap<String, Type.Key> argNameTypes, Op op) {
        switch (argNameTypes.size()) {
            case 0: {
                return buf.append(op == Op.PROGRESSIVE_RECORD_TYPE ? "{...}" : "()");
            }
            default: {
                if (op != Op.TUPLE_TYPE) break;
                return TypeSystem.unparseList(buf, Op.TIMES, left, right, argNameTypes.values());
            }
            case 1: 
        }
        buf.append('{');
        int i = 0;
        for (Map.Entry<String, Type.Key> entry : argNameTypes.entrySet()) {
            String name = entry.getKey();
            Type.Key typeKey = entry.getValue();
            if (i++ > 0) {
                buf.append(", ");
            }
            Parsers.appendId(buf, name).append(':').append(typeKey);
        }
        if (op == Op.PROGRESSIVE_RECORD_TYPE) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("...");
        }
        return buf.append('}');
    }

    public static Type.Key toProgressive(Type.Key key) {
        if (key instanceof RecordKey) {
            return Keys.progressiveRecord(((RecordKey)key).argNameTypes);
        }
        return key;
    }

    private static class NameKey
    extends Type.Key {
        private final String name;

        NameKey(String name) {
            super(name.isEmpty() ? Op.DUMMY_TYPE : Op.DATA_TYPE);
            this.name = Objects.requireNonNull(name);
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            return buf.append(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof NameKey && ((NameKey)obj).name.equals(this.name);
        }

        @Override
        public Type toType(TypeSystem typeSystem) {
            if (this.name.isEmpty()) {
                return DummyType.INSTANCE;
            }
            return typeSystem.lookup(this.name);
        }
    }

    private static class OrdinalKey
    extends Type.Key {
        final int ordinal;

        OrdinalKey(int ordinal) {
            super(Op.TY_VAR);
            this.ordinal = ordinal;
        }

        @Override
        public String toString() {
            return TypeVar.name(this.ordinal);
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            return buf.append(TypeVar.name(this.ordinal));
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof OrdinalKey && ((OrdinalKey)obj).ordinal == this.ordinal;
        }

        @Override
        public Type.Key substitute(List<? extends Type> types) {
            return types.get(this.ordinal).key();
        }

        @Override
        public Type toType(TypeSystem typeSystem) {
            return new TypeVar(this.ordinal);
        }
    }

    private static class ApplyKey
    extends Type.Key {
        final Type.Key key;
        final ImmutableList<Type.Key> args;

        ApplyKey(Type.Key key, ImmutableList<Type.Key> args) {
            super(Op.APPLY_TYPE);
            this.key = Objects.requireNonNull(key);
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            if (!this.args.isEmpty()) {
                TypeSystem.unparseList(buf, Op.COMMA, left, Op.APPLY.left, this.args);
                buf.append(Op.APPLY.padded);
            }
            return buf.append(this.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.args);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ApplyKey && ((ApplyKey)obj).key.equals(this.key) && ((ApplyKey)obj).args.equals(this.args);
        }

        @Override
        public Type toType(TypeSystem typeSystem) {
            Type type = this.key.toType(typeSystem);
            if (type instanceof ForallType) {
                return type.substitute(typeSystem, typeSystem.typesFor((Iterable<? extends Type.Key>)this.args));
            }
            throw new AssertionError();
        }

        @Override
        public Type.Key copy(UnaryOperator<Type.Key> transform) {
            return new ApplyKey(this.key.copy(transform), Static.transformEager(this.args, arg -> arg.copy(transform)));
        }
    }

    private static class RecordKey
    extends Type.Key {
        final ImmutableSortedMap<String, Type.Key> argNameTypes;

        RecordKey(ImmutableSortedMap<String, Type.Key> argNameTypes) {
            super(TypeSystem.areContiguousIntegers((Iterable<String>)argNameTypes.keySet()) ? Op.TUPLE_TYPE : Op.RECORD_TYPE);
            this.argNameTypes = Objects.requireNonNull(argNameTypes);
            Preconditions.checkArgument((argNameTypes.comparator() == RecordType.ORDERING ? 1 : 0) != 0);
        }

        @Override
        public Type.Key copy(UnaryOperator<Type.Key> transform) {
            return Keys.record(Maps.transformValues(this.argNameTypes, transform::apply));
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            return Keys.describeRecordType(buf, left, right, this.argNameTypes, this.op);
        }

        public int hashCode() {
            return this.argNameTypes.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof RecordKey && ((RecordKey)obj).argNameTypes.equals(this.argNameTypes);
        }

        @Override
        public Type toType(TypeSystem typeSystem) {
            switch (this.argNameTypes.size()) {
                case 0: {
                    return PrimitiveType.UNIT;
                }
                default: {
                    if (this.op != Op.TUPLE_TYPE) break;
                    return new TupleType(typeSystem.typesFor((Iterable<? extends Type.Key>)this.argNameTypes.values()));
                }
                case 1: 
            }
            return new RecordType(typeSystem.typesFor((Map<String, ? extends Type.Key>)this.argNameTypes));
        }
    }

    private static class ProgressiveRecordKey
    extends Type.Key {
        final ImmutableSortedMap<String, Type.Key> argNameTypes;

        ProgressiveRecordKey(ImmutableSortedMap<String, Type.Key> argNameTypes) {
            super(Op.PROGRESSIVE_RECORD_TYPE);
            this.argNameTypes = Objects.requireNonNull(argNameTypes);
        }

        @Override
        public Type.Key copy(UnaryOperator<Type.Key> transform) {
            return Keys.progressiveRecord(Maps.transformValues(this.argNameTypes, transform::apply));
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            return Keys.describeRecordType(buf, left, right, this.argNameTypes, this.op);
        }

        public int hashCode() {
            return this.argNameTypes.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ProgressiveRecordKey && ((ProgressiveRecordKey)obj).argNameTypes.equals(this.argNameTypes);
        }

        @Override
        public Type toType(TypeSystem typeSystem) {
            return new ProgressiveRecordType(typeSystem.typesFor((Map<String, ? extends Type.Key>)this.argNameTypes));
        }
    }

    private static class OpKey
    extends Type.Key {
        final ImmutableList<Type.Key> args;

        OpKey(Op op, List<Type.Key> args) {
            super(op);
            this.args = ImmutableList.copyOf(args);
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            switch (this.op) {
                case LIST: {
                    return TypeSystem.unparse(buf, (Type.Key)this.args.get(0), 0, Op.LIST.right).append(" list");
                }
            }
            return TypeSystem.unparseList(buf, this.op, left, right, this.args);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.op, this.args});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof OpKey && ((OpKey)obj).op.equals((Object)this.op) && ((OpKey)obj).args.equals(this.args);
        }

        @Override
        public Type toType(TypeSystem typeSystem) {
            switch (this.op) {
                case FN: {
                    assert (this.args.size() == 2);
                    return new FnType(typeSystem.typeFor((Type.Key)this.args.get(0)), typeSystem.typeFor((Type.Key)this.args.get(1)));
                }
                case LIST: {
                    assert (this.args.size() == 1);
                    return new ListType(typeSystem.typeFor((Type.Key)this.args.get(0)));
                }
            }
            throw new AssertionError((Object)this.op);
        }

        @Override
        public Type.Key copy(UnaryOperator<Type.Key> transform) {
            return new OpKey(this.op, Static.transform(this.args, arg -> arg.copy(transform)));
        }
    }

    private static class ForallKey
    extends Type.Key {
        final Type type;
        final int parameterCount;

        ForallKey(Type type, int parameterCount) {
            super(Op.FORALL_TYPE);
            this.type = Objects.requireNonNull(type);
            this.parameterCount = parameterCount;
            Preconditions.checkArgument((parameterCount >= 0 ? 1 : 0) != 0);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.parameterCount);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ForallKey && ((ForallKey)obj).type.equals(this.type) && ((ForallKey)obj).parameterCount == this.parameterCount;
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            buf.append("forall");
            for (int i = 0; i < this.parameterCount; ++i) {
                buf.append(' ').append(TypeVar.name(i));
            }
            buf.append(". ");
            return TypeSystem.unparse(buf, this.type.key(), 0, 0);
        }

        @Override
        public Type toType(TypeSystem typeSystem) {
            return new ForallType(this.parameterCount, this.type);
        }
    }

    public static class DataTypeKey
    extends Type.Key {
        private final String name;
        private final List<? extends Type.Key> arguments;
        private final SortedMap<String, Type.Key> typeConstructors;

        DataTypeKey(String name, List<? extends Type.Key> arguments, SortedMap<String, Type.Key> typeConstructors) {
            super(Op.DATA_TYPE);
            this.name = Objects.requireNonNull(name);
            this.arguments = ImmutableList.copyOf(arguments);
            this.typeConstructors = ImmutableSortedMap.copyOfSorted(typeConstructors);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.arguments, this.typeConstructors);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof DataTypeKey && ((DataTypeKey)obj).name.equals(this.name) && ((DataTypeKey)obj).arguments.equals(this.arguments) && ((DataTypeKey)obj).typeConstructors.equals(this.typeConstructors);
        }

        @Override
        public StringBuilder describe(StringBuilder buf, int left, int right) {
            if (this.arguments.isEmpty()) {
                return buf.append(this.name);
            }
            if (this.arguments.size() > 1) {
                buf.append('(');
            }
            int length = buf.length();
            for (Type.Key key : this.arguments) {
                if (buf.length() > length) {
                    buf.append(",");
                }
                if (key.op == Op.TUPLE_TYPE) {
                    buf.append('(');
                }
                key.describe(buf, 0, 0);
                if (key.op != Op.TUPLE_TYPE) continue;
                buf.append(')');
            }
            if (this.arguments.size() > 1) {
                buf.append(')');
            }
            return buf.append(' ').append(this.name);
        }

        @Override
        public DataType toType(TypeSystem typeSystem) {
            return typeSystem.dataType(this.name, typeSystem.typesFor(this.arguments), this.typeConstructors);
        }
    }
}

