/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.util.RangeSets;

public class RangeExtent {
    public final RangeSet rangeSet;
    public final Type type;
    private final Iterable iterable;
    private static final List<Boolean> BOOLEANS = ImmutableList.of((Object)false, (Object)true);

    public RangeExtent(RangeSet rangeSet, Type type) {
        this.rangeSet = ImmutableRangeSet.copyOf((RangeSet)rangeSet);
        this.type = type;
        this.iterable = this.toIterable(type, rangeSet);
    }

    public String toString() {
        return this.type + " " + this.rangeSet;
    }

    public Iterable toIterable() {
        return this.iterable;
    }

    private Iterable toIterable(Type type, RangeSet<?> rangeSet) {
        ArrayList setList = new ArrayList();
        rangeSet.asRanges().forEach(range -> setList.add(this.toIterable(type, (Range)range)));
        return RangeExtent.concat(setList);
    }

    private Iterable toIterable(Type type, Range range) {
        switch (type.op()) {
            case ID: {
                PrimitiveType primitiveType = (PrimitiveType)type;
                switch (primitiveType) {
                    case INT: {
                        return ContiguousSet.create((Range)RangeSets.copy((Range)range, BigDecimal::intValue), (DiscreteDomain)DiscreteDomain.integers());
                    }
                    case BOOL: {
                        return Iterables.filter(BOOLEANS, b -> range.contains((Comparable)b));
                    }
                }
                break;
            }
            case TUPLE_TYPE: {
                TupleType tupleType = (TupleType)type;
                return ContiguousSet.create((Range)range, this.discreteDomain(tupleType));
            }
        }
        throw new AssertionError((Object)("cannot iterate type '" + type + "'"));
    }

    private DiscreteDomain<? extends Comparable> discreteDomain(Type type) {
        switch (type.op()) {
            case ID: {
                PrimitiveType primitiveType = (PrimitiveType)type;
                switch (primitiveType) {
                    case BOOL: {
                        return new BooleanDiscreteDomain();
                    }
                    case INT: {
                        return DiscreteDomain.integers();
                    }
                }
                break;
            }
            case TUPLE_TYPE: {
                ArrayList<DiscreteDomain<? extends Comparable>> domains = new ArrayList<DiscreteDomain<? extends Comparable>>();
                TupleType tupleType = (TupleType)type;
                tupleType.argTypes.forEach(t -> domains.add(this.discreteDomain((Type)t)));
                return new ProductDiscreteDomain(domains);
            }
        }
        throw new AssertionError((Object)("cannot convert type '" + type + "' to discrete domain"));
    }

    private static <E> Iterable<? extends E> concat(List<? extends Iterable<? extends E>> iterableList) {
        switch (iterableList.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return iterableList.get(0);
            }
        }
        return Iterables.concat(iterableList);
    }

    private static class BooleanDiscreteDomain
    extends DiscreteDomain<Boolean> {
        private BooleanDiscreteDomain() {
        }

        @CheckForNull
        public Boolean next(Boolean value) {
            return value != false ? null : Boolean.valueOf(true);
        }

        @CheckForNull
        public Boolean previous(Boolean value) {
            return value != false ? Boolean.valueOf(false) : null;
        }

        public long distance(Boolean start, Boolean end) {
            return end.booleanValue() == start.booleanValue() ? 0L : (long)(end != false ? 1 : -1);
        }

        public Boolean minValue() {
            return false;
        }

        public Boolean maxValue() {
            return true;
        }
    }

    private static class ProductDiscreteDomain
    extends DiscreteDomain<FlatLists.ComparableList<Comparable>> {
        private final List<DiscreteDomain> domains;
        private final FlatLists.ComparableList<Comparable> minValue;
        private final FlatLists.ComparableList<Comparable> maxValues;

        ProductDiscreteDomain(List<DiscreteDomain<? extends Comparable>> domains) {
            this.domains = ImmutableList.copyOf(domains);
            this.minValue = FlatLists.ofComparable(domains.stream().map(DiscreteDomain::minValue).collect(Collectors.toList()));
            this.maxValues = FlatLists.ofComparable(domains.stream().map(DiscreteDomain::maxValue).collect(Collectors.toList()));
        }

        @CheckForNull
        public FlatLists.ComparableList<Comparable> next(FlatLists.ComparableList<Comparable> values) {
            Comparable[] objects = (Comparable[])values.toArray((Object[])new Comparable[0]);
            for (int i = 0; i < values.size(); ++i) {
                Comparable value = (Comparable)values.get(i);
                DiscreteDomain domain = this.domains.get(i);
                Comparable next = domain.next(value);
                if (next != null) {
                    objects[i] = next;
                    return (FlatLists.ComparableList)FlatLists.of((Comparable[])objects);
                }
                objects[i] = domain.minValue();
            }
            return null;
        }

        @CheckForNull
        public FlatLists.ComparableList<Comparable> previous(FlatLists.ComparableList<Comparable> values) {
            throw new UnsupportedOperationException();
        }

        public long distance(FlatLists.ComparableList<Comparable> start, FlatLists.ComparableList<Comparable> end) {
            long d = 0L;
            FlatLists.ComparableList<Comparable> c = start;
            while (c != null && c.compareTo(end) < 0) {
                ++d;
                c = this.next(c);
            }
            return d;
        }
    }
}

