/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.AbstractList;
import java.util.List;
import java.util.SortedMap;
import java.util.function.UnaryOperator;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.type.BaseType;
import net.hydromatic.morel.type.Keys;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVisitor;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Static;

public class TupleType
extends BaseType
implements RecordLikeType {
    private static final String[] INT_STRINGS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public final List<Type> argTypes;

    TupleType(List<? extends Type> argTypes) {
        super(Op.TUPLE_TYPE);
        this.argTypes = ImmutableList.copyOf(argTypes);
    }

    @Override
    public SortedMap<String, Type> argNameTypes() {
        ImmutableSortedMap.Builder map = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        Ord.forEachIndexed(this.argTypes, (t, i) -> map.put((Object)Integer.toString(i + 1), t));
        return map.build();
    }

    @Override
    public Type argType(int i) {
        return this.argTypes.get(i);
    }

    @Override
    public <R> R accept(TypeVisitor<R> typeVisitor) {
        return typeVisitor.visit(this);
    }

    @Override
    public Type.Key key() {
        return Keys.record(TupleType.toArgNameTypeKeys(this.argTypes));
    }

    @Override
    public TupleType copy(TypeSystem typeSystem, UnaryOperator<Type> transform) {
        int differenceCount = 0;
        ImmutableList.Builder argTypes2 = ImmutableList.builder();
        for (Type argType : this.argTypes) {
            Type argType2;
            if (argType != (argType2 = (Type)transform.apply(argType))) {
                ++differenceCount;
            }
            argTypes2.add((Object)argType2);
        }
        return differenceCount == 0 ? this : new TupleType((List<? extends Type>)argTypes2.build());
    }

    private static String str(int i) {
        return i >= 0 && i < INT_STRINGS.length ? INT_STRINGS[i] : Integer.toString(i);
    }

    public static List<String> ordinalNames(final int size) {
        return new AbstractList<String>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public String get(int index) {
                return TupleType.str(index + 1);
            }
        };
    }

    static <E> ImmutableSortedMap<String, E> recordMap(List<? extends E> argTypes) {
        ImmutableSortedMap.Builder b = ImmutableSortedMap.orderedBy(RecordType.ORDERING);
        Ord.forEachIndexed(argTypes, (t, i) -> b.put((Object)Integer.toString(i + 1), t));
        return b.build();
    }

    static ImmutableSortedMap<String, Type.Key> toArgNameTypeKeys(List<? extends Type> argTypes) {
        return TupleType.recordMap(Static.transform(argTypes, Type::key));
    }
}

