/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class JavaVersion
implements Comparable<JavaVersion> {
    public final List<Integer> components;
    public static final JavaVersion CURRENT;
    private static final Comparator<Iterable<Integer>> COMPARATOR;

    private JavaVersion(List<Integer> components) {
        this.components = ImmutableList.copyOf(components);
    }

    public static JavaVersion of(int ... components) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int component : components) {
            list.add(component);
        }
        return JavaVersion.of(list);
    }

    public static JavaVersion of(List<Integer> componentList) {
        if (componentList.size() >= 2 && componentList.get(0) == 1 && componentList.get(1) <= 9) {
            componentList = componentList.subList(1, componentList.size());
        }
        return new JavaVersion((List<Integer>)ImmutableList.copyOf(componentList));
    }

    @Override
    public int compareTo(JavaVersion o) {
        return COMPARATOR.compare(this.components, o.components);
    }

    static {
        String versionString = System.getProperty("java.version");
        String[] versions = versionString.split("[._]");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String version : versions) {
            list.add(Integer.parseInt(version));
        }
        CURRENT = new JavaVersion(list);
        COMPARATOR = Ordering.natural().lexicographical();
    }
}

