/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.hydromatic.morel.util.Unifier;

public class MartelliUnifier
extends Unifier {
    @Override
    @Nonnull
    public Unifier.Result unify(List<Unifier.TermTerm> termPairs, Map<Unifier.Variable, Unifier.Action> termActions, Unifier.Tracer tracer) {
        termPairs = new ArrayList<Unifier.TermTerm>(termPairs);
        LinkedHashMap<Unifier.Variable, Unifier.Term> result = new LinkedHashMap<Unifier.Variable, Unifier.Term>();
        block0: while (!termPairs.isEmpty()) {
            Unifier.TermTerm pair;
            int i = this.findDelete(termPairs);
            if (i >= 0) {
                pair = termPairs.remove(i);
                tracer.onDelete(pair.left, pair.right);
                continue;
            }
            i = this.findSeqSeq(termPairs);
            if (i >= 0) {
                pair = termPairs.get(i);
                Unifier.Sequence left = (Unifier.Sequence)pair.left;
                Unifier.Sequence right = (Unifier.Sequence)pair.right;
                if (!left.operator.equals(right.operator) || left.terms.size() != right.terms.size()) {
                    tracer.onConflict(left, right);
                    return this.failure("conflict: " + left + " vs " + right);
                }
                termPairs.remove(i);
                tracer.onSequence(left, right);
                int j = 0;
                while (true) {
                    if (j >= left.terms.size()) continue block0;
                    termPairs.add(new Unifier.TermTerm(left.terms.get(j), right.terms.get(j)));
                    ++j;
                }
            }
            i = this.findNonVarVar(termPairs);
            if (i >= 0) {
                pair = termPairs.get(i);
                termPairs.set(i, new Unifier.TermTerm(pair.right, pair.left));
                tracer.onSwap(pair.left, pair.right);
                continue;
            }
            i = this.findVarAny(termPairs);
            if (i < 0) continue;
            pair = termPairs.remove(i);
            Unifier.Term term = pair.right;
            Unifier.Variable variable = (Unifier.Variable)pair.left;
            if (term.contains(variable)) {
                tracer.onCycle(variable, term);
                return this.failure("cycle: variable " + variable + " in " + term);
            }
            tracer.onVariable(variable, term);
            result.put(variable, term);
            this.act(variable, term, termPairs, new Unifier.Substitution(result), termActions, 0);
            this.substituteList(termPairs, tracer, (Map<Unifier.Variable, Unifier.Term>)ImmutableMap.of((Object)variable, (Object)term));
        }
        return Unifier.SubstitutionResult.create(result);
    }

    private void substituteList(List<Unifier.TermTerm> termPairs, Unifier.Tracer tracer, Map<Unifier.Variable, Unifier.Term> map) {
        for (int j = 0; j < termPairs.size(); ++j) {
            Unifier.TermTerm pair2 = termPairs.get(j);
            Unifier.Term left2 = pair2.left.apply(map);
            Unifier.Term right2 = pair2.right.apply(map);
            if (left2 == pair2.left && right2 == pair2.right) continue;
            tracer.onSubstitute(pair2.left, pair2.right, left2, right2);
            termPairs.set(j, new Unifier.TermTerm(left2, right2));
        }
    }

    private void act(Unifier.Variable variable, Unifier.Term term, List<Unifier.TermTerm> termPairs, Unifier.Substitution substitution, Map<Unifier.Variable, Unifier.Action> termActions, int depth) {
        Unifier.Action action = termActions.get(variable);
        if (action != null) {
            action.accept(variable, term, substitution, termPairs);
        }
        if (term instanceof Unifier.Variable) {
            ArrayList<Unifier.TermTerm> termPairsCopy = new ArrayList<Unifier.TermTerm>(termPairs);
            termPairsCopy.forEach(termPair -> {
                if (termPair.left.equals(term) && depth < 2) {
                    this.act(variable, termPair.right, termPairs, substitution, termActions, depth + 1);
                }
            });
            if (depth < 1) {
                this.act((Unifier.Variable)term, variable, termPairs, substitution, termActions, depth + 1);
            }
        }
        substitution.resultMap.forEach((variable2, v) -> {
            if (v.equals(variable)) {
                this.act((Unifier.Variable)variable2, term, termPairs, substitution, termActions, depth + 1);
            }
        });
    }

    private int findDelete(List<Unifier.TermTerm> termPairs) {
        for (int i = 0; i < termPairs.size(); ++i) {
            Unifier.TermTerm termTerm = termPairs.get(i);
            if (!termTerm.left.equals(termTerm.right)) continue;
            return i;
        }
        return -1;
    }

    private int findSeqSeq(List<Unifier.TermTerm> termPairs) {
        for (int i = 0; i < termPairs.size(); ++i) {
            Unifier.TermTerm termTerm = termPairs.get(i);
            if (!(termTerm.left instanceof Unifier.Sequence) || !(termTerm.right instanceof Unifier.Sequence)) continue;
            return i;
        }
        return -1;
    }

    private int findNonVarVar(List<Unifier.TermTerm> termPairs) {
        for (int i = 0; i < termPairs.size(); ++i) {
            Unifier.TermTerm termTerm = termPairs.get(i);
            if (termTerm.left instanceof Unifier.Variable || !(termTerm.right instanceof Unifier.Variable)) continue;
            return i;
        }
        return -1;
    }

    private int findVarAny(List<Unifier.TermTerm> termPairs) {
        for (int i = 0; i < termPairs.size(); ++i) {
            Unifier.TermTerm termTerm = termPairs.get(i);
            if (!(termTerm.left instanceof Unifier.Variable)) continue;
            return i;
        }
        return -1;
    }
}

