/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Objects;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.Unifier;

public class Tracers {
    private static final NullTracer NULL_TRACER = new NullTracer();

    private Tracers() {
    }

    public static Unifier.Tracer nullTracer() {
        return NULL_TRACER;
    }

    public static Unifier.Tracer printTracer(PrintWriter w) {
        return new PrintTracer(w);
    }

    public static Unifier.Tracer printTracer(OutputStream stream) {
        return Tracers.printTracer(new PrintWriter(stream));
    }

    private static class NullTracer
    implements Unifier.Tracer {
        private NullTracer() {
        }

        @Override
        public void onDelete(Unifier.Term left, Unifier.Term right) {
        }

        @Override
        public void onConflict(Unifier.Sequence left, Unifier.Sequence right) {
        }

        @Override
        public void onSequence(Unifier.Sequence left, Unifier.Sequence right) {
        }

        @Override
        public void onSwap(Unifier.Term left, Unifier.Term right) {
        }

        @Override
        public void onCycle(Unifier.Variable variable, Unifier.Term term) {
        }

        @Override
        public void onVariable(Unifier.Variable variable, Unifier.Term term) {
        }

        @Override
        public void onSubstitute(Unifier.Term left, Unifier.Term right, Unifier.Term left2, Unifier.Term right2) {
        }
    }

    private static class PrintTracer
    implements Unifier.Tracer {
        private final StringBuilder b = new StringBuilder();
        private final PrintWriter w;

        PrintTracer(PrintWriter w) {
            this.w = Objects.requireNonNull(w);
        }

        private void flush() {
            this.w.println(Static.str(this.b));
            this.w.flush();
        }

        @Override
        public void onDelete(Unifier.Term left, Unifier.Term right) {
            this.b.append("delete ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onConflict(Unifier.Sequence left, Unifier.Sequence right) {
            this.b.append("conflict ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onSequence(Unifier.Sequence left, Unifier.Sequence right) {
            this.b.append("sequence ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onSwap(Unifier.Term left, Unifier.Term right) {
            this.b.append("swap ").append(left).append(' ').append(right);
            this.flush();
        }

        @Override
        public void onCycle(Unifier.Variable variable, Unifier.Term term) {
            this.b.append("cycle ").append(variable).append(' ').append(term);
            this.flush();
        }

        @Override
        public void onVariable(Unifier.Variable variable, Unifier.Term term) {
            this.b.append("variable ").append(variable).append(' ').append(term);
            this.flush();
        }

        @Override
        public void onSubstitute(Unifier.Term left, Unifier.Term right, Unifier.Term left2, Unifier.Term right2) {
            this.b.append("substitute ").append(left).append(' ').append(right);
            if (left2 != left) {
                this.b.append("; ").append(left).append(" -> ").append(left2);
            }
            if (right2 != right) {
                this.b.append("; ").append(right).append(" -> ").append(right2);
            }
            this.flush();
        }
    }
}

