/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.hydromatic.morel.util.Pair;

public abstract class Unifier {
    private int varId;
    private final Map<String, Variable> variableMap = new HashMap<String, Variable>();
    private final Map<String, Sequence> atomMap = new HashMap<String, Sequence>();
    private final Map<String, Sequence> sequenceMap = new HashMap<String, Sequence>();

    public boolean occurs() {
        return false;
    }

    public Sequence apply(String operator, Term ... args) {
        return this.apply(operator, (Iterable<? extends Term>)ImmutableList.copyOf((Object[])args));
    }

    public Sequence apply(String operator, Iterable<? extends Term> args) {
        Sequence sequence = new Sequence(operator, (List<Term>)ImmutableList.copyOf(args));
        return this.sequenceMap.computeIfAbsent(sequence.toString(), n -> sequence);
    }

    public Variable variable(String name) {
        return this.variableMap.computeIfAbsent(name, Variable::new);
    }

    public Variable variable(int ordinal) {
        String name = "T" + ordinal;
        return this.variableMap.computeIfAbsent(name, name2 -> new Variable(ordinal));
    }

    public Variable variable() {
        int ordinal;
        String name;
        do {
            ++this.varId;
        } while (this.variableMap.containsKey(name = "T" + ordinal));
        Variable variable = new Variable(ordinal);
        assert (variable.name.equals(name));
        this.variableMap.put(name, variable);
        return variable;
    }

    public Term atom(String name) {
        return this.atomMap.computeIfAbsent(name, Sequence::new);
    }

    public Substitution substitution(Term ... varTerms) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (varTerms.length % 2 != 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < varTerms.length; i += 2) {
            mapBuilder.put((Object)((Variable)varTerms[i + 1]), (Object)varTerms[i]);
        }
        return new Substitution((Map<Variable, Term>)mapBuilder.build());
    }

    static Sequence sequenceApply(String operator, Map<Variable, Term> substitutions, Iterable<Term> terms) {
        ImmutableList.Builder newTerms = ImmutableList.builder();
        for (Term term : terms) {
            newTerms.add((Object)term.apply(substitutions));
        }
        return new Sequence(operator, (List<Term>)newTerms.build());
    }

    @Nonnull
    public abstract Result unify(List<TermTerm> var1, Map<Variable, Action> var2, Tracer var3);

    private static void checkCycles(Map<Variable, Term> map, Map<Variable, Variable> active) throws CycleException {
        for (Term term : map.values()) {
            term.checkCycle(map, active);
        }
    }

    protected Failure failure(final String reason) {
        return new Failure(){

            public String toString() {
                return reason;
            }
        };
    }

    public static final class Sequence
    implements Term {
        public final String operator;
        public final List<Term> terms;

        Sequence(String operator, List<Term> terms) {
            this.operator = Objects.requireNonNull(operator);
            this.terms = ImmutableList.copyOf(terms);
        }

        Sequence(String operator) {
            this(operator, (List<Term>)ImmutableList.of());
        }

        public int hashCode() {
            return Objects.hash(this.operator, this.terms);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Sequence && this.operator.equals(((Sequence)obj).operator) && this.terms.equals(((Sequence)obj).terms);
        }

        public String toString() {
            if (this.terms.isEmpty()) {
                return this.operator;
            }
            StringBuilder builder = new StringBuilder(this.operator).append('(');
            for (int i = 0; i < this.terms.size(); ++i) {
                Term term = this.terms.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(term);
            }
            return builder.append(')').toString();
        }

        @Override
        public Term apply(Map<Variable, Term> substitutions) {
            Sequence sequence = Unifier.sequenceApply(this.operator, substitutions, this.terms);
            if (sequence.equalsShallow(this)) {
                return this;
            }
            return sequence;
        }

        @Override
        public void checkCycle(Map<Variable, Term> map, Map<Variable, Variable> active) throws CycleException {
            for (Term term : this.terms) {
                term.checkCycle(map, active);
            }
        }

        private boolean equalsShallow(Sequence sequence) {
            return this == sequence || Sequence.listEqual(this.terms, sequence.terms);
        }

        private static <E> boolean listEqual(List<E> list0, List<E> list1) {
            if (list0.size() != list1.size()) {
                return false;
            }
            for (int i = 0; i < list0.size(); ++i) {
                if (list0.get(i) == list1.get(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Variable variable) {
            for (Term term : this.terms) {
                if (!term.contains(variable)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <R> R accept(TermVisitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Variable
    implements Term,
    Comparable<Variable> {
        final String name;
        final int ordinal;

        Variable(String name, int ordinal) {
            this.name = Objects.requireNonNull(name);
            this.ordinal = ordinal;
            Preconditions.checkArgument((boolean)name.equals(name.toUpperCase(Locale.ROOT)), (String)"must be upper case: %s", (Object)name);
        }

        Variable(String name) {
            this(name, -1);
            Preconditions.checkArgument((!name.matches("T[0-9]+") ? 1 : 0) != 0, (Object)name);
        }

        Variable(int ordinal) {
            this("T" + ordinal, ordinal);
            Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)ordinal);
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Variable o) {
            int c = Integer.compare(this.ordinal, o.ordinal);
            if (c == 0) {
                c = this.name.compareTo(o.name);
            }
            return c;
        }

        @Override
        public Term apply(Map<Variable, Term> substitutions) {
            return substitutions.getOrDefault(this, this);
        }

        @Override
        public boolean contains(Variable variable) {
            return variable == this;
        }

        @Override
        public void checkCycle(Map<Variable, Term> map, Map<Variable, Variable> active) throws CycleException {
            Term term = map.get(this);
            if (term != null) {
                if (active.put(this, this) != null) {
                    throw new CycleException();
                }
                term.checkCycle(map, active);
                active.remove(this);
            }
        }

        @Override
        public <R> R accept(TermVisitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static interface Term {
        public Term apply(Map<Variable, Term> var1);

        public boolean contains(Variable var1);

        public void checkCycle(Map<Variable, Term> var1, Map<Variable, Variable> var2) throws CycleException;

        public <R> R accept(TermVisitor<R> var1);
    }

    public static class Substitution {
        public final Map<Variable, Term> resultMap;

        Substitution(Map<Variable, Term> resultMap) {
            this.resultMap = resultMap;
        }

        public int hashCode() {
            return this.resultMap.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Substitution && this.resultMap.equals(((Substitution)obj).resultMap);
        }

        public String toString() {
            return this.accept(new StringBuilder()).toString();
        }

        public StringBuilder accept(StringBuilder buf) {
            buf.append("[");
            Pair.forEachIndexed(this.resultMap, (i, variable, term) -> buf.append(i > 0 ? ", " : "").append(term).append("/").append(variable));
            return buf.append("]");
        }

        public Term resolve(Term term) {
            Term previous;
            Term current = term;
            do {
                previous = current;
            } while (!(current = current.apply(this.resultMap)).equals(previous));
            return current;
        }

        private boolean hasCycles(Map<Variable, Term> map) {
            try {
                Unifier.checkCycles(map, new IdentityHashMap());
                return false;
            }
            catch (CycleException e) {
                return true;
            }
        }

        public Substitution resolve() {
            if (this.hasCycles(this.resultMap)) {
                return this;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.resultMap.forEach((key, value) -> builder.put(key, (Object)this.resolve((Term)value)));
            return new Substitution((Map<Variable, Term>)builder.build());
        }
    }

    public static interface Tracer {
        public void onDelete(Term var1, Term var2);

        public void onConflict(Sequence var1, Sequence var2);

        public void onSequence(Sequence var1, Sequence var2);

        public void onSwap(Term var1, Term var2);

        public void onCycle(Variable var1, Term var2);

        public void onVariable(Variable var1, Term var2);

        public void onSubstitute(Term var1, Term var2, Term var3, Term var4);
    }

    public static final class TermTerm {
        final Term left;
        final Term right;

        public TermTerm(Term left, Term right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        public String toString() {
            return this.left + " = " + this.right;
        }
    }

    private static class CycleException
    extends Exception {
        private CycleException() {
        }
    }

    public static interface TermVisitor<R> {
        public R visit(Sequence var1);

        public R visit(Variable var1);
    }

    public static final class SubstitutionResult
    extends Substitution
    implements Result {
        public static final SubstitutionResult EMPTY = SubstitutionResult.create((Map<Variable, Term>)ImmutableSortedMap.of());

        private SubstitutionResult(Map<Variable, Term> resultMap) {
            super((Map<Variable, Term>)ImmutableSortedMap.copyOf(resultMap));
        }

        public static SubstitutionResult create(Map<Variable, Term> resultMap) {
            return new SubstitutionResult((Map<Variable, Term>)ImmutableSortedMap.copyOf(resultMap));
        }

        public static SubstitutionResult create(Variable v, Term t) {
            return new SubstitutionResult((Map<Variable, Term>)ImmutableSortedMap.of((Comparable)v, (Object)t));
        }
    }

    public static class Failure
    implements Result {
    }

    public static interface Result {
    }

    @FunctionalInterface
    public static interface Action {
        public void accept(Variable var1, Term var2, Substitution var3, List<TermTerm> var4);
    }
}

