/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.ObjIntConsumer;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.AstWriter;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Shuttle;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.compile.Extents;
import net.hydromatic.morel.compile.Resolver;
import net.hydromatic.morel.eval.Closure;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.DataType;
import net.hydromatic.morel.type.FnType;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.TupleType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypedValue;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Core {
    private Core() {
    }

    static class Wrapper
    implements Comparable<Wrapper> {
        private final Exp exp;
        private final Object o;

        private Wrapper(Exp exp, Object o) {
            this.exp = exp;
            this.o = o;
            assert (Wrapper.isValidValue(exp, o)) : o;
        }

        private static boolean isValidValue(Exp exp, Object o) {
            if (o instanceof Code) {
                return false;
            }
            if (o instanceof Closure) {
                return false;
            }
            if (o instanceof Id) {
                String name = ((Id)exp).idPat.name;
                return !"true".equals(name) && !"false".equals(name);
            }
            return true;
        }

        @Override
        public int compareTo(Wrapper o) {
            return Integer.compare(this.o.hashCode(), o.o.hashCode());
        }

        public String toString() {
            return this.o.toString();
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Wrapper && this.o.equals(((Wrapper)obj).o);
        }

        <T> T unwrap(Class<T> valueClass) {
            return valueClass.cast(this.o);
        }
    }

    public static class Aggregate
    extends BaseNode {
        public final Type type;
        public final Exp aggregate;
        public final @Nullable Exp argument;

        Aggregate(Type type, Exp aggregate, @Nullable Exp argument) {
            super(Pos.ZERO, Op.AGGREGATE);
            this.type = type;
            this.aggregate = Objects.requireNonNull(aggregate);
            this.argument = argument;
        }

        @Override
        public Aggregate accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append(this.aggregate, 0, 0);
            if (this.argument != null) {
                w.append(" of ").append(this.argument, 0, 0);
            }
            return w;
        }

        public Aggregate copy(Type type, Exp aggregate, @Nullable Exp argument) {
            return aggregate == this.aggregate && argument == this.argument ? this : CoreBuilder.core.aggregate(type, aggregate, argument);
        }
    }

    public static class Apply
    extends Exp {
        public final Exp fn;
        public final Exp arg;

        Apply(Pos pos, Type type, Exp fn, Exp arg) {
            super(pos, Op.APPLY, type);
            this.fn = fn;
            this.arg = arg;
        }

        public List<Exp> args() {
            return ((Tuple)this.arg).args;
        }

        @Override
        public Exp arg(int i) {
            return this.arg.arg(i);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            switch (this.fn.op) {
                case FN_LITERAL: {
                    BuiltIn builtIn = ((Literal)this.fn).unwrap(BuiltIn.class);
                    switch (builtIn) {
                        case Z_LIST: {
                            w.append("[");
                            this.arg.forEachArg((arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
                            return w.append("]");
                        }
                    }
                    Op op = (Op)((Object)Resolver.BUILT_IN_OP_MAP.get((Object)builtIn));
                    if (op == null) break;
                    return w.infix(left, this.args().get(0), op, this.args().get(1), right);
                }
            }
            return w.infix(left, this.fn, this.op, this.arg, right);
        }

        public Apply copy(Exp fn, Exp arg) {
            return fn == this.fn && arg == this.arg ? this : CoreBuilder.core.apply(this.pos, this.type, fn, arg);
        }

        @Override
        public boolean isConstant() {
            return this.isCallTo(BuiltIn.Z_LIST) && this.args().stream().allMatch(Exp::isConstant);
        }

        @Override
        public boolean isCallTo(BuiltIn builtIn) {
            return this.fn.op == Op.FN_LITERAL && ((Literal)this.fn).unwrap(BuiltIn.class) == builtIn;
        }
    }

    public static class Yield
    extends FromStep {
        public final Exp exp;

        Yield(ImmutableList<Binding> bindings, Exp exp) {
            super(Op.YIELD, bindings);
            this.exp = exp;
        }

        @Override
        protected AstWriter unparse(AstWriter w, From from, int ordinal, int left, int right) {
            return w.append(" yield ").append(this.exp, 0, 0);
        }

        @Override
        public Yield accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Yield copy(List<Binding> bindings, Exp exp) {
            return bindings.equals(this.bindings) && exp == this.exp ? this : CoreBuilder.core.yield_(bindings, exp);
        }
    }

    public static class Group
    extends FromStep {
        public final SortedMap<IdPat, Exp> groupExps;
        public final SortedMap<IdPat, Aggregate> aggregates;

        Group(ImmutableList<Binding> bindings, ImmutableSortedMap<IdPat, Exp> groupExps, ImmutableSortedMap<IdPat, Aggregate> aggregates) {
            super(Op.GROUP, bindings);
            this.groupExps = groupExps;
            this.aggregates = aggregates;
        }

        @Override
        public Group accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected AstWriter unparse(AstWriter w, From from, int ordinal, int left, int right) {
            w.append(" group");
            Pair.forEachIndexed(this.groupExps, (i, id, exp) -> w.append(i == 0 ? " " : ", ").append((AstNode)id, 0, 0).append(" = ").append((AstNode)exp, 0, 0));
            Pair.forEachIndexed(this.aggregates, (i, name, aggregate) -> w.append(i == 0 ? " compute " : ", ").append((AstNode)name, 0, 0).append(" = ").append((AstNode)aggregate, 0, 0));
            return w;
        }

        public Group copy(SortedMap<IdPat, Exp> groupExps, SortedMap<IdPat, Aggregate> aggregates) {
            return groupExps.equals(this.groupExps) && aggregates.equals(this.aggregates) ? this : CoreBuilder.core.group(groupExps, aggregates);
        }
    }

    public static class OrderItem
    extends BaseNode {
        public final Exp exp;
        public final Ast.Direction direction;

        OrderItem(Exp exp, Ast.Direction direction) {
            super(Pos.ZERO, Op.ORDER_ITEM);
            this.exp = Objects.requireNonNull(exp);
            this.direction = Objects.requireNonNull(direction);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(this.exp, 0, 0).append(this.direction == Ast.Direction.DESC ? " desc" : "");
        }

        public OrderItem copy(Exp exp, Ast.Direction direction) {
            return exp == this.exp && direction == this.direction ? this : CoreBuilder.core.orderItem(exp, direction);
        }
    }

    public static class Order
    extends FromStep {
        public final ImmutableList<OrderItem> orderItems;

        Order(ImmutableList<Binding> bindings, ImmutableList<OrderItem> orderItems) {
            super(Op.ORDER, bindings);
            this.orderItems = Objects.requireNonNull(orderItems);
        }

        @Override
        public Order accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected AstWriter unparse(AstWriter w, From from, int ordinal, int left, int right) {
            return w.append(" order ").appendAll((Iterable<? extends AstNode>)this.orderItems, ", ");
        }

        public Order copy(List<Binding> bindings, List<OrderItem> orderItems) {
            return bindings.equals(this.bindings) && orderItems.equals(this.orderItems) ? this : CoreBuilder.core.order(bindings, orderItems);
        }
    }

    public static class Take
    extends FromStep {
        public final Exp exp;

        Take(ImmutableList<Binding> bindings, Exp exp) {
            super(Op.TAKE, bindings);
            this.exp = Objects.requireNonNull(exp, "exp");
        }

        @Override
        public Take accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected AstWriter unparse(AstWriter w, From from, int ordinal, int left, int right) {
            return w.append(" take ").append(this.exp, 0, 0);
        }

        public Take copy(Exp exp, List<Binding> bindings) {
            return exp == this.exp && bindings.equals(this.bindings) ? this : CoreBuilder.core.take(bindings, exp);
        }
    }

    public static class Skip
    extends FromStep {
        public final Exp exp;

        Skip(ImmutableList<Binding> bindings, Exp exp) {
            super(Op.SKIP, bindings);
            this.exp = Objects.requireNonNull(exp, "exp");
        }

        @Override
        public Skip accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected AstWriter unparse(AstWriter w, From from, int ordinal, int left, int right) {
            return w.append(" skip ").append(this.exp, 0, 0);
        }

        public Skip copy(Exp exp, List<Binding> bindings) {
            return exp == this.exp && bindings.equals(this.bindings) ? this : CoreBuilder.core.skip(bindings, exp);
        }
    }

    public static class Where
    extends FromStep {
        public final Exp exp;

        Where(ImmutableList<Binding> bindings, Exp exp) {
            super(Op.WHERE, bindings);
            this.exp = Objects.requireNonNull(exp, "exp");
        }

        @Override
        public Where accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected AstWriter unparse(AstWriter w, From from, int ordinal, int left, int right) {
            return w.append(" where ").append(this.exp, 0, 0);
        }

        public Where copy(Exp exp, List<Binding> bindings) {
            return exp == this.exp && bindings.equals(this.bindings) ? this : CoreBuilder.core.where(bindings, exp);
        }
    }

    public static class Scan
    extends FromStep {
        public final Pat pat;
        public final Exp exp;
        public final Exp condition;

        Scan(ImmutableList<Binding> bindings, Pat pat, Exp exp, Exp condition) {
            super(Op.SCAN, bindings);
            this.pat = Objects.requireNonNull(pat, "pat");
            this.exp = Objects.requireNonNull(exp, "exp");
            this.condition = Objects.requireNonNull(condition, "condition");
            if (!(exp.type instanceof ListType)) {
                throw new IllegalArgumentException("scan expression must be list: " + exp.type);
            }
            ListType listType = (ListType)exp.type;
            if (!Scan.canAssign(listType.elementType, pat.type)) {
                throw new IllegalArgumentException(exp.type + " + " + pat.type);
            }
        }

        private static boolean canAssign(Type fromType, Type toType) {
            return fromType.equals(toType) || toType.isProgressive();
        }

        @Override
        public Scan accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        protected AstWriter unparse(AstWriter w, From from, int ordinal, int left, int right) {
            w.append(ordinal == 0 ? " " : " join ").append(this.pat, 0, Op.EQ.left);
            if (Extents.isInfinite(this.exp)) {
                w.append(" : ").append(((ListType)this.exp.type).elementType.moniker());
            } else {
                w.append(" in ").append(this.exp, Op.EQ.right, 0);
            }
            if (!this.isLiteralTrue()) {
                w.append("on").append(this.condition, 0, 0);
            }
            return w;
        }

        private boolean isLiteralTrue() {
            return this.condition.op == Op.BOOL_LITERAL && ((Literal)this.condition).unwrap(Boolean.class) != false;
        }

        public Scan copy(List<Binding> bindings, Pat pat, Exp exp, Exp condition) {
            return pat == this.pat && exp == this.exp && condition == this.condition && bindings.equals(this.bindings) ? this : CoreBuilder.core.scan(bindings, pat, exp, condition);
        }
    }

    public static abstract class FromStep
    extends BaseNode {
        public final ImmutableList<Binding> bindings;

        FromStep(Op op, ImmutableList<Binding> bindings) {
            super(Pos.ZERO, op);
            this.bindings = bindings;
        }

        @Override
        final AstWriter unparse(AstWriter w, int left, int right) {
            return this.unparse(w, null, -1, left, right);
        }

        protected abstract AstWriter unparse(AstWriter var1, From var2, int var3, int var4, int var5);

        @Override
        public abstract FromStep accept(Shuttle var1);
    }

    public static class From
    extends Exp {
        public final ImmutableList<FromStep> steps;

        From(ListType type, ImmutableList<FromStep> steps) {
            super(Pos.ZERO, Op.FROM, type);
            this.steps = Objects.requireNonNull(steps);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof From && this.steps.equals(((From)o).steps);
        }

        public int hashCode() {
            return this.steps.hashCode();
        }

        @Override
        public ListType type() {
            return (ListType)this.type;
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            if (left > this.op.left || this.op.right < right) {
                return w.append("(").append(this, 0, 0).append(")");
            }
            w.append("from");
            Ord.forEachIndexed(this.steps, (step, i) -> step.unparse(w, this, i, 0, 0));
            return w;
        }

        public Exp copy(TypeSystem typeSystem, @Nullable Environment env, List<FromStep> steps) {
            return steps.equals(this.steps) ? this : CoreBuilder.core.fromBuilder(typeSystem, env).addAll(steps).build();
        }
    }

    public static class Case
    extends Exp {
        public final Exp exp;
        public final List<Match> matchList;

        Case(Pos pos, Type type, Exp exp, ImmutableList<Match> matchList) {
            super(pos, Op.CASE, type);
            this.exp = exp;
            this.matchList = matchList;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("case ").append(this.exp, 0, 0).append(" of ").appendAll(this.matchList, left, Op.BAR, right);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Case copy(Exp exp, List<Match> matchList) {
            return exp == this.exp && matchList.equals(this.matchList) ? this : CoreBuilder.core.caseOf(this.pos, this.type, exp, matchList);
        }
    }

    public static class Fn
    extends Exp {
        public final IdPat idPat;
        public final Exp exp;

        Fn(FnType type, IdPat idPat, Exp exp) {
            super(Pos.ZERO, Op.FN, type);
            this.idPat = Objects.requireNonNull(idPat);
            this.exp = Objects.requireNonNull(exp);
        }

        @Override
        public FnType type() {
            return (FnType)this.type;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("fn ").append(this.idPat, 0, 0).append(" => ").append(this.exp, 0, right);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Fn copy(IdPat idPat, Exp exp) {
            return idPat == this.idPat && exp == this.exp ? this : CoreBuilder.core.fn(this.type(), idPat, exp);
        }
    }

    public static class Match
    extends BaseNode {
        public final Pat pat;
        public final Exp exp;

        Match(Pos pos, Pat pat, Exp exp) {
            super(pos, Op.MATCH);
            this.pat = pat;
            this.exp = exp;
        }

        @Override
        public Match accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append(this.pat, 0, 0).append(" => ").append(this.exp, 0, right);
        }

        public Match copy(Pat pat, Exp exp) {
            return pat == this.pat && exp == this.exp ? this : CoreBuilder.core.match(this.pos, pat, exp);
        }
    }

    public static class Local
    extends Exp {
        public final DataType dataType;
        public final Exp exp;

        Local(DataType dataType, Exp exp) {
            super(Pos.ZERO, Op.LOCAL, exp.type);
            this.dataType = Objects.requireNonNull(dataType);
            this.exp = Objects.requireNonNull(exp);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("local datatype ").append(this.dataType.toString()).append(" in ").append(this.exp, 0, 0).append(" end");
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Exp copy(DataType dataType, Exp exp) {
            return dataType == this.dataType && exp == this.exp ? this : CoreBuilder.core.local(dataType, exp);
        }
    }

    public static class Let
    extends Exp {
        public final ValDecl decl;
        public final Exp exp;

        Let(ValDecl decl, Exp exp) {
            super(Pos.ZERO, Op.LET, exp.type);
            this.decl = Objects.requireNonNull(decl);
            this.exp = Objects.requireNonNull(exp);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("let ").append(this.decl, 0, 0).append(" in ").append(this.exp, 0, 0).append(" end");
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Exp copy(ValDecl decl, Exp exp) {
            return decl == this.decl && exp == this.exp ? this : CoreBuilder.core.let(decl, exp);
        }
    }

    public static class Tuple
    extends Exp {
        public final List<Exp> args;

        Tuple(RecordLikeType type, ImmutableList<Exp> args) {
            super(Pos.ZERO, Op.TUPLE, type);
            this.args = ImmutableList.copyOf(args);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Tuple && this.args.equals(((Tuple)o).args) && this.type.equals(((Tuple)o).type);
        }

        public int hashCode() {
            return Objects.hash(this.args, this.type);
        }

        @Override
        public RecordLikeType type() {
            return (RecordLikeType)this.type;
        }

        @Override
        public void forEachArg(ObjIntConsumer<Exp> action) {
            Ord.forEachIndexed(this.args, action);
        }

        @Override
        public Exp arg(int i) {
            return this.args.get(i);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            if (this.type instanceof RecordType) {
                w.append("{");
                this.forEach((i, name, exp) -> w.append(i > 0 ? ", " : "").append((String)name).append(" = ").append((AstNode)exp, 0, 0));
                return w.append("}");
            }
            w.append("(");
            this.forEach((i, name, arg) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append(")");
        }

        public void forEach(PairList.IndexedBiConsumer<String, Exp> consumer) {
            ImmutableSortedSet nameSet = (ImmutableSortedSet)this.type().argNameTypes().keySet();
            ImmutableList names = nameSet.asList();
            Pair.forEachIndexed(names, this.args, consumer::accept);
        }

        public Tuple copy(TypeSystem typeSystem, List<Exp> args) {
            return args.equals(this.args) ? this : CoreBuilder.core.tuple(typeSystem, this.type(), args);
        }

        @Override
        public boolean isConstant() {
            return this.args.stream().allMatch(Exp::isConstant);
        }
    }

    public static class RecValDecl
    extends ValDecl {
        public final ImmutableList<NonRecValDecl> list;

        RecValDecl(ImmutableList<NonRecValDecl> list) {
            super(Pos.ZERO, Op.REC_VAL_DECL);
            this.list = Objects.requireNonNull(list);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof RecValDecl && this.list.equals(((RecValDecl)o).list);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("val rec ");
            Ord.forEachIndexed(this.list, (decl, i) -> w.append(i == 0 ? "" : " and ").append(decl.pat, 0, 0).append(" = ").append(decl.exp, 0, right));
            return w;
        }

        @Override
        public RecValDecl accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public void forEachBinding(BindingConsumer consumer) {
            this.list.forEach(b -> b.forEachBinding(consumer));
        }

        public RecValDecl copy(List<NonRecValDecl> list) {
            return list.equals(this.list) ? this : CoreBuilder.core.recValDecl(list);
        }
    }

    public static class NonRecValDecl
    extends ValDecl {
        public final NamedPat pat;
        public final Exp exp;

        NonRecValDecl(NamedPat pat, Exp exp, Pos pos) {
            super(pos, Op.VAL_DECL);
            this.pat = pat;
            this.exp = exp;
        }

        public int hashCode() {
            return Objects.hash(this.pat, this.exp);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof NonRecValDecl && this.pat.equals(((NonRecValDecl)o).pat) && this.exp.equals(((NonRecValDecl)o).exp);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("val ").append(this.pat, 0, 0).append(" = ").append(this.exp, 0, right);
        }

        @Override
        public NonRecValDecl accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public NonRecValDecl copy(NamedPat pat, Exp exp) {
            return pat == this.pat && exp == this.exp ? this : CoreBuilder.core.nonRecValDecl(this.pos, pat, exp);
        }

        @Override
        public void forEachBinding(BindingConsumer consumer) {
            consumer.accept(this.pat, this.exp, this.pos);
        }
    }

    @FunctionalInterface
    public static interface BindingConsumer {
        public void accept(NamedPat var1, Exp var2, Pos var3);
    }

    public static abstract class ValDecl
    extends Decl {
        ValDecl(Pos pos, Op op) {
            super(pos, op);
        }

        @Override
        public abstract ValDecl accept(Shuttle var1);

        public abstract void forEachBinding(BindingConsumer var1);
    }

    public static class DatatypeDecl
    extends Decl {
        public final List<DataType> dataTypes;

        DatatypeDecl(ImmutableList<DataType> dataTypes) {
            super(Pos.ZERO, Op.DATATYPE_DECL);
            this.dataTypes = (List)Objects.requireNonNull(dataTypes);
            Preconditions.checkArgument((!this.dataTypes.isEmpty() ? 1 : 0) != 0);
        }

        public int hashCode() {
            return Objects.hash(this.dataTypes);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof DatatypeDecl && this.dataTypes.equals(((DatatypeDecl)o).dataTypes);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            Ord.forEachIndexed(this.dataTypes, (dataType, i) -> w.append(i == 0 ? "datatype " : " and ").append(dataType.toString()));
            return w;
        }

        @Override
        public DatatypeDecl accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class Decl
    extends BaseNode {
        Decl(Pos pos, Op op) {
            super(pos, op);
        }

        @Override
        public abstract Decl accept(Shuttle var1);
    }

    public static class Literal
    extends Exp {
        public final Comparable value;

        Literal(Op op, Type type, Comparable value) {
            super(Pos.ZERO, op, type);
            this.value = Objects.requireNonNull(value);
        }

        static Comparable wrap(Exp exp, Object value) {
            return new Wrapper(exp, value);
        }

        public <C> C unwrap(Class<C> clazz) {
            Comparable<Number> v;
            if (this.value instanceof Wrapper && ((Wrapper)this.value).o instanceof TypedValue) {
                return ((TypedValue)((Wrapper)this.value).o).valueAs(clazz);
            }
            if (clazz.isInstance(this.value) && clazz != Object.class) {
                v = this.value;
            } else if (Number.class.isAssignableFrom(clazz) && this.value instanceof Number) {
                Number number = (Number)((Object)this.value);
                v = clazz == Double.class ? Double.valueOf(number.doubleValue()) : (clazz == Float.class ? Float.valueOf(number.floatValue()) : (clazz == Long.class ? Long.valueOf(number.longValue()) : (clazz == Integer.class ? Integer.valueOf(number.intValue()) : (clazz == Short.class ? Short.valueOf(number.shortValue()) : (clazz == Byte.class ? Byte.valueOf(number.byteValue()) : (clazz == BigInteger.class && number instanceof BigDecimal ? ((BigDecimal)number).toBigIntegerExact() : this.value))))));
            } else {
                v = ((Wrapper)this.value).o;
            }
            return clazz.cast(v);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Literal && this.value.equals(((Literal)o).value);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            switch (this.op) {
                case VALUE_LITERAL: {
                    return ((Wrapper)this.value).exp.unparse(w, left, right);
                }
                case INTERNAL_LITERAL: {
                    return w.appendLiteral((Comparable)((Object)((Wrapper)this.value).o.toString()));
                }
            }
            return w.appendLiteral(this.value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class RecordSelector
    extends Exp {
        public final int slot;

        RecordSelector(FnType fnType, int slot) {
            super(Pos.ZERO, Op.RECORD_SELECTOR, fnType);
            this.slot = slot;
        }

        public int hashCode() {
            return this.slot + 2237;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof RecordSelector && this.slot == ((RecordSelector)o).slot && this.type.equals(((RecordSelector)o).type);
        }

        public String fieldName() {
            RecordLikeType recordType = (RecordLikeType)this.type().paramType;
            return (String)Iterables.get(recordType.argNameTypes().keySet(), (int)this.slot);
        }

        @Override
        public FnType type() {
            return (FnType)this.type;
        }

        @Override
        public RecordSelector accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("#").append(this.fieldName());
        }
    }

    public static class Id
    extends Exp
    implements Comparable<Id> {
        public final NamedPat idPat;

        Id(NamedPat idPat) {
            super(Pos.ZERO, Op.ID, idPat.type);
            this.idPat = Objects.requireNonNull(idPat);
        }

        @Override
        public int compareTo(Id o) {
            return this.idPat.compareTo(o.idPat);
        }

        public int hashCode() {
            return this.idPat.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Id && this.idPat.equals(((Id)o).idPat);
        }

        @Override
        public Exp accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.idPat.name, this.idPat.i);
        }
    }

    public static abstract class Exp
    extends BaseNode {
        public final Type type;

        Exp(Pos pos, Op op, Type type) {
            super(pos, op);
            this.type = Objects.requireNonNull(type);
        }

        public void forEachArg(ObjIntConsumer<Exp> action) {
        }

        public Exp arg(int i) {
            throw new UnsupportedOperationException();
        }

        public Type type() {
            return this.type;
        }

        @Override
        public abstract Exp accept(Shuttle var1);

        public boolean isConstant() {
            return false;
        }

        public boolean isCallTo(BuiltIn builtIn) {
            return false;
        }
    }

    public static class RecordPat
    extends Pat {
        public final List<Pat> args;

        RecordPat(RecordType type, ImmutableList<Pat> args) {
            super(Op.RECORD_PAT, type);
            this.args = (List)Objects.requireNonNull(args);
            Preconditions.checkArgument((args.size() == type.argNameTypes.size() ? 1 : 0) != 0);
        }

        @Override
        public RecordType type() {
            return (RecordType)this.type;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("{");
            Pair.forEachIndexed(this.type().argNameTypes.keySet(), this.args, (i, name, arg) -> w.append(i > 0 ? ", " : "").append((String)name).append(" = ").append((AstNode)arg, 0, 0));
            return w.append("}");
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public Pat copy(TypeSystem typeSystem, Set<String> argNames, List<Pat> args) {
            return args.equals(this.args) ? this : CoreBuilder.core.recordPat(typeSystem, argNames, args);
        }
    }

    public static class ListPat
    extends Pat {
        public final List<Pat> args;

        ListPat(Type type, ImmutableList<Pat> args) {
            super(Op.LIST_PAT, type);
            this.args = (List)Objects.requireNonNull(args);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("[");
            Ord.forEachIndexed(this.args, (arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append("]");
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public ListPat copy(TypeSystem typeSystem, List<Pat> args) {
            return args.equals(this.args) ? this : CoreBuilder.core.listPat(typeSystem, args);
        }
    }

    public static class TuplePat
    extends Pat {
        public final List<Pat> args;

        TuplePat(RecordLikeType type, ImmutableList<Pat> args) {
            super(Op.TUPLE_PAT, type);
            this.args = (List)Objects.requireNonNull(args);
            Preconditions.checkArgument((args.size() == type.argNameTypes().size() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)(args.isEmpty() ? type == PrimitiveType.UNIT : type instanceof TupleType));
        }

        @Override
        public RecordLikeType type() {
            return (RecordLikeType)this.type;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            w.append("(");
            Ord.forEachIndexed(this.args, (arg, i) -> w.append(i == 0 ? "" : ", ").append((AstNode)arg, 0, 0));
            return w.append(")");
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public TuplePat copy(TypeSystem typeSystem, List<Pat> args) {
            return args.equals(this.args) ? this : CoreBuilder.core.tuplePat(typeSystem, args);
        }

        public List<String> fieldNames() {
            ImmutableList.Builder names = ImmutableList.builder();
            for (Pat arg : this.args) {
                if (!(arg instanceof NamedPat)) continue;
                names.add((Object)((NamedPat)arg).name);
            }
            return names.build();
        }
    }

    public static class Con0Pat
    extends Pat {
        public final String tyCon;

        Con0Pat(DataType type, String tyCon) {
            super(Op.CON0_PAT, type);
            this.tyCon = Objects.requireNonNull(tyCon);
        }

        @Override
        public DataType type() {
            return (DataType)this.type;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.tyCon);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ConPat
    extends Pat {
        public final String tyCon;
        public final Pat pat;

        protected ConPat(Op op, Type type, String tyCon, Pat pat) {
            super(op, type);
            this.tyCon = Objects.requireNonNull(tyCon);
            this.pat = Objects.requireNonNull(pat);
            Preconditions.checkArgument((op == Op.CON_PAT || op == Op.CONS_PAT ? 1 : 0) != 0);
        }

        ConPat(Type type, String tyCon, Pat pat) {
            this(Op.CON_PAT, type, tyCon, pat);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.tyCon).append("(").append(this.pat, 0, 0).append(")");
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public ConPat copy(String tyCon, Pat pat) {
            return this.tyCon.equals(tyCon) && this.pat.equals(pat) ? this : new ConPat(this.op, this.type, tyCon, pat);
        }
    }

    public static class AsPat
    extends NamedPat {
        public final Pat pat;

        protected AsPat(Type type, String name, int i, Pat pat) {
            super(Op.AS_PAT, type, name, i);
            this.pat = Objects.requireNonNull(pat);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.name).append(" as ").append(this.pat, 0, 0);
        }

        @Override
        public AsPat withType(Type type) {
            return type == this.type ? this : new AsPat(type, this.name, this.i, this.pat);
        }

        @Override
        public AsPat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public AsPat copy(String name, int i, Pat pat) {
            return this.name.equals(name) && this.i == i && this.pat.equals(pat) ? this : new AsPat(this.type, name, i, pat);
        }
    }

    public static class WildcardPat
    extends Pat {
        WildcardPat(Type type) {
            super(Op.WILDCARD_PAT, type);
        }

        public int hashCode() {
            return "_".hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof WildcardPat;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.append("_");
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class LiteralPat
    extends Pat {
        public final Comparable value;

        LiteralPat(Op op, Type type, Comparable value) {
            super(op, type);
            this.value = Objects.requireNonNull(value);
            Preconditions.checkArgument((op == Op.BOOL_LITERAL_PAT || op == Op.CHAR_LITERAL_PAT || op == Op.INT_LITERAL_PAT || op == Op.REAL_LITERAL_PAT || op == Op.STRING_LITERAL_PAT ? 1 : 0) != 0);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof LiteralPat && this.value.equals(((LiteralPat)o).value);
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.appendLiteral(this.value);
        }

        @Override
        public Pat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class IdPat
    extends NamedPat {
        IdPat(Type type, String name, int i) {
            super(Op.ID_PAT, type, name, i);
        }

        public int hashCode() {
            return this.name.hashCode() + this.i;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IdPat && ((IdPat)obj).name.equals(this.name) && ((IdPat)obj).i == this.i;
        }

        @Override
        AstWriter unparse(AstWriter w, int left, int right) {
            return w.id(this.name, this.i);
        }

        @Override
        public IdPat accept(Shuttle shuttle) {
            return shuttle.visit(this);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        @Override
        public IdPat withType(Type type) {
            return type == this.type ? this : new IdPat(type, this.name, this.i);
        }
    }

    public static abstract class NamedPat
    extends Pat
    implements Comparable<NamedPat> {
        public static final Ordering<NamedPat> ORDERING = Ordering.from(NamedPat::compare);
        public final String name;
        public final int i;

        NamedPat(Op op, Type type, String name, int i) {
            super(op, type);
            this.name = Objects.requireNonNull(name, "name");
            this.i = i;
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"empty name");
        }

        @Override
        public int compareTo(NamedPat o) {
            return NamedPat.compare(this, o);
        }

        static int compare(NamedPat o1, NamedPat o2) {
            int c = RecordType.compareNames(o1.name, o2.name);
            if (c != 0) {
                return c;
            }
            return Integer.compare(o1.i, o2.i);
        }

        public abstract NamedPat withType(Type var1);

        @Override
        public abstract NamedPat accept(Shuttle var1);
    }

    public static abstract class Pat
    extends BaseNode {
        public final Type type;

        Pat(Op op, Type type) {
            super(Pos.ZERO, op);
            this.type = Objects.requireNonNull(type);
        }

        public Type type() {
            return this.type;
        }

        @Override
        public abstract Pat accept(Shuttle var1);
    }

    static abstract class BaseNode
    extends AstNode {
        BaseNode(Pos pos, Op op) {
            super(pos, op);
        }

        @Override
        public AstNode accept(Shuttle shuttle) {
            throw new UnsupportedOperationException(this.getClass() + " cannot accept " + shuttle.getClass());
        }

        @Override
        public void accept(Visitor visitor) {
            throw new UnsupportedOperationException(this.getClass() + " cannot accept " + visitor.getClass());
        }
    }
}

