/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.hydromatic.morel.ast.Ast;
import net.hydromatic.morel.ast.AstNode;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Visitor;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.Compiler;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.eval.Applicable;
import net.hydromatic.morel.eval.Code;
import net.hydromatic.morel.eval.Describable;
import net.hydromatic.morel.eval.Describer;
import net.hydromatic.morel.eval.EvalEnv;
import net.hydromatic.morel.eval.EvalEnvs;
import net.hydromatic.morel.eval.Prop;
import net.hydromatic.morel.eval.Session;
import net.hydromatic.morel.eval.Unit;
import net.hydromatic.morel.foreign.Calcite;
import net.hydromatic.morel.foreign.CalciteFunctions;
import net.hydromatic.morel.foreign.Converters;
import net.hydromatic.morel.foreign.RelList;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.ListType;
import net.hydromatic.morel.type.PrimitiveType;
import net.hydromatic.morel.type.RecordLikeType;
import net.hydromatic.morel.type.RecordType;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.type.TypeVar;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Static;
import net.hydromatic.morel.util.ThreadLocals;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.JsonBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CalciteCompiler
extends Compiler {
    static final Map<BuiltIn, SqlOperator> UNARY_OPERATORS = ImmutableMap.builder().put((Object)BuiltIn.NOT, (Object)SqlStdOperatorTable.NOT).put((Object)BuiltIn.LIST_NULL, (Object)SqlStdOperatorTable.EXISTS).put((Object)BuiltIn.RELATIONAL_EXISTS, (Object)SqlStdOperatorTable.EXISTS).put((Object)BuiltIn.RELATIONAL_NOT_EXISTS, (Object)SqlStdOperatorTable.EXISTS).put((Object)BuiltIn.RELATIONAL_ONLY, (Object)SqlStdOperatorTable.SCALAR_QUERY).build();
    static final Map<BuiltIn, SqlOperator> BINARY_OPERATORS = ImmutableMap.builder().put((Object)BuiltIn.OP_EQ, (Object)SqlStdOperatorTable.EQUALS).put((Object)BuiltIn.OP_NE, (Object)SqlStdOperatorTable.NOT_EQUALS).put((Object)BuiltIn.OP_LT, (Object)SqlStdOperatorTable.LESS_THAN).put((Object)BuiltIn.OP_LE, (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL).put((Object)BuiltIn.OP_GT, (Object)SqlStdOperatorTable.GREATER_THAN).put((Object)BuiltIn.OP_GE, (Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL).put((Object)BuiltIn.OP_NEGATE, (Object)SqlStdOperatorTable.UNARY_MINUS).put((Object)BuiltIn.OP_ELEM, (Object)SqlStdOperatorTable.IN).put((Object)BuiltIn.OP_NOT_ELEM, (Object)SqlStdOperatorTable.NOT_IN).put((Object)BuiltIn.Z_NEGATE_INT, (Object)SqlStdOperatorTable.UNARY_MINUS).put((Object)BuiltIn.Z_NEGATE_REAL, (Object)SqlStdOperatorTable.UNARY_MINUS).put((Object)BuiltIn.OP_PLUS, (Object)SqlStdOperatorTable.PLUS).put((Object)BuiltIn.Z_PLUS_INT, (Object)SqlStdOperatorTable.PLUS).put((Object)BuiltIn.Z_PLUS_REAL, (Object)SqlStdOperatorTable.PLUS).put((Object)BuiltIn.OP_MINUS, (Object)SqlStdOperatorTable.MINUS).put((Object)BuiltIn.Z_MINUS_INT, (Object)SqlStdOperatorTable.MINUS).put((Object)BuiltIn.Z_MINUS_REAL, (Object)SqlStdOperatorTable.MINUS).put((Object)BuiltIn.OP_TIMES, (Object)SqlStdOperatorTable.MULTIPLY).put((Object)BuiltIn.Z_TIMES_INT, (Object)SqlStdOperatorTable.MULTIPLY).put((Object)BuiltIn.Z_TIMES_REAL, (Object)SqlStdOperatorTable.MULTIPLY).put((Object)BuiltIn.OP_DIVIDE, (Object)SqlStdOperatorTable.DIVIDE).put((Object)BuiltIn.Z_DIVIDE_INT, (Object)SqlStdOperatorTable.DIVIDE).put((Object)BuiltIn.Z_DIVIDE_REAL, (Object)SqlStdOperatorTable.DIVIDE).put((Object)BuiltIn.OP_DIV, (Object)SqlStdOperatorTable.DIVIDE).put((Object)BuiltIn.OP_MOD, (Object)SqlStdOperatorTable.MOD).put((Object)BuiltIn.Z_ANDALSO, (Object)SqlStdOperatorTable.AND).put((Object)BuiltIn.Z_ORELSE, (Object)SqlStdOperatorTable.OR).build();
    final Calcite calcite;

    public CalciteCompiler(TypeSystem typeSystem, Calcite calcite) {
        super(typeSystem);
        this.calcite = Objects.requireNonNull(calcite, "calcite");
    }

    public @Nullable RelNode toRel(Environment env, Core.Exp expression) {
        return this.toRel2(new RelContext(env, null, this.calcite.relBuilder(), (ImmutableSortedMap<String, VarData>)ImmutableSortedMap.of(), 0), expression);
    }

    private RelNode toRel2(RelContext cx, Core.Exp expression) {
        if (this.toRel3(cx, expression, false)) {
            return cx.relBuilder.build();
        }
        return null;
    }

    boolean toRel3(RelContext cx, Core.Exp expression, boolean aggressive) {
        Code code = this.compile(cx, expression);
        return code instanceof RelCode && ((RelCode)code).toRel(cx, aggressive);
    }

    Code toRel4(Environment env, Code code, Type type) {
        if (!(code instanceof RelCode)) {
            return code;
        }
        RelContext rx = new RelContext(env, null, this.calcite.relBuilder(), (ImmutableSortedMap<String, VarData>)ImmutableSortedMap.of(), 0);
        if (((RelCode)code).toRel(rx, false)) {
            return this.calcite.code(rx.env, rx.relBuilder.build(), type);
        }
        return code;
    }

    @Override
    protected CalciteFunctions.Context createContext(Environment env) {
        Session dummySession = new Session((Map<Prop, Object>)ImmutableMap.of());
        return new CalciteFunctions.Context(dummySession, env, this.typeSystem, (RelDataTypeFactory)this.calcite.dataContext.getTypeFactory());
    }

    @Override
    public Code compileArg(Compiler.Context cx, Core.Exp expression) {
        RelBuilder relBuilder;
        RelContext rx;
        Code code = super.compileArg(cx, expression);
        if (code instanceof RelCode && !(cx instanceof RelContext) && this.toRel3(rx = new RelContext(cx.env, null, relBuilder = this.calcite.relBuilder(), (ImmutableSortedMap<String, VarData>)ImmutableSortedMap.of(), 0), expression, false)) {
            return this.calcite.code(rx.env, rx.relBuilder.build(), expression.type);
        }
        return code;
    }

    @Override
    protected Code finishCompileLet(Compiler.Context cx, List<Code> matchCodes_, Code resultCode_, Type resultType) {
        Code resultCode = this.toRel4(cx.env, resultCode_, resultType);
        ImmutableList matchCodes = ImmutableList.copyOf(matchCodes_);
        final Code code = super.finishCompileLet(cx, (List<Code>)matchCodes, resultCode, resultType);
        return new RelCode(){
            final /* synthetic */ List val$matchCodes;
            final /* synthetic */ Code val$resultCode;
            {
                this.val$matchCodes = list;
                this.val$resultCode = code2;
            }

            @Override
            public boolean toRel(RelContext cx, boolean aggressive) {
                return false;
            }

            @Override
            public Object eval(EvalEnv evalEnv) {
                return code.eval(evalEnv);
            }

            @Override
            public Describer describe(Describer describer) {
                return describer.start("let", d -> {
                    Ord.forEachIndexed(this.val$matchCodes, (matchCode, i) -> d.arg("matchCode" + i, (Describable)matchCode));
                    d.arg("resultCode", this.val$resultCode);
                });
            }
        };
    }

    @Override
    protected RelCode compileApply(Compiler.Context cx, final Core.Apply apply) {
        final Code code = super.compileApply(cx, apply);
        return new RelCode(){

            @Override
            public Describer describe(Describer describer) {
                return code.describe(describer);
            }

            @Override
            public Object eval(EvalEnv env) {
                return code.eval(env);
            }

            @Override
            public boolean toRel(RelContext cx, boolean aggressive) {
                if (!(apply.type instanceof ListType)) {
                    return false;
                }
                switch (apply.fn.op) {
                    case RECORD_SELECTOR: {
                        Object o;
                        if (!(apply.arg instanceof Core.Id) || !((o = code.eval(CalciteCompiler.evalEnvOf(cx.env))) instanceof RelList)) break;
                        cx.relBuilder.push(((RelList)o).rel);
                        return true;
                    }
                    case FN_LITERAL: {
                        BuiltIn builtIn = ((Core.Literal)apply.fn).unwrap(BuiltIn.class);
                        switch (builtIn) {
                            case Z_LIST: {
                                List<Core.Exp> args = apply.args();
                                if (args.isEmpty()) {
                                    RelDataType calciteType = Converters.toCalciteType(CalciteCompiler.this.removeTypeVars(apply.type), cx.relBuilder.getTypeFactory());
                                    cx.relBuilder.values(calciteType.getComponentType());
                                } else {
                                    for (Core.Exp arg : args) {
                                        cx.relBuilder.values(new String[]{"T"}, new Object[]{true});
                                        CalciteCompiler.this.yield_(cx, (List)ImmutableList.of(), arg);
                                    }
                                    cx.relBuilder.union(true, args.size());
                                }
                                return true;
                            }
                            case OP_UNION: 
                            case OP_EXCEPT: 
                            case OP_INTERSECT: {
                                Core.Tuple tuple = (Core.Tuple)apply.arg;
                                for (Core.Exp arg : tuple.args) {
                                    if (CalciteCompiler.this.toRel3(cx, arg, false)) continue;
                                    return false;
                                }
                                CalciteCompiler.harmonizeRowTypes(cx.relBuilder, tuple.args.size());
                                switch (builtIn) {
                                    case OP_UNION: {
                                        cx.relBuilder.union(true, tuple.args.size());
                                        return true;
                                    }
                                    case OP_EXCEPT: {
                                        cx.relBuilder.minus(false, tuple.args.size());
                                        return true;
                                    }
                                    case OP_INTERSECT: {
                                        cx.relBuilder.intersect(false, tuple.args.size());
                                        return true;
                                    }
                                }
                                throw new AssertionError((Object)builtIn);
                            }
                        }
                    }
                }
                RelDataTypeFactory typeFactory = cx.relBuilder.getTypeFactory();
                RelDataType calciteType = Converters.toCalciteType(apply.type, typeFactory);
                RelDataType rowType = calciteType.getComponentType();
                if (rowType == null) {
                    return false;
                }
                if (!aggressive) {
                    return false;
                }
                JsonBuilder jsonBuilder = new JsonBuilder();
                RelJson relJson = RelJson.create().withJsonBuilder(jsonBuilder);
                String jsonRowType = jsonBuilder.toJsonString(relJson.toJson((Object)rowType));
                String morelCode = apply.toString();
                ThreadLocals.let(CalciteFunctions.THREAD_ENV, new CalciteFunctions.Context(new Session((Map<Prop, Object>)ImmutableMap.of()), cx.env, CalciteCompiler.this.typeSystem, cx.relBuilder.getTypeFactory()), () -> cx.relBuilder.functionScan(CalciteFunctions.TABLE_OPERATOR, 0, new RexNode[]{cx.relBuilder.literal((Object)morelCode), cx.relBuilder.literal((Object)jsonRowType)}));
                return true;
            }
        };
    }

    private Type removeTypeVars(Type type) {
        return type.copy(this.typeSystem, t -> t instanceof TypeVar ? this.typeSystem.recordType(RecordType.map("b", PrimitiveType.BOOL, new Object[0])) : t);
    }

    @Override
    protected Code finishCompileApply(Compiler.Context cx, Code fnCode, Code argCode, Type argType) {
        RelContext rx;
        if (argCode instanceof RelCode && cx instanceof RelContext && ((RelCode)argCode).toRel(rx = (RelContext)cx, false)) {
            Code argCode2 = this.calcite.code(rx.env, rx.relBuilder.build(), argType);
            return this.finishCompileApply(cx, fnCode, argCode2, argType);
        }
        return super.finishCompileApply(cx, fnCode, argCode, argType);
    }

    @Override
    protected Code finishCompileApply(Compiler.Context cx, Applicable fnValue, Code argCode, Type argType) {
        RelContext rx;
        if (argCode instanceof RelCode && cx instanceof RelContext && ((RelCode)argCode).toRel(rx = (RelContext)cx, false)) {
            Code argCode2 = this.calcite.code(rx.env, rx.relBuilder.build(), argType);
            return this.finishCompileApply(cx, fnValue, argCode2, argType);
        }
        return super.finishCompileApply(cx, fnValue, argCode, argType);
    }

    private static void harmonizeRowTypes(RelBuilder relBuilder, int inputCount) {
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(relBuilder.build());
        }
        RelDataType rowType = relBuilder.getTypeFactory().leastRestrictive(Static.transform(inputs, RelNode::getRowType));
        for (RelNode input : Lists.reverse(inputs)) {
            relBuilder.push(input).convert(rowType, false);
        }
    }

    @Override
    protected Code compileFrom(Compiler.Context cx, final Core.From from) {
        final Code code = super.compileFrom(cx, from);
        return new RelCode(){

            @Override
            public Describer describe(Describer describer) {
                return code.describe(describer);
            }

            @Override
            public Object eval(EvalEnv env) {
                return code.eval(env);
            }

            @Override
            public boolean toRel(RelContext cx, boolean aggressive) {
                if (from.steps.isEmpty() || !(from.steps.get(0) instanceof Core.Scan)) {
                    cx.relBuilder.values((Iterable)ImmutableList.of((Object)ImmutableList.of()), cx.relBuilder.getTypeFactory().builder().build());
                }
                cx = new RelContext(cx.env, cx, cx.relBuilder, (ImmutableSortedMap<String, VarData>)ImmutableSortedMap.of(), 1);
                for (Ord<Core.FromStep> fromStep : Ord.zip(from.steps)) {
                    if ((cx = this.step(cx, fromStep.i, (Core.FromStep)fromStep.e)) != null) continue;
                    return false;
                }
                if (from.steps.isEmpty() || ((Core.FromStep)Iterables.getLast(from.steps)).op != Op.YIELD) {
                    Core.Exp implicitYieldExp = CoreBuilder.core.implicitYieldExp(CalciteCompiler.this.typeSystem, (List<Core.FromStep>)from.steps);
                    cx = CalciteCompiler.this.yield_(cx, (List)ImmutableList.of(), implicitYieldExp);
                }
                return true;
            }

            private RelContext step(RelContext cx, int i, Core.FromStep fromStep) {
                switch (fromStep.op) {
                    case SCAN: {
                        return CalciteCompiler.this.join(cx, i, (Core.Scan)fromStep);
                    }
                    case WHERE: {
                        return CalciteCompiler.this.where(cx, (Core.Where)fromStep);
                    }
                    case SKIP: {
                        return CalciteCompiler.this.skip(cx, (Core.Skip)fromStep);
                    }
                    case TAKE: {
                        return CalciteCompiler.this.take(cx, (Core.Take)fromStep);
                    }
                    case ORDER: {
                        return CalciteCompiler.this.order(cx, (Core.Order)fromStep);
                    }
                    case GROUP: {
                        return CalciteCompiler.this.group(cx, (Core.Group)fromStep);
                    }
                    case YIELD: {
                        return CalciteCompiler.this.yield_(cx, (Core.Yield)fromStep);
                    }
                }
                throw new AssertionError(fromStep);
            }
        };
    }

    private RelContext yield_(RelContext cx, Core.Yield yield) {
        return this.yield_(cx, (List<Binding>)yield.bindings, yield.exp);
    }

    private RelContext yield_(RelContext cx, List<Binding> bindings, Core.Exp exp) {
        switch (exp.op) {
            case ID: {
                Core.Id id = (Core.Id)exp;
                Core.Tuple tuple = this.toRecord(cx, id);
                if (tuple == null) break;
                return this.yield_(cx, bindings, tuple);
            }
            case TUPLE: {
                Core.Tuple tuple = (Core.Tuple)exp;
                ImmutableList names = ImmutableList.copyOf(tuple.type().argNameTypes().keySet());
                cx.relBuilder.project(Static.transform(tuple.args, e -> this.translate(cx, (Core.Exp)e)), (Iterable)names);
                return CalciteCompiler.getRelContext(cx, cx.env.bindAll(bindings), (List<String>)names);
            }
        }
        RexNode rex = this.translate(cx, exp);
        cx.relBuilder.project(new RexNode[]{rex});
        return cx;
    }

    private RexNode translate(RelContext cx, Core.Exp exp) {
        switch (exp.op) {
            case CHAR_LITERAL: 
            case UNIT_LITERAL: 
            case BOOL_LITERAL: 
            case INT_LITERAL: 
            case REAL_LITERAL: 
            case STRING_LITERAL: {
                Core.Literal literal = (Core.Literal)exp;
                switch (exp.op) {
                    case CHAR_LITERAL: {
                        return cx.relBuilder.literal((Object)(literal.value + ""));
                    }
                    case UNIT_LITERAL: {
                        return cx.relBuilder.call((SqlOperator)SqlStdOperatorTable.ROW, new RexNode[0]);
                    }
                }
                return cx.relBuilder.literal((Object)literal.value);
            }
            case ID: {
                Core.Id id = (Core.Id)exp;
                Binding binding = cx.env.getOpt(id.idPat);
                if (binding != null && binding.value != Unit.INSTANCE) {
                    Core.Literal coreLiteral = CoreBuilder.core.literal((PrimitiveType)binding.id.type, binding.value);
                    return this.translate(cx, coreLiteral);
                }
                Core.Tuple record = this.toRecord(cx, id);
                if (record != null) {
                    return this.translate(cx, record);
                }
                if (!cx.map.containsKey((Object)id.idPat.name)) break;
                VarData fn = Objects.requireNonNull((VarData)cx.map.get((Object)id.idPat.name));
                return fn.apply(cx.relBuilder);
            }
            case APPLY: {
                Set<String> vars;
                Core.Apply apply = (Core.Apply)exp;
                switch (apply.fn.op) {
                    case FN_LITERAL: {
                        BuiltIn op = ((Core.Literal)apply.fn).unwrap(BuiltIn.class);
                        SqlOperator unaryOp = UNARY_OPERATORS.get((Object)op);
                        if (unaryOp != null) {
                            switch (op) {
                                case LIST_NULL: 
                                case RELATIONAL_NOT_EXISTS: 
                                case RELATIONAL_EXISTS: 
                                case RELATIONAL_ONLY: {
                                    RelNode r = this.toRel2(cx, apply.arg);
                                    if (r == null) break;
                                    switch (op) {
                                        case LIST_NULL: 
                                        case RELATIONAL_NOT_EXISTS: {
                                            return cx.relBuilder.not((RexNode)RexSubQuery.exists((RelNode)r));
                                        }
                                        case RELATIONAL_EXISTS: {
                                            return RexSubQuery.exists((RelNode)r);
                                        }
                                        case RELATIONAL_ONLY: {
                                            return RexSubQuery.scalar((RelNode)r);
                                        }
                                    }
                                    throw new AssertionError((Object)("unknown " + (Object)((Object)op)));
                                }
                            }
                            return cx.relBuilder.call(unaryOp, new RexNode[]{this.translate(cx, apply.arg)});
                        }
                        SqlOperator binaryOp = BINARY_OPERATORS.get((Object)op);
                        if (binaryOp == null) break;
                        assert (apply.arg.op == Op.TUPLE);
                        switch (op) {
                            case OP_ELEM: 
                            case OP_NOT_ELEM: {
                                RelNode r = this.toRel2(cx, apply.args().get(1));
                                if (r == null) break;
                                RexNode e = this.translate(cx, apply.args().get(0));
                                RexSubQuery in = RexSubQuery.in((RelNode)r, (ImmutableList)ImmutableList.of((Object)e));
                                return this.maybeNot(cx, (RexNode)in, op == BuiltIn.OP_NOT_ELEM);
                            }
                        }
                        return cx.relBuilder.call(binaryOp, this.translateList(cx, apply.args()));
                    }
                }
                if (apply.fn instanceof Core.RecordSelector && apply.arg instanceof Core.Id) {
                    Core.NamedPat idPat = ((Core.Id)apply.arg).idPat;
                    @Nullable RexNode range = cx.var(idPat.name);
                    if (range != null) {
                        Core.RecordSelector selector = (Core.RecordSelector)apply.fn;
                        return cx.relBuilder.field(range, selector.fieldName());
                    }
                }
                if ((vars = this.getRelationalVariables(cx.env, (Set<String>)cx.map.keySet(), apply)).isEmpty()) {
                    return this.morelScalar(cx, apply);
                }
                RexNode fnRex = this.translate(cx, apply.fn);
                RexNode argRex = this.translate(cx, apply.arg);
                return this.morelApply(cx, apply.type, apply.arg.type, fnRex, argRex);
            }
            case FROM: {
                Core.From from = (Core.From)exp;
                RelNode r = this.toRel2(cx, from);
                if (r == null) break;
                return cx.relBuilder.call((SqlOperator)SqlStdOperatorTable.ARRAY_QUERY, new RexNode[]{RexSubQuery.scalar((RelNode)r)});
            }
            case TUPLE: {
                Core.Tuple tuple = (Core.Tuple)exp;
                RelDataTypeFactory.FieldInfoBuilder builder = cx.relBuilder.getTypeFactory().builder();
                ArrayList operands = new ArrayList();
                Ord.forEachIndexed(tuple.args, (arg_0, arg_1) -> this.lambda$translate$2(cx, operands, (RelDataTypeFactory.Builder)builder, arg_0, arg_1));
                return cx.relBuilder.getRexBuilder().makeCall(builder.build(), (SqlOperator)SqlStdOperatorTable.ROW, operands);
            }
        }
        return this.morelScalar(cx, exp);
    }

    private RexNode maybeNot(RelContext cx, RexNode e, boolean not) {
        return not ? cx.relBuilder.not(e) : e;
    }

    private Set<String> getRelationalVariables(Environment env, final Set<String> nameSet, AstNode node) {
        final LinkedHashSet<String> varNames = new LinkedHashSet<String>();
        node.accept(new Visitor(){

            @Override
            protected void visit(Core.Id id) {
                if (nameSet.contains(id.idPat.name)) {
                    varNames.add(id.idPat.name);
                }
            }
        });
        return varNames;
    }

    private RexNode morelScalar(RelContext cx, Core.Exp exp) {
        RelDataTypeFactory typeFactory = cx.relBuilder.getTypeFactory();
        RelDataType calciteType = Converters.toCalciteType(exp.type, typeFactory);
        JsonBuilder jsonBuilder = new JsonBuilder();
        RelJson relJson = RelJson.create().withJsonBuilder(jsonBuilder);
        String jsonType = jsonBuilder.toJsonString(relJson.toJson((Object)calciteType));
        String morelCode = exp.toString();
        return cx.relBuilder.getRexBuilder().makeCall(calciteType, CalciteFunctions.SCALAR_OPERATOR, Arrays.asList(cx.relBuilder.literal((Object)morelCode), cx.relBuilder.literal((Object)jsonType)));
    }

    private RexNode morelApply(RelContext cx, Type type, Type argType, RexNode fn, RexNode arg) {
        RelDataTypeFactory typeFactory = cx.relBuilder.getTypeFactory();
        RelDataType calciteType = Converters.toCalciteType(type, typeFactory);
        String morelArgType = argType.toString();
        return cx.relBuilder.getRexBuilder().makeCall(calciteType, CalciteFunctions.APPLY_OPERATOR, Arrays.asList(cx.relBuilder.literal((Object)morelArgType), fn, arg));
    }

    private Core.Tuple toRecord(RelContext cx, Core.Id id) {
        Binding binding = cx.env.getOpt(id.idPat);
        Preconditions.checkNotNull((Object)binding, (String)"not found", (Object)id);
        Type type = binding.id.type;
        if (type instanceof RecordType) {
            RecordType recordType = (RecordType)type;
            ArrayList args = new ArrayList();
            recordType.argNameTypes.forEach((field, fieldType) -> args.add(CoreBuilder.core.apply(Pos.ZERO, (Type)fieldType, CoreBuilder.core.recordSelector(this.typeSystem, (RecordLikeType)recordType, (String)field), id)));
            return CoreBuilder.core.tuple((RecordLikeType)recordType, args);
        }
        return null;
    }

    private List<RexNode> translateList(RelContext cx, List<Core.Exp> exps) {
        return Static.transformEager(exps, exp -> this.translate(cx, (Core.Exp)exp));
    }

    private RelContext join(RelContext cx, int i, Core.Scan scan) {
        if (!this.toRel3(cx, scan.exp, true)) {
            return null;
        }
        TreeMap<String, VarData> varOffsets = new TreeMap<String, VarData>((SortedMap<String, VarData>)cx.map);
        int offset = 0;
        for (VarData varData : cx.map.values()) {
            offset += varData.rowType.getFieldCount();
        }
        Core.Pat pat = scan.pat;
        RelNode r = cx.relBuilder.peek();
        if (pat instanceof Core.IdPat) {
            Core.IdPat idPat = (Core.IdPat)pat;
            cx.relBuilder.as(idPat.name);
            varOffsets.put(idPat.name, new VarData(pat.type, offset, r.getRowType()));
        }
        cx = new RelContext(cx.env.bindAll((Iterable<Binding>)scan.bindings), cx, cx.relBuilder, (ImmutableSortedMap<String, VarData>)ImmutableSortedMap.copyOfSorted(varOffsets), cx.inputCount + 1);
        if (i > 0) {
            JoinRelType joinRelType = CalciteCompiler.joinRelType(scan.op);
            cx.relBuilder.join(joinRelType, this.translate(cx, scan.condition));
        }
        return cx;
    }

    private static JoinRelType joinRelType(Op op) {
        switch (op) {
            case SCAN: {
                return JoinRelType.INNER;
            }
        }
        throw new AssertionError((Object)op);
    }

    private RelContext where(RelContext cx, Core.Where where) {
        cx.relBuilder.filter(cx.varList, new RexNode[]{this.translate(cx, where.exp)});
        return cx;
    }

    private RelContext skip(RelContext cx, Core.Skip skip) {
        if (skip.exp.op != Op.INT_LITERAL) {
            throw new AssertionError((Object)("skip requires literal: " + skip.exp));
        }
        int offset = ((Core.Literal)skip.exp).unwrap(Integer.class);
        int fetch = -1;
        cx.relBuilder.limit(offset, fetch);
        return cx;
    }

    private RelContext take(RelContext cx, Core.Take take) {
        if (take.exp.op != Op.INT_LITERAL) {
            throw new AssertionError((Object)("take requires literal: " + take.exp));
        }
        int offset = 0;
        int fetch = ((Core.Literal)take.exp).unwrap(Integer.class);
        cx.relBuilder.limit(offset, fetch);
        return cx;
    }

    private RelContext order(RelContext cx, Core.Order order) {
        ArrayList exps = new ArrayList();
        order.orderItems.forEach(i -> {
            RexNode exp = this.translate(cx, i.exp);
            if (i.direction == Ast.Direction.DESC) {
                exp = cx.relBuilder.desc(exp);
            }
            exps.add(exp);
        });
        cx.relBuilder.sort(exps);
        return cx;
    }

    private RelContext group(RelContext cx, Core.Group group) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        ArrayList nodes = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        group.groupExps.forEach((idPat, exp) -> {
            bindings.add(Binding.of(idPat));
            nodes.add(this.translate(cx, (Core.Exp)exp));
            names.add(idPat.name);
        });
        RelBuilder.GroupKey groupKey = cx.relBuilder.groupKey(nodes);
        ArrayList aggregateCalls = new ArrayList();
        group.aggregates.forEach((idPat, aggregate) -> {
            bindings.add(Binding.of(idPat));
            SqlAggFunction op = this.aggOp(aggregate.aggregate);
            ImmutableList.Builder args = ImmutableList.builder();
            if (aggregate.argument != null) {
                args.add((Object)this.translate(cx, aggregate.argument));
            }
            aggregateCalls.add(cx.relBuilder.aggregateCall(op, (Iterable)args.build()).as(idPat.name));
            names.add(idPat.name);
        });
        cx.relBuilder.aggregate(groupKey, aggregateCalls);
        return CalciteCompiler.getRelContext(cx, cx.env.bindAll(bindings), names);
    }

    private static RelContext getRelContext(RelContext cx, Environment env, List<String> names) {
        ImmutableList sortedNames = Ordering.natural().immutableSortedCopy(names);
        cx.relBuilder.rename(names).project((Iterable)cx.relBuilder.fields((Iterable)sortedNames));
        RelDataType rowType = cx.relBuilder.peek().getRowType();
        TreeMap map = new TreeMap();
        sortedNames.forEach(name -> map.put(name, new VarData(PrimitiveType.UNIT, map.size(), rowType)));
        return new RelContext(env, cx, cx.relBuilder, (ImmutableSortedMap<String, VarData>)ImmutableSortedMap.copyOfSorted(map), 1);
    }

    private @NonNull SqlAggFunction aggOp(Core.Exp aggregate) {
        if (aggregate instanceof Core.Literal) {
            switch (((Core.Literal)aggregate).unwrap(BuiltIn.class)) {
                case RELATIONAL_SUM: 
                case Z_SUM_INT: 
                case Z_SUM_REAL: {
                    return SqlStdOperatorTable.SUM;
                }
                case RELATIONAL_COUNT: {
                    return SqlStdOperatorTable.COUNT;
                }
                case RELATIONAL_MIN: {
                    return SqlStdOperatorTable.MIN;
                }
                case RELATIONAL_MAX: {
                    return SqlStdOperatorTable.MAX;
                }
            }
        }
        throw new AssertionError((Object)("unknown aggregate function: " + aggregate));
    }

    private static EvalEnv evalEnvOf(Environment env) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        env.forEachValue(map::put);
        EMPTY_ENV.visit(map::putIfAbsent);
        return EvalEnvs.copyOf(map);
    }

    private /* synthetic */ void lambda$translate$2(RelContext cx, List operands, RelDataTypeFactory.Builder builder, Core.Exp arg, int i) {
        RexNode e = this.translate(cx, arg);
        operands.add(e);
        builder.add(Integer.toString(i), e.getType());
    }

    static class RelContext
    extends Compiler.Context {
        final @Nullable RelContext parent;
        final RelBuilder relBuilder;
        final ImmutableSortedMap<String, VarData> map;
        final int inputCount;
        final List<CorrelationId> varList = new ArrayList<CorrelationId>();
        private final RelNode top;

        RelContext(Environment env, RelContext parent, RelBuilder relBuilder, ImmutableSortedMap<String, VarData> map, int inputCount) {
            super(env);
            this.parent = parent;
            this.relBuilder = relBuilder;
            this.map = map;
            this.inputCount = inputCount;
            this.top = RelContext.top(relBuilder);
        }

        private static @Nullable RelNode top(RelBuilder relBuilder) {
            return relBuilder.size() == 0 ? null : relBuilder.peek();
        }

        @Override
        RelContext bindAll(Iterable<Binding> bindings) {
            Environment env2 = this.env.bindAll(bindings);
            return env2 == this.env ? this : new RelContext(env2, this, this.relBuilder, this.map, this.inputCount);
        }

        public @Nullable RexNode var(String name) {
            VarData fn = (VarData)this.map.get((Object)name);
            if (fn != null) {
                return fn.apply(this.relBuilder);
            }
            RelContext p = this.parent;
            while (p != null) {
                if (p.map.containsKey((Object)name)) {
                    RelOptCluster cluster = p.top.getCluster();
                    RexCorrelVariable correlVariable = (RexCorrelVariable)cluster.getRexBuilder().makeCorrel(p.top.getRowType(), cluster.createCorrel());
                    p.varList.add(correlVariable.id);
                    return correlVariable;
                }
                p = p.parent;
            }
            return null;
        }
    }

    static interface RelCode
    extends Code {
        public boolean toRel(RelContext var1, boolean var2);

        public static RelCode of(final Code code, final Predicate<RelContext> c) {
            return new RelCode(){

                @Override
                public Describer describe(Describer describer) {
                    return code.describe(describer);
                }

                @Override
                public Object eval(EvalEnv env) {
                    return code.eval(env);
                }

                @Override
                public boolean toRel(RelContext cx, boolean aggressive) {
                    return c.test(cx);
                }
            };
        }
    }

    private static class VarData {
        final Type type;
        final int offset;
        final RelDataType rowType;

        VarData(Type type, int offset, RelDataType rowType) {
            this.type = type;
            this.offset = offset;
            this.rowType = rowType;
        }

        RexNode apply(RelBuilder relBuilder) {
            if (this.type instanceof RecordType) {
                return relBuilder.getRexBuilder().makeRangeReference(this.rowType, this.offset, false);
            }
            return relBuilder.field(this.offset);
        }
    }
}

