/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.Shuttle;
import net.hydromatic.morel.compile.Compiles;
import net.hydromatic.morel.compile.Environment;
import net.hydromatic.morel.type.Binding;
import net.hydromatic.morel.type.TypeSystem;

abstract class EnvShuttle
extends Shuttle {
    final Environment env;

    protected EnvShuttle(TypeSystem typeSystem, Environment env) {
        super(typeSystem);
        this.env = env;
    }

    protected abstract EnvShuttle push(Environment var1);

    protected EnvShuttle bind(Binding binding) {
        return this.push(this.env.bind(binding));
    }

    protected EnvShuttle bind(List<Binding> bindingList) {
        Environment env2 = this.env.bindAll(bindingList);
        if (env2 == this.env) {
            return this;
        }
        return this.push(env2);
    }

    @Override
    protected Core.Fn visit(Core.Fn fn) {
        Core.IdPat idPat2 = fn.idPat.accept(this);
        Binding binding = Binding.of(fn.idPat);
        return fn.copy(idPat2, fn.exp.accept(this.bind(binding)));
    }

    @Override
    protected Core.Match visit(Core.Match match) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Core.Pat pat2 = match.pat.accept(this);
        Compiles.bindPattern(this.typeSystem, bindings, pat2);
        return CoreBuilder.core.match(match.pos, pat2, match.exp.accept(this.bind(bindings)));
    }

    @Override
    protected Core.Exp visit(Core.Let let) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Compiles.bindPattern(this.typeSystem, bindings, let.decl);
        return let.copy(let.decl.accept(this), let.exp.accept(this.bind(bindings)));
    }

    @Override
    protected Core.Exp visit(Core.Local local) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        Compiles.bindDataType(this.typeSystem, bindings, local.dataType);
        return local.copy(local.dataType, local.exp.accept(this.bind(bindings)));
    }

    @Override
    protected Core.RecValDecl visit(Core.RecValDecl recValDecl) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        recValDecl.list.forEach(decl -> Compiles.bindPattern(this.typeSystem, (List<Binding>)bindings, decl.pat));
        return recValDecl.copy(this.bind(bindings).visitList(recValDecl.list));
    }

    @Override
    protected Core.Exp visit(Core.From from) {
        ImmutableList<Binding> bindings = ImmutableList.of();
        ArrayList<Core.FromStep> steps = new ArrayList<Core.FromStep>();
        for (Core.FromStep step : from.steps) {
            Core.FromStep step2 = step.accept(this.bind((List<Binding>)bindings));
            steps.add(step2);
            bindings = step2.bindings;
        }
        return from.copy(this.typeSystem, this.env, steps);
    }
}

