/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.morel.compile;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import net.hydromatic.morel.ast.Core;
import net.hydromatic.morel.ast.CoreBuilder;
import net.hydromatic.morel.ast.FromBuilder;
import net.hydromatic.morel.ast.Op;
import net.hydromatic.morel.ast.Pos;
import net.hydromatic.morel.ast.Shuttle;
import net.hydromatic.morel.compile.BuiltIn;
import net.hydromatic.morel.compile.CompileException;
import net.hydromatic.morel.type.RangeExtent;
import net.hydromatic.morel.type.Type;
import net.hydromatic.morel.type.TypeSystem;
import net.hydromatic.morel.util.ImmutablePairList;
import net.hydromatic.morel.util.Ord;
import net.hydromatic.morel.util.Pair;
import net.hydromatic.morel.util.PairList;
import net.hydromatic.morel.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Extents {
    private Extents() {
    }

    /*
     * WARNING - void declaration
     */
    public static Analysis create(TypeSystem typeSystem, Core.Pat pat, SortedMap<Core.NamedPat, Core.Exp> boundPats, Iterable<? extends Core.FromStep> followingSteps, PairList<Core.IdPat, Core.Exp> idPats) {
        void var9_12;
        Extent extent = new Extent(typeSystem, pat, boundPats, idPats);
        ArrayList remainingFilters = new ArrayList();
        ExtentMap map = new ExtentMap();
        for (Core.FromStep fromStep : followingSteps) {
            if (!(fromStep instanceof Core.Where)) continue;
            extent.g3(map.map, ((Core.Where)fromStep).exp);
        }
        extent.definitions.forEach((namedPat, exp) -> {
            if (!map.map.containsKey(namedPat) || Extents.isInfinite(map.map.get(namedPat).left(0))) {
                map.map.put((Core.Pat)namedPat, (PairList<Core.Exp, Core.Exp>)ImmutablePairList.of(CoreBuilder.core.list(typeSystem, (Core.Exp)exp, new Core.Exp[0]), CoreBuilder.core.equal(typeSystem, CoreBuilder.core.id((Core.NamedPat)namedPat), (Core.Exp)exp)));
            }
        });
        PairList<Core.Exp, Core.Exp> foo = map.get(typeSystem, pat);
        if (foo.isEmpty()) {
            Pair<Core.Exp, Core.Literal> pair = Pair.of(CoreBuilder.core.extent(typeSystem, pat.type, (RangeSet)ImmutableRangeSet.of((Range)Range.all())), CoreBuilder.core.boolLiteral(true));
        } else {
            Pair<Core.Exp, Core.Exp> pair = Extents.reduceAnd(typeSystem, foo);
        }
        return new Analysis(boundPats, extent.goalPats, (Core.Exp)var9_12.left, CoreBuilder.core.decomposeAnd((Core.Exp)var9_12.right), remainingFilters);
    }

    private static List<Core.IdPat> flatten(Core.Pat pat) {
        switch (pat.op) {
            case ID_PAT: {
                return ImmutableList.of((Object)((Core.IdPat)pat));
            }
            case TUPLE_PAT: {
                Core.TuplePat tuplePat = (Core.TuplePat)pat;
                for (Core.Pat arg : tuplePat.args) {
                    if (arg.op == Op.ID_PAT) continue;
                    throw new CompileException("must be id", false, arg.pos);
                }
                return tuplePat.args;
            }
            case RECORD_PAT: {
                Core.RecordPat recordPat = (Core.RecordPat)pat;
                for (Core.Pat arg : recordPat.args) {
                    if (arg.op == Op.ID_PAT) continue;
                    throw new CompileException("must be id", false, arg.pos);
                }
                return recordPat.args;
            }
        }
        throw new CompileException("must be id", false, pat.pos);
    }

    public static boolean isInfinite(Core.Exp exp) {
        if (!exp.isCallTo(BuiltIn.Z_EXTENT)) {
            return false;
        }
        Core.Apply apply = (Core.Apply)exp;
        Core.Literal literal = (Core.Literal)apply.arg;
        RangeExtent rangeExtent = literal.unwrap(RangeExtent.class);
        return rangeExtent.iterable == null;
    }

    public static Core.Decl infinitePats(TypeSystem typeSystem, Core.Decl node) {
        return node.accept(new Shuttle(typeSystem){

            @Override
            protected Core.From visit(Core.From from) {
                for (Ord<Core.FromStep> step : Ord.zip(from.steps)) {
                    if (!(step.e instanceof Core.Scan)) continue;
                    Core.Scan scan = (Core.Scan)step.e;
                    if (!Extents.isInfinite(scan.exp)) continue;
                    FromBuilder fromBuilder = CoreBuilder.core.fromBuilder(this.typeSystem);
                    List<Core.FromStep> followingSteps = Static.skip(from.steps, step.i + 1);
                    Analysis analysis = Extents.create(this.typeSystem, scan.pat, (SortedMap<Core.NamedPat, Core.Exp>)ImmutableSortedMap.of(), followingSteps, ImmutablePairList.of());
                    for (Core.FromStep step2 : from.steps) {
                        if (step2 == scan) {
                            fromBuilder.scan(scan.pat, analysis.extentExp, scan.condition);
                            continue;
                        }
                        if (step2 instanceof Core.Where) {
                            fromBuilder.where(CoreBuilder.core.subTrue(this.typeSystem, ((Core.Where)step2).exp, analysis.satisfiedFilters));
                            continue;
                        }
                        fromBuilder.addAll((Iterable<? extends Core.FromStep>)ImmutableList.of((Object)step2));
                    }
                    return fromBuilder.build();
                }
                return from;
            }
        });
    }

    public static <C extends Comparable<C>> Map<String, ImmutableRangeSet<C>> intersect(List<Map<String, ImmutableRangeSet<C>>> rangeSetMaps) {
        switch (rangeSetMaps.size()) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return rangeSetMaps.get(0);
            }
        }
        HashMultimap rangeSetMultimap = HashMultimap.create();
        for (Map<String, ImmutableRangeSet<C>> rangeSetMap : rangeSetMaps) {
            rangeSetMap.forEach((arg_0, arg_1) -> ((Multimap)rangeSetMultimap).put(arg_0, arg_1));
        }
        ImmutableMap.Builder rangeSetMap = ImmutableMap.builder();
        rangeSetMultimap.asMap().forEach((path, rangeSets) -> rangeSetMap.put(path, Extents.intersectRangeSets(rangeSets)));
        return rangeSetMap.build();
    }

    public static <C extends Comparable<C>> Map<String, ImmutableRangeSet<C>> union(List<Map<String, ImmutableRangeSet<C>>> rangeSetMaps) {
        switch (rangeSetMaps.size()) {
            case 0: {
                return ImmutableMap.of((Object)"/", (Object)ImmutableRangeSet.of());
            }
            case 1: {
                return rangeSetMaps.get(0);
            }
        }
        HashMultimap rangeSetMultimap = HashMultimap.create();
        for (Map<String, ImmutableRangeSet<C>> rangeSetMap : rangeSetMaps) {
            rangeSetMap.forEach((arg_0, arg_1) -> ((Multimap)rangeSetMultimap).put(arg_0, arg_1));
        }
        ImmutableMap.Builder rangeSetMap = ImmutableMap.builder();
        rangeSetMultimap.asMap().forEach((path, rangeSets) -> rangeSetMap.put(path, Extents.unionRangeSets(rangeSets)));
        return rangeSetMap.build();
    }

    private static <C extends Comparable<C>> ImmutableRangeSet<C> intersectRangeSets(Collection<ImmutableRangeSet<C>> rangeSets) {
        return rangeSets.stream().reduce(ImmutableRangeSet.of((Range)Range.all()), ImmutableRangeSet::intersection);
    }

    private static <C extends Comparable<C>> ImmutableRangeSet<C> unionRangeSets(Collection<ImmutableRangeSet<C>> rangeSets) {
        return rangeSets.stream().reduce(ImmutableRangeSet.of(), ImmutableRangeSet::union);
    }

    static Pair<Core.Exp, Core.Exp> reduceAnd(TypeSystem typeSystem, PairList<Core.Exp, Core.Exp> extentFilters) {
        if (extentFilters.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList extents = new ArrayList();
        CoreBuilder.core.flattenAnds(extentFilters.leftList(), extents::add);
        Pair<Core.Exp, List<Core.Exp>> pair = CoreBuilder.core.intersectExtents(typeSystem, extents);
        return Pair.of((Core.Exp)pair.left, CoreBuilder.core.andAlso(typeSystem, extentFilters.rightList()));
    }

    static Pair<Core.Exp, Core.Exp> reduceOr(TypeSystem typeSystem, PairList<Core.Exp, Core.Exp> extentFilters) {
        return Pair.of(CoreBuilder.core.union(typeSystem, extentFilters.leftList()), CoreBuilder.core.orElse(typeSystem, extentFilters.rightList()));
    }

    private static class Extent {
        private final TypeSystem typeSystem;
        final Set<Core.NamedPat> goalPats;
        final SortedMap<Core.NamedPat, Core.Exp> boundPats;
        final PairList<Core.IdPat, Core.Exp> idPats;
        final Map<Core.NamedPat, Core.Exp> definitions = new HashMap<Core.NamedPat, Core.Exp>();

        Extent(TypeSystem typeSystem, Core.Pat pat, SortedMap<Core.NamedPat, Core.Exp> boundPats, PairList<Core.IdPat, Core.Exp> idPats) {
            this.typeSystem = typeSystem;
            this.goalPats = ImmutableSet.copyOf((Collection)Extents.flatten(pat));
            this.boundPats = ImmutableSortedMap.copyOf(boundPats);
            this.idPats = idPats;
        }

        void g3(Map<Core.Pat, PairList<Core.Exp, Core.Exp>> map, Core.Exp filter) {
            switch (filter.op) {
                case APPLY: {
                    Core.Apply apply = (Core.Apply)filter;
                    block3 : switch (apply.fn.op) {
                        case FN_LITERAL: {
                            BuiltIn builtIn = ((Core.Literal)apply.fn).unwrap(BuiltIn.class);
                            switch (builtIn) {
                                case Z_ANDALSO: {
                                    LinkedHashMap<Core.Pat, PairList> map2 = new LinkedHashMap<Core.Pat, PairList>();
                                    apply.arg.forEachArg((arg, i) -> this.g3((Map<Core.Pat, PairList<Core.Exp, Core.Exp>>)map2, (Core.Exp)arg));
                                    map2.forEach((pat, foo) -> map.computeIfAbsent((Core.Pat)pat, p -> PairList.of()).addAll(foo));
                                    break block3;
                                }
                                case Z_ORELSE: {
                                    LinkedHashMap<Core.Pat, PairList> map2 = new LinkedHashMap<Core.Pat, PairList>();
                                    LinkedHashMap map3 = new LinkedHashMap();
                                    apply.arg.forEachArg((arg, i) -> {
                                        this.g3(map3, (Core.Exp)arg);
                                        map3.forEach((pat, foo) -> map2.computeIfAbsent((Core.Pat)pat, p -> PairList.of()).add(Extents.reduceAnd(this.typeSystem, foo)));
                                        map3.clear();
                                    });
                                    map2.forEach((pat, foo) -> {
                                        PairList foo1 = map.computeIfAbsent((Core.Pat)pat, p -> PairList.of());
                                        if (foo1.isEmpty()) {
                                            foo1.add(Extents.reduceOr(this.typeSystem, foo));
                                        } else {
                                            PairList<Core.Exp, Core.Exp> intersectExtents = PairList.of();
                                            intersectExtents.add(Extents.reduceAnd(this.typeSystem, foo1));
                                            intersectExtents.add(Extents.reduceAnd(this.typeSystem, foo));
                                            foo1.clear();
                                            foo1.add(Extents.reduceOr(this.typeSystem, intersectExtents));
                                        }
                                    });
                                    break block3;
                                }
                                case OP_EQ: 
                                case OP_NE: 
                                case OP_GE: 
                                case OP_GT: 
                                case OP_LT: 
                                case OP_LE: {
                                    this.g4(builtIn, apply.arg(0), apply.arg(1), (pat, filter2, extent) -> map.computeIfAbsent((Core.Pat)pat, p -> PairList.of()).add(extent, filter2));
                                    break block3;
                                }
                                case OP_ELEM: {
                                    switch (apply.arg((int)0).op) {
                                        case ID: {
                                            Core.NamedPat pat2 = ((Core.Id)apply.arg((int)0)).idPat;
                                            map.computeIfAbsent(pat2, p1 -> PairList.of()).add(apply.arg(1), apply);
                                            break block3;
                                        }
                                        case TUPLE: {
                                            Core.Tuple tuple = (Core.Tuple)apply.arg(0);
                                            Core.Id id = CoreBuilder.core.id(this.createId(tuple.type, apply.arg(1)));
                                            Core.Exp elem = CoreBuilder.core.elem(this.typeSystem, id, apply.arg(1));
                                            this.g3(map, CoreBuilder.core.andAlso(this.typeSystem, elem, CoreBuilder.core.equal(this.typeSystem, id, tuple)));
                                            ArrayList<Core.Exp> conjunctions = new ArrayList<Core.Exp>();
                                            conjunctions.add(CoreBuilder.core.elem(this.typeSystem, id, apply.arg(1)));
                                            tuple.forEach((i, name, arg) -> conjunctions.add(CoreBuilder.core.equal(this.typeSystem, CoreBuilder.core.field(this.typeSystem, id, i), (Core.Exp)arg)));
                                            this.g3(map, CoreBuilder.core.andAlso(this.typeSystem, conjunctions));
                                        }
                                    }
                                }
                            }
                        }
                    }
                    break;
                }
            }
        }

        private void g4(BuiltIn builtIn, Core.Exp arg0, Core.Exp arg1, TriConsumer<Core.Pat, Core.Exp, Core.Exp> consumer) {
            this.g5(builtIn, arg0, arg1, consumer);
            this.g5(builtIn.reverse(), arg1, arg0, consumer);
        }

        private void g5(BuiltIn builtIn, Core.Exp arg0, Core.Exp arg1, TriConsumer<Core.Pat, Core.Exp, Core.Exp> consumer) {
            switch (builtIn) {
                case OP_EQ: {
                    Core.Id id;
                    switch (arg0.op) {
                        case ID: {
                            id = (Core.Id)arg0;
                            this.definitions.put(id.idPat, arg1);
                        }
                    }
                }
                case OP_NE: 
                case OP_GE: 
                case OP_GT: 
                case OP_LT: 
                case OP_LE: {
                    Core.Id id;
                    switch (arg0.op) {
                        case ID: {
                            id = (Core.Id)arg0;
                            if (!arg1.isConstant()) break;
                            consumer.accept(id.idPat, CoreBuilder.core.call(this.typeSystem, builtIn, arg0.type, Pos.ZERO, arg0, arg1), this.baz(builtIn, arg1));
                        }
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected: " + (Object)((Object)builtIn)));
                }
            }
        }

        private Core.Exp baz(BuiltIn builtIn, Core.Exp arg) {
            switch (builtIn) {
                case OP_EQ: {
                    return CoreBuilder.core.list(this.typeSystem, arg, new Core.Exp[0]);
                }
                case OP_NE: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet)ImmutableRangeSet.of((Range)Range.singleton((Comparable)((Core.Literal)arg).value)).complement());
                }
                case OP_GE: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet)ImmutableRangeSet.of((Range)Range.atLeast((Comparable)((Core.Literal)arg).value)));
                }
                case OP_GT: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet)ImmutableRangeSet.of((Range)Range.greaterThan((Comparable)((Core.Literal)arg).value)));
                }
                case OP_LE: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet)ImmutableRangeSet.of((Range)Range.atMost((Comparable)((Core.Literal)arg).value)));
                }
                case OP_LT: {
                    return CoreBuilder.core.extent(this.typeSystem, arg.type, (RangeSet)ImmutableRangeSet.of((Range)Range.lessThan((Comparable)((Core.Literal)arg).value)));
                }
            }
            throw new AssertionError((Object)("unexpected: " + (Object)((Object)builtIn)));
        }

        private Core.IdPat createId(Type type, Core.Exp extent) {
            int i = this.idPats.firstMatch((id, e) -> extent.equals(e));
            if (i >= 0) {
                return this.idPats.leftList().get(i);
            }
            Core.IdPat idPat = CoreBuilder.core.idPat(type, this.typeSystem.nameGenerator);
            this.idPats.add(idPat, extent);
            return idPat;
        }
    }

    static class ExtentMap {
        final Map<Core.Pat, PairList<Core.Exp, Core.Exp>> map = new LinkedHashMap<Core.Pat, PairList<Core.Exp, Core.Exp>>();

        ExtentMap() {
        }

        public PairList<Core.Exp, Core.Exp> get(TypeSystem typeSystem, Core.Pat pat) {
            PairList<Core.Exp, Core.Exp> foo = this.map.get(pat);
            if (foo != null && !foo.isEmpty()) {
                return foo;
            }
            if (this.canGet(pat)) {
                return this.get_(typeSystem, pat);
            }
            return ImmutablePairList.of();
        }

        private @NonNull PairList<Core.Exp, Core.Exp> get_(TypeSystem typeSystem, Core.Pat pat) {
            PairList<Core.Exp, Core.Exp> foo = this.map.get(pat);
            if (foo != null && !foo.isEmpty()) {
                return foo;
            }
            switch (pat.op) {
                case TUPLE_PAT: {
                    Core.TuplePat tuplePat = (Core.TuplePat)pat;
                    if (tuplePat.args.stream().allMatch(this::canGet)) {
                        FromBuilder fromBuilder = CoreBuilder.core.fromBuilder(typeSystem);
                        ArrayList<Core.Exp> filters = new ArrayList<Core.Exp>();
                        for (Core.Pat p : tuplePat.args) {
                            PairList<Core.Exp, Core.Exp> f = Objects.requireNonNull(this.get(typeSystem, p), "contradicts canGet");
                            fromBuilder.scan(p, CoreBuilder.core.union(typeSystem, f.leftList()));
                            CoreBuilder.core.flattenAnds(f.rightList(), filters::add);
                        }
                        return PairList.of(fromBuilder.build(), CoreBuilder.core.andAlso(typeSystem, filters));
                    }
                    PairList<Core.Exp, Core.Exp> foo1 = PairList.of();
                    this.map.forEach((pat1, foo2) -> {
                        if (pat1.op == Op.TUPLE_PAT) {
                            Core.TuplePat tuplePat1 = (Core.TuplePat)pat1;
                            List<String> fieldNames = tuplePat1.fieldNames();
                            if (tuplePat.args.stream().allMatch(arg -> arg instanceof Core.NamedPat && fieldNames.contains(((Core.NamedPat)arg).name))) {
                                foo1.addAll((PairList<Core.Exp, Core.Exp>)foo2);
                            }
                        }
                    });
                    return foo1;
                }
            }
            throw new AssertionError((Object)"contradicts canGet");
        }

        boolean canGet(Core.Pat pat) {
            PairList<Core.Exp, Core.Exp> foo = this.map.get(pat);
            if (foo != null && !foo.isEmpty()) {
                return true;
            }
            if (pat.type.isFinite()) {
                return true;
            }
            switch (pat.op) {
                case TUPLE_PAT: {
                    Core.TuplePat tuplePat = (Core.TuplePat)pat;
                    if (tuplePat.args.stream().allMatch(this::canGet)) {
                        return true;
                    }
                    for (Core.Pat pat1 : this.map.keySet()) {
                        if (pat1.op != Op.TUPLE_PAT) continue;
                        Core.TuplePat tuplePat1 = (Core.TuplePat)pat1;
                        List<String> fieldNames = tuplePat1.fieldNames();
                        if (!tuplePat.args.stream().allMatch(arg -> arg instanceof Core.NamedPat && fieldNames.contains(((Core.NamedPat)arg).name))) continue;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }

    public static class Analysis {
        final SortedMap<Core.NamedPat, Core.Exp> boundPats;
        final Set<Core.NamedPat> goalPats;
        final Core.Exp extentExp;
        final List<Core.Exp> satisfiedFilters;
        final List<Core.Exp> remainingFilters;

        private Analysis(SortedMap<Core.NamedPat, Core.Exp> boundPats, Set<Core.NamedPat> goalPats, Core.Exp extentExp, List<Core.Exp> satisfiedFilters, List<Core.Exp> remainingFilters) {
            this.boundPats = ImmutableSortedMap.copyOf(boundPats);
            this.goalPats = ImmutableSet.copyOf(goalPats);
            this.extentExp = extentExp;
            this.satisfiedFilters = ImmutableList.copyOf(satisfiedFilters);
            this.remainingFilters = ImmutableList.copyOf(remainingFilters);
        }

        Set<Core.NamedPat> unboundPats() {
            return Util.minus(this.goalPats, this.boundPats.keySet());
        }
    }

    @FunctionalInterface
    static interface TriConsumer<R, S, T> {
        public void accept(R var1, S var2, T var3);
    }
}

